/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.termsenum.action;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.xpack.core.termsenum.action.TermCount;

class NodeTermsEnumResponse
extends TransportResponse {
    private String error;
    private boolean complete;
    private List<TermCount> terms;
    private String nodeId;

    NodeTermsEnumResponse(StreamInput in) throws IOException {
        super(in);
        this.terms = in.readList(TermCount::new);
        this.error = in.readOptionalString();
        this.complete = in.readBoolean();
        this.nodeId = in.readString();
    }

    NodeTermsEnumResponse(String nodeId, List<TermCount> terms, String error, boolean complete) {
        this.nodeId = nodeId;
        this.terms = terms;
        this.error = error;
        this.complete = complete;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.terms);
        out.writeOptionalString(this.error);
        out.writeBoolean(this.complete);
        out.writeString(this.nodeId);
    }

    public List<TermCount> terms() {
        return this.terms;
    }

    public String getError() {
        return this.error;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public boolean isComplete() {
        return this.complete;
    }
}

