/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.enrich.action;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ChannelActionListener;
import org.elasticsearch.action.support.nodes.BaseNodeRequest;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.enrich.action.EnrichStatsAction;
import org.elasticsearch.xpack.enrich.EnrichCache;
import org.elasticsearch.xpack.enrich.action.EnrichCoordinatorProxyAction;

public class EnrichCoordinatorStatsAction
extends ActionType<Response> {
    public static final EnrichCoordinatorStatsAction INSTANCE = new EnrichCoordinatorStatsAction();
    public static final String NAME = "cluster:monitor/xpack/enrich/coordinator_stats";
    public static final String BWC_NAME = "cluster:admin/xpack/enrich/coordinator_stats";

    private EnrichCoordinatorStatsAction() {
        super(NAME, Response::new);
    }

    public static class TransportAction
    extends TransportNodesAction<Request, Response, NodeRequest, NodeResponse> {
        private final EnrichCache enrichCache;
        private final EnrichCoordinatorProxyAction.Coordinator coordinator;

        @Inject
        public TransportAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, EnrichCache enrichCache, EnrichCoordinatorProxyAction.Coordinator coordinator) {
            super(EnrichCoordinatorStatsAction.NAME, threadPool, clusterService, transportService, actionFilters, Request::new, NodeRequest::new, "same", NodeResponse.class);
            this.enrichCache = enrichCache;
            this.coordinator = coordinator;
            transportService.registerRequestHandler("cluster:admin/xpack/enrich/coordinator_stats[n]", "same", NodeRequest::new, (request, channel, task) -> channel.sendResponse((TransportResponse)this.nodeOperation((BaseNodeRequest)request, task)));
            transportService.registerRequestHandler(EnrichCoordinatorStatsAction.BWC_NAME, "same", false, true, Request::new, (request, channel, task) -> this.execute(task, (ActionRequest)request, (ActionListener)new ChannelActionListener(channel, EnrichCoordinatorStatsAction.BWC_NAME, request)));
        }

        protected void resolveRequest(Request request, ClusterState clusterState) {
            DiscoveryNode[] ingestNodes = clusterState.getNodes().getIngestNodes().values().toArray(new DiscoveryNode[0]);
            request.setConcreteNodes(ingestNodes);
        }

        protected Response newResponse(Request request, List<NodeResponse> nodeResponses, List<FailedNodeException> failures) {
            return new Response(this.clusterService.getClusterName(), nodeResponses, failures);
        }

        protected NodeRequest newNodeRequest(Request request) {
            return new NodeRequest();
        }

        protected NodeResponse newNodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
            return new NodeResponse(in);
        }

        protected NodeResponse nodeOperation(NodeRequest request) {
            DiscoveryNode node = this.clusterService.localNode();
            return new NodeResponse(node, this.enrichCache.getStats(node.getId()), this.coordinator.getStats(node.getId()));
        }

        protected String getTransportNodeAction(DiscoveryNode node) {
            return node.getVersion().before(Version.V_7_9_0) ? "cluster:admin/xpack/enrich/coordinator_stats[n]" : this.transportNodeAction;
        }
    }

    public static class NodeResponse
    extends BaseNodeResponse {
        private final EnrichStatsAction.Response.CacheStats cacheStats;
        private final EnrichStatsAction.Response.CoordinatorStats coordinatorStats;

        NodeResponse(DiscoveryNode node, EnrichStatsAction.Response.CacheStats cacheStats, EnrichStatsAction.Response.CoordinatorStats coordinatorStats) {
            super(node);
            this.cacheStats = cacheStats;
            this.coordinatorStats = coordinatorStats;
        }

        NodeResponse(StreamInput in) throws IOException {
            super(in);
            this.cacheStats = in.getVersion().onOrAfter(Version.V_7_16_0) ? new EnrichStatsAction.Response.CacheStats(in) : null;
            this.coordinatorStats = new EnrichStatsAction.Response.CoordinatorStats(in);
        }

        public EnrichStatsAction.Response.CoordinatorStats getCoordinatorStats() {
            return this.coordinatorStats;
        }

        public EnrichStatsAction.Response.CacheStats getCacheStats() {
            return this.cacheStats;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            if (out.getVersion().onOrAfter(Version.V_7_16_0)) {
                this.cacheStats.writeTo(out);
            }
            this.coordinatorStats.writeTo(out);
        }
    }

    public static class Response
    extends BaseNodesResponse<NodeResponse> {
        Response(StreamInput in) throws IOException {
            super(in);
        }

        Response(ClusterName clusterName, List<NodeResponse> nodes, List<FailedNodeException> failures) {
            super(clusterName, nodes, failures);
        }

        protected List<NodeResponse> readNodesFrom(StreamInput in) throws IOException {
            return in.readList(NodeResponse::new);
        }

        protected void writeNodesTo(StreamOutput out, List<NodeResponse> nodes) throws IOException {
            out.writeList(nodes);
        }
    }

    public static class NodeRequest
    extends BaseNodeRequest {
        NodeRequest() {
        }

        NodeRequest(StreamInput in) throws IOException {
            super(in);
        }
    }

    public static class Request
    extends BaseNodesRequest<Request> {
        public Request() {
            super(new String[0]);
        }

        Request(StreamInput in) throws IOException {
            super(in);
        }
    }
}

