/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.idp.privileges;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.OriginSettingClient;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.List;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.security.action.privilege.GetPrivilegesAction;
import org.elasticsearch.xpack.core.security.action.privilege.GetPrivilegesRequest;
import org.elasticsearch.xpack.idp.saml.sp.ServiceProviderDefaults;

public class ApplicationActionsResolver
extends AbstractLifecycleComponent {
    private static final int CACHE_SIZE_DEFAULT = 100;
    private static final TimeValue CACHE_TTL_DEFAULT = TimeValue.timeValueMinutes((long)90L);
    public static final Setting<Integer> CACHE_SIZE = Setting.intSetting((String)"xpack.idp.privileges.cache.size", (int)100, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<TimeValue> CACHE_TTL = Setting.timeSetting((String)"xpack.idp.privileges.cache.ttl", (TimeValue)CACHE_TTL_DEFAULT, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private final Logger logger = LogManager.getLogger();
    private final ServiceProviderDefaults defaults;
    private final Client client;
    private final Cache<String, Set<String>> cache;

    public ApplicationActionsResolver(Settings settings, ServiceProviderDefaults defaults, Client client) {
        this.defaults = defaults;
        this.client = new OriginSettingClient(client, "idp");
        TimeValue cacheTtl = (TimeValue)CACHE_TTL.get(settings);
        this.cache = CacheBuilder.builder().setMaximumWeight((long)((Integer)CACHE_SIZE.get(settings)).intValue()).setExpireAfterWrite(cacheTtl).build();
        TimeValue preloadInterval = TimeValue.timeValueMillis((long)(cacheTtl.millis() * 2L / 3L));
        client.threadPool().scheduleWithFixedDelay(this::loadPrivilegesForDefaultApplication, preloadInterval, "generic");
    }

    public static Collection<? extends Setting<?>> getSettings() {
        return List.of(CACHE_SIZE, CACHE_TTL);
    }

    protected void doStart() {
        this.loadPrivilegesForDefaultApplication();
    }

    private void loadPrivilegesForDefaultApplication() {
        this.loadActions(this.defaults.applicationName, (ActionListener<Set<String>>)ActionListener.wrap(actions -> this.logger.info("Found actions [{}] defined within application privileges for [{}]", actions, (Object)this.defaults.applicationName), ex -> this.logger.warn((Message)new ParameterizedMessage("Failed to load application privileges actions for application [{}]", (Object)this.defaults.applicationName), (Throwable)ex)));
    }

    protected void doStop() {
    }

    protected void doClose() throws IOException {
    }

    public void getActions(String application, ActionListener<Set<String>> listener) {
        Set actions = (Set)this.cache.get((Object)application);
        if (actions == null || actions.isEmpty()) {
            this.loadActions(application, listener);
        } else {
            listener.onResponse((Object)actions);
        }
    }

    private void loadActions(String applicationName, ActionListener<Set<String>> listener) {
        GetPrivilegesRequest request = new GetPrivilegesRequest();
        request.application(applicationName);
        this.client.execute((ActionType)GetPrivilegesAction.INSTANCE, (ActionRequest)request, ActionListener.wrap(response -> {
            Set fixedActions = Stream.of(response.privileges()).map(p -> p.getActions()).flatMap(Collection::stream).filter(s -> s.indexOf(42) == -1).collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));
            this.cache.put((Object)applicationName, (Object)fixedActions);
            listener.onResponse((Object)fixedActions);
        }, arg_0 -> listener.onFailure(arg_0)));
    }
}

