/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.datafeed;

import java.util.Objects;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedTimingStats;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.ml.job.persistence.RestartTimeInfo;

public class DatafeedContext {
    private final DatafeedConfig datafeedConfig;
    private final Job job;
    private final RestartTimeInfo restartTimeInfo;
    private final DatafeedTimingStats timingStats;

    private DatafeedContext(DatafeedConfig datafeedConfig, Job job, RestartTimeInfo restartTimeInfo, DatafeedTimingStats timingStats) {
        this.datafeedConfig = Objects.requireNonNull(datafeedConfig);
        this.job = Objects.requireNonNull(job);
        this.restartTimeInfo = Objects.requireNonNull(restartTimeInfo);
        this.timingStats = Objects.requireNonNull(timingStats);
    }

    public DatafeedConfig getDatafeedConfig() {
        return this.datafeedConfig;
    }

    public Job getJob() {
        return this.job;
    }

    public RestartTimeInfo getRestartTimeInfo() {
        return this.restartTimeInfo;
    }

    public DatafeedTimingStats getTimingStats() {
        return this.timingStats;
    }

    static Builder builder() {
        return new Builder();
    }

    static class Builder {
        private volatile DatafeedConfig datafeedConfig;
        private volatile Job job;
        private volatile RestartTimeInfo restartTimeInfo;
        private volatile DatafeedTimingStats timingStats;

        Builder() {
        }

        Builder setDatafeedConfig(DatafeedConfig datafeedConfig) {
            this.datafeedConfig = datafeedConfig;
            return this;
        }

        Builder setJob(Job job) {
            this.job = job;
            return this;
        }

        Job getJob() {
            return this.job;
        }

        Builder setRestartTimeInfo(RestartTimeInfo restartTimeInfo) {
            this.restartTimeInfo = restartTimeInfo;
            return this;
        }

        Builder setTimingStats(DatafeedTimingStats timingStats) {
            this.timingStats = timingStats;
            return this;
        }

        DatafeedContext build() {
            return new DatafeedContext(this.datafeedConfig, this.job, this.restartTimeInfo, this.timingStats);
        }
    }
}

