/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security;

import io.netty.channel.Channel;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpUtil;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilter;
import org.elasticsearch.action.support.DestructiveOperations;
import org.elasticsearch.bootstrap.BootstrapCheck;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.CheckedBiConsumer;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Binder;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.inject.util.Providers;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.network.NetworkModule;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.List;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.http.HttpChannel;
import org.elasticsearch.http.HttpPreRequest;
import org.elasticsearch.http.HttpRequest;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.http.netty4.internal.HttpHeadersAuthenticatorUtils;
import org.elasticsearch.http.netty4.internal.HttpValidator;
import org.elasticsearch.index.IndexModule;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.shard.SearchOperationListener;
import org.elasticsearch.indices.ExecutorNames;
import org.elasticsearch.indices.IndicesQueryCache;
import org.elasticsearch.indices.SystemIndexDescriptor;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicenseService;
import org.elasticsearch.license.LicenseStateListener;
import org.elasticsearch.license.LicensedFeature;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.ClusterPlugin;
import org.elasticsearch.plugins.DiscoveryPlugin;
import org.elasticsearch.plugins.ExtensiblePlugin;
import org.elasticsearch.plugins.IngestPlugin;
import org.elasticsearch.plugins.MapperPlugin;
import org.elasticsearch.plugins.NetworkPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.SearchPlugin;
import org.elasticsearch.plugins.SystemIndexPlugin;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestHeaderDefinition;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.threadpool.ExecutorBuilder;
import org.elasticsearch.threadpool.FixedExecutorBuilder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.SharedGroupFactory;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportInterceptor;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.nio.NioGroupFactory;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.SecurityExtension;
import org.elasticsearch.xpack.core.security.SecurityField;
import org.elasticsearch.xpack.core.security.SecuritySettings;
import org.elasticsearch.xpack.core.security.action.ClearSecurityCacheAction;
import org.elasticsearch.xpack.core.security.action.CreateApiKeyAction;
import org.elasticsearch.xpack.core.security.action.DelegatePkiAuthenticationAction;
import org.elasticsearch.xpack.core.security.action.GetApiKeyAction;
import org.elasticsearch.xpack.core.security.action.GrantApiKeyAction;
import org.elasticsearch.xpack.core.security.action.InvalidateApiKeyAction;
import org.elasticsearch.xpack.core.security.action.apikey.QueryApiKeyAction;
import org.elasticsearch.xpack.core.security.action.oidc.OpenIdConnectAuthenticateAction;
import org.elasticsearch.xpack.core.security.action.oidc.OpenIdConnectLogoutAction;
import org.elasticsearch.xpack.core.security.action.oidc.OpenIdConnectPrepareAuthenticationAction;
import org.elasticsearch.xpack.core.security.action.privilege.ClearPrivilegesCacheAction;
import org.elasticsearch.xpack.core.security.action.privilege.DeletePrivilegesAction;
import org.elasticsearch.xpack.core.security.action.privilege.GetBuiltinPrivilegesAction;
import org.elasticsearch.xpack.core.security.action.privilege.GetPrivilegesAction;
import org.elasticsearch.xpack.core.security.action.privilege.PutPrivilegesAction;
import org.elasticsearch.xpack.core.security.action.realm.ClearRealmCacheAction;
import org.elasticsearch.xpack.core.security.action.role.ClearRolesCacheAction;
import org.elasticsearch.xpack.core.security.action.role.DeleteRoleAction;
import org.elasticsearch.xpack.core.security.action.role.GetRolesAction;
import org.elasticsearch.xpack.core.security.action.role.PutRoleAction;
import org.elasticsearch.xpack.core.security.action.rolemapping.DeleteRoleMappingAction;
import org.elasticsearch.xpack.core.security.action.rolemapping.GetRoleMappingsAction;
import org.elasticsearch.xpack.core.security.action.rolemapping.PutRoleMappingAction;
import org.elasticsearch.xpack.core.security.action.saml.SamlAuthenticateAction;
import org.elasticsearch.xpack.core.security.action.saml.SamlCompleteLogoutAction;
import org.elasticsearch.xpack.core.security.action.saml.SamlInvalidateSessionAction;
import org.elasticsearch.xpack.core.security.action.saml.SamlLogoutAction;
import org.elasticsearch.xpack.core.security.action.saml.SamlPrepareAuthenticationAction;
import org.elasticsearch.xpack.core.security.action.saml.SamlSpMetadataAction;
import org.elasticsearch.xpack.core.security.action.service.CreateServiceAccountTokenAction;
import org.elasticsearch.xpack.core.security.action.service.DeleteServiceAccountTokenAction;
import org.elasticsearch.xpack.core.security.action.service.GetServiceAccountAction;
import org.elasticsearch.xpack.core.security.action.service.GetServiceAccountCredentialsAction;
import org.elasticsearch.xpack.core.security.action.service.GetServiceAccountNodesCredentialsAction;
import org.elasticsearch.xpack.core.security.action.token.CreateTokenAction;
import org.elasticsearch.xpack.core.security.action.token.InvalidateTokenAction;
import org.elasticsearch.xpack.core.security.action.token.RefreshTokenAction;
import org.elasticsearch.xpack.core.security.action.user.AuthenticateAction;
import org.elasticsearch.xpack.core.security.action.user.ChangePasswordAction;
import org.elasticsearch.xpack.core.security.action.user.DeleteUserAction;
import org.elasticsearch.xpack.core.security.action.user.GetUserPrivilegesAction;
import org.elasticsearch.xpack.core.security.action.user.GetUsersAction;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesAction;
import org.elasticsearch.xpack.core.security.action.user.PutUserAction;
import org.elasticsearch.xpack.core.security.action.user.SetEnabledAction;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.AuthenticationFailureHandler;
import org.elasticsearch.xpack.core.security.authc.AuthenticationServiceField;
import org.elasticsearch.xpack.core.security.authc.DefaultAuthenticationFailureHandler;
import org.elasticsearch.xpack.core.security.authc.InternalRealmsSettings;
import org.elasticsearch.xpack.core.security.authc.Realm;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.RealmSettings;
import org.elasticsearch.xpack.core.security.authz.AuthorizationEngine;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.accesscontrol.DocumentSubsetBitsetCache;
import org.elasticsearch.xpack.core.security.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.xpack.core.security.authz.accesscontrol.SecurityIndexReaderWrapper;
import org.elasticsearch.xpack.core.security.authz.permission.FieldPermissions;
import org.elasticsearch.xpack.core.security.authz.permission.FieldPermissionsCache;
import org.elasticsearch.xpack.core.security.authz.store.ReservedRolesStore;
import org.elasticsearch.xpack.core.security.authz.store.RoleRetrievalResult;
import org.elasticsearch.xpack.core.security.support.Automatons;
import org.elasticsearch.xpack.core.security.user.AnonymousUser;
import org.elasticsearch.xpack.core.ssl.SSLConfigurationSettings;
import org.elasticsearch.xpack.core.ssl.SSLService;
import org.elasticsearch.xpack.core.ssl.TLSLicenseBootstrapCheck;
import org.elasticsearch.xpack.core.ssl.action.GetCertificateInfoAction;
import org.elasticsearch.xpack.core.ssl.action.TransportGetCertificateInfoAction;
import org.elasticsearch.xpack.core.ssl.rest.RestGetCertificateInfoAction;
import org.elasticsearch.xpack.security.PkiRealmBootstrapCheck;
import org.elasticsearch.xpack.security.SecurityFeatureSet;
import org.elasticsearch.xpack.security.TokenSSLBootstrapCheck;
import org.elasticsearch.xpack.security.action.TransportClearSecurityCacheAction;
import org.elasticsearch.xpack.security.action.TransportCreateApiKeyAction;
import org.elasticsearch.xpack.security.action.TransportDelegatePkiAuthenticationAction;
import org.elasticsearch.xpack.security.action.TransportGetApiKeyAction;
import org.elasticsearch.xpack.security.action.TransportGrantApiKeyAction;
import org.elasticsearch.xpack.security.action.TransportInvalidateApiKeyAction;
import org.elasticsearch.xpack.security.action.apikey.TransportQueryApiKeyAction;
import org.elasticsearch.xpack.security.action.filter.SecurityActionFilter;
import org.elasticsearch.xpack.security.action.oidc.TransportOpenIdConnectAuthenticateAction;
import org.elasticsearch.xpack.security.action.oidc.TransportOpenIdConnectLogoutAction;
import org.elasticsearch.xpack.security.action.oidc.TransportOpenIdConnectPrepareAuthenticationAction;
import org.elasticsearch.xpack.security.action.privilege.TransportClearPrivilegesCacheAction;
import org.elasticsearch.xpack.security.action.privilege.TransportDeletePrivilegesAction;
import org.elasticsearch.xpack.security.action.privilege.TransportGetBuiltinPrivilegesAction;
import org.elasticsearch.xpack.security.action.privilege.TransportGetPrivilegesAction;
import org.elasticsearch.xpack.security.action.privilege.TransportPutPrivilegesAction;
import org.elasticsearch.xpack.security.action.realm.TransportClearRealmCacheAction;
import org.elasticsearch.xpack.security.action.role.TransportClearRolesCacheAction;
import org.elasticsearch.xpack.security.action.role.TransportDeleteRoleAction;
import org.elasticsearch.xpack.security.action.role.TransportGetRolesAction;
import org.elasticsearch.xpack.security.action.role.TransportPutRoleAction;
import org.elasticsearch.xpack.security.action.rolemapping.TransportDeleteRoleMappingAction;
import org.elasticsearch.xpack.security.action.rolemapping.TransportGetRoleMappingsAction;
import org.elasticsearch.xpack.security.action.rolemapping.TransportPutRoleMappingAction;
import org.elasticsearch.xpack.security.action.saml.TransportSamlAuthenticateAction;
import org.elasticsearch.xpack.security.action.saml.TransportSamlCompleteLogoutAction;
import org.elasticsearch.xpack.security.action.saml.TransportSamlInvalidateSessionAction;
import org.elasticsearch.xpack.security.action.saml.TransportSamlLogoutAction;
import org.elasticsearch.xpack.security.action.saml.TransportSamlPrepareAuthenticationAction;
import org.elasticsearch.xpack.security.action.saml.TransportSamlSpMetadataAction;
import org.elasticsearch.xpack.security.action.service.TransportCreateServiceAccountTokenAction;
import org.elasticsearch.xpack.security.action.service.TransportDeleteServiceAccountTokenAction;
import org.elasticsearch.xpack.security.action.service.TransportGetServiceAccountAction;
import org.elasticsearch.xpack.security.action.service.TransportGetServiceAccountCredentialsAction;
import org.elasticsearch.xpack.security.action.service.TransportGetServiceAccountNodesCredentialsAction;
import org.elasticsearch.xpack.security.action.token.TransportCreateTokenAction;
import org.elasticsearch.xpack.security.action.token.TransportInvalidateTokenAction;
import org.elasticsearch.xpack.security.action.token.TransportRefreshTokenAction;
import org.elasticsearch.xpack.security.action.user.TransportAuthenticateAction;
import org.elasticsearch.xpack.security.action.user.TransportChangePasswordAction;
import org.elasticsearch.xpack.security.action.user.TransportDeleteUserAction;
import org.elasticsearch.xpack.security.action.user.TransportGetUserPrivilegesAction;
import org.elasticsearch.xpack.security.action.user.TransportGetUsersAction;
import org.elasticsearch.xpack.security.action.user.TransportHasPrivilegesAction;
import org.elasticsearch.xpack.security.action.user.TransportPutUserAction;
import org.elasticsearch.xpack.security.action.user.TransportSetEnabledAction;
import org.elasticsearch.xpack.security.audit.AuditTrail;
import org.elasticsearch.xpack.security.audit.AuditTrailService;
import org.elasticsearch.xpack.security.audit.logfile.LoggingAuditTrail;
import org.elasticsearch.xpack.security.authc.ApiKeyService;
import org.elasticsearch.xpack.security.authc.AuthenticationService;
import org.elasticsearch.xpack.security.authc.InternalRealms;
import org.elasticsearch.xpack.security.authc.Realms;
import org.elasticsearch.xpack.security.authc.TokenService;
import org.elasticsearch.xpack.security.authc.esnative.NativeUsersStore;
import org.elasticsearch.xpack.security.authc.esnative.ReservedRealm;
import org.elasticsearch.xpack.security.authc.service.CachingServiceAccountTokenStore;
import org.elasticsearch.xpack.security.authc.service.FileServiceAccountTokenStore;
import org.elasticsearch.xpack.security.authc.service.IndexServiceAccountTokenStore;
import org.elasticsearch.xpack.security.authc.service.ServiceAccountService;
import org.elasticsearch.xpack.security.authc.support.SecondaryAuthenticator;
import org.elasticsearch.xpack.security.authc.support.mapper.NativeRoleMappingStore;
import org.elasticsearch.xpack.security.authz.AuthorizationService;
import org.elasticsearch.xpack.security.authz.DlsFlsRequestCacheDifferentiator;
import org.elasticsearch.xpack.security.authz.SecuritySearchOperationListener;
import org.elasticsearch.xpack.security.authz.accesscontrol.OptOutQueryCache;
import org.elasticsearch.xpack.security.authz.interceptor.BulkShardRequestInterceptor;
import org.elasticsearch.xpack.security.authz.interceptor.DlsFlsLicenseRequestInterceptor;
import org.elasticsearch.xpack.security.authz.interceptor.IndicesAliasesRequestInterceptor;
import org.elasticsearch.xpack.security.authz.interceptor.RequestInterceptor;
import org.elasticsearch.xpack.security.authz.interceptor.ResizeRequestInterceptor;
import org.elasticsearch.xpack.security.authz.interceptor.SearchRequestInterceptor;
import org.elasticsearch.xpack.security.authz.interceptor.ShardSearchRequestInterceptor;
import org.elasticsearch.xpack.security.authz.interceptor.UpdateRequestInterceptor;
import org.elasticsearch.xpack.security.authz.store.CompositeRolesStore;
import org.elasticsearch.xpack.security.authz.store.DeprecationRoleDescriptorConsumer;
import org.elasticsearch.xpack.security.authz.store.FileRolesStore;
import org.elasticsearch.xpack.security.authz.store.NativePrivilegeStore;
import org.elasticsearch.xpack.security.authz.store.NativeRolesStore;
import org.elasticsearch.xpack.security.authz.store.RoleProviders;
import org.elasticsearch.xpack.security.ingest.SetSecurityUserProcessor;
import org.elasticsearch.xpack.security.operator.FileOperatorUsersStore;
import org.elasticsearch.xpack.security.operator.OperatorOnlyRegistry;
import org.elasticsearch.xpack.security.operator.OperatorPrivileges;
import org.elasticsearch.xpack.security.rest.RemoteHostHeader;
import org.elasticsearch.xpack.security.rest.SecurityRestFilter;
import org.elasticsearch.xpack.security.rest.action.RestAuthenticateAction;
import org.elasticsearch.xpack.security.rest.action.RestDelegatePkiAuthenticationAction;
import org.elasticsearch.xpack.security.rest.action.apikey.RestClearApiKeyCacheAction;
import org.elasticsearch.xpack.security.rest.action.apikey.RestCreateApiKeyAction;
import org.elasticsearch.xpack.security.rest.action.apikey.RestGetApiKeyAction;
import org.elasticsearch.xpack.security.rest.action.apikey.RestGrantApiKeyAction;
import org.elasticsearch.xpack.security.rest.action.apikey.RestInvalidateApiKeyAction;
import org.elasticsearch.xpack.security.rest.action.apikey.RestQueryApiKeyAction;
import org.elasticsearch.xpack.security.rest.action.oauth2.RestGetTokenAction;
import org.elasticsearch.xpack.security.rest.action.oauth2.RestInvalidateTokenAction;
import org.elasticsearch.xpack.security.rest.action.oidc.RestOpenIdConnectAuthenticateAction;
import org.elasticsearch.xpack.security.rest.action.oidc.RestOpenIdConnectLogoutAction;
import org.elasticsearch.xpack.security.rest.action.oidc.RestOpenIdConnectPrepareAuthenticationAction;
import org.elasticsearch.xpack.security.rest.action.privilege.RestClearPrivilegesCacheAction;
import org.elasticsearch.xpack.security.rest.action.privilege.RestDeletePrivilegesAction;
import org.elasticsearch.xpack.security.rest.action.privilege.RestGetBuiltinPrivilegesAction;
import org.elasticsearch.xpack.security.rest.action.privilege.RestGetPrivilegesAction;
import org.elasticsearch.xpack.security.rest.action.privilege.RestPutPrivilegesAction;
import org.elasticsearch.xpack.security.rest.action.realm.RestClearRealmCacheAction;
import org.elasticsearch.xpack.security.rest.action.role.RestClearRolesCacheAction;
import org.elasticsearch.xpack.security.rest.action.role.RestDeleteRoleAction;
import org.elasticsearch.xpack.security.rest.action.role.RestGetRolesAction;
import org.elasticsearch.xpack.security.rest.action.role.RestPutRoleAction;
import org.elasticsearch.xpack.security.rest.action.rolemapping.RestDeleteRoleMappingAction;
import org.elasticsearch.xpack.security.rest.action.rolemapping.RestGetRoleMappingsAction;
import org.elasticsearch.xpack.security.rest.action.rolemapping.RestPutRoleMappingAction;
import org.elasticsearch.xpack.security.rest.action.saml.RestSamlAuthenticateAction;
import org.elasticsearch.xpack.security.rest.action.saml.RestSamlCompleteLogoutAction;
import org.elasticsearch.xpack.security.rest.action.saml.RestSamlInvalidateSessionAction;
import org.elasticsearch.xpack.security.rest.action.saml.RestSamlLogoutAction;
import org.elasticsearch.xpack.security.rest.action.saml.RestSamlPrepareAuthenticationAction;
import org.elasticsearch.xpack.security.rest.action.saml.RestSamlSpMetadataAction;
import org.elasticsearch.xpack.security.rest.action.service.RestClearServiceAccountTokenStoreCacheAction;
import org.elasticsearch.xpack.security.rest.action.service.RestCreateServiceAccountTokenAction;
import org.elasticsearch.xpack.security.rest.action.service.RestDeleteServiceAccountTokenAction;
import org.elasticsearch.xpack.security.rest.action.service.RestGetServiceAccountAction;
import org.elasticsearch.xpack.security.rest.action.service.RestGetServiceAccountCredentialsAction;
import org.elasticsearch.xpack.security.rest.action.user.RestChangePasswordAction;
import org.elasticsearch.xpack.security.rest.action.user.RestDeleteUserAction;
import org.elasticsearch.xpack.security.rest.action.user.RestGetUserPrivilegesAction;
import org.elasticsearch.xpack.security.rest.action.user.RestGetUsersAction;
import org.elasticsearch.xpack.security.rest.action.user.RestHasPrivilegesAction;
import org.elasticsearch.xpack.security.rest.action.user.RestPutUserAction;
import org.elasticsearch.xpack.security.rest.action.user.RestSetEnabledAction;
import org.elasticsearch.xpack.security.support.CacheInvalidatorRegistry;
import org.elasticsearch.xpack.security.support.ExtensionComponents;
import org.elasticsearch.xpack.security.support.SecurityIndexManager;
import org.elasticsearch.xpack.security.support.SecurityStatusChangeListener;
import org.elasticsearch.xpack.security.transport.SSLEngineUtils;
import org.elasticsearch.xpack.security.transport.SecurityHttpSettings;
import org.elasticsearch.xpack.security.transport.SecurityServerTransportInterceptor;
import org.elasticsearch.xpack.security.transport.filter.IPFilter;
import org.elasticsearch.xpack.security.transport.netty4.SecurityNetty4HttpServerTransport;
import org.elasticsearch.xpack.security.transport.netty4.SecurityNetty4ServerTransport;
import org.elasticsearch.xpack.security.transport.nio.SecurityNioHttpServerTransport;
import org.elasticsearch.xpack.security.transport.nio.SecurityNioTransport;

public class Security
extends Plugin
implements SystemIndexPlugin,
IngestPlugin,
NetworkPlugin,
ClusterPlugin,
DiscoveryPlugin,
MapperPlugin,
ExtensiblePlugin,
SearchPlugin {
    public static final String SECURITY_CRYPTO_THREAD_POOL_NAME = "security-crypto";
    public static final Version FLATTENED_FIELD_TYPE_INTRODUCED = Version.V_7_3_0;
    public static final LicensedFeature.Momentary IP_FILTERING_FEATURE = LicensedFeature.momentaryLenient(null, (String)"security-ip-filtering", (License.OperationMode)License.OperationMode.GOLD);
    public static final LicensedFeature.Momentary AUDITING_FEATURE = LicensedFeature.momentaryLenient(null, (String)"security-auditing", (License.OperationMode)License.OperationMode.GOLD);
    public static final LicensedFeature.Momentary TOKEN_SERVICE_FEATURE = LicensedFeature.momentaryLenient(null, (String)"security-token-service", (License.OperationMode)License.OperationMode.STANDARD);
    private static final String REALMS_FEATURE_FAMILY = "security-realms";
    public static final LicensedFeature.Persistent LDAP_REALM_FEATURE = LicensedFeature.persistentLenient((String)"security-realms", (String)"ldap", (License.OperationMode)License.OperationMode.GOLD);
    public static final LicensedFeature.Persistent AD_REALM_FEATURE = LicensedFeature.persistentLenient((String)"security-realms", (String)"active-directory", (License.OperationMode)License.OperationMode.GOLD);
    public static final LicensedFeature.Persistent PKI_REALM_FEATURE = LicensedFeature.persistentLenient((String)"security-realms", (String)"pki", (License.OperationMode)License.OperationMode.GOLD);
    public static final LicensedFeature.Persistent SAML_REALM_FEATURE = LicensedFeature.persistentLenient((String)"security-realms", (String)"saml", (License.OperationMode)License.OperationMode.PLATINUM);
    public static final LicensedFeature.Persistent OIDC_REALM_FEATURE = LicensedFeature.persistentLenient((String)"security-realms", (String)"oidc", (License.OperationMode)License.OperationMode.PLATINUM);
    public static final LicensedFeature.Persistent KERBEROS_REALM_FEATURE = LicensedFeature.persistentLenient((String)"security-realms", (String)"kerberos", (License.OperationMode)License.OperationMode.PLATINUM);
    public static final LicensedFeature.Persistent CUSTOM_REALMS_FEATURE = LicensedFeature.persistentLenient((String)"security-realms", (String)"custom", (License.OperationMode)License.OperationMode.PLATINUM);
    public static final LicensedFeature.Momentary DELEGATED_AUTHORIZATION_FEATURE = LicensedFeature.momentary(null, (String)"security-delegated-authorization", (License.OperationMode)License.OperationMode.PLATINUM);
    public static final LicensedFeature.Momentary AUTHORIZATION_ENGINE_FEATURE = LicensedFeature.momentary(null, (String)"security-authorization-engine", (License.OperationMode)License.OperationMode.PLATINUM);
    public static final LicensedFeature.Persistent CUSTOM_ROLE_PROVIDERS_FEATURE = LicensedFeature.persistent(null, (String)"security-roles-provider", (License.OperationMode)License.OperationMode.PLATINUM);
    public static final LicensedFeature.Momentary OPERATOR_PRIVILEGES_FEATURE = LicensedFeature.momentary(null, (String)"operator-privileges", (License.OperationMode)License.OperationMode.ENTERPRISE);
    private static final Logger logger = LogManager.getLogger(Security.class);
    public static final SystemIndexDescriptor SECURITY_MAIN_INDEX_DESCRIPTOR = Security.getSecurityMainIndexDescriptor();
    public static final SystemIndexDescriptor SECURITY_TOKEN_INDEX_DESCRIPTOR = Security.getSecurityTokenIndexDescriptor();
    private final Settings settings;
    private final boolean enabled;
    private final boolean transportClientMode;
    private final SetOnce<TransportInterceptor> securityInterceptor = new SetOnce();
    private final SetOnce<IPFilter> ipFilter = new SetOnce();
    private final SetOnce<AuthenticationService> authcService = new SetOnce();
    private final SetOnce<SecondaryAuthenticator> secondayAuthc = new SetOnce();
    private final SetOnce<AuditTrailService> auditTrailService = new SetOnce();
    private final SetOnce<SecurityContext> securityContext = new SetOnce();
    private final SetOnce<ThreadContext> threadContext = new SetOnce();
    private final SetOnce<TokenService> tokenService = new SetOnce();
    private final SetOnce<SecurityActionFilter> securityActionFilter = new SetOnce();
    private final SetOnce<SecurityIndexManager> securityIndex = new SetOnce();
    private final SetOnce<SharedGroupFactory> sharedGroupFactory = new SetOnce();
    private final SetOnce<NioGroupFactory> nioGroupFactory = new SetOnce();
    private final SetOnce<DocumentSubsetBitsetCache> dlsBitsetCache = new SetOnce();
    private final SetOnce<java.util.List<BootstrapCheck>> bootstrapChecks = new SetOnce();
    private final java.util.List<SecurityExtension> securityExtensions = new ArrayList<SecurityExtension>();
    private final SetOnce<Transport> transportReference = new SetOnce();
    private final SetOnce<ScriptService> scriptServiceReference = new SetOnce();

    public Security(Settings settings, Path configPath) {
        this(settings, configPath, Collections.emptyList());
    }

    Security(Settings settings, Path configPath, java.util.List<SecurityExtension> extensions) {
        this.settings = settings;
        this.transportClientMode = XPackPlugin.transportClientMode((Settings)settings);
        this.enabled = (Boolean)XPackSettings.SECURITY_ENABLED.get(settings);
        if (this.enabled && !this.transportClientMode) {
            Security.runStartupChecks(settings);
            Automatons.updateConfiguration((Settings)settings);
        } else {
            this.bootstrapChecks.set(Collections.emptyList());
        }
        this.securityExtensions.addAll(extensions);
    }

    private static void runStartupChecks(Settings settings) {
        Security.validateRealmSettings(settings);
        if (((Boolean)XPackSettings.FIPS_MODE_ENABLED.get(settings)).booleanValue()) {
            Security.validateForFips(settings);
        }
    }

    public Collection<Module> createGuiceModules() {
        ArrayList<Module> modules = new ArrayList<Module>();
        if (!this.enabled || this.transportClientMode) {
            modules.add(b -> b.bind(IPFilter.class).toProvider(Providers.of(null)));
        }
        if (this.transportClientMode) {
            if (!this.enabled) {
                return modules;
            }
            modules.add(b -> b.bind(SSLService.class).toProvider(this::getSslService));
            return modules;
        }
        modules.add(b -> XPackPlugin.bindFeatureSet((Binder)b, SecurityFeatureSet.class));
        if (!this.enabled) {
            modules.add(b -> {
                b.bind(Realms.class).toProvider(Providers.of(null));
                b.bind(CompositeRolesStore.class).toProvider(Providers.of(null));
                b.bind(NativeRoleMappingStore.class).toProvider(Providers.of(null));
                b.bind(AuditTrailService.class).toInstance((Object)new AuditTrailService(Collections.emptyList(), this.getLicenseState()));
            });
            return modules;
        }
        return modules;
    }

    protected Clock getClock() {
        return Clock.systemUTC();
    }

    protected SSLService getSslService() {
        return XPackPlugin.getSharedSslService();
    }

    protected XPackLicenseState getLicenseState() {
        return XPackPlugin.getSharedLicenseState();
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver expressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        try {
            return this.createComponents(client, threadPool, clusterService, resourceWatcherService, scriptService, xContentRegistry, environment, expressionResolver);
        }
        catch (Exception e) {
            throw new IllegalStateException("security initialization failed", e);
        }
    }

    Collection<Object> createComponents(Client client, ThreadPool threadPool, ClusterService clusterService, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, IndexNameExpressionResolver expressionResolver) throws Exception {
        OperatorPrivileges.OperatorPrivilegesService operatorPrivilegesService;
        if (!this.enabled) {
            return Collections.emptyList();
        }
        this.scriptServiceReference.set((Object)scriptService);
        ArrayList<BootstrapCheck> checks = new ArrayList<BootstrapCheck>();
        checks.addAll(Arrays.asList(new TokenSSLBootstrapCheck(), new PkiRealmBootstrapCheck(this.getSslService()), new TLSLicenseBootstrapCheck()));
        checks.addAll(InternalRealms.getBootstrapChecks(this.settings, environment));
        this.bootstrapChecks.set(Collections.unmodifiableList(checks));
        this.threadContext.set((Object)threadPool.getThreadContext());
        ArrayList<Object> components = new ArrayList<Object>();
        this.securityContext.set((Object)new SecurityContext(this.settings, threadPool.getThreadContext()));
        components.add(this.securityContext.get());
        java.util.List<AuditTrail> auditTrails = (Boolean)XPackSettings.AUDIT_ENABLED.get(this.settings) != false ? Collections.singletonList(new LoggingAuditTrail(this.settings, clusterService, threadPool)) : Collections.emptyList();
        AuditTrailService auditTrailService = new AuditTrailService(auditTrails, this.getLicenseState());
        components.add(auditTrailService);
        this.auditTrailService.set((Object)auditTrailService);
        this.securityIndex.set((Object)SecurityIndexManager.buildSecurityIndexManager(client, clusterService, SECURITY_MAIN_INDEX_DESCRIPTOR));
        TokenService tokenService = new TokenService(this.settings, Clock.systemUTC(), client, this.getLicenseState(), (SecurityContext)this.securityContext.get(), (SecurityIndexManager)this.securityIndex.get(), SecurityIndexManager.buildSecurityIndexManager(client, clusterService, SECURITY_TOKEN_INDEX_DESCRIPTOR), clusterService);
        this.tokenService.set((Object)tokenService);
        components.add(tokenService);
        NativeUsersStore nativeUsersStore = new NativeUsersStore(this.settings, client, (SecurityIndexManager)this.securityIndex.get());
        NativeRoleMappingStore nativeRoleMappingStore = new NativeRoleMappingStore(this.settings, client, (SecurityIndexManager)this.securityIndex.get(), scriptService);
        AnonymousUser anonymousUser = new AnonymousUser(this.settings);
        components.add(anonymousUser);
        ReservedRealm reservedRealm = new ReservedRealm(environment, this.settings, nativeUsersStore, anonymousUser, (SecurityIndexManager)this.securityIndex.get(), threadPool);
        ExtensionComponents extensionComponents = new ExtensionComponents(environment, client, clusterService, resourceWatcherService, nativeRoleMappingStore);
        HashMap<String, Realm.Factory> realmFactories = new HashMap<String, Realm.Factory>(InternalRealms.getFactories(threadPool, resourceWatcherService, this.getSslService(), nativeUsersStore, nativeRoleMappingStore, (SecurityIndexManager)this.securityIndex.get()));
        for (SecurityExtension extension : this.securityExtensions) {
            Map newRealms = extension.getRealms((SecurityExtension.SecurityComponents)extensionComponents);
            for (Map.Entry entry : newRealms.entrySet()) {
                if (realmFactories.put((String)entry.getKey(), (Realm.Factory)entry.getValue()) == null) continue;
                throw new IllegalArgumentException("Realm type [" + (String)entry.getKey() + "] is already registered");
            }
        }
        Realms realms = new Realms(this.settings, environment, realmFactories, this.getLicenseState(), threadPool.getThreadContext(), reservedRealm);
        components.add(nativeUsersStore);
        components.add(nativeRoleMappingStore);
        components.add(realms);
        components.add((Object)reservedRealm);
        ((SecurityIndexManager)this.securityIndex.get()).addStateListener(nativeRoleMappingStore::onSecurityIndexStateChange);
        CacheInvalidatorRegistry cacheInvalidatorRegistry = new CacheInvalidatorRegistry();
        cacheInvalidatorRegistry.registerAlias("service", org.elasticsearch.core.Set.of((Object)"file_service_account_token", (Object)"index_service_account_token"));
        components.add(cacheInvalidatorRegistry);
        ((SecurityIndexManager)this.securityIndex.get()).addStateListener(cacheInvalidatorRegistry::onSecurityIndexStateChange);
        NativePrivilegeStore privilegeStore = new NativePrivilegeStore(this.settings, client, (SecurityIndexManager)this.securityIndex.get(), cacheInvalidatorRegistry);
        components.add(privilegeStore);
        this.dlsBitsetCache.set((Object)new DocumentSubsetBitsetCache(this.settings, threadPool));
        FieldPermissionsCache fieldPermissionsCache = new FieldPermissionsCache(this.settings);
        FileRolesStore fileRolesStore = new FileRolesStore(this.settings, environment, resourceWatcherService, this.getLicenseState(), xContentRegistry);
        NativeRolesStore nativeRolesStore = new NativeRolesStore(this.settings, client, this.getLicenseState(), (SecurityIndexManager)this.securityIndex.get());
        ReservedRolesStore reservedRolesStore = new ReservedRolesStore();
        RoleDescriptor.setFieldPermissionsCache((FieldPermissionsCache)fieldPermissionsCache);
        LinkedHashMap<String, java.util.List<BiConsumer<Set<String>, ActionListener<RoleRetrievalResult>>>> customRoleProviders = new LinkedHashMap<String, java.util.List<BiConsumer<Set<String>, ActionListener<RoleRetrievalResult>>>>();
        for (SecurityExtension extension : this.securityExtensions) {
            java.util.List providers = extension.getRolesProviders((SecurityExtension.SecurityComponents)extensionComponents);
            if (providers == null || providers.isEmpty()) continue;
            customRoleProviders.put(extension.extensionName(), providers);
        }
        ApiKeyService apiKeyService = new ApiKeyService(this.settings, Clock.systemUTC(), client, this.getLicenseState(), (SecurityIndexManager)this.securityIndex.get(), clusterService, cacheInvalidatorRegistry, threadPool);
        components.add(apiKeyService);
        IndexServiceAccountTokenStore indexServiceAccountTokenStore = new IndexServiceAccountTokenStore(this.settings, threadPool, this.getClock(), client, (SecurityIndexManager)this.securityIndex.get(), clusterService, cacheInvalidatorRegistry);
        components.add(indexServiceAccountTokenStore);
        FileServiceAccountTokenStore fileServiceAccountTokenStore = new FileServiceAccountTokenStore(environment, resourceWatcherService, threadPool, clusterService, cacheInvalidatorRegistry);
        components.add(fileServiceAccountTokenStore);
        ServiceAccountService serviceAccountService = new ServiceAccountService(client, fileServiceAccountTokenStore, indexServiceAccountTokenStore);
        components.add(serviceAccountService);
        RoleProviders roleProviders = new RoleProviders(reservedRolesStore, fileRolesStore, nativeRolesStore, customRoleProviders, this.getLicenseState());
        CompositeRolesStore allRolesStore = new CompositeRolesStore(this.settings, roleProviders, privilegeStore, threadPool.getThreadContext(), this.getLicenseState(), fieldPermissionsCache, apiKeyService, serviceAccountService, (DocumentSubsetBitsetCache)this.dlsBitsetCache.get(), new DeprecationRoleDescriptorConsumer(clusterService, threadPool));
        ((SecurityIndexManager)this.securityIndex.get()).addStateListener(allRolesStore::onSecurityIndexStateChange);
        this.getLicenseState().addListener(allRolesStore::invalidateAll);
        this.getLicenseState().addListener((LicenseStateListener)new SecurityStatusChangeListener(this.getLicenseState()));
        AuthenticationFailureHandler failureHandler = this.createAuthenticationFailureHandler(realms, extensionComponents);
        boolean operatorPrivilegesEnabled = (Boolean)OperatorPrivileges.OPERATOR_PRIVILEGES_ENABLED.get(this.settings);
        if (operatorPrivilegesEnabled) {
            logger.info("operator privileges are enabled");
            operatorPrivilegesService = new OperatorPrivileges.DefaultOperatorPrivilegesService(this.getLicenseState(), new FileOperatorUsersStore(environment, resourceWatcherService), new OperatorOnlyRegistry(clusterService.getClusterSettings()));
        } else {
            operatorPrivilegesService = OperatorPrivileges.NOOP_OPERATOR_PRIVILEGES_SERVICE;
        }
        this.authcService.set((Object)new AuthenticationService(this.settings, realms, auditTrailService, failureHandler, threadPool, anonymousUser, tokenService, apiKeyService, serviceAccountService, operatorPrivilegesService));
        components.add(this.authcService.get());
        ((SecurityIndexManager)this.securityIndex.get()).addStateListener(((AuthenticationService)this.authcService.get())::onSecurityIndexStateChange);
        Set<Object> requestInterceptors = Sets.newHashSet((Object[])new RequestInterceptor[]{new ResizeRequestInterceptor(threadPool, this.getLicenseState(), auditTrailService), new IndicesAliasesRequestInterceptor(threadPool.getThreadContext(), this.getLicenseState(), auditTrailService)});
        if (((Boolean)XPackSettings.DLS_FLS_ENABLED.get(this.settings)).booleanValue()) {
            requestInterceptors.addAll(Arrays.asList(new SearchRequestInterceptor(threadPool, this.getLicenseState(), clusterService), new ShardSearchRequestInterceptor(threadPool, this.getLicenseState(), clusterService), new UpdateRequestInterceptor(threadPool, this.getLicenseState()), new BulkShardRequestInterceptor(threadPool, this.getLicenseState()), new DlsFlsLicenseRequestInterceptor(threadPool.getThreadContext(), this.getLicenseState())));
        }
        requestInterceptors = Collections.unmodifiableSet(requestInterceptors);
        AuthorizationService authzService = new AuthorizationService(this.settings, allRolesStore, fieldPermissionsCache, clusterService, auditTrailService, failureHandler, threadPool, anonymousUser, this.getAuthorizationEngine(), requestInterceptors, this.getLicenseState(), expressionResolver, operatorPrivilegesService);
        components.add(nativeRolesStore);
        components.add(reservedRolesStore);
        components.add(allRolesStore);
        components.add(authzService);
        SecondaryAuthenticator secondaryAuthenticator = new SecondaryAuthenticator((SecurityContext)this.securityContext.get(), (AuthenticationService)this.authcService.get(), auditTrailService);
        this.secondayAuthc.set((Object)secondaryAuthenticator);
        components.add(secondaryAuthenticator);
        this.ipFilter.set((Object)new IPFilter(this.settings, auditTrailService, clusterService.getClusterSettings(), this.getLicenseState()));
        components.add(this.ipFilter.get());
        DestructiveOperations destructiveOperations = new DestructiveOperations(this.settings, clusterService.getClusterSettings());
        this.securityInterceptor.set((Object)new SecurityServerTransportInterceptor(this.settings, threadPool, (AuthenticationService)this.authcService.get(), authzService, this.getLicenseState(), this.getSslService(), (SecurityContext)this.securityContext.get(), destructiveOperations, clusterService));
        this.securityActionFilter.set((Object)new SecurityActionFilter((AuthenticationService)this.authcService.get(), authzService, auditTrailService, this.getLicenseState(), threadPool, (SecurityContext)this.securityContext.get(), destructiveOperations));
        cacheInvalidatorRegistry.validate();
        return components;
    }

    private AuthorizationEngine getAuthorizationEngine() {
        return this.findValueFromExtensions("authorization engine", extension -> extension.getAuthorizationEngine(this.settings));
    }

    private AuthenticationFailureHandler createAuthenticationFailureHandler(Realms realms, SecurityExtension.SecurityComponents components) {
        AuthenticationFailureHandler failureHandler = this.findValueFromExtensions("authentication failure handler", extension -> extension.getAuthenticationFailureHandler(components));
        if (failureHandler == null) {
            logger.debug("Using default authentication failure handler");
            Supplier<Map> headersSupplier = () -> {
                HashMap<String, java.util.List> defaultFailureResponseHeaders = new HashMap<String, java.util.List>();
                realms.getActiveRealms().stream().forEach(realm -> {
                    Map realmFailureHeaders = realm.getAuthenticationFailureHeaders();
                    realmFailureHeaders.entrySet().stream().forEach(e -> {
                        String key = (String)e.getKey();
                        ((java.util.List)e.getValue()).stream().filter(v -> !defaultFailureResponseHeaders.computeIfAbsent(key, x -> new ArrayList()).contains(v)).forEach(v -> ((java.util.List)defaultFailureResponseHeaders.get(key)).add(v));
                    });
                });
                if (TokenService.isTokenServiceEnabled(this.settings).booleanValue()) {
                    String bearerScheme = "Bearer realm=\"security\"";
                    if (!defaultFailureResponseHeaders.computeIfAbsent("WWW-Authenticate", x -> new ArrayList()).contains(bearerScheme)) {
                        ((java.util.List)defaultFailureResponseHeaders.get("WWW-Authenticate")).add(bearerScheme);
                    }
                }
                if (((Boolean)XPackSettings.API_KEY_SERVICE_ENABLED_SETTING.get(this.settings)).booleanValue()) {
                    String apiKeyScheme = "ApiKey";
                    if (!defaultFailureResponseHeaders.computeIfAbsent("WWW-Authenticate", x -> new ArrayList()).contains("ApiKey")) {
                        ((java.util.List)defaultFailureResponseHeaders.get("WWW-Authenticate")).add("ApiKey");
                    }
                }
                return defaultFailureResponseHeaders;
            };
            DefaultAuthenticationFailureHandler finalDefaultFailureHandler = new DefaultAuthenticationFailureHandler(headersSupplier.get());
            failureHandler = finalDefaultFailureHandler;
            this.getLicenseState().addListener(() -> finalDefaultFailureHandler.setHeaders((Map)headersSupplier.get()));
        }
        return failureHandler;
    }

    @Nullable
    private <T> T findValueFromExtensions(String valueType, Function<SecurityExtension, T> method) {
        T foundValue = null;
        String fromExtension = null;
        for (SecurityExtension extension : this.securityExtensions) {
            T extensionValue = method.apply(extension);
            if (extensionValue == null) continue;
            if (foundValue == null) {
                foundValue = extensionValue;
                fromExtension = extension.extensionName();
                continue;
            }
            throw new IllegalStateException("Extensions [" + fromExtension + "] and [" + extension.extensionName() + "]  both attempted to provide a value for [" + valueType + "]");
        }
        if (foundValue == null) {
            return null;
        }
        logger.debug("Using [{}] [{}] from extension [{}]", (Object)valueType, foundValue, fromExtension);
        return foundValue;
    }

    public Settings additionalSettings() {
        return Security.additionalSettings(this.settings, this.enabled, this.transportClientMode);
    }

    /*
     * Enabled aggressive block sorting
     */
    static Settings additionalSettings(Settings settings, boolean enabled, boolean transportClientMode) {
        if (enabled && !transportClientMode) {
            Settings.Builder builder = Settings.builder();
            builder.put(SecuritySettings.addTransportSettings((Settings)settings));
            if (NetworkModule.HTTP_TYPE_SETTING.exists(settings)) {
                String httpType = (String)NetworkModule.HTTP_TYPE_SETTING.get(settings);
                if (!httpType.equals("security4") && !httpType.equals("security-nio")) {
                    String message = String.format(Locale.ROOT, "http type setting [%s] must be [%s] or [%s] but is [%s]", "http.type", "security4", "security-nio", httpType);
                    throw new IllegalArgumentException(message);
                }
                SecurityHttpSettings.overrideSettings(builder, settings);
            } else {
                builder.put("http.type", "security4");
                SecurityHttpSettings.overrideSettings(builder, settings);
            }
            builder.put(SecuritySettings.addUserSettings((Settings)settings));
            return builder.build();
        }
        return Settings.EMPTY;
    }

    public java.util.List<Setting<?>> getSettings() {
        return Security.getSettings(this.transportClientMode, this.securityExtensions);
    }

    public static java.util.List<Setting<?>> getSettings(boolean transportClientMode, java.util.List<SecurityExtension> securityExtensions) {
        ArrayList settingsList = new ArrayList();
        if (transportClientMode) {
            return settingsList;
        }
        IPFilter.addSettings(settingsList);
        LoggingAuditTrail.registerSettings(settingsList);
        AnonymousUser.addSettings(settingsList);
        settingsList.addAll(InternalRealmsSettings.getSettings());
        NativeRolesStore.addSettings(settingsList);
        ReservedRealm.addSettings(settingsList);
        AuthenticationService.addSettings(settingsList);
        AuthorizationService.addSettings(settingsList);
        Automatons.addSettings(settingsList);
        settingsList.addAll(CompositeRolesStore.getSettings());
        settingsList.addAll(DocumentSubsetBitsetCache.getSettings());
        settingsList.add(FieldPermissionsCache.CACHE_SIZE_SETTING);
        settingsList.add(TokenService.TOKEN_EXPIRATION);
        settingsList.add(TokenService.DELETE_INTERVAL);
        settingsList.add(TokenService.DELETE_TIMEOUT);
        settingsList.add((Setting<?>)SecurityServerTransportInterceptor.TRANSPORT_TYPE_PROFILE_SETTING);
        settingsList.addAll(SSLConfigurationSettings.getProfileSettings());
        settingsList.add(ApiKeyService.PASSWORD_HASHING_ALGORITHM);
        settingsList.add(ApiKeyService.DELETE_TIMEOUT);
        settingsList.add(ApiKeyService.DELETE_INTERVAL);
        settingsList.add(ApiKeyService.CACHE_HASH_ALGO_SETTING);
        settingsList.add(ApiKeyService.CACHE_MAX_KEYS_SETTING);
        settingsList.add(ApiKeyService.CACHE_TTL_SETTING);
        settingsList.add(ApiKeyService.DOC_CACHE_TTL_SETTING);
        settingsList.add(NativePrivilegeStore.CACHE_MAX_APPLICATIONS_SETTING);
        settingsList.add(NativePrivilegeStore.CACHE_TTL_SETTING);
        settingsList.add(OperatorPrivileges.OPERATOR_PRIVILEGES_ENABLED);
        settingsList.add(CachingServiceAccountTokenStore.CACHE_TTL_SETTING);
        settingsList.add(CachingServiceAccountTokenStore.CACHE_HASH_ALGO_SETTING);
        settingsList.add(CachingServiceAccountTokenStore.CACHE_MAX_TOKENS_SETTING);
        settingsList.add(Setting.listSetting((String)SecurityField.setting((String)"hide_settings"), Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        return settingsList;
    }

    public Collection<RestHeaderDefinition> getRestHeaders() {
        if (this.transportClientMode) {
            return Collections.emptyList();
        }
        HashSet<RestHeaderDefinition> headers = new HashSet<RestHeaderDefinition>();
        headers.add(new RestHeaderDefinition("Authorization", false));
        headers.add(new RestHeaderDefinition("es-secondary-authorization", false));
        if (((Boolean)XPackSettings.AUDIT_ENABLED.get(this.settings)).booleanValue()) {
            headers.add(new RestHeaderDefinition("X-Forwarded-For", true));
        }
        if (((Boolean)AuthenticationServiceField.RUN_AS_ENABLED.get(this.settings)).booleanValue()) {
            headers.add(new RestHeaderDefinition("es-security-runas-user", false));
        }
        return headers;
    }

    public java.util.List<String> getSettingsFilter() {
        java.util.List asArray = this.settings.getAsList(SecurityField.setting((String)"hide_settings"));
        ArrayList<String> settingsFilter = new ArrayList<String>(asArray);
        settingsFilter.add("transport.profiles.*." + SecurityField.setting((String)"*"));
        return settingsFilter;
    }

    public java.util.List<BootstrapCheck> getBootstrapChecks() {
        return (java.util.List)this.bootstrapChecks.get();
    }

    public void onIndexModule(IndexModule module) {
        if (this.enabled) {
            assert (this.getLicenseState() != null);
            if (((Boolean)XPackSettings.DLS_FLS_ENABLED.get(this.settings)).booleanValue()) {
                assert (this.dlsBitsetCache.get() != null);
                module.setReaderWrapper(indexService -> new SecurityIndexReaderWrapper(shardId -> indexService.newSearchExecutionContext(shardId.id(), 0, null, () -> {
                    throw new IllegalArgumentException("permission filters are not allowed to use the current timestamp");
                }, null, Collections.emptyMap()), (DocumentSubsetBitsetCache)this.dlsBitsetCache.get(), (SecurityContext)this.securityContext.get(), this.getLicenseState(), indexService.getScriptService()));
                module.forceQueryCacheProvider((settings, cache) -> {
                    OptOutQueryCache queryCache = new OptOutQueryCache((IndexSettings)settings, (IndicesQueryCache)cache, (ThreadContext)this.threadContext.get(), this.getLicenseState());
                    queryCache.listenForLicenseStateChanges();
                    return queryCache;
                });
            }
            module.addSearchOperationListener((SearchOperationListener)new SecuritySearchOperationListener((SecurityContext)this.securityContext.get(), this.getLicenseState(), (AuditTrailService)this.auditTrailService.get()));
        }
    }

    public java.util.List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        if (!this.enabled) {
            return Collections.emptyList();
        }
        return Arrays.asList(new ActionPlugin.ActionHandler((ActionType)ClearRealmCacheAction.INSTANCE, TransportClearRealmCacheAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ClearRolesCacheAction.INSTANCE, TransportClearRolesCacheAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ClearPrivilegesCacheAction.INSTANCE, TransportClearPrivilegesCacheAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ClearSecurityCacheAction.INSTANCE, TransportClearSecurityCacheAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetUsersAction.INSTANCE, TransportGetUsersAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)PutUserAction.INSTANCE, TransportPutUserAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)DeleteUserAction.INSTANCE, TransportDeleteUserAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetRolesAction.INSTANCE, TransportGetRolesAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)PutRoleAction.INSTANCE, TransportPutRoleAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)DeleteRoleAction.INSTANCE, TransportDeleteRoleAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ChangePasswordAction.INSTANCE, TransportChangePasswordAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)AuthenticateAction.INSTANCE, TransportAuthenticateAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)SetEnabledAction.INSTANCE, TransportSetEnabledAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)HasPrivilegesAction.INSTANCE, TransportHasPrivilegesAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetUserPrivilegesAction.INSTANCE, TransportGetUserPrivilegesAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetRoleMappingsAction.INSTANCE, TransportGetRoleMappingsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)PutRoleMappingAction.INSTANCE, TransportPutRoleMappingAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)DeleteRoleMappingAction.INSTANCE, TransportDeleteRoleMappingAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)CreateTokenAction.INSTANCE, TransportCreateTokenAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)InvalidateTokenAction.INSTANCE, TransportInvalidateTokenAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetCertificateInfoAction.INSTANCE, TransportGetCertificateInfoAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)RefreshTokenAction.INSTANCE, TransportRefreshTokenAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)SamlPrepareAuthenticationAction.INSTANCE, TransportSamlPrepareAuthenticationAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)SamlAuthenticateAction.INSTANCE, TransportSamlAuthenticateAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)SamlLogoutAction.INSTANCE, TransportSamlLogoutAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)SamlInvalidateSessionAction.INSTANCE, TransportSamlInvalidateSessionAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)SamlCompleteLogoutAction.INSTANCE, TransportSamlCompleteLogoutAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)SamlSpMetadataAction.INSTANCE, TransportSamlSpMetadataAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)OpenIdConnectPrepareAuthenticationAction.INSTANCE, TransportOpenIdConnectPrepareAuthenticationAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)OpenIdConnectAuthenticateAction.INSTANCE, TransportOpenIdConnectAuthenticateAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)OpenIdConnectLogoutAction.INSTANCE, TransportOpenIdConnectLogoutAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetBuiltinPrivilegesAction.INSTANCE, TransportGetBuiltinPrivilegesAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetPrivilegesAction.INSTANCE, TransportGetPrivilegesAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)PutPrivilegesAction.INSTANCE, TransportPutPrivilegesAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)DeletePrivilegesAction.INSTANCE, TransportDeletePrivilegesAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)CreateApiKeyAction.INSTANCE, TransportCreateApiKeyAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GrantApiKeyAction.INSTANCE, TransportGrantApiKeyAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)InvalidateApiKeyAction.INSTANCE, TransportInvalidateApiKeyAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetApiKeyAction.INSTANCE, TransportGetApiKeyAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)QueryApiKeyAction.INSTANCE, TransportQueryApiKeyAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)DelegatePkiAuthenticationAction.INSTANCE, TransportDelegatePkiAuthenticationAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)CreateServiceAccountTokenAction.INSTANCE, TransportCreateServiceAccountTokenAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)DeleteServiceAccountTokenAction.INSTANCE, TransportDeleteServiceAccountTokenAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetServiceAccountCredentialsAction.INSTANCE, TransportGetServiceAccountCredentialsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetServiceAccountNodesCredentialsAction.INSTANCE, TransportGetServiceAccountNodesCredentialsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetServiceAccountAction.INSTANCE, TransportGetServiceAccountAction.class, new Class[0]));
    }

    public java.util.List<ActionFilter> getActionFilters() {
        if (!this.enabled) {
            return Collections.emptyList();
        }
        if (!this.transportClientMode) {
            return Collections.singletonList((ActionFilter)this.securityActionFilter.get());
        }
        return Collections.emptyList();
    }

    public java.util.List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        if (!this.enabled) {
            return Collections.emptyList();
        }
        return Arrays.asList(new RestHandler[]{new RestAuthenticateAction(settings, (SecurityContext)this.securityContext.get(), this.getLicenseState()), new RestClearRealmCacheAction(settings, this.getLicenseState()), new RestClearRolesCacheAction(settings, this.getLicenseState()), new RestClearPrivilegesCacheAction(settings, this.getLicenseState()), new RestClearApiKeyCacheAction(settings, this.getLicenseState()), new RestClearServiceAccountTokenStoreCacheAction(settings, this.getLicenseState()), new RestGetUsersAction(settings, this.getLicenseState()), new RestPutUserAction(settings, this.getLicenseState()), new RestDeleteUserAction(settings, this.getLicenseState()), new RestGetRolesAction(settings, this.getLicenseState()), new RestPutRoleAction(settings, this.getLicenseState()), new RestDeleteRoleAction(settings, this.getLicenseState()), new RestChangePasswordAction(settings, (SecurityContext)this.securityContext.get(), this.getLicenseState()), new RestSetEnabledAction(settings, this.getLicenseState()), new RestHasPrivilegesAction(settings, (SecurityContext)this.securityContext.get(), this.getLicenseState()), new RestGetUserPrivilegesAction(settings, (SecurityContext)this.securityContext.get(), this.getLicenseState()), new RestGetRoleMappingsAction(settings, this.getLicenseState()), new RestPutRoleMappingAction(settings, this.getLicenseState()), new RestDeleteRoleMappingAction(settings, this.getLicenseState()), new RestGetTokenAction(settings, this.getLicenseState()), new RestInvalidateTokenAction(settings, this.getLicenseState()), new RestGetCertificateInfoAction(), new RestSamlPrepareAuthenticationAction(settings, this.getLicenseState()), new RestSamlAuthenticateAction(settings, this.getLicenseState()), new RestSamlLogoutAction(settings, this.getLicenseState()), new RestSamlInvalidateSessionAction(settings, this.getLicenseState()), new RestSamlCompleteLogoutAction(settings, this.getLicenseState()), new RestSamlSpMetadataAction(settings, this.getLicenseState()), new RestOpenIdConnectPrepareAuthenticationAction(settings, this.getLicenseState()), new RestOpenIdConnectAuthenticateAction(settings, this.getLicenseState()), new RestOpenIdConnectLogoutAction(settings, this.getLicenseState()), new RestGetBuiltinPrivilegesAction(settings, this.getLicenseState()), new RestGetPrivilegesAction(settings, this.getLicenseState()), new RestPutPrivilegesAction(settings, this.getLicenseState()), new RestDeletePrivilegesAction(settings, this.getLicenseState()), new RestCreateApiKeyAction(settings, this.getLicenseState()), new RestGrantApiKeyAction(settings, this.getLicenseState()), new RestInvalidateApiKeyAction(settings, this.getLicenseState()), new RestGetApiKeyAction(settings, this.getLicenseState()), new RestQueryApiKeyAction(settings, this.getLicenseState()), new RestDelegatePkiAuthenticationAction(settings, this.getLicenseState()), new RestCreateServiceAccountTokenAction(settings, this.getLicenseState()), new RestDeleteServiceAccountTokenAction(settings, this.getLicenseState()), new RestGetServiceAccountCredentialsAction(settings, this.getLicenseState()), new RestGetServiceAccountAction(settings, this.getLicenseState())});
    }

    public Map<String, Processor.Factory> getProcessors(Processor.Parameters parameters) {
        return Collections.singletonMap("set_security_user", new SetSecurityUserProcessor.Factory(() -> this.securityContext.get(), this::getLicenseState));
    }

    static void validateRealmSettings(Settings settings) {
        Set badRealmSettings = settings.keySet().stream().filter(k -> k.startsWith("xpack.security.authc.realms.")).filter(key -> {
            String suffix = key.substring("xpack.security.authc.realms.".length());
            return suffix.indexOf(46) == suffix.lastIndexOf(46);
        }).collect(Collectors.toSet());
        if (!badRealmSettings.isEmpty()) {
            String sampleRealmSetting = RealmSettings.realmSettingPrefix((RealmConfig.RealmIdentifier)new RealmConfig.RealmIdentifier("file", "my_file")) + "order";
            throw new IllegalArgumentException("Incorrect realm settings found. Realm settings have been changed to include the type as part of the setting key.\nFor example '" + sampleRealmSetting + "'\nFound invalid config: " + Strings.collectionToDelimitedString(badRealmSettings, (String)", ") + "\nPlease see the breaking changes documentation.");
        }
    }

    static void validateForFips(Settings settings) {
        String selectedAlgorithm;
        Settings keystorePathSettings;
        ArrayList<String> validationErrors = new ArrayList<String>();
        Settings keystoreTypeSettings = settings.filter(k -> k.endsWith("keystore.type")).filter(k -> settings.get(k).equalsIgnoreCase("jks"));
        if (!keystoreTypeSettings.isEmpty()) {
            validationErrors.add("JKS Keystores cannot be used in a FIPS 140 compliant JVM. Please revisit [" + keystoreTypeSettings.toDelimitedString(',') + "] settings");
        }
        if (!(keystorePathSettings = settings.filter(k -> k.endsWith("keystore.path")).filter(k -> !settings.hasValue(k.replace(".path", ".type")))).isEmpty() && SSLConfigurationSettings.inferKeyStoreType(null).equals("jks")) {
            validationErrors.add("JKS Keystores cannot be used in a FIPS 140 compliant JVM. Please revisit [" + keystorePathSettings.toDelimitedString(',') + "] settings");
        }
        if (!(selectedAlgorithm = (String)XPackSettings.PASSWORD_HASHING_ALGORITHM.get(settings)).toLowerCase(Locale.ROOT).startsWith("pbkdf2")) {
            validationErrors.add("Only PBKDF2 is allowed for password hashing in a FIPS 140 JVM. Please set the appropriate value for [ " + XPackSettings.PASSWORD_HASHING_ALGORITHM.getKey() + " ] setting.");
        }
        if (!validationErrors.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Validation for FIPS 140 mode failed: \n");
            int index = 0;
            for (String error : validationErrors) {
                sb.append(++index).append(": ").append(error).append(";\n");
            }
            throw new IllegalArgumentException(sb.toString());
        }
    }

    public java.util.List<TransportInterceptor> getTransportInterceptors(NamedWriteableRegistry namedWriteableRegistry, ThreadContext threadContext) {
        if (this.transportClientMode || !this.enabled) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new TransportInterceptor(){

            public <T extends TransportRequest> TransportRequestHandler<T> interceptHandler(String action, String executor, boolean forceExecution, TransportRequestHandler<T> actualHandler) {
                assert (Security.this.securityInterceptor.get() != null);
                return ((TransportInterceptor)Security.this.securityInterceptor.get()).interceptHandler(action, executor, forceExecution, actualHandler);
            }

            public TransportInterceptor.AsyncSender interceptSender(TransportInterceptor.AsyncSender sender) {
                assert (Security.this.securityInterceptor.get() != null);
                return ((TransportInterceptor)Security.this.securityInterceptor.get()).interceptSender(sender);
            }
        });
    }

    public Map<String, Supplier<Transport>> getTransports(Settings settings, ThreadPool threadPool, PageCacheRecycler pageCacheRecycler, CircuitBreakerService circuitBreakerService, NamedWriteableRegistry namedWriteableRegistry, NetworkService networkService) {
        if (this.transportClientMode || !this.enabled) {
            return Collections.emptyMap();
        }
        IPFilter ipFilter = (IPFilter)this.ipFilter.get();
        HashMap<String, Supplier<Transport>> transports = new HashMap<String, Supplier<Transport>>();
        transports.put("security4", () -> {
            this.transportReference.set((Object)new SecurityNetty4ServerTransport(settings, Version.CURRENT, threadPool, networkService, pageCacheRecycler, namedWriteableRegistry, circuitBreakerService, ipFilter, this.getSslService(), this.getNettySharedGroupFactory(settings)));
            return (Transport)this.transportReference.get();
        });
        transports.put("security-nio", () -> {
            this.transportReference.set((Object)new SecurityNioTransport(settings, Version.CURRENT, threadPool, networkService, pageCacheRecycler, namedWriteableRegistry, circuitBreakerService, ipFilter, this.getSslService(), this.getNioGroupFactory(settings)));
            return (Transport)this.transportReference.get();
        });
        return Collections.unmodifiableMap(transports);
    }

    public Map<String, Supplier<HttpServerTransport>> getHttpTransports(Settings settings, ThreadPool threadPool, BigArrays bigArrays, PageCacheRecycler pageCacheRecycler, CircuitBreakerService circuitBreakerService, NamedXContentRegistry xContentRegistry, NetworkService networkService, HttpServerTransport.Dispatcher dispatcher, final BiConsumer<HttpPreRequest, ThreadContext> perRequestThreadContext, ClusterSettings clusterSettings) {
        if (!this.enabled) {
            return Collections.emptyMap();
        }
        HashMap<String, Supplier<HttpServerTransport>> httpTransports = new HashMap<String, Supplier<HttpServerTransport>>();
        httpTransports.put("security4", () -> {
            BiConsumer<Channel, ThreadContext> populateClientCertificate = (Boolean)XPackSettings.HTTP_SSL_ENABLED.get(settings) != false && this.getSslService().isSSLClientAuthEnabled(this.getSslService().getHttpTransportSSLConfiguration()) ? (channel, threadContext) -> SSLEngineUtils.extractClientCertificates(logger, threadContext, channel) : (channel, threadContext) -> {};
            AuthenticationService authenticationService = (AuthenticationService)this.authcService.get();
            ThreadContext threadContext2 = (ThreadContext)this.threadContext.get();
            return Security.getHttpServerTransportWithHeadersValidator(settings, networkService, bigArrays, threadPool, xContentRegistry, dispatcher, (IPFilter)this.ipFilter.get(), this.getSslService(), this.getNettySharedGroupFactory(settings), clusterSettings, (httpRequest, channel, listener) -> {
                HttpPreRequest httpPreRequest = HttpHeadersAuthenticatorUtils.asHttpPreRequest((io.netty.handler.codec.http.HttpRequest)httpRequest);
                perRequestThreadContext.accept(httpPreRequest, threadContext2);
                populateClientCertificate.accept(channel, threadContext2);
                RemoteHostHeader.process(channel, threadContext2);
                authenticationService.authenticate(httpPreRequest, (ActionListener<Authentication>)ActionListener.wrap(ignored -> listener.onResponse(null), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
            }, (httpRequest, channel, listener) -> {
                HttpPreRequest httpPreRequest = HttpHeadersAuthenticatorUtils.asHttpPreRequest((io.netty.handler.codec.http.HttpRequest)httpRequest);
                perRequestThreadContext.accept(httpPreRequest, threadContext2);
                populateClientCertificate.accept(channel, threadContext2);
                RemoteHostHeader.process(channel, threadContext2);
                listener.onResponse(null);
            });
        });
        httpTransports.put("security-nio", () -> {
            final BiConsumer<HttpChannel, ThreadContext> populateClientCertificate = (Boolean)XPackSettings.HTTP_SSL_ENABLED.get(settings) != false && this.getSslService().isSSLClientAuthEnabled(this.getSslService().getHttpTransportSSLConfiguration()) ? (channel, threadContext) -> SSLEngineUtils.extractClientCertificates(logger, threadContext, channel) : (channel, threadContext) -> {};
            return new SecurityNioHttpServerTransport(settings, networkService, bigArrays, pageCacheRecycler, threadPool, xContentRegistry, dispatcher, (IPFilter)this.ipFilter.get(), this.getSslService(), this.getNioGroupFactory(settings), clusterSettings){

                protected void populatePerRequestThreadContext(RestRequest restRequest, ThreadContext threadContext) {
                    perRequestThreadContext.accept(restRequest.getHttpRequest(), threadContext);
                    populateClientCertificate.accept(restRequest.getHttpChannel(), threadContext);
                    RemoteHostHeader.process(restRequest.getHttpChannel(), threadContext);
                }
            };
        });
        return httpTransports;
    }

    public static SecurityNetty4HttpServerTransport getHttpServerTransportWithHeadersValidator(Settings settings, NetworkService networkService, BigArrays bigArrays, ThreadPool threadPool, NamedXContentRegistry xContentRegistry, HttpServerTransport.Dispatcher dispatcher, IPFilter ipFilter, SSLService sslService, SharedGroupFactory sharedGroupFactory, ClusterSettings clusterSettings, HttpValidator httpValidator, HttpValidator httpOptionsValidator) {
        return Security.getHttpServerTransportWithHeadersValidator(settings, networkService, bigArrays, threadPool, xContentRegistry, dispatcher, ipFilter, sslService, sharedGroupFactory, clusterSettings, (httpRequest, channel, listener) -> {
            if (httpRequest.method() == HttpMethod.OPTIONS) {
                if (HttpUtil.getContentLength((HttpMessage)httpRequest, (long)-1L) > 1L || HttpUtil.isTransferEncodingChunked((HttpMessage)httpRequest)) {
                    listener.onFailure((Exception)new ElasticsearchStatusException("OPTIONS requests with a payload body are not supported", RestStatus.BAD_REQUEST, new Object[0]));
                } else {
                    httpOptionsValidator.validate(httpRequest, channel, listener);
                }
            } else {
                httpValidator.validate(httpRequest, channel, listener);
            }
        });
    }

    public static SecurityNetty4HttpServerTransport getHttpServerTransportWithHeadersValidator(Settings settings, NetworkService networkService, BigArrays bigArrays, ThreadPool threadPool, NamedXContentRegistry xContentRegistry, HttpServerTransport.Dispatcher dispatcher, IPFilter ipFilter, SSLService sslService, SharedGroupFactory sharedGroupFactory, ClusterSettings clusterSettings, HttpValidator httpValidator) {
        return new SecurityNetty4HttpServerTransport(settings, networkService, bigArrays, ipFilter, sslService, threadPool, xContentRegistry, dispatcher, clusterSettings, sharedGroupFactory, Objects.requireNonNull(httpValidator)){

            protected void populatePerRequestThreadContext(RestRequest restRequest, ThreadContext threadContext) {
                ThreadContext.StoredContext authenticationThreadContext = HttpHeadersAuthenticatorUtils.extractAuthenticationContext((HttpRequest)restRequest.getHttpRequest());
                if (authenticationThreadContext == null) {
                    throw new ElasticsearchSecurityException("Request is not authenticated", new Object[0]);
                }
                authenticationThreadContext.restore();
            }
        };
    }

    public UnaryOperator<RestHandler> getRestHandlerWrapper(ThreadContext threadContext) {
        if (!this.enabled || this.transportClientMode) {
            return null;
        }
        return handler -> new SecurityRestFilter(this.getLicenseState(), (AuthenticationService)this.authcService.get(), (SecondaryAuthenticator)this.secondayAuthc.get(), (AuditTrailService)this.auditTrailService.get(), (RestHandler)handler);
    }

    public java.util.List<ExecutorBuilder<?>> getExecutorBuilders(Settings settings) {
        if (this.enabled && !this.transportClientMode) {
            int allocatedProcessors = EsExecutors.allocatedProcessors((Settings)settings);
            return List.of((Object)new FixedExecutorBuilder(settings, "security-token-key", 1, 1000, "xpack.security.authc.token.thread_pool", false), (Object)new FixedExecutorBuilder(settings, SECURITY_CRYPTO_THREAD_POOL_NAME, (allocatedProcessors + 1) / 2, 1000, "xpack.security.crypto.thread_pool", false));
        }
        return Collections.emptyList();
    }

    public UnaryOperator<Map<String, IndexTemplateMetadata>> getIndexTemplateMetadataUpgrader() {
        return templates -> {
            templates.remove("security_audit_log");
            templates.remove("security-index-template");
            return templates;
        };
    }

    public Function<String, Predicate<String>> getFieldFilter() {
        if (this.enabled) {
            return index -> {
                XPackLicenseState licenseState = this.getLicenseState();
                if (!licenseState.isSecurityEnabled()) {
                    return MapperPlugin.NOOP_FIELD_PREDICATE;
                }
                IndicesAccessControl indicesAccessControl = (IndicesAccessControl)((ThreadContext)this.threadContext.get()).getTransient("_indices_permissions");
                if (indicesAccessControl == null) {
                    return MapperPlugin.NOOP_FIELD_PREDICATE;
                }
                IndicesAccessControl.IndexAccessControl indexPermissions = indicesAccessControl.getIndexPermissions(index);
                if (indexPermissions == null) {
                    return MapperPlugin.NOOP_FIELD_PREDICATE;
                }
                if (!indexPermissions.isGranted()) {
                    throw new IllegalStateException("unexpected call to getFieldFilter for index [" + index + "] which is not granted");
                }
                FieldPermissions fieldPermissions = indexPermissions.getFieldPermissions();
                if (!fieldPermissions.hasFieldLevelSecurity()) {
                    return MapperPlugin.NOOP_FIELD_PREDICATE;
                }
                if (!SecurityField.FIELD_LEVEL_SECURITY_FEATURE.checkWithoutTracking(licenseState)) {
                    return MapperPlugin.NOOP_FIELD_PREDICATE;
                }
                return arg_0 -> ((FieldPermissions)fieldPermissions).grantsAccessTo(arg_0);
            };
        }
        return super.getFieldFilter();
    }

    public BiConsumer<DiscoveryNode, ClusterState> getJoinValidator() {
        if (this.enabled) {
            return new ValidateUpgradedSecurityIndex().andThen(new ValidateLicenseForFIPS((Boolean)XPackSettings.FIPS_MODE_ENABLED.get(this.settings)));
        }
        return null;
    }

    public void loadExtensions(ExtensiblePlugin.ExtensionLoader loader) {
        this.securityExtensions.addAll(loader.loadExtensions(SecurityExtension.class));
    }

    private synchronized NioGroupFactory getNioGroupFactory(Settings settings) {
        if (this.nioGroupFactory.get() != null) {
            assert (((NioGroupFactory)this.nioGroupFactory.get()).getSettings().equals((Object)settings)) : "Different settings than originally provided";
            return (NioGroupFactory)this.nioGroupFactory.get();
        }
        this.nioGroupFactory.set((Object)new NioGroupFactory(settings, logger));
        return (NioGroupFactory)this.nioGroupFactory.get();
    }

    private synchronized SharedGroupFactory getNettySharedGroupFactory(Settings settings) {
        if (this.sharedGroupFactory.get() != null) {
            assert (((SharedGroupFactory)this.sharedGroupFactory.get()).getSettings().equals((Object)settings)) : "Different settings than originally provided";
            return (SharedGroupFactory)this.sharedGroupFactory.get();
        }
        this.sharedGroupFactory.set((Object)new SharedGroupFactory(settings));
        return (SharedGroupFactory)this.sharedGroupFactory.get();
    }

    private static SystemIndexDescriptor getSecurityMainIndexDescriptor() {
        return SystemIndexDescriptor.builder().setMinimumNodeVersion(FLATTENED_FIELD_TYPE_INTRODUCED).setIndexPattern(".security-[0-9]+*").setPrimaryIndex(".security-7").setDescription("Contains Security configuration").setMappings(Security.getIndexMappings()).setSettings(Security.getIndexSettings()).setAliasName(".security").setIndexFormat(6).setVersionMetaKey("security-version").setOrigin("security").setPriorSystemIndexDescriptors(List.of((Object)SystemIndexDescriptor.builder().setIndexPattern(".security-[0-9]+*").setPrimaryIndex(".security-7").setDescription("Contains Security configuration").setMappings(Security.getIndexMappings(Version.V_7_12_0)).setSettings(Security.getIndexSettings()).setAliasName(".security").setIndexFormat(6).setVersionMetaKey("security-version").setOrigin("security").build())).setThreadPools(ExecutorNames.CRITICAL_SYSTEM_INDEX_THREAD_POOLS).build();
    }

    private static SystemIndexDescriptor getSecurityTokenIndexDescriptor() {
        return SystemIndexDescriptor.builder().setIndexPattern(".security-tokens-[0-9]+*").setPrimaryIndex(".security-tokens-7").setDescription("Contains auth token data").setMappings(Security.getTokenIndexMappings()).setSettings(Security.getTokenIndexSettings()).setAliasName(".security-tokens").setIndexFormat(7).setVersionMetaKey("security-version").setOrigin("security").setThreadPools(ExecutorNames.CRITICAL_SYSTEM_INDEX_THREAD_POOLS).build();
    }

    public Collection<SystemIndexDescriptor> getSystemIndexDescriptors(Settings settings) {
        return Collections.unmodifiableList(Arrays.asList(SECURITY_MAIN_INDEX_DESCRIPTOR, SECURITY_TOKEN_INDEX_DESCRIPTOR));
    }

    private static Settings getIndexSettings() {
        return Settings.builder().put("index.number_of_shards", 1).put("index.number_of_replicas", 0).put("index.auto_expand_replicas", "0-1").put("index.priority", 1000).put("index.refresh_interval", "1s").put(IndexMetadata.INDEX_FORMAT_SETTING.getKey(), 6).put("analysis.filter.email.type", "pattern_capture").put("analysis.filter.email.preserve_original", true).putList("analysis.filter.email.patterns", Arrays.asList("([^@]+)", "(\\p{L}+)", "(\\d+)", "@(.+)")).put("analysis.analyzer.email.tokenizer", "uax_url_email").putList("analysis.analyzer.email.filter", Arrays.asList("email", "lowercase", "unique")).build();
    }

    private static XContentBuilder getIndexMappings() {
        return Security.getIndexMappings(Version.CURRENT);
    }

    private static XContentBuilder getIndexMappings(Version mappingVersion) {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.startObject();
            builder.startObject("_meta");
            builder.field("security-version", mappingVersion.toString());
            builder.endObject();
            builder.field("dynamic", "strict");
            builder.startObject("properties");
            builder.startObject("username");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("roles");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("role_templates");
            builder.startObject("properties");
            builder.startObject("template");
            builder.field("type", "text");
            builder.endObject();
            builder.startObject("format");
            builder.field("type", "keyword");
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.startObject("password");
            builder.field("type", "keyword");
            builder.field("index", false);
            builder.field("doc_values", false);
            builder.endObject();
            builder.startObject("full_name");
            builder.field("type", "text");
            builder.endObject();
            builder.startObject("email");
            builder.field("type", "text");
            builder.field("analyzer", "email");
            builder.endObject();
            builder.startObject("metadata");
            builder.field("type", "object");
            builder.field("dynamic", false);
            builder.endObject();
            if (mappingVersion.onOrAfter(Version.V_7_13_0)) {
                builder.startObject("metadata_flattened");
                builder.field("type", "flattened");
                builder.endObject();
            }
            builder.startObject("enabled");
            builder.field("type", "boolean");
            builder.endObject();
            builder.startObject("cluster");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("indices");
            builder.field("type", "object");
            builder.startObject("properties");
            builder.startObject("field_security");
            builder.startObject("properties");
            builder.startObject("grant");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("except");
            builder.field("type", "keyword");
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.startObject("names");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("privileges");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("query");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("allow_restricted_indices");
            builder.field("type", "boolean");
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.startObject("applications");
            builder.field("type", "object");
            builder.startObject("properties");
            builder.startObject("application");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("privileges");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("resources");
            builder.field("type", "keyword");
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.startObject("application");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("global");
            builder.field("type", "object");
            builder.startObject("properties");
            builder.startObject("application");
            builder.field("type", "object");
            builder.startObject("properties");
            builder.startObject("manage");
            builder.field("type", "object");
            builder.startObject("properties");
            builder.startObject("applications");
            builder.field("type", "keyword");
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.startObject("name");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("run_as");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("doc_type");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("type");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("actions");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("expiration_time");
            builder.field("type", "date");
            builder.field("format", "epoch_millis");
            builder.endObject();
            builder.startObject("creation_time");
            builder.field("type", "date");
            builder.field("format", "epoch_millis");
            builder.endObject();
            builder.startObject("api_key_hash");
            builder.field("type", "keyword");
            builder.field("index", false);
            builder.field("doc_values", false);
            builder.endObject();
            builder.startObject("api_key_invalidated");
            builder.field("type", "boolean");
            builder.endObject();
            builder.startObject("role_descriptors");
            builder.field("type", "object");
            builder.field("enabled", false);
            builder.endObject();
            builder.startObject("limited_by_role_descriptors");
            builder.field("type", "object");
            builder.field("enabled", false);
            builder.endObject();
            builder.startObject("version");
            builder.field("type", "integer");
            builder.endObject();
            builder.startObject("creator");
            builder.field("type", "object");
            builder.startObject("properties");
            builder.startObject("principal");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("full_name");
            builder.field("type", "text");
            builder.endObject();
            builder.startObject("email");
            builder.field("type", "text");
            builder.field("analyzer", "email");
            builder.endObject();
            builder.startObject("metadata");
            builder.field("type", "object");
            builder.field("dynamic", false);
            builder.endObject();
            builder.startObject("realm");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("realm_type");
            builder.field("type", "keyword");
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.startObject("rules");
            builder.field("type", "object");
            builder.field("dynamic", false);
            builder.endObject();
            builder.startObject("refresh_token");
            builder.field("type", "object");
            builder.startObject("properties");
            builder.startObject("token");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("refreshed");
            builder.field("type", "boolean");
            builder.endObject();
            builder.startObject("refresh_time");
            builder.field("type", "date");
            builder.field("format", "epoch_millis");
            builder.endObject();
            builder.startObject("superseding");
            builder.field("type", "object");
            builder.startObject("properties");
            builder.startObject("encrypted_tokens");
            builder.field("type", "binary");
            builder.endObject();
            builder.startObject("encryption_iv");
            builder.field("type", "binary");
            builder.endObject();
            builder.startObject("encryption_salt");
            builder.field("type", "binary");
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.startObject("invalidated");
            builder.field("type", "boolean");
            builder.endObject();
            builder.startObject("client");
            builder.field("type", "object");
            builder.startObject("properties");
            builder.startObject("type");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("user");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("realm");
            builder.field("type", "keyword");
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.startObject("access_token");
            builder.field("type", "object");
            builder.startObject("properties");
            builder.startObject("user_token");
            builder.field("type", "object");
            builder.startObject("properties");
            builder.startObject("id");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("expiration_time");
            builder.field("type", "date");
            builder.field("format", "epoch_millis");
            builder.endObject();
            builder.startObject("version");
            builder.field("type", "integer");
            builder.endObject();
            builder.startObject("metadata");
            builder.field("type", "object");
            builder.field("dynamic", false);
            builder.endObject();
            builder.startObject("authentication");
            builder.field("type", "binary");
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.startObject("invalidated");
            builder.field("type", "boolean");
            builder.endObject();
            builder.startObject("realm");
            builder.field("type", "keyword");
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.endObject();
            return builder;
        }
        catch (IOException e) {
            logger.fatal("Failed to build .security-7 index mappings", (Throwable)e);
            throw new UncheckedIOException("Failed to build .security-7 index mappings", e);
        }
    }

    private static Settings getTokenIndexSettings() {
        return Settings.builder().put("index.number_of_shards", 1).put("index.number_of_replicas", 0).put("index.auto_expand_replicas", "0-1").put("index.priority", 1000).put("index.refresh_interval", "1s").put(IndexMetadata.INDEX_FORMAT_SETTING.getKey(), 7).build();
    }

    private static XContentBuilder getTokenIndexMappings() {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.startObject();
            builder.startObject("_meta");
            builder.field("security-version", (ToXContent)Version.CURRENT);
            builder.endObject();
            builder.field("dynamic", "strict");
            builder.startObject("properties");
            builder.startObject("doc_type");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("creation_time");
            builder.field("type", "date");
            builder.field("format", "epoch_millis");
            builder.endObject();
            builder.startObject("refresh_token");
            builder.field("type", "object");
            builder.startObject("properties");
            builder.startObject("token");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("refreshed");
            builder.field("type", "boolean");
            builder.endObject();
            builder.startObject("refresh_time");
            builder.field("type", "date");
            builder.field("format", "epoch_millis");
            builder.endObject();
            builder.startObject("superseding");
            builder.field("type", "object");
            builder.startObject("properties");
            builder.startObject("encrypted_tokens");
            builder.field("type", "binary");
            builder.endObject();
            builder.startObject("encryption_iv");
            builder.field("type", "binary");
            builder.endObject();
            builder.startObject("encryption_salt");
            builder.field("type", "binary");
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.startObject("invalidated");
            builder.field("type", "boolean");
            builder.endObject();
            builder.startObject("client");
            builder.field("type", "object");
            builder.startObject("properties");
            builder.startObject("type");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("user");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("realm");
            builder.field("type", "keyword");
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.startObject("access_token");
            builder.field("type", "object");
            builder.startObject("properties");
            builder.startObject("user_token");
            builder.field("type", "object");
            builder.startObject("properties");
            builder.startObject("id");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("expiration_time");
            builder.field("type", "date");
            builder.field("format", "epoch_millis");
            builder.endObject();
            builder.startObject("version");
            builder.field("type", "integer");
            builder.endObject();
            builder.startObject("metadata");
            builder.field("type", "object");
            builder.field("dynamic", false);
            builder.endObject();
            builder.startObject("authentication");
            builder.field("type", "binary");
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.startObject("invalidated");
            builder.field("type", "boolean");
            builder.endObject();
            builder.startObject("realm");
            builder.field("type", "keyword");
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.endObject();
            return builder;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to build .security-tokens-7 index mappings", e);
        }
    }

    public String getFeatureName() {
        return "security";
    }

    public String getFeatureDescription() {
        return "Manages configuration for Security features, such as users and roles";
    }

    public CheckedBiConsumer<ShardSearchRequest, StreamOutput, IOException> getRequestCacheKeyDifferentiator() {
        if (!this.enabled) {
            return null;
        }
        return new DlsFlsRequestCacheDifferentiator(this.getLicenseState(), this.securityContext, this.scriptServiceReference);
    }

    static final class ValidateUpgradedSecurityIndex
    implements BiConsumer<DiscoveryNode, ClusterState> {
        ValidateUpgradedSecurityIndex() {
        }

        @Override
        public void accept(DiscoveryNode node, ClusterState state) {
            IndexMetadata indexMetadata;
            if (state.getNodes().getMinNodeVersion().before(Version.V_7_0_0) && (indexMetadata = (IndexMetadata)state.getMetadata().getIndices().get((Object)".security")) != null && (Integer)IndexMetadata.INDEX_FORMAT_SETTING.get(indexMetadata.getSettings()) < 6) {
                throw new IllegalStateException("Security index is not on the current version [6] - The Upgrade API must be run for 7.x nodes to join the cluster");
            }
        }
    }

    static final class ValidateLicenseForFIPS
    implements BiConsumer<DiscoveryNode, ClusterState> {
        private final boolean inFipsMode;

        ValidateLicenseForFIPS(boolean inFipsMode) {
            this.inFipsMode = inFipsMode;
        }

        @Override
        public void accept(DiscoveryNode node, ClusterState state) {
            License license;
            if (this.inFipsMode && (license = LicenseService.getLicense((Metadata)state.metadata())) != null && !XPackLicenseState.isFipsAllowedForOperationMode((License.OperationMode)license.operationMode())) {
                throw new IllegalStateException("FIPS mode cannot be used with a [" + license.operationMode() + "] license. It is only allowed with a Platinum or Trial license.");
            }
        }
    }

    static final class ValidateLicenseCanBeDeserialized
    implements BiConsumer<DiscoveryNode, ClusterState> {
        ValidateLicenseCanBeDeserialized() {
        }

        @Override
        public void accept(DiscoveryNode node, ClusterState state) {
            License license = LicenseService.getLicense((Metadata)state.metadata());
            if (license != null && license.version() >= 4 && node.getVersion().before(Version.V_6_4_0)) {
                throw new IllegalStateException("node " + node + " is on version [" + node.getVersion() + "] that cannot deserialize the license format [" + license.version() + "], upgrade node to at least 6.4.0");
            }
        }
    }
}

