/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.metadata.BrokerMetadataListener$;
import kafka.server.metadata.BrokerMetadataListener$BatchLoadResults$;
import kafka.server.metadata.MetadataPublisher;
import kafka.server.metadata.MetadataSnapshotter;
import kafka.utils.Logging;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.queue.EventQueue;
import org.apache.kafka.queue.KafkaEventQueue;
import org.apache.kafka.raft.Batch;
import org.apache.kafka.raft.BatchReader;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.raft.RaftClient;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.snapshot.SnapshotReader;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0011er!B7o\u0011\u0003)h!B<o\u0011\u0003A\bBB@\u0002\t\u0003\t\t\u0001C\u0005\u0002\u0004\u0005\u0011\r\u0011\"\u0001\u0002\u0006!A\u0011qC\u0001!\u0002\u0013\t9\u0001C\u0005\u0002\u001a\u0005\u0011\r\u0011\"\u0001\u0002\u0006!A\u00111D\u0001!\u0002\u0013\t9AB\u0003x]\u0002\ti\u0002\u0003\u0006\u0002^\u001d\u0011)\u0019!C\u0001\u0003?B!\"a\u001a\b\u0005\u0003\u0005\u000b\u0011BA1\u0011)\tIg\u0002B\u0001B\u0003%\u00111\u000e\u0005\u000b\u0003s:!\u0011!Q\u0001\n\u0005m\u0004BCAK\u000f\t\u0015\r\u0011\"\u0001\u0002\u0018\"Q\u0011qT\u0004\u0003\u0002\u0003\u0006I!!'\t\u0015\u0005\u0005vA!b\u0001\n\u0003\t\u0019\u000b\u0003\u0006\u0002.\u001e\u0011\t\u0011)A\u0005\u0003KCaa`\u0004\u0005\u0002\u0005=\u0006\"CA_\u000f\t\u0007I\u0011BA`\u0011!\t9m\u0002Q\u0001\n\u0005\u0005\u0007\"CAe\u000f\t\u0007I\u0011BAf\u0011!\tIn\u0002Q\u0001\n\u00055\u0007\"CAn\u000f\t\u0007I\u0011BAo\u0011!\t)p\u0002Q\u0001\n\u0005}\u0007\"CA|\u000f\t\u0007I\u0011BAo\u0011!\tIp\u0002Q\u0001\n\u0005}\u0007\"CA~\u000f\u0001\u0007I\u0011AAL\u0011%\tip\u0002a\u0001\n\u0003\ty\u0010\u0003\u0005\u0003\f\u001d\u0001\u000b\u0015BAM\u0011%\u0011)b\u0002a\u0001\n\u0013\t9\nC\u0005\u0003\u0018\u001d\u0001\r\u0011\"\u0003\u0003\u001a!A!QD\u0004!B\u0013\tI\nC\u0005\u0003 \u001d\u0001\r\u0011\"\u0003\u0003\"!I!qF\u0004A\u0002\u0013%!\u0011\u0007\u0005\t\u0005k9\u0001\u0015)\u0003\u0003$!I!qG\u0004A\u0002\u0013%!\u0011\b\u0005\n\u0005\u0003:\u0001\u0019!C\u0005\u0005\u0007B\u0001Ba\u0012\bA\u0003&!1\b\u0005\n\u0005\u0013:\u0001\u0019!C\u0005\u0005\u0017B\u0011B!\u0016\b\u0001\u0004%IAa\u0016\t\u0011\tms\u0001)Q\u0005\u0005\u001bB\u0011B!\u0018\b\u0001\u0004%I!a&\t\u0013\t}s\u00011A\u0005\n\t\u0005\u0004\u0002\u0003B3\u000f\u0001\u0006K!!'\t\u0013\t\u001dtA1A\u0005\u0002\t%\u0004\u0002\u0003B<\u000f\u0001\u0006IAa\u001b\t\u000f\tet\u0001\"\u0001\u0002\u0018\"9!1P\u0004\u0005B\tudA\u0002BE\u000f\u0001\u0011Y\t\u0003\u0006\u0003\u0002>\u0012\t\u0011)A\u0005\u0005\u0007Caa`\u0018\u0005\u0002\tm\u0005b\u0002BR_\u0011\u0005#Q\u0015\u0005\b\u0005O;A\u0011\u0002BU\u0011\u001d\u0011\tl\u0002C!\u0005g3aAa1\b\u0001\t\u0015\u0007B\u0003BAk\t\u0005\t\u0015!\u0003\u00038\"1q0\u000eC\u0001\u0005\u000fDqAa)6\t\u0003\u0012)K\u0002\u0004\u0003N\u001e\u0001%q\u001a\u0005\u000b\u0005;L$Q3A\u0005\u0002\u0005}\u0003B\u0003Bps\tE\t\u0015!\u0003\u0002b!Q!\u0011]\u001d\u0003\u0016\u0004%\t!a\u0018\t\u0015\t\r\u0018H!E!\u0002\u0013\t\t\u0007\u0003\u0006\u0003ff\u0012)\u001a!C\u0001\u0003/C!Ba::\u0005#\u0005\u000b\u0011BAM\u0011)\u0011I/\u000fBK\u0002\u0013\u0005\u0011q\u0013\u0005\u000b\u0005WL$\u0011#Q\u0001\n\u0005e\u0005BB@:\t\u0003\u0011i\u000fC\u0004\u0003zf\"\tEa?\t\u0013\tu\u0018(!A\u0005\u0002\t}\b\"CB\u0005sE\u0005I\u0011AB\u0006\u0011%\u0019\t#OI\u0001\n\u0003\u0019Y\u0001C\u0005\u0004$e\n\n\u0011\"\u0001\u0004&!I1\u0011F\u001d\u0012\u0002\u0013\u00051Q\u0005\u0005\n\u0007WI\u0014\u0011!C!\u0003\u000bA\u0011b!\f:\u0003\u0003%\t!a\u0018\t\u0013\r=\u0012(!A\u0005\u0002\rE\u0002\"CB\u001es\u0005\u0005I\u0011IB\u001f\u0011%\u0019Y%OA\u0001\n\u0003\u0019i\u0005C\u0005\u0004Re\n\t\u0011\"\u0011\u0004T!I1QK\u001d\u0002\u0002\u0013\u00053qK\u0004\n\u00077:\u0011\u0011!E\u0001\u0007;2\u0011B!4\b\u0003\u0003E\taa\u0018\t\r}\fF\u0011AB7\u0011%\u0011I0UA\u0001\n\u000b\u001ay\u0007C\u0005\u0004rE\u000b\t\u0011\"!\u0004t!I1QP)\u0002\u0002\u0013\u00055q\u0010\u0005\b\u0007\u001b;A\u0011BBH\u0011\u001d\u0019Il\u0002C\u0001\u0007w3aaa5\b\u0001\rU\u0007BCBi1\n\u0005\t\u0015!\u0003\u0003P!1q\u0010\u0017C\u0001\u0007/D\u0011b!8Y\u0005\u0004%\taa8\t\u0011\r\u0005\b\f)A\u0005\u0007{CqAa)Y\t\u0003\u0012)\u000bC\u0004\u0004d\u001e!Ia!:\t\u000f\r%x\u0001\"\u0011\u0004l\"91q_\u0004\u0005B\t\u0015fABB}\u000f\u0001\u0019Y\u0010\u0003\u0004\u0000C\u0012\u00051Q \u0005\b\u0005G\u000bG\u0011\tBS\u0011\u001d!\ta\u0002C\u0001\u0005KC\u0001\u0002b\u0001\b\t\u0003\u0011HQ\u0001\u0004\u0007\t\u001f9\u0001\u0001\"\u0005\t\u0015\rugM!A!\u0002\u0013!9\u0001\u0003\u0004\u0000M\u0012\u0005Aq\u0004\u0005\n\tK1'\u0019!C\u0001\tOA\u0001\u0002b\fgA\u0003%A\u0011\u0006\u0005\b\tc1G\u0011\tC\u001a\u0011\u001d\u0011\u0019K\u001aC!\u0005K\u000baC\u0011:pW\u0016\u0014X*\u001a;bI\u0006$\u0018\rT5ti\u0016tWM\u001d\u0006\u0003_B\f\u0001\"\\3uC\u0012\fG/\u0019\u0006\u0003cJ\faa]3sm\u0016\u0014(\"A:\u0002\u000b-\fgm[1\u0004\u0001A\u0011a/A\u0007\u0002]\n1\"I]8lKJlU\r^1eCR\fG*[:uK:,'o\u0005\u0002\u0002sB\u0011!0`\u0007\u0002w*\tA0A\u0003tG\u0006d\u0017-\u0003\u0002\u007fw\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A;\u0002;5+G/\u00193bi\u0006\u0014\u0015\r^2i!J|7-Z:tS:<G+[7f+N,\"!a\u0002\u0011\t\u0005%\u00111C\u0007\u0003\u0003\u0017QA!!\u0004\u0002\u0010\u0005!A.\u00198h\u0015\t\t\t\"\u0001\u0003kCZ\f\u0017\u0002BA\u000b\u0003\u0017\u0011aa\u0015;sS:<\u0017AH'fi\u0006$\u0017\r^1CCR\u001c\u0007\u000e\u0015:pG\u0016\u001c8/\u001b8h)&lW-V:!\u0003IiU\r^1eCR\f')\u0019;dQNK'0Z:\u0002'5+G/\u00193bi\u0006\u0014\u0015\r^2i'&TXm\u001d\u0011\u0014\u000f\u001d\ty\"!\n\u0002RA!\u0011\u0011BA\u0011\u0013\u0011\t\u0019#a\u0003\u0003\r=\u0013'.Z2u!\u0019\t9#!\u0010\u0002D9!\u0011\u0011FA\u001d\u001b\t\tYC\u0003\u0003\u0002.\u0005=\u0012\u0001\u0002:bMRT1a]A\u0019\u0015\u0011\t\u0019$!\u000e\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\t9$A\u0002pe\u001eLA!a\u000f\u0002,\u0005Q!+\u00194u\u00072LWM\u001c;\n\t\u0005}\u0012\u0011\t\u0002\t\u0019&\u001cH/\u001a8fe*!\u00111HA\u0016!\u0011\t)%!\u0014\u000e\u0005\u0005\u001d#\u0002BA%\u0003\u0017\naaY8n[>t'bA9\u00020%!\u0011qJA$\u0005Q\t\u0005/['fgN\fw-Z!oIZ+'o]5p]B!\u00111KA-\u001b\t\t)FC\u0002\u0002XI\fq!\\3ue&\u001c7/\u0003\u0003\u0002\\\u0005U#!E&bM.\fW*\u001a;sS\u000e\u001cxI]8va\u0006A!M]8lKJLE-\u0006\u0002\u0002bA\u0019!0a\u0019\n\u0007\u0005\u00154PA\u0002J]R\f\u0011B\u0019:pW\u0016\u0014\u0018\n\u001a\u0011\u0002\tQLW.\u001a\t\u0005\u0003[\n)(\u0004\u0002\u0002p)!\u0011\u0011OA:\u0003\u0015)H/\u001b7t\u0015\u0011\tI%a\f\n\t\u0005]\u0014q\u000e\u0002\u0005)&lW-\u0001\tuQJ,\u0017\r\u001a(b[\u0016\u0004&/\u001a4jqB)!0! \u0002\u0002&\u0019\u0011qP>\u0003\r=\u0003H/[8o!\u0011\t\u0019)!%\u000f\t\u0005\u0015\u0015Q\u0012\t\u0004\u0003\u000f[XBAAE\u0015\r\tY\t^\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005=50\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003+\t\u0019JC\u0002\u0002\u0010n\f\u0001$\\1y\u0005f$Xm\u001d\"fi^,WM\\*oCB\u001c\bn\u001c;t+\t\tI\nE\u0002{\u00037K1!!(|\u0005\u0011auN\\4\u000235\f\u0007PQ=uKN\u0014U\r^<fK:\u001cf.\u00199tQ>$8\u000fI\u0001\fg:\f\u0007o\u001d5piR,'/\u0006\u0002\u0002&B)!0! \u0002(B\u0019a/!+\n\u0007\u0005-fNA\nNKR\fG-\u0019;b':\f\u0007o\u001d5piR,'/\u0001\u0007t]\u0006\u00048\u000f[8ui\u0016\u0014\b\u0005\u0006\u0007\u00022\u0006M\u0016QWA\\\u0003s\u000bY\f\u0005\u0002w\u000f!9\u0011Q\f\tA\u0002\u0005\u0005\u0004bBA5!\u0001\u0007\u00111\u000e\u0005\b\u0003s\u0002\u0002\u0019AA>\u0011\u001d\t)\n\u0005a\u0001\u00033Cq!!)\u0011\u0001\u0004\t)+\u0001\u0006m_\u001e\u001cuN\u001c;fqR,\"!!1\u0011\t\u00055\u00141Y\u0005\u0005\u0003\u000b\fyG\u0001\u0006M_\u001e\u001cuN\u001c;fqR\f1\u0002\\8h\u0007>tG/\u001a=uA\u0005\u0019An\\4\u0016\u0005\u00055\u0007\u0003BAh\u0003+l!!!5\u000b\t\u0005M\u0017QG\u0001\u0006g24GG[\u0005\u0005\u0003/\f\tN\u0001\u0004M_\u001e<WM]\u0001\u0005Y><\u0007%A\fcCR\u001c\u0007\u000e\u0015:pG\u0016\u001c8/\u001b8h)&lW\rS5tiV\u0011\u0011q\u001c\t\u0005\u0003C\f\t0\u0004\u0002\u0002d*!\u0011Q]At\u0003\u0011\u0019wN]3\u000b\t\u0005]\u0013\u0011\u001e\u0006\u0005\u0003W\fi/\u0001\u0004zC6lWM\u001d\u0006\u0003\u0003_\f1aY8n\u0013\u0011\t\u00190a9\u0003\u0013!K7\u000f^8he\u0006l\u0017\u0001\u00072bi\u000eD\u0007K]8dKN\u001c\u0018N\\4US6,\u0007*[:uA\u0005)R.\u001a;bI\u0006$\u0018MQ1uG\"\u001c\u0016N_3ISN$\u0018AF7fi\u0006$\u0017\r^1CCR\u001c\u0007nU5{K\"K7\u000f\u001e\u0011\u0002\u001d}C\u0017n\u001a5fgR|eMZ:fi\u0006\u0011r\f[5hQ\u0016\u001cHo\u00144gg\u0016$x\fJ3r)\u0011\u0011\tAa\u0002\u0011\u0007i\u0014\u0019!C\u0002\u0003\u0006m\u0014A!\u00168ji\"I!\u0011\u0002\u000e\u0002\u0002\u0003\u0007\u0011\u0011T\u0001\u0004q\u0012\n\u0014aD0iS\u001eDWm\u001d;PM\u001a\u001cX\r\u001e\u0011)\u0007m\u0011y\u0001E\u0002{\u0005#I1Aa\u0005|\u0005!1x\u000e\\1uS2,\u0017!E0iS\u001eDWm\u001d;US6,7\u000f^1na\u0006)r\f[5hQ\u0016\u001cH\u000fV5nKN$\u0018-\u001c9`I\u0015\fH\u0003\u0002B\u0001\u00057A\u0011B!\u0003\u001e\u0003\u0003\u0005\r!!'\u0002%}C\u0017n\u001a5fgR$\u0016.\\3ti\u0006l\u0007\u000fI\u0001\u0007?&l\u0017mZ3\u0016\u0005\t\r\u0002\u0003\u0002B\u0013\u0005Wi!Aa\n\u000b\t\t%\u0012qF\u0001\u0006S6\fw-Z\u0005\u0005\u0005[\u00119CA\u0007NKR\fG-\u0019;b\u00136\fw-Z\u0001\u000b?&l\u0017mZ3`I\u0015\fH\u0003\u0002B\u0001\u0005gA\u0011B!\u0003!\u0003\u0003\u0005\rAa\t\u0002\u000f}KW.Y4fA\u00051q\fZ3mi\u0006,\"Aa\u000f\u0011\t\t\u0015\"QH\u0005\u0005\u0005\u007f\u00119CA\u0007NKR\fG-\u0019;b\t\u0016dG/Y\u0001\u000b?\u0012,G\u000e^1`I\u0015\fH\u0003\u0002B\u0001\u0005\u000bB\u0011B!\u0003$\u0003\u0003\u0005\rAa\u000f\u0002\u000f}#W\r\u001c;bA\u0005Qq\f];cY&\u001c\b.\u001a:\u0016\u0005\t5\u0003#\u0002>\u0002~\t=\u0003c\u0001<\u0003R%\u0019!1\u000b8\u0003#5+G/\u00193bi\u0006\u0004VO\u00197jg\",'/\u0001\b`aV\u0014G.[:iKJ|F%Z9\u0015\t\t\u0005!\u0011\f\u0005\n\u0005\u00131\u0013\u0011!a\u0001\u0005\u001b\n1b\u00189vE2L7\u000f[3sA\u00059rLY=uKN\u001c\u0016N\\2f\u0019\u0006\u001cHo\u00158baNDw\u000e^\u0001\u001c?\nLH/Z:TS:\u001cW\rT1tiNs\u0017\r]:i_R|F%Z9\u0015\t\t\u0005!1\r\u0005\n\u0005\u0013I\u0013\u0011!a\u0001\u00033\u000b\u0001d\u00182zi\u0016\u001c8+\u001b8dK2\u000b7\u000f^*oCB\u001c\bn\u001c;!\u0003))g/\u001a8u#V,W/Z\u000b\u0003\u0005W\u0002BA!\u001c\u0003t5\u0011!q\u000e\u0006\u0005\u0005c\ny#A\u0003rk\u0016,X-\u0003\u0003\u0003v\t=$aD&bM.\fWI^3oiF+X-^3\u0002\u0017\u00154XM\u001c;Rk\u0016,X\rI\u0001\u0016Q&<\u0007.Z:u\u001b\u0016$\u0018\rZ1uC>3gm]3u\u00031A\u0017M\u001c3mK\u000e{W.\\5u)\u0011\u0011\tAa \t\u000f\t\u0005e\u00061\u0001\u0003\u0004\u00061!/Z1eKJ\u0004b!!\u000b\u0003\u0006\u0006\r\u0013\u0002\u0002BD\u0003W\u00111BQ1uG\"\u0014V-\u00193fe\n\u0011\u0002*\u00198eY\u0016\u001cu.\\7jiN,e/\u001a8u'\ry#Q\u0012\t\u0005\u0005\u001f\u0013)J\u0004\u0003\u0003n\tE\u0015\u0002\u0002BJ\u0005_\n!\"\u0012<f]R\fV/Z;f\u0013\u0011\u00119J!'\u0003'\u0019\u000b\u0017\u000e\\;sK2{wmZ5oO\u00163XM\u001c;\u000b\t\tM%q\u000e\u000b\u0005\u0005;\u0013\t\u000bE\u0002\u0003 >j\u0011a\u0002\u0005\b\u0005\u0003\u000b\u0004\u0019\u0001BB\u0003\r\u0011XO\u001c\u000b\u0003\u0005\u0003\tab\u001d5pk2$7K\\1qg\"|G\u000f\u0006\u0002\u0003,B\u0019!P!,\n\u0007\t=6PA\u0004C_>dW-\u00198\u0002\u001d!\fg\u000e\u001a7f':\f\u0007o\u001d5piR!!\u0011\u0001B[\u0011\u001d\u0011\t\t\u000ea\u0001\u0005o\u0003bA!/\u0003@\u0006\rSB\u0001B^\u0015\u0011\u0011i,a\f\u0002\u0011Mt\u0017\r]:i_RLAA!1\u0003<\nq1K\\1qg\"|GOU3bI\u0016\u0014(a\u0005%b]\u0012dWm\u00158baNDw\u000e^#wK:$8cA\u001b\u0003\u000eR!!\u0011\u001aBf!\r\u0011y*\u000e\u0005\b\u0005\u0003;\u0004\u0019\u0001B\\\u0005A\u0011\u0015\r^2i\u0019>\fGMU3tk2$8o\u0005\u0004:s\nE'q\u001b\t\u0004u\nM\u0017b\u0001Bkw\n9\u0001K]8ek\u000e$\bc\u0001>\u0003Z&\u0019!1\\>\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u00159,XNQ1uG\",7/A\u0006ok6\u0014\u0015\r^2iKN\u0004\u0013A\u00038v[J+7m\u001c:eg\u0006Ya.^7SK\u000e|'\u000fZ:!\u0003%)G.\u00199tK\u0012,6/\u0001\u0006fY\u0006\u00048/\u001a3Vg\u0002\n\u0001B\\;n\u0005f$Xm]\u0001\n]Vl')\u001f;fg\u0002\"\"Ba<\u0003r\nM(Q\u001fB|!\r\u0011y*\u000f\u0005\b\u0005;\u0014\u0005\u0019AA1\u0011\u001d\u0011\tO\u0011a\u0001\u0003CBqA!:C\u0001\u0004\tI\nC\u0004\u0003j\n\u0003\r!!'\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!!\u0002\t\r|\u0007/\u001f\u000b\u000b\u0005_\u001c\taa\u0001\u0004\u0006\r\u001d\u0001\"\u0003Bo\tB\u0005\t\u0019AA1\u0011%\u0011\t\u000f\u0012I\u0001\u0002\u0004\t\t\u0007C\u0005\u0003f\u0012\u0003\n\u00111\u0001\u0002\u001a\"I!\u0011\u001e#\u0011\u0002\u0003\u0007\u0011\u0011T\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0019iA\u000b\u0003\u0002b\r=1FAB\t!\u0011\u0019\u0019b!\b\u000e\u0005\rU!\u0002BB\f\u00073\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\rm10\u0001\u0006b]:|G/\u0019;j_:LAaa\b\u0004\u0016\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTCAB\u0014U\u0011\tIja\u0004\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%i\u0005i\u0001O]8ek\u000e$\bK]3gSb\fA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u00044\re\u0002c\u0001>\u00046%\u00191qG>\u0003\u0007\u0005s\u0017\u0010C\u0005\u0003\n-\u000b\t\u00111\u0001\u0002b\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0004@A11\u0011IB$\u0007gi!aa\u0011\u000b\u0007\r\u001530\u0001\u0006d_2dWm\u0019;j_:LAa!\u0013\u0004D\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\u0011Yka\u0014\t\u0013\t%Q*!AA\u0002\rM\u0012\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005\u0005\u0014AB3rk\u0006d7\u000f\u0006\u0003\u0003,\u000ee\u0003\"\u0003B\u0005\u001f\u0006\u0005\t\u0019AB\u001a\u0003A\u0011\u0015\r^2i\u0019>\fGMU3tk2$8\u000fE\u0002\u0003 F\u001bR!UB1\u0005/\u0004bba\u0019\u0004j\u0005\u0005\u0014\u0011MAM\u00033\u0013y/\u0004\u0002\u0004f)\u00191qM>\u0002\u000fI,h\u000e^5nK&!11NB3\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g\u000e\u000e\u000b\u0003\u0007;\"\"!a\u0002\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0015\t=8QOB<\u0007s\u001aY\bC\u0004\u0003^R\u0003\r!!\u0019\t\u000f\t\u0005H\u000b1\u0001\u0002b!9!Q\u001d+A\u0002\u0005e\u0005b\u0002Bu)\u0002\u0007\u0011\u0011T\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0019\ti!#\u0011\u000bi\fiha!\u0011\u0017i\u001c))!\u0019\u0002b\u0005e\u0015\u0011T\u0005\u0004\u0007\u000f[(A\u0002+va2,G\u0007C\u0005\u0004\fV\u000b\t\u00111\u0001\u0003p\u0006\u0019\u0001\u0010\n\u0019\u0002\u00171|\u0017\r\u001a\"bi\u000eDWm\u001d\u000b\r\u0005_\u001c\tj!&\u0004*\u000e=61\u0017\u0005\b\u0007'3\u0006\u0019\u0001B\u001e\u0003\u0015!W\r\u001c;b\u0011\u001d\u00199J\u0016a\u0001\u00073\u000b\u0001\"\u001b;fe\u0006$xN\u001d\t\u0007\u00077\u001b\tka)\u000e\u0005\ru%\u0002BBP\u0003\u001f\tA!\u001e;jY&!1\u0011JBO!\u0019\tIc!*\u0002D%!1qUA\u0016\u0005\u0015\u0011\u0015\r^2i\u0011\u001d\u0019YK\u0016a\u0001\u0007[\u000b1\u0003\\1ti\u0006\u0003\b/\u001a8e)&lWm\u001d;b[B\u0004RA_A?\u00033Cqa!-W\u0001\u0004\u0019i+A\nmCN$8i\\7nSR$X\rZ(gMN,G\u000fC\u0004\u00046Z\u0003\raa.\u0002%1\f7\u000f^\"p[6LG\u000f^3e\u000bB|7\r\u001b\t\u0006u\u0006u\u0014\u0011M\u0001\u0010gR\f'\u000f\u001e)vE2L7\u000f[5oOR!1QXBh!\u0019\u0019yl!2\u0004J6\u00111\u0011\u0019\u0006\u0005\u0007\u0007\u001ci*\u0001\u0006d_:\u001cWO\u001d:f]RLAaa2\u0004B\n\t2i\\7qY\u0016$\u0018M\u00197f\rV$XO]3\u0011\t\u0005%11Z\u0005\u0005\u0007\u001b\fYA\u0001\u0003W_&$\u0007bBBi/\u0002\u0007!qJ\u0001\naV\u0014G.[:iKJ\u0014Ac\u0015;beR\u0004VO\u00197jg\"LgnZ#wK:$8c\u0001-\u0003\u000eR!1\u0011\\Bn!\r\u0011y\n\u0017\u0005\b\u0007#T\u0006\u0019\u0001B(\u0003\u00191W\u000f^;sKV\u00111QX\u0001\bMV$XO]3!\u0003\u001d\u0001XO\u00197jg\"$BA!\u0001\u0004h\"91\u0011\u001b0A\u0002\t=\u0013A\u00055b]\u0012dW\rT3bI\u0016\u00148\t[1oO\u0016$BA!\u0001\u0004n\"91q^0A\u0002\rE\u0018A\u00047fC\u0012,'/\u00118e\u000bB|7\r\u001b\t\u0005\u0003S\u0019\u00190\u0003\u0003\u0004v\u0006-\"A\u0004'fC\u0012,'/\u00118e\u000bB|7\r[\u0001\u000eE\u0016<\u0017N\\*ikR$wn\u001e8\u0003\u001bMCW\u000f\u001e3po:,e/\u001a8u'\r\t'Q\u0012\u000b\u0003\u0007\u007f\u00042Aa(b\u0003\u0015\u0019Gn\\:f\u0003=9W\r^%nC\u001e,'+Z2pe\u0012\u001cHC\u0001C\u0004!\u0019\u0019yl!2\u0005\nA111\u0014C\u0006\u0003\u0007JA\u0001\"\u0004\u0004\u001e\n!A*[:u\u0005Q9U\r^%nC\u001e,'+Z2pe\u0012\u001cXI^3oiN)aM!$\u0005\u0014A1AQ\u0003C\u000e\t\u0013i!\u0001b\u0006\u000b\t\u0011e1QT\u0001\tMVt7\r^5p]&!AQ\u0004C\f\u0005!\u0019uN\\:v[\u0016\u0014H\u0003\u0002C\u0011\tG\u00012Aa(g\u0011\u001d\u0019i\u000e\u001ba\u0001\t\u000f\tqA]3d_J$7/\u0006\u0002\u0005*A111\u0014C\u0016\u0003\u0007JA\u0001\"\f\u0004\u001e\nI\u0011I\u001d:bs2K7\u000f^\u0001\te\u0016\u001cwN\u001d3tA\u00051\u0011mY2faR$BA!\u0001\u00056!9AqG6A\u0002\u0011%\u0011!\u00022bi\u000eD\u0007")
public class BrokerMetadataListener
implements RaftClient.Listener<ApiMessageAndVersion>,
KafkaMetricsGroup {
    private volatile BrokerMetadataListener$BatchLoadResults$ BatchLoadResults$module;
    private final int brokerId;
    private final Time time;
    private final long maxBytesBetweenSnapshots;
    private final Option<MetadataSnapshotter> snapshotter;
    private final LogContext logContext;
    private final Logger kafka$server$metadata$BrokerMetadataListener$$log;
    private final Histogram batchProcessingTimeHist;
    private final Histogram metadataBatchSizeHist;
    private volatile long _highestOffset;
    private long kafka$server$metadata$BrokerMetadataListener$$_highestTimestamp;
    private MetadataImage kafka$server$metadata$BrokerMetadataListener$$_image;
    private MetadataDelta kafka$server$metadata$BrokerMetadataListener$$_delta;
    private Option<MetadataPublisher> kafka$server$metadata$BrokerMetadataListener$$_publisher;
    private long kafka$server$metadata$BrokerMetadataListener$$_bytesSinceLastSnapshot;
    private final KafkaEventQueue eventQueue;
    private com.typesafe.scalalogging.Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static String MetadataBatchSizes() {
        return BrokerMetadataListener$.MODULE$.MetadataBatchSizes();
    }

    public static String MetadataBatchProcessingTimeUs() {
        return BrokerMetadataListener$.MODULE$.MetadataBatchProcessingTimeUs();
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Meter newMeter(MetricName metricName, String eventType, TimeUnit timeUnit) {
        return KafkaMetricsGroup.newMeter$(this, metricName, eventType, timeUnit);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public BrokerMetadataListener$BatchLoadResults$ BatchLoadResults() {
        if (this.BatchLoadResults$module == null) {
            this.BatchLoadResults$lzycompute$1();
        }
        return this.BatchLoadResults$module;
    }

    private com.typesafe.scalalogging.Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public com.typesafe.scalalogging.Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public long maxBytesBetweenSnapshots() {
        return this.maxBytesBetweenSnapshots;
    }

    public Option<MetadataSnapshotter> snapshotter() {
        return this.snapshotter;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    public Logger kafka$server$metadata$BrokerMetadataListener$$log() {
        return this.kafka$server$metadata$BrokerMetadataListener$$log;
    }

    private Histogram batchProcessingTimeHist() {
        return this.batchProcessingTimeHist;
    }

    private Histogram metadataBatchSizeHist() {
        return this.metadataBatchSizeHist;
    }

    public long _highestOffset() {
        return this._highestOffset;
    }

    public void _highestOffset_$eq(long x$1) {
        this._highestOffset = x$1;
    }

    public long kafka$server$metadata$BrokerMetadataListener$$_highestTimestamp() {
        return this.kafka$server$metadata$BrokerMetadataListener$$_highestTimestamp;
    }

    private void kafka$server$metadata$BrokerMetadataListener$$_highestTimestamp_$eq(long x$1) {
        this.kafka$server$metadata$BrokerMetadataListener$$_highestTimestamp = x$1;
    }

    public MetadataImage kafka$server$metadata$BrokerMetadataListener$$_image() {
        return this.kafka$server$metadata$BrokerMetadataListener$$_image;
    }

    private void kafka$server$metadata$BrokerMetadataListener$$_image_$eq(MetadataImage x$1) {
        this.kafka$server$metadata$BrokerMetadataListener$$_image = x$1;
    }

    public MetadataDelta kafka$server$metadata$BrokerMetadataListener$$_delta() {
        return this.kafka$server$metadata$BrokerMetadataListener$$_delta;
    }

    public void kafka$server$metadata$BrokerMetadataListener$$_delta_$eq(MetadataDelta x$1) {
        this.kafka$server$metadata$BrokerMetadataListener$$_delta = x$1;
    }

    public Option<MetadataPublisher> kafka$server$metadata$BrokerMetadataListener$$_publisher() {
        return this.kafka$server$metadata$BrokerMetadataListener$$_publisher;
    }

    public void kafka$server$metadata$BrokerMetadataListener$$_publisher_$eq(Option<MetadataPublisher> x$1) {
        this.kafka$server$metadata$BrokerMetadataListener$$_publisher = x$1;
    }

    public long kafka$server$metadata$BrokerMetadataListener$$_bytesSinceLastSnapshot() {
        return this.kafka$server$metadata$BrokerMetadataListener$$_bytesSinceLastSnapshot;
    }

    public void kafka$server$metadata$BrokerMetadataListener$$_bytesSinceLastSnapshot_$eq(long x$1) {
        this.kafka$server$metadata$BrokerMetadataListener$$_bytesSinceLastSnapshot = x$1;
    }

    public KafkaEventQueue eventQueue() {
        return this.eventQueue;
    }

    public long highestMetadataOffset() {
        return this._highestOffset();
    }

    public void handleCommit(BatchReader<ApiMessageAndVersion> reader) {
        this.eventQueue().append((EventQueue.Event)new HandleCommitsEvent(this, reader));
    }

    public boolean kafka$server$metadata$BrokerMetadataListener$$shouldSnapshot() {
        return this.kafka$server$metadata$BrokerMetadataListener$$_bytesSinceLastSnapshot() >= this.maxBytesBetweenSnapshots();
    }

    public void handleSnapshot(SnapshotReader<ApiMessageAndVersion> reader) {
        this.eventQueue().append((EventQueue.Event)new HandleSnapshotEvent(this, reader));
    }

    public BatchLoadResults kafka$server$metadata$BrokerMetadataListener$$loadBatches(MetadataDelta delta, java.util.Iterator<Batch<ApiMessageAndVersion>> iterator, Option<Object> lastAppendTimestamp, Option<Object> lastCommittedOffset, Option<Object> lastCommittedEpoch) {
        long startTimeNs = this.time.nanoseconds();
        int numBatches = 0;
        IntRef numRecords = IntRef.create((int)0);
        long numBytes = 0L;
        while (iterator.hasNext()) {
            Batch<ApiMessageAndVersion> batch = iterator.next();
            int epoch = BoxesRunTime.unboxToInt((Object)lastCommittedEpoch.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> batch.epoch()));
            this.kafka$server$metadata$BrokerMetadataListener$$_highestTimestamp_$eq(BoxesRunTime.unboxToLong((Object)lastAppendTimestamp.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> batch.appendTimestamp())));
            IntRef index = IntRef.create((int)0);
            batch.records().forEach(messageAndVersion -> {
                if (this.isTraceEnabled()) {
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Metadata batch ").append(batch.lastOffset()).append(": processing [").append(index$1.elem + 1).append("/").append(batch.records().size()).append("]:").append(" ").append(messageAndVersion.message()).toString());
                }
                this._highestOffset_$eq(BoxesRunTime.unboxToLong((Object)lastCommittedOffset.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> batch.baseOffset() + (long)index$1.elem)));
                delta.replay(this.highestMetadataOffset(), epoch, messageAndVersion.message());
                ++numRecords$1.elem;
                ++index$1.elem;
            });
            numBytes += (long)batch.sizeInBytes();
            this.metadataBatchSizeHist().update(batch.records().size());
            ++numBatches;
        }
        long endTimeNs = this.time.nanoseconds();
        long elapsedUs = TimeUnit.MICROSECONDS.convert(endTimeNs - startTimeNs, TimeUnit.NANOSECONDS);
        this.batchProcessingTimeHist().update(elapsedUs);
        return new BatchLoadResults(this, numBatches, numRecords.elem, elapsedUs, numBytes);
    }

    public CompletableFuture<Void> startPublishing(MetadataPublisher publisher) {
        StartPublishingEvent event = new StartPublishingEvent(this, publisher);
        this.eventQueue().append((EventQueue.Event)event);
        return event.future();
    }

    public void kafka$server$metadata$BrokerMetadataListener$$publish(MetadataPublisher publisher) {
        MetadataDelta delta = this.kafka$server$metadata$BrokerMetadataListener$$_delta();
        this.kafka$server$metadata$BrokerMetadataListener$$_image_$eq(this.kafka$server$metadata$BrokerMetadataListener$$_delta().apply());
        this.kafka$server$metadata$BrokerMetadataListener$$_delta_$eq(new MetadataDelta(this.kafka$server$metadata$BrokerMetadataListener$$_image()));
        if (this.isDebugEnabled()) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Publishing new metadata delta ").append(delta).append(" at offset ").append($this.kafka$server$metadata$BrokerMetadataListener$$_image().highestOffsetAndEpoch().offset).append(".").toString());
        }
        publisher.publish(delta, this.kafka$server$metadata$BrokerMetadataListener$$_image());
    }

    public void handleLeaderChange(LeaderAndEpoch leaderAndEpoch) {
    }

    public void beginShutdown() {
        this.eventQueue().beginShutdown("beginShutdown", (EventQueue.Event)new ShutdownEvent());
    }

    public void close() {
        this.beginShutdown();
        this.eventQueue().close();
    }

    /*
     * WARNING - void declaration
     */
    public CompletableFuture<List<ApiMessageAndVersion>> getImageRecords() {
        void var1_1;
        CompletableFuture<List<ApiMessageAndVersion>> future = new CompletableFuture<List<ApiMessageAndVersion>>();
        this.eventQueue().append((EventQueue.Event)new GetImageRecordsEvent(this, future));
        return var1_1;
    }

    private final void BatchLoadResults$lzycompute$1() {
        synchronized (this) {
            if (this.BatchLoadResults$module == null) {
                this.BatchLoadResults$module = new BrokerMetadataListener$BatchLoadResults$(this);
            }
            return;
        }
    }

    public BrokerMetadataListener(int brokerId, Time time, Option<String> threadNamePrefix, long maxBytesBetweenSnapshots, Option<MetadataSnapshotter> snapshotter) {
        this.brokerId = brokerId;
        this.time = time;
        this.maxBytesBetweenSnapshots = maxBytesBetweenSnapshots;
        this.snapshotter = snapshotter;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.logContext = new LogContext(new StringBuilder(29).append("[BrokerMetadataListener id=").append(brokerId).append("] ").toString());
        this.kafka$server$metadata$BrokerMetadataListener$$log = this.logContext().logger(BrokerMetadataListener.class);
        this.logIdent_$eq(this.logContext().logPrefix());
        this.batchProcessingTimeHist = this.newHistogram(BrokerMetadataListener$.MODULE$.MetadataBatchProcessingTimeUs(), this.newHistogram$default$2(), this.newHistogram$default$3());
        this.metadataBatchSizeHist = this.newHistogram(BrokerMetadataListener$.MODULE$.MetadataBatchSizes(), this.newHistogram$default$2(), this.newHistogram$default$3());
        this._highestOffset = -1L;
        this.kafka$server$metadata$BrokerMetadataListener$$_highestTimestamp = -1L;
        this.kafka$server$metadata$BrokerMetadataListener$$_image = MetadataImage.EMPTY;
        this.kafka$server$metadata$BrokerMetadataListener$$_delta = new MetadataDelta(this.kafka$server$metadata$BrokerMetadataListener$$_image());
        this.kafka$server$metadata$BrokerMetadataListener$$_publisher = None$.MODULE$;
        this.kafka$server$metadata$BrokerMetadataListener$$_bytesSinceLastSnapshot = 0L;
        this.eventQueue = new KafkaEventQueue(time, this.logContext(), (String)threadNamePrefix.getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
    }

    public class BatchLoadResults
    implements Product,
    scala.Serializable {
        private final int numBatches;
        private final int numRecords;
        private final long elapsedUs;
        private final long numBytes;
        public final /* synthetic */ BrokerMetadataListener $outer;

        public int numBatches() {
            return this.numBatches;
        }

        public int numRecords() {
            return this.numRecords;
        }

        public long elapsedUs() {
            return this.elapsedUs;
        }

        public long numBytes() {
            return this.numBytes;
        }

        public String toString() {
            return new StringBuilder(71).append(this.numBatches()).append(" batch(es) with ").append(this.numRecords()).append(" record(s) in ").append(this.numBytes()).append(" bytes ").append("ending at offset ").append(this.kafka$server$metadata$BrokerMetadataListener$BatchLoadResults$$$outer().highestMetadataOffset()).append(" in ").append(this.elapsedUs()).append(" microseconds").toString();
        }

        public BatchLoadResults copy(int numBatches, int numRecords, long elapsedUs, long numBytes) {
            return new BatchLoadResults(this.kafka$server$metadata$BrokerMetadataListener$BatchLoadResults$$$outer(), numBatches, numRecords, elapsedUs, numBytes);
        }

        public int copy$default$1() {
            return this.numBatches();
        }

        public int copy$default$2() {
            return this.numRecords();
        }

        public long copy$default$3() {
            return this.elapsedUs();
        }

        public long copy$default$4() {
            return this.numBytes();
        }

        public String productPrefix() {
            return "BatchLoadResults";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return BoxesRunTime.boxToInteger((int)this.numBatches());
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this.numRecords());
                }
                case 2: {
                    return BoxesRunTime.boxToLong((long)this.elapsedUs());
                }
                case 3: {
                    return BoxesRunTime.boxToLong((long)this.numBytes());
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof BatchLoadResults;
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)this.numBatches()), (int)this.numRecords()), (int)Statics.longHash((long)this.elapsedUs())), (int)Statics.longHash((long)this.numBytes())), (int)4);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    boolean bl = x$1 instanceof BatchLoadResults && ((BatchLoadResults)x$1).kafka$server$metadata$BrokerMetadataListener$BatchLoadResults$$$outer() == this.kafka$server$metadata$BrokerMetadataListener$BatchLoadResults$$$outer();
                    if (!bl) break block3;
                    BatchLoadResults batchLoadResults = (BatchLoadResults)x$1;
                    if (!(this.numBatches() == batchLoadResults.numBatches() && this.numRecords() == batchLoadResults.numRecords() && this.elapsedUs() == batchLoadResults.elapsedUs() && this.numBytes() == batchLoadResults.numBytes() && batchLoadResults.canEqual(this))) break block3;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ BrokerMetadataListener kafka$server$metadata$BrokerMetadataListener$BatchLoadResults$$$outer() {
            return this.$outer;
        }

        public BatchLoadResults(BrokerMetadataListener $outer, int numBatches, int numRecords, long elapsedUs, long numBytes) {
            this.numBatches = numBatches;
            this.numRecords = numRecords;
            this.elapsedUs = elapsedUs;
            this.numBytes = numBytes;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }

    public class GetImageRecordsEvent
    extends EventQueue.FailureLoggingEvent
    implements Consumer<List<ApiMessageAndVersion>> {
        private final CompletableFuture<List<ApiMessageAndVersion>> future;
        private final ArrayList<ApiMessageAndVersion> records;
        public final /* synthetic */ BrokerMetadataListener $outer;

        @Override
        public Consumer<List<ApiMessageAndVersion>> andThen(Consumer<? super List<ApiMessageAndVersion>> x$1) {
            return Consumer.super.andThen(x$1);
        }

        public ArrayList<ApiMessageAndVersion> records() {
            return this.records;
        }

        @Override
        public void accept(List<ApiMessageAndVersion> batch) {
            this.records().addAll(batch);
        }

        public void run() {
            this.kafka$server$metadata$BrokerMetadataListener$GetImageRecordsEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$_image().write((Consumer)this);
            this.future.complete(this.records());
        }

        public /* synthetic */ BrokerMetadataListener kafka$server$metadata$BrokerMetadataListener$GetImageRecordsEvent$$$outer() {
            return this.$outer;
        }

        public GetImageRecordsEvent(BrokerMetadataListener $outer, CompletableFuture<List<ApiMessageAndVersion>> future) {
            this.future = future;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super($outer.kafka$server$metadata$BrokerMetadataListener$$log());
            this.records = new ArrayList();
        }
    }

    public class HandleCommitsEvent
    extends EventQueue.FailureLoggingEvent {
        private final BatchReader<ApiMessageAndVersion> reader;
        public final /* synthetic */ BrokerMetadataListener $outer;

        /*
         * WARNING - void declaration
         */
        public void run() {
            void var1_1;
            try {
                BatchLoadResults loadResults = this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$loadBatches(this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$_delta(), (java.util.Iterator<Batch<ApiMessageAndVersion>>)this.reader, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
                if (this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().isDebugEnabled()) {
                    this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Loaded new commits: ").append(loadResults).toString());
                }
            }
            finally {
                this.reader.close();
            }
            this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$_publisher().foreach((Function1 & Serializable & scala.Serializable)publisher -> {
                HandleCommitsEvent.$anonfun$run$2(this, publisher);
                return BoxedUnit.UNIT;
            });
            this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().snapshotter().foreach(arg_0 -> HandleCommitsEvent.$anonfun$run$3$adapted(this, (BatchLoadResults)var1_1, arg_0));
        }

        public /* synthetic */ BrokerMetadataListener kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ void $anonfun$run$2(HandleCommitsEvent $this, MetadataPublisher publisher) {
            $this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$publish(publisher);
        }

        public static final /* synthetic */ void $anonfun$run$3(HandleCommitsEvent $this, BatchLoadResults results$1, MetadataSnapshotter snapshotter) {
            $this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$_bytesSinceLastSnapshot_$eq($this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$_bytesSinceLastSnapshot() + results$1.numBytes());
            if ($this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$shouldSnapshot() && snapshotter.maybeStartSnapshot($this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$_highestTimestamp(), $this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$_delta().apply())) {
                $this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$_bytesSinceLastSnapshot_$eq(0L);
                return;
            }
        }

        public HandleCommitsEvent(BrokerMetadataListener $outer, BatchReader<ApiMessageAndVersion> reader) {
            this.reader = reader;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super($outer.kafka$server$metadata$BrokerMetadataListener$$log());
        }

        public static final /* synthetic */ Object $anonfun$run$3$adapted(HandleCommitsEvent $this, BatchLoadResults results$1, MetadataSnapshotter snapshotter) {
            HandleCommitsEvent.$anonfun$run$3($this, results$1, snapshotter);
            return BoxedUnit.UNIT;
        }
    }

    public class HandleSnapshotEvent
    extends EventQueue.FailureLoggingEvent {
        private final SnapshotReader<ApiMessageAndVersion> reader;
        public final /* synthetic */ BrokerMetadataListener $outer;

        public void run() {
            try {
                this.kafka$server$metadata$BrokerMetadataListener$HandleSnapshotEvent$$$outer().info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Loading snapshot ").append($this.reader.snapshotId().offset).append("-").append($this.reader.snapshotId().epoch).append(".").toString());
                this.kafka$server$metadata$BrokerMetadataListener$HandleSnapshotEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$_delta_$eq(new MetadataDelta(this.kafka$server$metadata$BrokerMetadataListener$HandleSnapshotEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$_image()));
                BatchLoadResults loadResults = this.kafka$server$metadata$BrokerMetadataListener$HandleSnapshotEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$loadBatches(this.kafka$server$metadata$BrokerMetadataListener$HandleSnapshotEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$_delta(), (java.util.Iterator<Batch<ApiMessageAndVersion>>)this.reader, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.reader.lastContainedLogTimestamp())), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.reader.lastContainedLogOffset())), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)this.reader.lastContainedLogEpoch())));
                this.kafka$server$metadata$BrokerMetadataListener$HandleSnapshotEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$_delta().finishSnapshot();
                this.kafka$server$metadata$BrokerMetadataListener$HandleSnapshotEvent$$$outer().info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Loaded snapshot ").append($this.reader.snapshotId().offset).append("-").append($this.reader.snapshotId().epoch).append(": ").append(loadResults).toString());
            }
            finally {
                this.reader.close();
            }
            this.kafka$server$metadata$BrokerMetadataListener$HandleSnapshotEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$_publisher().foreach((Function1 & Serializable & scala.Serializable)publisher -> {
                HandleSnapshotEvent.$anonfun$run$6(this, publisher);
                return BoxedUnit.UNIT;
            });
        }

        public /* synthetic */ BrokerMetadataListener kafka$server$metadata$BrokerMetadataListener$HandleSnapshotEvent$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ void $anonfun$run$6(HandleSnapshotEvent $this, MetadataPublisher publisher) {
            $this.kafka$server$metadata$BrokerMetadataListener$HandleSnapshotEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$publish(publisher);
        }

        public HandleSnapshotEvent(BrokerMetadataListener $outer, SnapshotReader<ApiMessageAndVersion> reader) {
            this.reader = reader;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super($outer.kafka$server$metadata$BrokerMetadataListener$$log());
        }
    }

    public class ShutdownEvent
    extends EventQueue.FailureLoggingEvent {
        public void run() {
            this.kafka$server$metadata$BrokerMetadataListener$ShutdownEvent$$$outer().removeMetric(BrokerMetadataListener$.MODULE$.MetadataBatchProcessingTimeUs(), this.kafka$server$metadata$BrokerMetadataListener$ShutdownEvent$$$outer().removeMetric$default$2());
            this.kafka$server$metadata$BrokerMetadataListener$ShutdownEvent$$$outer().removeMetric(BrokerMetadataListener$.MODULE$.MetadataBatchSizes(), this.kafka$server$metadata$BrokerMetadataListener$ShutdownEvent$$$outer().removeMetric$default$2());
        }

        public /* synthetic */ BrokerMetadataListener kafka$server$metadata$BrokerMetadataListener$ShutdownEvent$$$outer() {
            return BrokerMetadataListener.this;
        }

        public ShutdownEvent() {
            if (BrokerMetadataListener.this == null) {
                throw null;
            }
            super(BrokerMetadataListener.this.kafka$server$metadata$BrokerMetadataListener$$log());
        }
    }

    public class StartPublishingEvent
    extends EventQueue.FailureLoggingEvent {
        private final MetadataPublisher publisher;
        private final CompletableFuture<Void> future;
        public final /* synthetic */ BrokerMetadataListener $outer;

        public CompletableFuture<Void> future() {
            return this.future;
        }

        public void run() {
            this.kafka$server$metadata$BrokerMetadataListener$StartPublishingEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$_publisher_$eq((Option<MetadataPublisher>)new Some((Object)this.publisher));
            this.kafka$server$metadata$BrokerMetadataListener$StartPublishingEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$log().info(new StringBuilder(47).append("Starting to publish metadata events at offset ").append(this.kafka$server$metadata$BrokerMetadataListener$StartPublishingEvent$$$outer().highestMetadataOffset()).append(".").toString());
            try {
                this.kafka$server$metadata$BrokerMetadataListener$StartPublishingEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$publish(this.publisher);
                this.future().complete(null);
                return;
            }
            catch (Throwable e) {
                this.future().completeExceptionally(e);
                throw e;
            }
        }

        public /* synthetic */ BrokerMetadataListener kafka$server$metadata$BrokerMetadataListener$StartPublishingEvent$$$outer() {
            return this.$outer;
        }

        public StartPublishingEvent(BrokerMetadataListener $outer, MetadataPublisher publisher) {
            this.publisher = publisher;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super($outer.kafka$server$metadata$BrokerMetadataListener$$log());
            this.future = new CompletableFuture();
        }
    }
}

