/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.backup;

import SevenZip.Compression.LZMA.Decoder;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import kd.bos.olapServer.common.CommonTypesKt;
import kd.bos.olapServer.tools.Res;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b \u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0004R\u0018\u0010\b\u001a\u00060\tj\u0002`\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0018\u0010\u000f\u001a\u00060\u0005j\u0002`\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0018\u0010\u0012\u001a\u00060\u0013j\u0002`\u0014X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001d"}, d2={"Lkd/bos/olapServer/backup/BaseRecovery;", "", "inputStream", "Ljava/io/DataInputStream;", "fileVersion", "", "Lkd/bos/olapServer/common/int;", "(Ljava/io/DataInputStream;I)V", "contentLength", "", "Lkd/bos/olapServer/common/long;", "getContentLength", "()J", "getInputStream", "()Ljava/io/DataInputStream;", "pathLength", "getPathLength", "()I", "relativePath", "", "Lkd/bos/olapServer/common/string;", "getRelativePath", "()Ljava/lang/String;", "writeToFile", "", "decoder", "LSevenZip/Compression/LZMA/Decoder;", "file", "Ljava/io/File;", "bos-olap-core"})
public abstract class BaseRecovery {
    @NotNull
    private final DataInputStream inputStream;
    private final long contentLength;
    private final int pathLength;
    @NotNull
    private final String relativePath;

    public BaseRecovery(@NotNull DataInputStream inputStream, int fileVersion) {
        long l;
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        this.inputStream = inputStream;
        int n = fileVersion;
        switch (n) {
            case 1: {
                this.inputStream.readInt();
                l = this.inputStream.readInt();
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                l = this.inputStream.readLong();
                break;
            }
            default: {
                Object[] objectArray = Res.INSTANCE.getCubeRecoveryException_6();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.CubeRecoveryException_6");
                Object[] objectArray2 = objectArray;
                objectArray = new Object[]{fileVersion};
                throw Res.INSTANCE.getRuntimeException((String)objectArray2, objectArray);
            }
        }
        this.contentLength = l;
        this.pathLength = this.inputStream.readInt();
        byte[] bytes = new byte[this.pathLength];
        int len = CommonTypesKt.readByteArray(this.inputStream, bytes);
        if (len != this.pathLength) {
            throw new RuntimeException(len + " != " + this.pathLength);
        }
        byte[] byArray = bytes;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        boolean bl2 = false;
        this.relativePath = new String(byArray, charset);
    }

    @NotNull
    protected final DataInputStream getInputStream() {
        return this.inputStream;
    }

    protected final long getContentLength() {
        return this.contentLength;
    }

    protected final int getPathLength() {
        return this.pathLength;
    }

    @NotNull
    protected final String getRelativePath() {
        return this.relativePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void writeToFile(@NotNull Decoder decoder, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(file));
        Closeable closeable = outputStream;
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            BufferedOutputStream it = (BufferedOutputStream)closeable;
            boolean bl3 = false;
            if (!decoder.Code((InputStream)this.getInputStream(), (OutputStream)outputStream, this.getContentLength())) {
                throw new RuntimeException(Res.INSTANCE.getCommonException_1());
            }
            it.flush();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

