/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.backup;

import SevenZip.Compression.LZMA.Encoder;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.olapServer.backup.BackupConstant;
import kd.bos.olapServer.backup.BackupFileType;
import kd.bos.olapServer.backup.DistributedBackup;
import kd.bos.olapServer.backup.FileBackup;
import kd.bos.olapServer.backup.IBackupItem;
import kd.bos.olapServer.backup.KeysBackup;
import kd.bos.olapServer.backup.MeasuresBackup;
import kd.bos.olapServer.backup.QueryLockBackupItem;
import kd.bos.olapServer.common.Paths;
import kd.bos.olapServer.metadata.Cube;
import kd.bos.olapServer.storages.AbstractCubeWorkspace;
import kd.bos.olapServer.storages.CubeDataLock;
import kd.bos.olapServer.storages.CubeWorkspace;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\u0014\u0010\u0013\u001a\u00020\u00112\n\u0010\u0014\u001a\u00060\u0015j\u0002`\u0016H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lkd/bos/olapServer/backup/CubeBackup;", "Ljava/io/Closeable;", "workspace", "Lkd/bos/olapServer/storages/CubeWorkspace;", "outputStream", "Ljava/io/OutputStream;", "rootPath", "", "Lkd/bos/olapServer/common/string;", "(Lkd/bos/olapServer/storages/CubeWorkspace;Ljava/io/OutputStream;Ljava/lang/String;)V", "cube", "Lkd/bos/olapServer/metadata/Cube;", "items", "Lkd/bos/olapServer/backup/DistributedBackup;", "Lkd/bos/olapServer/backup/IBackupItem;", "metadataReadLock", "backup", "", "close", "write", "version", "", "Lkd/bos/olapServer/common/long;", "bos-olap-core"})
public final class CubeBackup
implements Closeable {
    @NotNull
    private final CubeWorkspace workspace;
    @NotNull
    private final OutputStream outputStream;
    @NotNull
    private final DistributedBackup<IBackupItem> items;
    @NotNull
    private final Cube cube;
    @Nullable
    private Closeable metadataReadLock;

    public CubeBackup(@NotNull CubeWorkspace workspace, @NotNull OutputStream outputStream, @NotNull String rootPath) {
        Intrinsics.checkNotNullParameter((Object)workspace, (String)"workspace");
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
        this.workspace = workspace;
        this.outputStream = outputStream;
        this.items = new DistributedBackup();
        this.cube = this.workspace.getMetadata();
        this.metadataReadLock = this.workspace.getMetadataLock().getReadLock();
        try {
            Object object;
            String cubeName = this.cube.getName();
            for (String string : this.workspace.getMetadataStorage().getFileNames()) {
                object = new String[]{cubeName, string};
                File dbFile = Paths.INSTANCE.get(rootPath, (String[])object).toFile();
                if (!dbFile.exists()) continue;
                this.items.registerProxy(new FileBackup(cubeName, rootPath, string, BackupFileType.MetaData));
            }
            String[] stringArray = new String[]{cubeName, "cube.json"};
            File jsonFile = new File(((Object)Paths.INSTANCE.get(rootPath, stringArray)).toString());
            if (jsonFile.exists()) {
                this.items.registerProxy(new FileBackup(cubeName, rootPath, "cube.json", BackupFileType.MetaData));
            }
            if (this.cube.getEnabledPartition()) {
                Iterator<AbstractCubeWorkspace> $this$forEach$iv = this.workspace.getSubWorkspaces();
                boolean $i$f$forEach = false;
                Iterator<AbstractCubeWorkspace> iterator = $this$forEach$iv;
                boolean dbFile = false;
                object = iterator;
                while (object.hasNext()) {
                    Object element$iv = object.next();
                    AbstractCubeWorkspace subWorkspace = (AbstractCubeWorkspace)element$iv;
                    boolean bl = false;
                    if (subWorkspace.getRowCount() <= 0) continue;
                    CubeDataLock dataLock = subWorkspace.getDataLock();
                    KeysBackup keyItem = new KeysBackup(subWorkspace, dataLock);
                    MeasuresBackup measureItem = new MeasuresBackup(keyItem, subWorkspace, rootPath);
                    this.items.registerProxy(keyItem);
                    this.items.registerProxy(new QueryLockBackupItem(measureItem, dataLock));
                }
            } else {
                AbstractCubeWorkspace basicWorkspace = this.workspace.getSubWorkspaces().next();
                if (basicWorkspace.getRowCount() > 0) {
                    CubeDataLock dataLock = basicWorkspace.getDataLock();
                    KeysBackup keysBackup = new KeysBackup(basicWorkspace, dataLock);
                    this.items.registerProxy(keysBackup);
                    MeasuresBackup measureItem = new MeasuresBackup(keysBackup, basicWorkspace, rootPath);
                    this.items.registerProxy(new QueryLockBackupItem(measureItem, dataLock));
                }
            }
        }
        catch (Exception ex) {
            this.close();
            throw ex;
        }
    }

    public final void backup() {
        boolean bl = false;
        List tasks = new ArrayList();
        long version = this.workspace.getTransactionManager().getLastCommittedTransactionId();
        this.items.init(tasks);
        Closeable readLock = this.metadataReadLock;
        if (readLock != null) {
            readLock.close();
            this.metadataReadLock = null;
        }
        this.write(version);
    }

    private final void write(long version) {
        String string;
        DataOutputStream stream = new DataOutputStream(new BufferedOutputStream(this.outputStream));
        if (this.cube.getEnabledPartition()) {
            string = BackupConstant.INSTANCE.getBackupFileHeader_v4();
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string2.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            stream.write(byArray);
        } else {
            string = BackupConstant.INSTANCE.getBackupFileHeader_v3();
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            String string3 = string;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string3.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            stream.write(byArray);
        }
        stream.writeLong(version);
        stream.writeInt(this.items.getFileCount());
        this.items.writeManifest(stream);
        Encoder encoder = new Encoder();
        encoder.SetNumFastBytes(5);
        encoder.WriteCoderProperties((OutputStream)stream);
        this.items.writeContent(encoder, stream);
        stream.flush();
    }

    @Override
    public void close() {
        Closeable closeable = this.metadataReadLock;
        if (closeable != null) {
            closeable.close();
        }
        this.items.close();
    }
}

