/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.backup;

import SevenZip.Compression.LZMA.Decoder;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.olapServer.backup.BackupConstant;
import kd.bos.olapServer.backup.FileRecovery;
import kd.bos.olapServer.backup.IRecoveryItem;
import kd.bos.olapServer.backup.KeyFileRecovery;
import kd.bos.olapServer.backup.KeysRecoveryV2;
import kd.bos.olapServer.backup.KeysRecoveryV3;
import kd.bos.olapServer.backup.KeysRecoveryV4;
import kd.bos.olapServer.backup.RecoveryContext;
import kd.bos.olapServer.common.CancellableToken;
import kd.bos.olapServer.common.CommandTypes;
import kd.bos.olapServer.common.CommonTypesKt;
import kd.bos.olapServer.common.IContinueToken;
import kd.bos.olapServer.common.ParallelTaskManager;
import kd.bos.olapServer.common.Paths;
import kd.bos.olapServer.metadata.builds.CubeBuilder;
import kd.bos.olapServer.metadata.builds.CubeEntry;
import kd.bos.olapServer.metadata.builds.IMetadataWriterContext;
import kd.bos.olapServer.metadata.builds.OlapMetadataBuilder;
import kd.bos.olapServer.metadata.builds.PropertyValueBuilder;
import kd.bos.olapServer.replication.LocalRedo;
import kd.bos.olapServer.replication.ReplicationManager;
import kd.bos.olapServer.storages.IMetadataDatabase;
import kd.bos.olapServer.storages.OlapLockManager;
import kd.bos.olapServer.storages.OlapWorkspace;
import kd.bos.olapServer.tools.FileTools;
import kd.bos.olapServer.tools.Res;
import kd.bos.olapServer.tools.StringValidator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\n\u0010\u0007\u001a\u00060\u0005j\u0002`\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u00160\u0015j\b\u0012\u0004\u0012\u00020\u0016`\u0017H\u0002J\u0006\u0010\u0018\u001a\u00020\u0013J\b\u0010\u0019\u001a\u00020\u0013H\u0002J\u0014\u0010\u001a\u001a\u00020\u00132\n\u0010\u001b\u001a\u00060\u001cj\u0002`\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u0013H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lkd/bos/olapServer/backup/CubeRecovery;", "", "olapWorkspace", "Lkd/bos/olapServer/storages/OlapWorkspace;", "cubeName", "", "Lkd/bos/olapServer/common/string;", "rootPath", "inputStream", "Ljava/io/DataInputStream;", "(Lkd/bos/olapServer/storages/OlapWorkspace;Ljava/lang/String;Ljava/lang/String;Ljava/io/DataInputStream;)V", "context", "Lkd/bos/olapServer/backup/RecoveryContext;", "cubePath", "fileVersion", "", "createDecoder", "LSevenZip/Compression/LZMA/Decoder;", "innerRecovery", "", "readRecoveryList", "Ljava/util/ArrayList;", "Lkd/bos/olapServer/backup/IRecoveryItem;", "Lkotlin/collections/ArrayList;", "recovery", "renameCube", "updateOlapMetadata", "version", "", "Lkd/bos/olapServer/common/long;", "validateHeader", "bos-olap-core"})
public final class CubeRecovery {
    @NotNull
    private final OlapWorkspace olapWorkspace;
    @NotNull
    private final String cubeName;
    @NotNull
    private final String rootPath;
    @NotNull
    private final DataInputStream inputStream;
    @NotNull
    private final String cubePath;
    private int fileVersion;
    @NotNull
    private final RecoveryContext context;

    public CubeRecovery(@NotNull OlapWorkspace olapWorkspace, @NotNull String cubeName, @NotNull String rootPath, @NotNull DataInputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)olapWorkspace, (String)"olapWorkspace");
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        this.olapWorkspace = olapWorkspace;
        this.cubeName = cubeName;
        this.rootPath = rootPath;
        this.inputStream = inputStream;
        this.fileVersion = 1;
        StringValidator.INSTANCE.validate(this.cubeName);
        String[] stringArray = new String[]{this.cubeName};
        this.cubePath = ((Object)Paths.INSTANCE.get(this.rootPath, stringArray)).toString();
        this.context = new RecoveryContext(this.cubePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void recovery() {
        OlapLockManager.CubeLock lock = this.olapWorkspace.getLockManager().lock(this.cubeName);
        Closeable closeable = lock;
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            OlapLockManager.CubeLock it = (OlapLockManager.CubeLock)closeable;
            boolean bl3 = false;
            if (FileTools.INSTANCE.isExist(this.cubePath)) {
                FileTools.INSTANCE.deleteDir(new File(this.cubePath));
                this.innerRecovery();
            } else {
                this.innerRecovery();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final void innerRecovery() {
        this.validateHeader();
        long version = this.fileVersion == 3 || this.fileVersion == 4 ? this.inputStream.readLong() : 0L;
        CancellableToken.INSTANCE.withCancellable((Function0)new Function0<Unit>(this){
            final /* synthetic */ CubeRecovery this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                FileTools.INSTANCE.createFile(CubeRecovery.access$getCubePath$p(this.this$0), false);
                ArrayList fileList = CubeRecovery.access$readRecoveryList(this.this$0);
                Decoder decoder = CubeRecovery.access$createDecoder(this.this$0);
                ParallelTaskManager ptm = ParallelTaskManager.Companion.begin();
                Closeable closeable = ptm;
                CubeRecovery cubeRecovery = this.this$0;
                boolean bl = false;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    ParallelTaskManager it = (ParallelTaskManager)closeable;
                    boolean bl3 = false;
                    IContinueToken continueToken = CancellableToken.INSTANCE.getContinueToken();
                    for (IRecoveryItem file : fileList) {
                        if (!continueToken.canContinue()) continue;
                        file.recovery(decoder);
                    }
                    CubeRecovery.access$getContext$p(cubeRecovery).waitTasks();
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
        }, (Function1)new Function1<Exception, Unit>(this){
            final /* synthetic */ CubeRecovery this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Exception $noName_0) {
                Intrinsics.checkNotNullParameter((Object)$noName_0, (String)"$noName_0");
                CubeRecovery.access$getContext$p(this.this$0).close();
                if (FileTools.INSTANCE.isExist(CubeRecovery.access$getCubePath$p(this.this$0))) {
                    FileTools.INSTANCE.deleteDir(new File(CubeRecovery.access$getCubePath$p(this.this$0)));
                }
            }
        }, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ CubeRecovery this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                CubeRecovery.access$getContext$p(this.this$0).close();
            }
        }));
        this.renameCube();
        this.updateOlapMetadata(version);
    }

    private final void validateHeader() {
        int n;
        byte[] headerByte = new byte[23];
        int len = CommonTypesKt.readByteArray(this.inputStream, headerByte);
        if (len != 23) {
            throw new RuntimeException(Res.INSTANCE.getCubeRecoveryException_2());
        }
        Object object = Charsets.UTF_8;
        boolean bl = false;
        String currentFileHeader = new String(headerByte, (Charset)object);
        if (Intrinsics.areEqual((Object)(object = currentFileHeader), (Object)"Kingdee Shrek backup v1")) {
            n = 1;
        } else if (Intrinsics.areEqual((Object)object, (Object)BackupConstant.INSTANCE.getBackupFileHeader_v2())) {
            n = 2;
        } else if (Intrinsics.areEqual((Object)object, (Object)BackupConstant.INSTANCE.getBackupFileHeader_v3())) {
            n = 3;
        } else if (Intrinsics.areEqual((Object)object, (Object)BackupConstant.INSTANCE.getBackupFileHeader_v4())) {
            n = 4;
        } else {
            throw new RuntimeException(Res.INSTANCE.getCubeRecoveryException_2());
        }
        this.fileVersion = n;
    }

    private final ArrayList<IRecoveryItem> readRecoveryList() {
        int fileCount = this.inputStream.readInt();
        ArrayList<IRecoveryItem> fileList = new ArrayList<IRecoveryItem>();
        HashMap keysRecoveryMap = new HashMap();
        KeysRecoveryV3 keyReader = null;
        KeysRecoveryV4 keyReader4 = null;
        int n = 0;
        if (n < fileCount) {
            do {
                int ordinal;
                int index2 = n++;
                int n2 = ordinal = this.inputStream.read();
                switch (n2) {
                    case 1: {
                        Object object;
                        if (this.fileVersion < 3) {
                            fileList.add(new KeysRecoveryV2(this.inputStream, this.cubePath, this.fileVersion));
                            break;
                        }
                        if (this.fileVersion == 3) {
                            if (keyReader == null) {
                                keyReader = new KeysRecoveryV3(this.context);
                                fileList.add(keyReader);
                            }
                            keyReader.addDimensionFile(new KeyFileRecovery(this.inputStream, this.fileVersion));
                            break;
                        }
                        KeyFileRecovery keyFile = new KeyFileRecovery(this.inputStream, this.fileVersion);
                        String partitionName = keyFile.getPartitionName();
                        CharSequence charSequence = partitionName;
                        boolean bl = false;
                        if (charSequence.length() == 0) {
                            if (keyReader4 == null) {
                                keyReader4 = new KeysRecoveryV4(partitionName, this.context);
                                fileList.add(keyReader4);
                            }
                            keyReader4.addDimensionFile(keyFile);
                            break;
                        }
                        Map $this$getOrPut$iv = keysRecoveryMap;
                        boolean $i$f$getOrPut = false;
                        Object value$iv = $this$getOrPut$iv.get(partitionName);
                        if (value$iv == null) {
                            boolean bl2 = false;
                            KeysRecoveryV4 keysRecoveryV4 = new KeysRecoveryV4(partitionName, this.context);
                            boolean bl3 = false;
                            boolean bl4 = false;
                            KeysRecoveryV4 it = keysRecoveryV4;
                            boolean bl5 = false;
                            fileList.add(it);
                            KeysRecoveryV4 answer$iv = keysRecoveryV4;
                            $this$getOrPut$iv.put(partitionName, answer$iv);
                            object = answer$iv;
                        } else {
                            object = value$iv;
                        }
                        KeysRecoveryV4 keyRecovery = (KeysRecoveryV4)object;
                        keyRecovery.addDimensionFile(keyFile);
                        break;
                    }
                    case 0: 
                    case 2: 
                    case 3: {
                        fileList.add(new FileRecovery(this.inputStream, this.cubePath, this.fileVersion));
                        break;
                    }
                    default: {
                        Object[] objectArray = Res.INSTANCE.getCubeRecoveryException_3();
                        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.CubeRecoveryException_3");
                        Object[] objectArray2 = objectArray;
                        objectArray = new Object[]{ordinal};
                        Res.INSTANCE.getRuntimeException((String)objectArray2, objectArray);
                    }
                }
            } while (n < fileCount);
        }
        return fileList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateOlapMetadata(long version) {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        Closeable closeable = IMetadataDatabase.Companion.readFrom(this.cubePath).createWriterContext();
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            IMetadataWriterContext writerContext = (IMetadataWriterContext)closeable;
            boolean bl3 = false;
            CubeBuilder.PropertyValueBuilderCollection properties2 = writerContext.getCubeBuilder().getProperties();
            Iterable $this$forEach$iv = properties2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PropertyValueBuilder it = (PropertyValueBuilder)element$iv;
                boolean bl4 = false;
                Map map = propertyMap;
                String string = it.getName();
                String string2 = it.getValue();
                boolean bl5 = false;
                map.put(string, string2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Ref.IntRef cubeId = new Ref.IntRef();
        this.olapWorkspace.getLockManager().enterWrite((Function0)new Function0<Unit>(cubeId, this, propertyMap){
            final /* synthetic */ Ref.IntRef $cubeId;
            final /* synthetic */ CubeRecovery this$0;
            final /* synthetic */ HashMap<String, String> $propertyMap;
            {
                this.$cubeId = $cubeId;
                this.this$0 = $receiver;
                this.$propertyMap = $propertyMap;
                super(0);
            }

            public final void invoke() {
                this.$cubeId.element = CubeRecovery.access$getOlapWorkspace$p(this.this$0).assignNextId();
                OlapMetadataBuilder builder = OlapMetadataBuilder.Companion.readFrom(CubeRecovery.access$getRootPath$p(this.this$0));
                CubeEntry cubeEntry = new CubeEntry(this.$cubeId.element, CubeRecovery.access$getCubeName$p(this.this$0), this.$propertyMap);
                builder.getCubes().add(cubeEntry);
                builder.save();
            }
        });
        this.olapWorkspace.updateMetadata(CommandTypes.create, this.cubeName);
        this.olapWorkspace.getCubeWorkspace(this.cubeName).getTransactionManager().updateVersion(version);
        if (ReplicationManager.INSTANCE.getEnableMaster()) {
            LocalRedo localRedo = new LocalRedo(ReplicationManager.INSTANCE.getMaster());
            localRedo.addCubeRecoverRecord(version, cubeId.element, this.olapWorkspace.getCubeWorkspace(this.cubeName).getMd5());
            localRedo.flushSyncSlaves();
        }
    }

    private final Decoder createDecoder() {
        Decoder decoder = new Decoder();
        int propertiesSize = 5;
        byte[] properties2 = new byte[propertiesSize];
        if (CommonTypesKt.readByteArray(this.inputStream, properties2, 0, propertiesSize) != propertiesSize) {
            throw new RuntimeException(Res.INSTANCE.getCubeRecoveryException_4());
        }
        if (!decoder.SetDecoderProperties(properties2)) {
            throw new RuntimeException(Res.INSTANCE.getCubeRecoveryException_5());
        }
        return decoder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void renameCube() {
        CharSequence charSequence = this.cubeName;
        boolean bl = false;
        if (charSequence.length() > 0) {
            IMetadataDatabase metadataDatabase = IMetadataDatabase.Companion.readFrom(this.cubePath);
            Closeable closeable = metadataDatabase.createWriterContext();
            boolean bl2 = false;
            boolean bl3 = false;
            Throwable throwable = null;
            try {
                IMetadataWriterContext writerContext = (IMetadataWriterContext)closeable;
                boolean bl4 = false;
                writerContext.getCubeBuilder().setName(this.cubeName);
                writerContext.save();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }

    public static final /* synthetic */ String access$getCubePath$p(CubeRecovery $this) {
        return $this.cubePath;
    }

    public static final /* synthetic */ ArrayList access$readRecoveryList(CubeRecovery $this) {
        return $this.readRecoveryList();
    }

    public static final /* synthetic */ Decoder access$createDecoder(CubeRecovery $this) {
        return $this.createDecoder();
    }

    public static final /* synthetic */ RecoveryContext access$getContext$p(CubeRecovery $this) {
        return $this.context;
    }

    public static final /* synthetic */ OlapWorkspace access$getOlapWorkspace$p(CubeRecovery $this) {
        return $this.olapWorkspace;
    }

    public static final /* synthetic */ String access$getRootPath$p(CubeRecovery $this) {
        return $this.rootPath;
    }

    public static final /* synthetic */ String access$getCubeName$p(CubeRecovery $this) {
        return $this.cubeName;
    }
}

