/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.backup;

import SevenZip.Compression.LZMA.Decoder;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.olapServer.backup.FileRecovery;
import kd.bos.olapServer.backup.IRecoveryItem;
import kd.bos.olapServer.backup.KeyFileRecovery;
import kd.bos.olapServer.backup.KeysRecoveryV2;
import kd.bos.olapServer.backup.KeysRecoveryV3;
import kd.bos.olapServer.backup.KeysRecoveryV4;
import kd.bos.olapServer.backup.RecoveryContext;
import kd.bos.olapServer.common.CancellableToken;
import kd.bos.olapServer.common.CommonTypesKt;
import kd.bos.olapServer.common.IContinueToken;
import kd.bos.olapServer.common.ParallelTaskManager;
import kd.bos.olapServer.common.Paths;
import kd.bos.olapServer.tools.FileTools;
import kd.bos.olapServer.tools.Res;
import kd.bos.olapServer.tools.StringValidator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B1\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u0012\n\u0010\b\u001a\u00060\u0006j\u0002`\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u00150\u0014j\b\u0012\u0004\u0012\u00020\u0015`\u0016H\u0002J\u0006\u0010\u0017\u001a\u00020\u0012R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00060\u0006j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lkd/bos/olapServer/backup/CubeRecoveryAdapter;", "", "fileVersion", "", "Lkd/bos/olapServer/common/int;", "cubeName", "", "Lkd/bos/olapServer/common/string;", "rootPath", "inputStream", "Ljava/io/DataInputStream;", "(ILjava/lang/String;Ljava/lang/String;Ljava/io/DataInputStream;)V", "context", "Lkd/bos/olapServer/backup/RecoveryContext;", "cubePath", "createDecoder", "LSevenZip/Compression/LZMA/Decoder;", "innerRecovery", "", "readRecoveryList", "Ljava/util/ArrayList;", "Lkd/bos/olapServer/backup/IRecoveryItem;", "Lkotlin/collections/ArrayList;", "recovery", "bos-olap-core"})
public final class CubeRecoveryAdapter {
    private final int fileVersion;
    @NotNull
    private final String cubeName;
    @NotNull
    private final DataInputStream inputStream;
    @NotNull
    private final String cubePath;
    @NotNull
    private final RecoveryContext context;

    public CubeRecoveryAdapter(int fileVersion, @NotNull String cubeName, @NotNull String rootPath, @NotNull DataInputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        this.fileVersion = fileVersion;
        this.cubeName = cubeName;
        this.inputStream = inputStream;
        StringValidator.INSTANCE.validate(this.cubeName);
        String[] stringArray = new String[]{this.cubeName};
        this.cubePath = ((Object)Paths.INSTANCE.get(rootPath, stringArray)).toString();
        this.context = new RecoveryContext(this.cubePath);
    }

    public final void recovery() {
        this.innerRecovery();
    }

    private final void innerRecovery() {
        CancellableToken.INSTANCE.withCancellable((Function0)new Function0<Unit>(this){
            final /* synthetic */ CubeRecoveryAdapter this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                FileTools.INSTANCE.createFile(CubeRecoveryAdapter.access$getCubePath$p(this.this$0), false);
                ArrayList fileList = CubeRecoveryAdapter.access$readRecoveryList(this.this$0);
                Decoder decoder = CubeRecoveryAdapter.access$createDecoder(this.this$0);
                ParallelTaskManager ptm = ParallelTaskManager.Companion.begin();
                Closeable closeable = ptm;
                CubeRecoveryAdapter cubeRecoveryAdapter = this.this$0;
                boolean bl = false;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    ParallelTaskManager it = (ParallelTaskManager)closeable;
                    boolean bl3 = false;
                    IContinueToken continueToken = CancellableToken.INSTANCE.getContinueToken();
                    for (IRecoveryItem file : fileList) {
                        if (!continueToken.canContinue()) continue;
                        file.recovery(decoder);
                    }
                    CubeRecoveryAdapter.access$getContext$p(cubeRecoveryAdapter).waitTasks();
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
        }, (Function1)new Function1<Exception, Unit>(this){
            final /* synthetic */ CubeRecoveryAdapter this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Exception $noName_0) {
                Intrinsics.checkNotNullParameter((Object)$noName_0, (String)"$noName_0");
                CubeRecoveryAdapter.access$getContext$p(this.this$0).close();
                if (FileTools.INSTANCE.isExist(CubeRecoveryAdapter.access$getCubePath$p(this.this$0))) {
                    FileTools.INSTANCE.deleteDir(new File(CubeRecoveryAdapter.access$getCubePath$p(this.this$0)));
                }
            }
        }, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ CubeRecoveryAdapter this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                CubeRecoveryAdapter.access$getContext$p(this.this$0).close();
            }
        }));
    }

    private final ArrayList<IRecoveryItem> readRecoveryList() {
        int fileCount = this.inputStream.readInt();
        ArrayList<IRecoveryItem> fileList = new ArrayList<IRecoveryItem>();
        HashMap keysRecoveryMap = new HashMap();
        KeysRecoveryV3 keyReader = null;
        KeysRecoveryV4 keyReader4 = null;
        int n = 0;
        if (n < fileCount) {
            do {
                int ordinal;
                int index2 = n++;
                int n2 = ordinal = this.inputStream.read();
                switch (n2) {
                    case 1: {
                        Object object;
                        if (this.fileVersion < 3) {
                            fileList.add(new KeysRecoveryV2(this.inputStream, this.cubePath, this.fileVersion));
                            break;
                        }
                        if (this.fileVersion == 3) {
                            if (keyReader == null) {
                                keyReader = new KeysRecoveryV3(this.context);
                                fileList.add(keyReader);
                            }
                            keyReader.addDimensionFile(new KeyFileRecovery(this.inputStream, this.fileVersion));
                            break;
                        }
                        KeyFileRecovery keyFile = new KeyFileRecovery(this.inputStream, this.fileVersion);
                        String partitionName = keyFile.getPartitionName();
                        CharSequence charSequence = partitionName;
                        boolean bl = false;
                        if (charSequence.length() == 0) {
                            if (keyReader4 == null) {
                                keyReader4 = new KeysRecoveryV4(partitionName, this.context);
                                fileList.add(keyReader4);
                            }
                            keyReader4.addDimensionFile(keyFile);
                            break;
                        }
                        Map $this$getOrPut$iv = keysRecoveryMap;
                        boolean $i$f$getOrPut = false;
                        Object value$iv = $this$getOrPut$iv.get(partitionName);
                        if (value$iv == null) {
                            boolean bl2 = false;
                            KeysRecoveryV4 keysRecoveryV4 = new KeysRecoveryV4(partitionName, this.context);
                            boolean bl3 = false;
                            boolean bl4 = false;
                            KeysRecoveryV4 it = keysRecoveryV4;
                            boolean bl5 = false;
                            fileList.add(it);
                            KeysRecoveryV4 answer$iv = keysRecoveryV4;
                            $this$getOrPut$iv.put(partitionName, answer$iv);
                            object = answer$iv;
                        } else {
                            object = value$iv;
                        }
                        KeysRecoveryV4 keyRecovery = (KeysRecoveryV4)object;
                        keyRecovery.addDimensionFile(keyFile);
                        break;
                    }
                    case 0: 
                    case 2: 
                    case 3: {
                        fileList.add(new FileRecovery(this.inputStream, this.cubePath, this.fileVersion));
                        break;
                    }
                    default: {
                        Object[] objectArray = Res.INSTANCE.getCubeRecoveryException_3();
                        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.CubeRecoveryException_3");
                        Object[] objectArray2 = objectArray;
                        objectArray = new Object[]{ordinal};
                        throw Res.INSTANCE.getRuntimeException((String)objectArray2, objectArray);
                    }
                }
            } while (n < fileCount);
        }
        return fileList;
    }

    private final Decoder createDecoder() {
        Decoder decoder = new Decoder();
        int propertiesSize = 5;
        byte[] properties2 = new byte[propertiesSize];
        if (CommonTypesKt.readByteArray(this.inputStream, properties2, 0, propertiesSize) != propertiesSize) {
            throw new RuntimeException(Res.INSTANCE.getCubeRecoveryException_4());
        }
        if (!decoder.SetDecoderProperties(properties2)) {
            throw new RuntimeException(Res.INSTANCE.getCubeRecoveryException_5());
        }
        return decoder;
    }

    public static final /* synthetic */ String access$getCubePath$p(CubeRecoveryAdapter $this) {
        return $this.cubePath;
    }

    public static final /* synthetic */ ArrayList access$readRecoveryList(CubeRecoveryAdapter $this) {
        return $this.readRecoveryList();
    }

    public static final /* synthetic */ Decoder access$createDecoder(CubeRecoveryAdapter $this) {
        return $this.createDecoder();
    }

    public static final /* synthetic */ RecoveryContext access$getContext$p(CubeRecoveryAdapter $this) {
        return $this.context;
    }
}

