/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.backup;

import SevenZip.Compression.LZMA.Encoder;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;
import kd.bos.olapServer.backup.BackupFileType;
import kd.bos.olapServer.backup.IBackupItem;
import kd.bos.olapServer.common.Paths;
import kd.bos.olapServer.storages.selectors.SelectorContext;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u00002\u00020\u0001B3\b\u0016\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\n\u0010\u0005\u001a\u00060\u0003j\u0002`\u0004\u0012\n\u0010\u0006\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB3\u0012\n\u0010\n\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\u0010\u0006\u001a\u00060\u0003j\u0002`\u0004\u0012\f\b\u0002\u0010\u000b\u001a\u00060\fj\u0002`\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\"H\u0016J\u0018\u0010&\u001a\u00020\"2\u0006\u0010'\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020\u001eH\u0002J\u001c\u0010)\u001a\u00020\"2\u0012\u0010*\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0,0+H\u0016J\u0018\u0010-\u001a\u00020\"2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0016J\u0010\u00102\u001a\u00020\"2\u0006\u00100\u001a\u000201H\u0016R\u0018\u0010\u000f\u001a\u00060\u0010j\u0002`\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0018\u0010\u0014\u001a\u00060\u0015j\u0002`\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0019\u0010\u0019\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00060\fj\u0002`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001f\u001a\u00060\u0015j\u0002`\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0018R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lkd/bos/olapServer/backup/FileBackup;", "Lkd/bos/olapServer/backup/IBackupItem;", "cubeName", "", "Lkd/bos/olapServer/common/string;", "rootPath", "relativePath", "fileType", "Lkd/bos/olapServer/backup/BackupFileType;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkd/bos/olapServer/backup/BackupFileType;)V", "sourcePath", "copyToTempFolder", "", "Lkd/bos/olapServer/common/bool;", "(Ljava/lang/String;Lkd/bos/olapServer/backup/BackupFileType;Ljava/lang/String;Z)V", "ContentLength", "", "Lkd/bos/olapServer/common/long;", "getContentLength", "()J", "PathLength", "", "Lkd/bos/olapServer/common/int;", "getPathLength", "()I", "TempFilePath", "getTempFilePath", "()Ljava/lang/String;", "_contentLength", "_tmpFile", "Ljava/io/File;", "fileCount", "getFileCount", "check", "", "context", "Lkd/bos/olapServer/storages/selectors/SelectorContext;", "close", "directCopy", "sourceFile", "targetFile", "init", "parallelTasks", "", "Lkotlin/Function0;", "writeContent", "encoder", "LSevenZip/Compression/LZMA/Encoder;", "stream", "Ljava/io/DataOutputStream;", "writeManifest", "bos-olap-core"})
public class FileBackup
implements IBackupItem {
    @NotNull
    private final String sourcePath;
    @NotNull
    private final BackupFileType fileType;
    @NotNull
    private final String relativePath;
    private final boolean copyToTempFolder;
    private long _contentLength;
    @Nullable
    private File _tmpFile;

    public FileBackup(@NotNull String sourcePath, @NotNull BackupFileType fileType, @NotNull String relativePath, boolean copyToTempFolder) {
        Intrinsics.checkNotNullParameter((Object)sourcePath, (String)"sourcePath");
        Intrinsics.checkNotNullParameter((Object)((Object)fileType), (String)"fileType");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        this.sourcePath = sourcePath;
        this.fileType = fileType;
        this.relativePath = relativePath;
        this.copyToTempFolder = copyToTempFolder;
        this._contentLength = -1L;
    }

    public /* synthetic */ FileBackup(String string, BackupFileType backupFileType, String string2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = true;
        }
        this(string, backupFileType, string2, bl);
    }

    public FileBackup(@NotNull String cubeName, @NotNull String rootPath, @NotNull String relativePath, @NotNull BackupFileType fileType) {
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Intrinsics.checkNotNullParameter((Object)((Object)fileType), (String)"fileType");
        String[] stringArray = new String[]{cubeName, relativePath};
        this(((Object)Paths.INSTANCE.get(rootPath, stringArray)).toString(), fileType, relativePath, true);
    }

    private final int getPathLength() {
        String string = this.relativePath;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        return byArray.length;
    }

    private final long getContentLength() {
        return this._contentLength;
    }

    @Nullable
    public final String getTempFilePath() {
        File file = this._tmpFile;
        return file == null ? null : file.getAbsolutePath();
    }

    @Override
    public int getFileCount() {
        return 1;
    }

    @Override
    public void init(@NotNull List<Function0<Unit>> parallelTasks) {
        Intrinsics.checkNotNullParameter(parallelTasks, (String)"parallelTasks");
        File sourceFile = new File(this.sourcePath);
        this._contentLength = sourceFile.length();
        if (this.copyToTempFolder) {
            File tmpFile;
            this._tmpFile = tmpFile = File.createTempFile("backupFile", ".tmp");
            if (this.fileType == BackupFileType.MetaData) {
                Intrinsics.checkNotNullExpressionValue((Object)tmpFile, (String)"tmpFile");
                this.directCopy(sourceFile, tmpFile);
            } else {
                parallelTasks.add(new Function0<Unit>(this, sourceFile, tmpFile){
                    final /* synthetic */ FileBackup this$0;
                    final /* synthetic */ File $sourceFile;
                    final /* synthetic */ File $tmpFile;
                    {
                        this.this$0 = $receiver;
                        this.$sourceFile = $sourceFile;
                        this.$tmpFile = $tmpFile;
                        super(0);
                    }

                    public final void invoke() {
                        File file = this.$tmpFile;
                        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"tmpFile");
                        FileBackup.access$directCopy(this.this$0, this.$sourceFile, file);
                    }
                });
            }
        }
    }

    @Override
    public void check(@NotNull SelectorContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
    }

    @Override
    public void writeManifest(@NotNull DataOutputStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        boolean bl = false;
        boolean bl2 = false;
        DataOutputStream $this$writeManifest_u24lambda_u2d0 = stream;
        boolean bl3 = false;
        $this$writeManifest_u24lambda_u2d0.writeByte(this.fileType.getValue());
        boolean bl4 = this.getContentLength() >= 0L;
        boolean bl5 = false;
        boolean bl6 = false;
        bl6 = false;
        boolean bl7 = false;
        if (!bl4) {
            boolean bl8 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        $this$writeManifest_u24lambda_u2d0.writeLong(this.getContentLength());
        $this$writeManifest_u24lambda_u2d0.writeInt(this.getPathLength());
        String string = this.relativePath;
        Charset charset = Charsets.UTF_8;
        bl6 = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        $this$writeManifest_u24lambda_u2d0.write(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeContent(@NotNull Encoder encoder, @NotNull DataOutputStream stream) {
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        Object object = this._tmpFile;
        BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream((File)(object == null ? new File(this.sourcePath) : object)));
        object = inputStream;
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            BufferedInputStream it = (BufferedInputStream)object;
            boolean bl3 = false;
            encoder.Code((InputStream)inputStream, (OutputStream)stream, -1L, -1L, null);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    @Override
    public void close() {
        File file = this._tmpFile;
        if (file != null) {
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void directCopy(File sourceFile, File targetFile) {
        FileOutputStream fos = new FileOutputStream(targetFile);
        FileInputStream inputStream = new FileInputStream(sourceFile);
        try {
            byte[] buffer = new byte[4096];
            int size = inputStream.read(buffer);
            while (size >= 0) {
                fos.write(buffer, 0, size);
                size = inputStream.read(buffer);
            }
        }
        finally {
            inputStream.close();
            fos.close();
        }
    }

    public static final /* synthetic */ void access$directCopy(FileBackup $this, File sourceFile, File targetFile) {
        $this.directCopy(sourceFile, targetFile);
    }
}

