/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.backup;

import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.olapServer.backup.BackupConstant;
import kd.bos.olapServer.backup.BackupFileType;
import kd.bos.olapServer.backup.DistributedBackup;
import kd.bos.olapServer.backup.FileBackup;
import kd.bos.olapServer.backup.IBackupItem;
import kd.bos.olapServer.common.Paths;
import kd.bos.olapServer.memoryMappedFiles.AbstractMetadata;
import kd.bos.olapServer.memoryMappedFiles.ListBooleanMetadata;
import kd.bos.olapServer.memoryMappedFiles.ListMetadata;
import kd.bos.olapServer.memoryMappedFiles.MutableCanSetListBoolean;
import kd.bos.olapServer.metadata.Measure;
import kd.bos.olapServer.storages.AbstractCubeWorkspace;
import kd.bos.olapServer.storages.selectors.SelectorContext;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.IntIterator;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001c\u0010\u0013\u001a\u00020\u00102\u0012\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00150\u000eH\u0016R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lkd/bos/olapServer/backup/MeasureDecimalBackup;", "Lkd/bos/olapServer/backup/DistributedBackup;", "Lkd/bos/olapServer/backup/IBackupItem;", "cubeWorkspace", "Lkd/bos/olapServer/storages/AbstractCubeWorkspace;", "rootPath", "", "Lkd/bos/olapServer/common/string;", "measure", "Lkd/bos/olapServer/metadata/Measure;", "(Lkd/bos/olapServer/storages/AbstractCubeWorkspace;Ljava/lang/String;Lkd/bos/olapServer/metadata/Measure;)V", "_flagFile", "Lkd/bos/olapServer/backup/FileBackup;", "_mainFiles", "", "check", "", "context", "Lkd/bos/olapServer/storages/selectors/SelectorContext;", "init", "parallelTasks", "Lkotlin/Function0;", "bos-olap-core"})
public final class MeasureDecimalBackup
extends DistributedBackup<IBackupItem> {
    @NotNull
    private final AbstractCubeWorkspace cubeWorkspace;
    @NotNull
    private final String rootPath;
    @NotNull
    private final Measure measure;
    @NotNull
    private final List<FileBackup> _mainFiles;
    @Nullable
    private FileBackup _flagFile;

    public MeasureDecimalBackup(@NotNull AbstractCubeWorkspace cubeWorkspace, @NotNull String rootPath, @NotNull Measure measure) {
        Intrinsics.checkNotNullParameter((Object)cubeWorkspace, (String)"cubeWorkspace");
        Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
        Intrinsics.checkNotNullParameter((Object)measure, (String)"measure");
        this.cubeWorkspace = cubeWorkspace;
        this.rootPath = rootPath;
        this.measure = measure;
        boolean bl = false;
        this._mainFiles = new ArrayList();
    }

    @Override
    public void init(@NotNull List<Function0<Unit>> parallelTasks) {
        Intrinsics.checkNotNullParameter(parallelTasks, (String)"parallelTasks");
        String cubeName = this.cubeWorkspace.getMetadata().getName();
        String partitionKey = BackupConstant.INSTANCE.getPartitionKey(this.cubeWorkspace);
        String[] stringArray = new String[]{cubeName, partitionKey, this.measure.getName()};
        String path = ((Object)Paths.INSTANCE.get(this.rootPath, stringArray)).toString();
        int fileCount = BackupConstant.INSTANCE.getFileCount(path, "main", "dat");
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)fileCount);
        boolean $i$f$forEach2 = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int it = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            String[] stringArray2 = new String[]{this.measure.getName(), "main" + (it != 0 ? String.valueOf(it) : "") + ".dat"};
            FileBackup measureMain = new FileBackup(cubeName, this.rootPath, ((Object)Paths.INSTANCE.get(partitionKey, stringArray2)).toString(), BackupFileType.MeasureMain);
            this.registerProxy((IBackupItem)measureMain);
            this._mainFiles.add(measureMain);
        }
        if (fileCount != 0) {
            String[] $i$f$forEach2 = new String[]{this.measure.getName(), "flags.dat"};
            String flagFile = ((Object)Paths.INSTANCE.get(partitionKey, $i$f$forEach2)).toString();
            if (new File(((Object)Paths.INSTANCE.get(this.rootPath, $i$f$forEach2 = new String[]{cubeName, flagFile})).toString()).exists()) {
                FileBackup measureFlag = new FileBackup(cubeName, this.rootPath, flagFile, BackupFileType.OtherFile);
                this.registerProxy((IBackupItem)measureFlag);
                this._flagFile = measureFlag;
            }
        }
        super.init(parallelTasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void check(@NotNull SelectorContext context) {
        String tempFile;
        BackupConstant backupConstant;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int mainRowCount = 0;
        Iterable $this$forEach$iv = this._mainFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FileBackup it = (FileBackup)element$iv;
            boolean bl = false;
            String tempFile2 = it.getTempFilePath();
            if (tempFile2 == null) continue;
            backupConstant = BackupConstant.INSTANCE;
            AbstractMetadata $this$use$iv = new ListMetadata(tempFile2, null, true, 2, null);
            boolean $i$f$use = false;
            Throwable exception$iv = null;
            try {
                ListMetadata it2 = (ListMetadata)$this$use$iv;
                boolean bl2 = false;
                mainRowCount += it2.getCount();
                it2 = Unit.INSTANCE;
            }
            catch (Throwable e$iv) {
                try {
                    exception$iv = e$iv;
                    throw e$iv;
                }
                catch (Throwable throwable) {
                    if (exception$iv == null) {
                        $this$use$iv.close();
                    } else {
                        try {
                            $this$use$iv.close();
                        }
                        catch (Throwable throwable2) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
            $this$use$iv.close();
        }
        context.checkRowCount(mainRowCount, Intrinsics.stringPlus((String)this.measure.getName(), (Object)"/main.dat"));
        int flagRowCount = 0;
        FileBackup flagFile = this._flagFile;
        if (flagFile != null && (tempFile = flagFile.getTempFilePath()) != null) {
            ListBooleanMetadata metadata = new ListBooleanMetadata(tempFile, null, true, 2, null);
            Closeable closeable = new MutableCanSetListBoolean(metadata);
            boolean bl = false;
            boolean bl3 = false;
            Throwable throwable = null;
            try {
                MutableCanSetListBoolean it = (MutableCanSetListBoolean)closeable;
                boolean bl4 = false;
                flagRowCount = it.getCount();
                backupConstant = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        context.checkRowCount(flagRowCount, Intrinsics.stringPlus((String)this.measure.getName(), (Object)"/flags.dat"));
    }
}

