/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.backup;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.olapServer.backup.BackupConstant;
import kd.bos.olapServer.backup.BackupFileType;
import kd.bos.olapServer.backup.DistributedBackup;
import kd.bos.olapServer.backup.FileBackup;
import kd.bos.olapServer.backup.IBackupItem;
import kd.bos.olapServer.common.Paths;
import kd.bos.olapServer.memoryMappedFiles.AbstractMetadata;
import kd.bos.olapServer.memoryMappedFiles.ListMetadata;
import kd.bos.olapServer.metadata.Measure;
import kd.bos.olapServer.storages.AbstractCubeWorkspace;
import kd.bos.olapServer.storages.selectors.SelectorContext;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001c\u0010\u0012\u001a\u00020\u000f2\u0012\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u00140\fH\u0016R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lkd/bos/olapServer/backup/MeasureObjectBackup;", "Lkd/bos/olapServer/backup/DistributedBackup;", "Lkd/bos/olapServer/backup/IBackupItem;", "cubeWorkspace", "Lkd/bos/olapServer/storages/AbstractCubeWorkspace;", "rootPath", "", "Lkd/bos/olapServer/common/string;", "measure", "Lkd/bos/olapServer/metadata/Measure;", "(Lkd/bos/olapServer/storages/AbstractCubeWorkspace;Ljava/lang/String;Lkd/bos/olapServer/metadata/Measure;)V", "_indexFiles", "", "Lkd/bos/olapServer/backup/FileBackup;", "check", "", "context", "Lkd/bos/olapServer/storages/selectors/SelectorContext;", "init", "parallelTasks", "Lkotlin/Function0;", "bos-olap-core"})
public final class MeasureObjectBackup
extends DistributedBackup<IBackupItem> {
    @NotNull
    private final AbstractCubeWorkspace cubeWorkspace;
    @NotNull
    private final String rootPath;
    @NotNull
    private final Measure measure;
    @NotNull
    private final List<FileBackup> _indexFiles;

    public MeasureObjectBackup(@NotNull AbstractCubeWorkspace cubeWorkspace, @NotNull String rootPath, @NotNull Measure measure) {
        Intrinsics.checkNotNullParameter((Object)cubeWorkspace, (String)"cubeWorkspace");
        Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
        Intrinsics.checkNotNullParameter((Object)measure, (String)"measure");
        this.cubeWorkspace = cubeWorkspace;
        this.rootPath = rootPath;
        this.measure = measure;
        boolean bl = false;
        this._indexFiles = new ArrayList();
    }

    @Override
    public void init(@NotNull List<Function0<Unit>> parallelTasks) {
        String[] stringArray;
        int it;
        int element$iv;
        Intrinsics.checkNotNullParameter(parallelTasks, (String)"parallelTasks");
        String cubeName = this.cubeWorkspace.getMetadata().getName();
        String partitionKey = BackupConstant.INSTANCE.getPartitionKey(this.cubeWorkspace);
        String[] stringArray2 = new String[]{cubeName, partitionKey, this.measure.getName()};
        String path = ((Object)Paths.INSTANCE.get(this.rootPath, stringArray2)).toString();
        int fileCount = BackupConstant.INSTANCE.getFileCount(path, "index", "yxw");
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)fileCount);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            it = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            stringArray = new String[]{this.measure.getName(), "index" + (it != 0 ? String.valueOf(it) : "") + ".yxw"};
            FileBackup measureIndex = new FileBackup(cubeName, this.rootPath, ((Object)Paths.INSTANCE.get(partitionKey, stringArray)).toString(), BackupFileType.OtherFile);
            this.registerProxy((IBackupItem)measureIndex);
            this._indexFiles.add(measureIndex);
        }
        $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)fileCount);
        $i$f$forEach = false;
        iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            it = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            stringArray = new String[]{this.measure.getName(), "heap" + (it != 0 ? String.valueOf(it) : "") + ".yxw"};
            FileBackup measureHeap = new FileBackup(cubeName, this.rootPath, ((Object)Paths.INSTANCE.get(partitionKey, stringArray)).toString(), BackupFileType.OtherFile);
            this.registerProxy((IBackupItem)measureHeap);
        }
        super.init(parallelTasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void check(@NotNull SelectorContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int indexRowCount = 0;
        Iterable $this$forEach$iv = this._indexFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FileBackup it = (FileBackup)element$iv;
            boolean bl = false;
            String tempFile = it.getTempFilePath();
            if (tempFile == null) continue;
            BackupConstant backupConstant = BackupConstant.INSTANCE;
            AbstractMetadata $this$use$iv = new ListMetadata(tempFile, null, true, 2, null);
            boolean $i$f$use = false;
            Throwable exception$iv = null;
            try {
                ListMetadata it2 = (ListMetadata)$this$use$iv;
                boolean bl2 = false;
                indexRowCount += it2.getCount();
                it2 = Unit.INSTANCE;
            }
            catch (Throwable e$iv) {
                try {
                    exception$iv = e$iv;
                    throw e$iv;
                }
                catch (Throwable throwable) {
                    if (exception$iv == null) {
                        $this$use$iv.close();
                    } else {
                        try {
                            $this$use$iv.close();
                        }
                        catch (Throwable throwable2) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
            $this$use$iv.close();
        }
        context.checkRowCount(indexRowCount, Intrinsics.stringPlus((String)this.measure.getName(), (Object)"/index.yxw"));
    }
}

