/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.backup;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kd.bos.olapServer.backup.BackupConstant;
import kd.bos.olapServer.backup.RecoveryContext;
import kd.bos.olapServer.common.CommonTypesKt;
import kd.bos.olapServer.common.OlapContext;
import kd.bos.olapServer.storages.AbstractCubeWorkspace;
import kd.bos.olapServer.storages.CubeWorkspace;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0012\u0010\u0018\u001a\u00020\u00142\n\u0010\u0019\u001a\u00060\u0003j\u0002`\u0004J\f\u0010\u001a\u001a\u00060\u001bj\u0002`\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J\u0014\u0010\u001f\u001a\u00020\u00172\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00170!J\u0006\u0010\"\u001a\u00020\u0017R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R*\u0010\u0012\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00140\u0013j\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0014`\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lkd/bos/olapServer/backup/RecoveryContext;", "Ljava/io/Closeable;", "cubePath", "", "Lkd/bos/olapServer/common/string;", "(Ljava/lang/String;)V", "_cubeWorkspace", "Lkd/bos/olapServer/storages/CubeWorkspace;", "_executor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "_isClosed", "", "_tasks", "", "Ljava/util/concurrent/Future;", "getCubePath", "()Ljava/lang/String;", "realWorkspaceMap", "Ljava/util/HashMap;", "Lkd/bos/olapServer/storages/AbstractCubeWorkspace;", "Lkotlin/collections/HashMap;", "close", "", "getRealWorkspace", "partitionName", "getThreadSize", "", "Lkd/bos/olapServer/common/int;", "initRealWorkspaceMap", "workspace", "subTask", "task", "Lkotlin/Function0;", "waitTasks", "bos-olap-core"})
public final class RecoveryContext
implements Closeable {
    @NotNull
    private final String cubePath;
    @NotNull
    private final HashMap<String, AbstractCubeWorkspace> realWorkspaceMap;
    @Nullable
    private CubeWorkspace _cubeWorkspace;
    @NotNull
    private final List<Future<?>> _tasks;
    private final ExecutorService _executor;
    private boolean _isClosed;

    public RecoveryContext(@NotNull String cubePath) {
        Intrinsics.checkNotNullParameter((Object)cubePath, (String)"cubePath");
        this.cubePath = cubePath;
        this.realWorkspaceMap = new HashMap();
        boolean bl = false;
        this._tasks = new ArrayList();
        this._executor = Executors.newFixedThreadPool(this.getThreadSize());
    }

    @NotNull
    public final String getCubePath() {
        return this.cubePath;
    }

    private final void initRealWorkspaceMap(CubeWorkspace workspace) {
        Iterator<AbstractCubeWorkspace> iterator = workspace.getSubWorkspaces();
        boolean bl = false;
        Iterator<AbstractCubeWorkspace> iterator2 = iterator;
        while (iterator2.hasNext()) {
            AbstractCubeWorkspace realWorkspace = iterator2.next();
            Map map = this.realWorkspaceMap;
            String string = BackupConstant.INSTANCE.getPartitionKey(realWorkspace);
            boolean bl2 = false;
            map.put(string, realWorkspace);
        }
    }

    @NotNull
    public final AbstractCubeWorkspace getRealWorkspace(@NotNull String partitionName) {
        Intrinsics.checkNotNullParameter((Object)partitionName, (String)"partitionName");
        Object object = this._cubeWorkspace;
        if (object == null) {
            CubeWorkspace cubeWorkspace = new CubeWorkspace(this.cubePath, 0, 2, null);
            boolean bl = false;
            boolean bl2 = false;
            CubeWorkspace it = cubeWorkspace;
            boolean bl3 = false;
            this._cubeWorkspace = it;
            this.initRealWorkspaceMap(it);
        }
        AbstractCubeWorkspace abstractCubeWorkspace = this.realWorkspaceMap.get(partitionName);
        Intrinsics.checkNotNull((Object)abstractCubeWorkspace);
        object = abstractCubeWorkspace;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"realWorkspaceMap[partitionName]!!");
        return (AbstractCubeWorkspace)object;
    }

    private final int getThreadSize() {
        int n;
        int partitionSize = this.realWorkspaceMap.size();
        if (partitionSize > 0) {
            int n2 = CommonTypesKt.getAvailableProcessors();
            boolean bl = false;
            n = Math.min(partitionSize, n2);
        } else {
            int n3 = CommonTypesKt.getAvailableProcessors();
            int n4 = 8;
            boolean bl = false;
            n = Math.min(n3, n4);
        }
        return n;
    }

    public final void subTask(@NotNull Function0<Unit> task) {
        Intrinsics.checkNotNullParameter(task, (String)"task");
        OlapContext mainOlapContext = OlapContext.Companion.getCurrentContext$bos_olap_core();
        Future<?> future = this._executor.submit(() -> RecoveryContext.subTask$lambda-1(mainOlapContext, task));
        Intrinsics.checkNotNullExpressionValue(future, (String)"_executor.submit {\n            OlapContext.newContext(mainOlapContext, {\n                task()\n            }, catchAction = { ex ->\n                //\u6709\u65f6\u5019\u662f\u5f53\u524d\u7ebf\u7a0b\u51fa\u73b0\u5f02\u5e38\uff0c\u6709\u65f6\u5019\u662f\u54cd\u5e94\u4e86 cancel \u5904\u7406\u3002\n                OlapContext.tryGetContext(ICancellable::class.java)?.cancel(ex)\n                //\u4e0d\u4f1a\u518d\u6b21\u629b\u51fa\u5f02\u5e38\uff0c\u56e0\u4e3a\u5df2\u7ecf\u6807\u8bb0\u4e86\u5f02\u5e38\u3002\n            })\n        }");
        this._tasks.add(future);
    }

    public final void waitTasks() {
        Iterable $this$forEach$iv = this._tasks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Future it = (Future)element$iv;
            boolean bl = false;
            it.get();
        }
    }

    @Override
    public void close() {
        if (!this._isClosed) {
            this._executor.shutdown();
            this._executor.awaitTermination(5L, TimeUnit.SECONDS);
            CubeWorkspace cubeWorkspace = this._cubeWorkspace;
            if (cubeWorkspace != null) {
                cubeWorkspace.close();
            }
            this._isClosed = true;
        }
    }

    private static final void subTask$lambda-1(OlapContext $mainOlapContext, Function0 $task) {
        Intrinsics.checkNotNullParameter((Object)$task, (String)"$task");
        OlapContext.Companion.newContext($mainOlapContext, (Function0)new Function0<Unit>((Function0<Unit>)$task){
            final /* synthetic */ Function0<Unit> $task;
            {
                this.$task = $task;
                super(0);
            }

            public final void invoke() {
                this.$task.invoke();
            }
        }, subTask.1.2.INSTANCE);
    }
}

