/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.backup;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Iterator;
import kd.bos.olapServer.backup.CubeRecovery;
import kd.bos.olapServer.backup.sequenceLog.FaultToleranceCustomer;
import kd.bos.olapServer.backup.sequenceLog.ISeqLogReader;
import kd.bos.olapServer.backup.sequenceLog.SeqLogDirectoryEntry;
import kd.bos.olapServer.backup.sequenceLog.SeqLogSetting;
import kd.bos.olapServer.computingEngine.ComputingCommandExecutor;
import kd.bos.olapServer.dataSources.CommandInfo;
import kd.bos.olapServer.dataSources.ComputingCommandInfo;
import kd.bos.olapServer.dataSources.MetadataCommandInfo;
import kd.bos.olapServer.dataSources.SaveCommandInfo;
import kd.bos.olapServer.metadata.MetadataCommandExecutor;
import kd.bos.olapServer.storages.CubeWorkspace;
import kd.bos.olapServer.storages.OlapWorkspace;
import kd.bos.olapServer.storages.SaveCommandExecutor;
import kd.bos.olapServer.tools.JsonHelper;
import kd.bos.olapServer.tools.Res;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0002\u001d\u001eBe\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\n\u0010\u0007\u001a\u00060\u0005j\u0002`\u0006\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\u0010\n\u001a\u00060\u0005j\u0002`\u0006\u0012\f\b\u0002\u0010\u000b\u001a\u00060\u0005j\u0002`\u0006\u0012\f\b\u0002\u0010\f\u001a\u00060\u0005j\u0002`\u0006\u0012\f\b\u0002\u0010\r\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\u0002\u0010\u000eJ2\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u000e\u0010\u0015\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006H\u0002J\u0006\u0010\u0016\u001a\u00020\u0010J(\u0010\u0017\u001a\u00020\u00102\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u00062\u0006\u0010\u0018\u001a\u00020\u00192\n\u0010\u001a\u001a\u00060\u001bj\u0002`\u001cH\u0002R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lkd/bos/olapServer/backup/RecoveryMixTransactionLog;", "", "olapWorkspace", "Lkd/bos/olapServer/storages/OlapWorkspace;", "cubeName", "", "Lkd/bos/olapServer/common/string;", "rootPath", "inputStream", "Ljava/io/InputStream;", "logRootPath", "logPrefix", "logSuffix", "logZSuffix", "(Lkd/bos/olapServer/storages/OlapWorkspace;Ljava/lang/String;Ljava/lang/String;Ljava/io/InputStream;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "executeCmd", "", "cubeWorkspace", "Lkd/bos/olapServer/storages/CubeWorkspace;", "command", "Lkd/bos/olapServer/dataSources/CommandInfo;", "value", "rebuildCube", "rebuildCubeByLog", "transactionItr", "Lkd/bos/olapServer/backup/RecoveryMixTransactionLog$CommandIterator;", "startVersion", "", "Lkd/bos/olapServer/common/long;", "CommandElem", "CommandIterator", "bos-olap-core"})
public final class RecoveryMixTransactionLog {
    @NotNull
    private final OlapWorkspace olapWorkspace;
    @NotNull
    private final String cubeName;
    @NotNull
    private final String rootPath;
    @Nullable
    private final InputStream inputStream;
    @NotNull
    private final String logRootPath;
    @NotNull
    private final String logPrefix;
    @NotNull
    private final String logSuffix;
    @NotNull
    private final String logZSuffix;

    public RecoveryMixTransactionLog(@NotNull OlapWorkspace olapWorkspace, @NotNull String cubeName, @NotNull String rootPath, @Nullable InputStream inputStream, @NotNull String logRootPath, @NotNull String logPrefix, @NotNull String logSuffix, @NotNull String logZSuffix) {
        Intrinsics.checkNotNullParameter((Object)olapWorkspace, (String)"olapWorkspace");
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
        Intrinsics.checkNotNullParameter((Object)logRootPath, (String)"logRootPath");
        Intrinsics.checkNotNullParameter((Object)logPrefix, (String)"logPrefix");
        Intrinsics.checkNotNullParameter((Object)logSuffix, (String)"logSuffix");
        Intrinsics.checkNotNullParameter((Object)logZSuffix, (String)"logZSuffix");
        this.olapWorkspace = olapWorkspace;
        this.cubeName = cubeName;
        this.rootPath = rootPath;
        this.inputStream = inputStream;
        this.logRootPath = logRootPath;
        this.logPrefix = logPrefix;
        this.logSuffix = logSuffix;
        this.logZSuffix = logZSuffix;
    }

    public /* synthetic */ RecoveryMixTransactionLog(OlapWorkspace olapWorkspace, String string, String string2, InputStream inputStream, String string3, String string4, String string5, String string6, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            string4 = "commands";
        }
        if ((n & 0x40) != 0) {
            string5 = ".log";
        }
        if ((n & 0x80) != 0) {
            string6 = ".logz";
        }
        this(olapWorkspace, string, string2, inputStream, string3, string4, string5, string6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void rebuildCube() {
        if (this.olapWorkspace.tryGet(this.cubeName) != null) {
            throw new RuntimeException(Intrinsics.stringPlus((String)"\u5df2\u5b58\u5728\u6570\u636e\u5e93", (Object)this.cubeName));
        }
        long startVersion = 0L;
        if (this.inputStream != null) {
            new CubeRecovery(this.olapWorkspace, this.cubeName, this.rootPath, new DataInputStream(this.inputStream)).recovery();
            CubeWorkspace cubeWorkspace = this.olapWorkspace.getCubeWorkspace(this.cubeName);
            startVersion = cubeWorkspace.getTransactionManager().getLastCommittedTransactionId() + 1L;
            if (startVersion < 1L) {
                Object[] objectArray = Res.INSTANCE.getRecoveryMixTransactionLogException_4();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.RecoveryMixTransactionLogException_4");
                Object[] objectArray2 = objectArray;
                objectArray = new Object[]{startVersion};
                throw Res.INSTANCE.getRuntimeException((String)objectArray2, objectArray);
            }
        } else {
            startVersion = 1L;
        }
        Closeable closeable = new SeqLogDirectoryEntry(new SeqLogSetting(this.logRootPath, this.logPrefix), this.logSuffix, this.logZSuffix).read(startVersion);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            ISeqLogReader reader = (ISeqLogReader)closeable;
            boolean bl3 = false;
            this.rebuildCubeByLog(this.cubeName, new CommandIterator(reader), startVersion);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final void rebuildCubeByLog(String cubeName, CommandIterator transactionItr, long startVersion) {
        FaultToleranceCustomer<CommandElem> customer2 = new FaultToleranceCustomer<CommandElem>(10, startVersion, (Function2)new Function2<Long, CommandElem, Unit>(this, cubeName){
            final /* synthetic */ RecoveryMixTransactionLog this$0;
            final /* synthetic */ String $cubeName;
            {
                this.this$0 = $receiver;
                this.$cubeName = $cubeName;
                super(2);
            }

            public final void invoke(long $noName_0, @NotNull CommandElem ele) {
                Intrinsics.checkNotNullParameter((Object)ele, (String)"ele");
                CubeWorkspace cubeWorkspace = RecoveryMixTransactionLog.access$getOlapWorkspace$p(this.this$0).tryGet(this.$cubeName);
                RecoveryMixTransactionLog.access$executeCmd(this.this$0, RecoveryMixTransactionLog.access$getOlapWorkspace$p(this.this$0), cubeWorkspace, ele.getCommand(), ele.getSaveData());
            }
        });
        while (transactionItr.hasNext()) {
            CommandElem elem = transactionItr.next();
            customer2.deal(elem.getId(), elem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void executeCmd(OlapWorkspace olapWorkspace, CubeWorkspace cubeWorkspace, CommandInfo command, String value2) {
        CommandInfo commandInfo = command;
        if (commandInfo instanceof MetadataCommandInfo) {
            new MetadataCommandExecutor((MetadataCommandInfo)command, olapWorkspace, cubeWorkspace).run();
        } else if (commandInfo instanceof ComputingCommandInfo) {
            ComputingCommandInfo computingCommandInfo = (ComputingCommandInfo)command;
            CubeWorkspace cubeWorkspace2 = cubeWorkspace;
            Intrinsics.checkNotNull((Object)cubeWorkspace2);
            new ComputingCommandExecutor(computingCommandInfo, olapWorkspace, cubeWorkspace2).run();
        } else if (commandInfo instanceof SaveCommandInfo) {
            if (value2 == null) {
                String string = Res.INSTANCE.getRecoveryMixTransactionLogException_1();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Res.RecoveryMixTransactionLogException_1");
                throw Res.INSTANCE.getRuntimeException(string, new Object[0]);
            }
            Closeable closeable = new BufferedReader(new StringReader(value2));
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                BufferedReader it = (BufferedReader)closeable;
                boolean bl3 = false;
                CubeWorkspace cubeWorkspace3 = cubeWorkspace;
                Intrinsics.checkNotNull((Object)cubeWorkspace3);
                new SaveCommandExecutor(cubeWorkspace3, (SaveCommandInfo)command, it).write();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        } else {
            Object[] objectArray = Res.INSTANCE.getRecoveryMixTransactionLogException_2();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.RecoveryMixTransactionLogException_2");
            Object[] objectArray2 = objectArray;
            objectArray = new Object[]{command};
            throw Res.INSTANCE.getRuntimeException((String)objectArray2, objectArray);
        }
    }

    public static final /* synthetic */ OlapWorkspace access$getOlapWorkspace$p(RecoveryMixTransactionLog $this) {
        return $this.olapWorkspace;
    }

    public static final /* synthetic */ void access$executeCmd(RecoveryMixTransactionLog $this, OlapWorkspace olapWorkspace, CubeWorkspace cubeWorkspace, CommandInfo command, String value2) {
        $this.executeCmd(olapWorkspace, cubeWorkspace, command, value2);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B)\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\u0010\u0007\u001a\n\u0018\u00010\bj\u0004\u0018\u0001`\t\u00a2\u0006\u0002\u0010\nJ\r\u0010\u0011\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0006H\u00c6\u0003J\u0011\u0010\u0013\u001a\n\u0018\u00010\bj\u0004\u0018\u0001`\tH\u00c6\u0003J3\u0010\u0014\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u00060\u0003j\u0002`\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u0010\b\u0002\u0010\u0007\u001a\n\u0018\u00010\bj\u0004\u0018\u0001`\tH\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\bH\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0019\u0010\u0007\u001a\n\u0018\u00010\bj\u0004\u0018\u0001`\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lkd/bos/olapServer/backup/RecoveryMixTransactionLog$CommandElem;", "", "id", "", "Lkd/bos/olapServer/common/long;", "command", "Lkd/bos/olapServer/dataSources/CommandInfo;", "saveData", "", "Lkd/bos/olapServer/common/string;", "(JLkd/bos/olapServer/dataSources/CommandInfo;Ljava/lang/String;)V", "getCommand", "()Lkd/bos/olapServer/dataSources/CommandInfo;", "getId", "()J", "getSaveData", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "bos-olap-core"})
    private static final class CommandElem {
        private final long id;
        @NotNull
        private final CommandInfo command;
        @Nullable
        private final String saveData;

        public CommandElem(long id, @NotNull CommandInfo command, @Nullable String saveData) {
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            this.id = id;
            this.command = command;
            this.saveData = saveData;
        }

        public final long getId() {
            return this.id;
        }

        @NotNull
        public final CommandInfo getCommand() {
            return this.command;
        }

        @Nullable
        public final String getSaveData() {
            return this.saveData;
        }

        public final long component1() {
            return this.id;
        }

        @NotNull
        public final CommandInfo component2() {
            return this.command;
        }

        @Nullable
        public final String component3() {
            return this.saveData;
        }

        @NotNull
        public final CommandElem copy(long id, @NotNull CommandInfo command, @Nullable String saveData) {
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            return new CommandElem(id, command, saveData);
        }

        public static /* synthetic */ CommandElem copy$default(CommandElem commandElem, long l, CommandInfo commandInfo, String string, int n, Object object) {
            if ((n & 1) != 0) {
                l = commandElem.id;
            }
            if ((n & 2) != 0) {
                commandInfo = commandElem.command;
            }
            if ((n & 4) != 0) {
                string = commandElem.saveData;
            }
            return commandElem.copy(l, commandInfo, string);
        }

        @NotNull
        public String toString() {
            return "CommandElem(id=" + this.id + ", command=" + this.command + ", saveData=" + this.saveData + ')';
        }

        public int hashCode() {
            int result = Long.hashCode(this.id);
            result = result * 31 + this.command.hashCode();
            result = result * 31 + (this.saveData == null ? 0 : this.saveData.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CommandElem)) {
                return false;
            }
            CommandElem commandElem = (CommandElem)other;
            if (this.id != commandElem.id) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.command, (Object)commandElem.command)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.saveData, (Object)commandElem.saveData);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0010\u0010\u0003\u001a\f\u0012\b\u0012\u00060\u0004j\u0002`\u00050\u0001\u00a2\u0006\u0002\u0010\u0006J\r\u0010\n\u001a\u00060\u000bj\u0002`\fH\u0096\u0002J\t\u0010\r\u001a\u00020\u0002H\u0096\u0002J\f\u0010\u000e\u001a\u00060\u0004j\u0002`\u0005H\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0003\u001a\f\u0012\b\u0012\u00060\u0004j\u0002`\u00050\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"Lkd/bos/olapServer/backup/RecoveryMixTransactionLog$CommandIterator;", "", "Lkd/bos/olapServer/backup/RecoveryMixTransactionLog$CommandElem;", "inputStream", "", "Lkd/bos/olapServer/common/string;", "(Ljava/util/Iterator;)V", "elem", "getInputStream", "()Ljava/util/Iterator;", "hasNext", "", "Lkd/bos/olapServer/common/bool;", "next", "readSaveValue", "bos-olap-core"})
    private static final class CommandIterator
    implements Iterator<CommandElem>,
    KMappedMarker {
        @NotNull
        private final Iterator<String> inputStream;
        @Nullable
        private CommandElem elem;

        public CommandIterator(@NotNull Iterator<String> inputStream) {
            Intrinsics.checkNotNullParameter(inputStream, (String)"inputStream");
            this.inputStream = inputStream;
        }

        @NotNull
        public final Iterator<String> getInputStream() {
            return this.inputStream;
        }

        @Override
        public boolean hasNext() {
            while (this.inputStream.hasNext()) {
                String line = this.inputStream.next();
                CharSequence charSequence = line;
                boolean bl = false;
                if (!(!StringsKt.isBlank((CharSequence)charSequence))) continue;
                try {
                    Pair<Long, String> temp = SeqLogSetting.Companion.parseLogLine(line);
                    long commandId = ((Number)temp.getFirst()).longValue();
                    CommandInfo command = (CommandInfo)JsonHelper.INSTANCE.getMapper().readValue((String)temp.getSecond(), CommandInfo.class);
                    Intrinsics.checkNotNullExpressionValue((Object)command, (String)"command");
                    this.elem = new CommandElem(commandId, command, command instanceof SaveCommandInfo ? this.readSaveValue() : null);
                    return true;
                }
                catch (RuntimeException e) {
                    Object[] objectArray = Res.INSTANCE.getRecoveryMixTransactionLogException_3();
                    Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.RecoveryMixTransactionLogException_3");
                    Object[] objectArray2 = objectArray;
                    objectArray = new Object[]{e.getMessage() + ':' + line};
                    throw Res.INSTANCE.getRuntimeException((String)objectArray2, e, objectArray);
                }
            }
            return false;
        }

        @Override
        @NotNull
        public CommandElem next() {
            CommandElem commandElem = this.elem;
            if (commandElem == null) {
                String string = Res.INSTANCE.getCommonException_9();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Res.CommonException_9");
                throw Res.INSTANCE.getRuntimeException(string, new Object[0]);
            }
            return commandElem;
        }

        private final String readSaveValue() {
            String line;
            StringBuilder dataValues = new StringBuilder();
            while (this.inputStream.hasNext() && !StringsKt.isBlank((CharSequence)(line = this.inputStream.next()))) {
                StringBuilder stringBuilder = dataValues;
                boolean bl = false;
                StringBuilder stringBuilder2 = stringBuilder.append(line);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder2);
            }
            String string = dataValues.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dataValues.toString()");
            return string;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }
}

