/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.backup.bigFile;

import java.io.Closeable;
import java.io.InputStream;
import kd.bos.olapServer.common.CommonTypesKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\f\u0010\u0013\u001a\u00060\bj\u0002`\u0014H\u0002J\n\u0010\u0015\u001a\u00060\bj\u0002`\u0014J\f\u0010\u0016\u001a\u00060\bj\u0002`\u0014H\u0002J\f\u0010\u0017\u001a\u00060\bj\u0002`\u0014H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lkd/bos/olapServer/backup/bigFile/RunLengthIntListReader;", "Ljava/io/Closeable;", "stream", "Ljava/io/InputStream;", "(Ljava/io/InputStream;)V", "byteArray", "", "byteArrayIndex", "", "count", "", "isDisperse", "", "loadCount", "getStream", "()Ljava/io/InputStream;", "value", "close", "", "loadByteArray", "Lkd/bos/olapServer/common/int;", "read", "read7BitInt", "readCore", "bos-olap-core"})
public final class RunLengthIntListReader
implements Closeable {
    @NotNull
    private final InputStream stream;
    private long count;
    private int value;
    private boolean isDisperse;
    @NotNull
    private final byte[] byteArray;
    private int loadCount;
    private int byteArrayIndex;

    public RunLengthIntListReader(@NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        this.stream = stream;
        this.value = -1;
        this.byteArray = new byte[1024];
        this.loadCount = this.byteArray.length;
        this.byteArrayIndex = this.byteArray.length;
    }

    @NotNull
    public final InputStream getStream() {
        return this.stream;
    }

    private final int loadByteArray() {
        if (this.byteArrayIndex >= this.loadCount) {
            this.loadCount = this.stream.read(this.byteArray);
            if (this.loadCount == -1) {
                return -1;
            }
            this.byteArrayIndex = 0;
        }
        RunLengthIntListReader runLengthIntListReader = this;
        int n = runLengthIntListReader.byteArrayIndex;
        runLengthIntListReader.byteArrayIndex = n + 1;
        return n;
    }

    private final int read7BitInt() {
        int result = 0;
        int shift = 0;
        int value2 = 0;
        do {
            boolean bl = shift < 35;
            boolean bl2 = false;
            boolean bl3 = false;
            bl3 = false;
            boolean bl4 = false;
            if (!bl) {
                boolean bl5 = false;
                String string = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            value2 = CommonTypesKt.toIntNoNegative(this.byteArray[this.loadByteArray()]);
            result |= (value2 & 0x7F) << shift;
            shift += 7;
        } while ((value2 & 0x80) != 0);
        return result;
    }

    public final int read() {
        int n;
        if (this.value == -1) {
            return this.readCore();
        }
        if (this.isDisperse) {
            if (this.count > 0L) {
                RunLengthIntListReader runLengthIntListReader = this;
                long l = runLengthIntListReader.count;
                runLengthIntListReader.count = l + -1L;
                n = this.read7BitInt();
            } else {
                n = this.readCore();
            }
        } else if (this.count > 0L) {
            RunLengthIntListReader runLengthIntListReader = this;
            long l = runLengthIntListReader.count;
            runLengthIntListReader.count = l + -1L;
            n = this.value;
        } else {
            n = this.readCore();
        }
        return n;
    }

    private final int readCore() {
        int start = this.loadByteArray();
        if (start == -1) {
            return -1;
        }
        byte byteCount = this.byteArray[start];
        if ((byteCount & 0x80) == 128) {
            this.isDisperse = false;
            this.count = byteCount & 0x3F;
            if ((byteCount & 0x40) == 64) {
                byteCount = this.byteArray[this.loadByteArray()];
                int left = 6;
                while ((byteCount & 0x80) == 128) {
                    this.count |= (long)(byteCount & 0x7F) << left;
                    left += 7;
                    byteCount = this.byteArray[this.loadByteArray()];
                }
                this.count |= (long)(byteCount & 0x7F) << left;
            }
            RunLengthIntListReader runLengthIntListReader = this;
            long l = runLengthIntListReader.count;
            runLengthIntListReader.count = l + -1L;
            this.value = this.read7BitInt();
            return this.value;
        }
        this.isDisperse = true;
        this.count = (long)byteCount - 1L;
        this.value = this.read7BitInt();
        return this.value;
    }

    @Override
    public void close() {
        this.stream.close();
    }
}

