/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.backup.sequenceLog;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import kd.bos.olapServer.collections.LockFreeQueue;
import kd.bos.olapServer.tools.RecycledByteArrayOutputStream;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u000f2\u00020\u0001:\u0002\u000f\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\b\u001a\u00020\tH\u0016J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ\b\u0010\r\u001a\u0004\u0018\u00010\u0006J\b\u0010\u000e\u001a\u0004\u0018\u00010\u0003R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lkd/bos/olapServer/backup/sequenceLog/BigStreamCache;", "Ljava/io/Closeable;", "tempPath", "Ljava/io/File;", "(Ljava/io/File;)V", "_inMemoryByteBuffer", "Ljava/nio/ByteBuffer;", "_tempFile", "close", "", "copy", "Ljava/io/InputStream;", "inputStream", "tryGetInMemoryByteBuffer", "tryGetTempFile", "Companion", "InMemoryCache", "bos-olap-core"})
public final class BigStreamCache
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File tempPath;
    @Nullable
    private File _tempFile;
    @Nullable
    private ByteBuffer _inMemoryByteBuffer;
    @NotNull
    private static final ThreadLocal<byte[]> byteBufferCache = new ThreadLocal();
    private static final int MaxReleaseByteBufferSize = 16384;
    private static final int InitByteBufferSize = 1024;
    @NotNull
    private static final LockFreeQueue<byte[]> bigByteBufferCache = new LockFreeQueue(4, true);
    private static final int BigByteBufferSize = 0x800000;

    public BigStreamCache(@NotNull File tempPath) {
        Intrinsics.checkNotNullParameter((Object)tempPath, (String)"tempPath");
        this.tempPath = tempPath;
    }

    @Nullable
    public final ByteBuffer tryGetInMemoryByteBuffer() {
        return this._inMemoryByteBuffer;
    }

    @Nullable
    public final File tryGetTempFile() {
        return this._tempFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final InputStream copy(@NotNull InputStream inputStream) {
        File tempFile;
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        InMemoryCache smallCache = new InMemoryCache(Companion.getOrCreateByteBuffer());
        this._inMemoryByteBuffer = smallCache.write(inputStream);
        if (this._inMemoryByteBuffer != null) {
            return smallCache.createStream();
        }
        InMemoryCache bigCache = new InMemoryCache(Companion.getOrCreateBigByteBuffer());
        bigCache.getInMemoryStream().write(smallCache.getByteArray());
        Companion.release(smallCache.getByteBuffer());
        this._inMemoryByteBuffer = bigCache.write(inputStream);
        if (this._inMemoryByteBuffer != null) {
            return bigCache.createStream();
        }
        this._tempFile = tempFile = File.createTempFile("KDMDD", "Cache", this.tempPath);
        Intrinsics.checkNotNullExpressionValue((Object)tempFile, (String)"tempFile");
        Object object = tempFile;
        boolean bl = false;
        object = new FileOutputStream((File)object);
        bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            FileOutputStream tempStream = (FileOutputStream)object;
            boolean bl3 = false;
            tempStream.write(bigCache.getByteArray());
            Companion.release(bigCache.getByteBuffer());
            this._inMemoryByteBuffer = null;
            long l = ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)tempStream, (int)0, (int)2, null);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        object = tempFile;
        bl = false;
        return new FileInputStream((File)object);
    }

    @Override
    public void close() {
        Comparable<ByteBuffer> comparable = this._inMemoryByteBuffer;
        if (comparable != null) {
            ByteBuffer byteBuffer = comparable;
            boolean bl = false;
            boolean bl2 = false;
            ByteBuffer it = byteBuffer;
            boolean bl3 = false;
            Companion.release(it);
        }
        comparable = this._tempFile;
        if (comparable != null) {
            ((File)comparable).delete();
        }
        this._inMemoryByteBuffer = null;
        this._tempFile = null;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0012\u001a\u00020\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lkd/bos/olapServer/backup/sequenceLog/BigStreamCache$InMemoryCache;", "", "byteBuffer", "Ljava/nio/ByteBuffer;", "(Ljava/nio/ByteBuffer;)V", "byteArray", "", "getByteArray", "()[B", "getByteBuffer", "()Ljava/nio/ByteBuffer;", "inMemoryStream", "Lkd/bos/olapServer/tools/RecycledByteArrayOutputStream;", "getInMemoryStream", "()Lkd/bos/olapServer/tools/RecycledByteArrayOutputStream;", "createStream", "Ljava/io/InputStream;", "write", "inputStream", "bos-olap-core"})
    private static final class InMemoryCache {
        @NotNull
        private final ByteBuffer byteBuffer;
        @NotNull
        private final byte[] byteArray;
        @NotNull
        private final RecycledByteArrayOutputStream inMemoryStream;

        public InMemoryCache(@NotNull ByteBuffer byteBuffer) {
            Intrinsics.checkNotNullParameter((Object)byteBuffer, (String)"byteBuffer");
            this.byteBuffer = byteBuffer;
            byte[] byArray = this.byteBuffer.array();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"byteBuffer.array()");
            this.byteArray = byArray;
            this.inMemoryStream = new RecycledByteArrayOutputStream(this.byteArray, null);
        }

        @NotNull
        public final ByteBuffer getByteBuffer() {
            return this.byteBuffer;
        }

        @NotNull
        public final byte[] getByteArray() {
            return this.byteArray;
        }

        @NotNull
        public final RecycledByteArrayOutputStream getInMemoryStream() {
            return this.inMemoryStream;
        }

        @Nullable
        public final ByteBuffer write(@NotNull InputStream inputStream) {
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            this.inMemoryStream.writeFrom(inputStream, this.byteArray.length - this.inMemoryStream.getSize());
            int size = this.inMemoryStream.getSize();
            return size < this.byteArray.length ? ByteBuffer.wrap(this.byteArray, 0, size) : null;
        }

        @NotNull
        public final InputStream createStream() {
            return new ByteArrayInputStream(this.byteArray, 0, this.inMemoryStream.getSize());
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\rJ\u0010\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lkd/bos/olapServer/backup/sequenceLog/BigStreamCache$Companion;", "", "()V", "BigByteBufferSize", "", "InitByteBufferSize", "MaxReleaseByteBufferSize", "bigByteBufferCache", "Lkd/bos/olapServer/collections/LockFreeQueue;", "", "byteBufferCache", "Ljava/lang/ThreadLocal;", "getOrCreateBigByteBuffer", "Ljava/nio/ByteBuffer;", "getOrCreateByteBuffer", "release", "", "value", "bos-olap-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ByteBuffer getOrCreateByteBuffer() {
            byte[] cache = (byte[])byteBufferCache.get();
            if (cache == null) {
                cache = new byte[1024];
            } else {
                byteBufferCache.set(null);
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(cache);
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"wrap(cache)");
            return byteBuffer;
        }

        public final void release(@Nullable ByteBuffer value2) {
            byte[] old = (byte[])byteBufferCache.get();
            if (value2 != null) {
                value2.limit(0);
                if (value2.capacity() < 16384 && (old == null || old.length < value2.capacity())) {
                    byteBufferCache.set(value2.array());
                } else if (value2.capacity() == 0x800000) {
                    LockFreeQueue lockFreeQueue = bigByteBufferCache;
                    byte[] byArray = value2.array();
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"value.array()");
                    lockFreeQueue.push(byArray);
                }
            }
        }

        @NotNull
        public final ByteBuffer getOrCreateBigByteBuffer() {
            Object object = (byte[])bigByteBufferCache.tryPop();
            byte[] cache = object == null ? new byte[0x800000] : object;
            object = ByteBuffer.wrap(cache);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"wrap(cache)");
            return object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

