/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.backup.sequenceLog;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.olapServer.backup.sequenceLog.SeqLog7zItemEntry;
import kd.bos.olapServer.backup.sequenceLog.SeqLogContainerEntry;
import kd.bos.olapServer.backup.sequenceLog.SeqLogFileEntry;
import kd.bos.olapServer.backup.sequenceLog.SeqLogSetting;
import kd.bos.olapServer.common.Paths;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.apache.commons.compress.archivers.sevenz.SevenZOutputFile;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0016B\u0019\u0012\n\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0014\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\u0004H\u0016R\u0018\u0010\t\u001a\u00060\nj\u0002`\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0015\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\u00060\nj\u0002`\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\r\u00a8\u0006\u0017"}, d2={"Lkd/bos/olapServer/backup/sequenceLog/SeqLog7zEntry;", "Lkd/bos/olapServer/backup/sequenceLog/SeqLogContainerEntry;", "Lkd/bos/olapServer/backup/sequenceLog/SeqLog7zItemEntry;", "filename", "", "Lkd/bos/olapServer/common/string;", "setting", "Lkd/bos/olapServer/backup/sequenceLog/SeqLogSetting;", "(Ljava/lang/String;Lkd/bos/olapServer/backup/sequenceLog/SeqLogSetting;)V", "end", "", "Lkd/bos/olapServer/common/long;", "getEnd", "()J", "getFilename", "()Ljava/lang/String;", "start", "getStart", "getEntriesCore", "", "()[Lkd/bos/olapServer/backup/sequenceLog/SeqLog7zItemEntry;", "toString", "Companion", "bos-olap-core"})
public final class SeqLog7zEntry
extends SeqLogContainerEntry<SeqLog7zItemEntry> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String filename;
    private final long start;
    private final long end;

    public SeqLog7zEntry(@NotNull String filename, @NotNull SeqLogSetting setting) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Intrinsics.checkNotNullParameter((Object)setting, (String)"setting");
        super(setting);
        this.filename = filename;
        Pair<Long, Long> versions = SeqLogSetting.Companion.getStartAndEnd(this.filename, setting.getPrefix().length());
        this.start = ((Number)versions.getFirst()).longValue();
        this.end = ((Number)versions.getSecond()).longValue();
    }

    @NotNull
    public final String getFilename() {
        return this.filename;
    }

    @Override
    public long getStart() {
        return this.start;
    }

    @Override
    public long getEnd() {
        return this.end;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected SeqLog7zItemEntry[] getEntriesCore() {
        boolean bl = false;
        List result = new ArrayList();
        Object object = new String[]{this.filename};
        object = (Closeable)new SevenZFile(Paths.INSTANCE.get(this.getSetting().getRootPath(), (String)object).toFile());
        boolean bl2 = false;
        boolean bl3 = false;
        Throwable throwable = null;
        try {
            SevenZFile it = (SevenZFile)object;
            boolean bl4 = false;
            for (SevenZArchiveEntry elem : it.getEntries()) {
                Intrinsics.checkNotNullExpressionValue((Object)elem, (String)"elem");
                result.add(new SeqLog7zItemEntry(this, elem, this.getSetting()));
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        Collection $this$toTypedArray$iv = result;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        SeqLog7zItemEntry[] seqLog7zItemEntryArray = thisCollection$iv.toArray(new SeqLog7zItemEntry[0]);
        if (seqLog7zItemEntryArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return seqLog7zItemEntryArray;
    }

    @NotNull
    public String toString() {
        return "" + '[' + this.getStart() + ',' + this.getEnd() + ']' + this.filename;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\n\u0010\b\u001a\u00060\tj\u0002`\n2\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lkd/bos/olapServer/backup/sequenceLog/SeqLog7zEntry$Companion;", "", "()V", "create7zFile", "Lkd/bos/olapServer/backup/sequenceLog/SeqLog7zEntry;", "source", "", "Lkd/bos/olapServer/backup/sequenceLog/SeqLogFileEntry;", "target", "", "Lkd/bos/olapServer/common/string;", "setting", "Lkd/bos/olapServer/backup/sequenceLog/SeqLogSetting;", "([Lkd/bos/olapServer/backup/sequenceLog/SeqLogFileEntry;Ljava/lang/String;Lkd/bos/olapServer/backup/sequenceLog/SeqLogSetting;)Lkd/bos/olapServer/backup/sequenceLog/SeqLog7zEntry;", "bos-olap-core"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final SeqLog7zEntry create7zFile(@NotNull SeqLogFileEntry[] source2, @NotNull String target, @NotNull SeqLogSetting setting) {
            Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            Intrinsics.checkNotNullParameter((Object)setting, (String)"setting");
            String rootPath = setting.getRootPath();
            File tmpFile = null;
            String[] stringArray = new String[]{Intrinsics.stringPlus((String)target, (Object)".tmp")};
            tmpFile = Paths.INSTANCE.get(rootPath, stringArray).toFile();
            try {
                if (tmpFile.exists()) {
                    tmpFile.delete();
                }
                stringArray = (Closeable)new SevenZOutputFile(tmpFile);
                boolean bl = false;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    SevenZOutputFile sevenZOutput = (SevenZOutputFile)stringArray;
                    boolean bl3 = false;
                    byte[] byteArrayCache = new byte[16384];
                    SeqLogFileEntry[] seqLogFileEntryArray = source2;
                    int n = 0;
                    int n2 = seqLogFileEntryArray.length;
                    while (n < n2) {
                        SeqLogFileEntry elem = seqLogFileEntryArray[n];
                        ++n;
                        SevenZArchiveEntry entry = new SevenZArchiveEntry();
                        File file = new File(elem.getPath());
                        entry.setName(file.getName());
                        sevenZOutput.putArchiveEntry((ArchiveEntry)entry);
                        Closeable closeable = new BufferedInputStream(new FileInputStream(file));
                        boolean bl4 = false;
                        boolean bl5 = false;
                        Throwable throwable2 = null;
                        try {
                            BufferedInputStream sourceReader = (BufferedInputStream)closeable;
                            boolean bl6 = false;
                            int length = sourceReader.read(byteArrayCache);
                            while (length >= 0) {
                                sevenZOutput.write(byteArrayCache, 0, length);
                                length = sourceReader.read(byteArrayCache);
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                        }
                        sevenZOutput.closeArchiveEntry();
                    }
                    sevenZOutput.finish();
                    sevenZOutput = Unit.INSTANCE;
                }
                catch (Throwable sevenZOutput) {
                    throwable = sevenZOutput;
                    throw sevenZOutput;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)stringArray, (Throwable)throwable);
                }
                stringArray = new String[]{target};
                boolean bl7 = tmpFile.renameTo(Paths.INSTANCE.get(rootPath, stringArray).toFile());
                bl = false;
                boolean bl8 = false;
                if (!bl7) {
                    boolean bl9 = false;
                    String[] stringArray2 = new String[]{target};
                    String string = tmpFile + " rename to " + Paths.INSTANCE.get(rootPath, stringArray2) + " failed.";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                tmpFile = null;
                SeqLog7zEntry seqLog7zEntry = new SeqLog7zEntry(target, setting);
                File file = tmpFile;
                return seqLog7zEntry;
            }
            catch (Throwable throwable) {
                File file = tmpFile;
                if (file != null) {
                    file.delete();
                }
                throw throwable;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

