/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.backup.sequenceLog;

import java.io.InputStream;
import kd.bos.olapServer.backup.sequenceLog.ISeqLogReader;
import kd.bos.olapServer.backup.sequenceLog.SeqLog7zEntry;
import kd.bos.olapServer.backup.sequenceLog.SeqLogEntry;
import kd.bos.olapServer.backup.sequenceLog.SeqLogFileReader;
import kd.bos.olapServer.backup.sequenceLog.SeqLogSetting;
import kd.bos.olapServer.common.Paths;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0013B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u00060\nj\u0002`\u000bH\u0016R\u0018\u0010\t\u001a\u00060\nj\u0002`\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000e\u001a\u00060\nj\u0002`\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u0014"}, d2={"Lkd/bos/olapServer/backup/sequenceLog/SeqLog7zItemEntry;", "Lkd/bos/olapServer/backup/sequenceLog/SeqLogEntry;", "parent", "Lkd/bos/olapServer/backup/sequenceLog/SeqLog7zEntry;", "entry", "Lorg/apache/commons/compress/archivers/sevenz/SevenZArchiveEntry;", "setting", "Lkd/bos/olapServer/backup/sequenceLog/SeqLogSetting;", "(Lkd/bos/olapServer/backup/sequenceLog/SeqLog7zEntry;Lorg/apache/commons/compress/archivers/sevenz/SevenZArchiveEntry;Lkd/bos/olapServer/backup/sequenceLog/SeqLogSetting;)V", "end", "", "Lkd/bos/olapServer/common/long;", "getEnd", "()J", "start", "getStart", "read", "Lkd/bos/olapServer/backup/sequenceLog/ISeqLogReader;", "version", "SevenZInputStream", "bos-olap-core"})
public final class SeqLog7zItemEntry
extends SeqLogEntry {
    @NotNull
    private final SeqLog7zEntry parent;
    @NotNull
    private final SevenZArchiveEntry entry;
    private final long start;
    private final long end;

    public SeqLog7zItemEntry(@NotNull SeqLog7zEntry parent, @NotNull SevenZArchiveEntry entry, @NotNull SeqLogSetting setting) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)setting, (String)"setting");
        super(setting);
        this.parent = parent;
        this.entry = entry;
        String string = this.entry.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"entry.name");
        Pair<Long, Long> versions = SeqLogSetting.Companion.getStartAndEnd(string, setting.getPrefix().length());
        this.start = ((Number)versions.getFirst()).longValue();
        this.end = ((Number)versions.getSecond()).longValue();
    }

    @Override
    public long getStart() {
        return this.start;
    }

    @Override
    public long getEnd() {
        return this.end;
    }

    @Override
    @NotNull
    public ISeqLogReader read(long version) {
        boolean bl = version <= this.getEnd();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "This file should not be read.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        String[] stringArray = new String[]{this.parent.getFilename()};
        SevenZFile reader = new SevenZFile(Paths.INSTANCE.get(this.getSetting().getRootPath(), stringArray).toFile());
        boolean haveFlg = false;
        SevenZArchiveEntry currentEntry = reader.getNextEntry();
        while (currentEntry != null) {
            if (Intrinsics.areEqual((Object)this.entry.getName(), (Object)currentEntry.getName())) {
                haveFlg = true;
                break;
            }
            currentEntry = reader.getNextEntry();
        }
        boolean bl5 = false;
        boolean bl6 = false;
        if (!haveFlg) {
            boolean bl7 = false;
            reader.close();
            String[] stringArray2 = new String[]{this.parent.getFilename()};
            String string = "can find " + this.entry.getName() + " in " + Paths.INSTANCE.get(this.getSetting().getRootPath(), stringArray2);
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        SeqLogFileReader seqLogFileReader = new SeqLogFileReader(new SevenZInputStream(reader));
        bl6 = false;
        boolean bl8 = false;
        SeqLogFileReader $this$read_u24lambda_u2d2 = seqLogFileReader;
        boolean bl9 = false;
        if (version > this.getStart()) {
            $this$read_u24lambda_u2d2.skip(version);
        }
        return seqLogFileReader;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lkd/bos/olapServer/backup/sequenceLog/SeqLog7zItemEntry$SevenZInputStream;", "Ljava/io/InputStream;", "file", "Lorg/apache/commons/compress/archivers/sevenz/SevenZFile;", "(Lorg/apache/commons/compress/archivers/sevenz/SevenZFile;)V", "close", "", "read", "", "b", "", "off", "len", "bos-olap-core"})
    private static final class SevenZInputStream
    extends InputStream {
        @NotNull
        private final SevenZFile file;

        public SevenZInputStream(@NotNull SevenZFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            this.file = file;
        }

        @Override
        public int read() {
            return this.file.read();
        }

        @Override
        public int read(@NotNull byte[] b, int off, int len) {
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return this.file.read(b, off, len);
        }

        @Override
        public void close() {
            this.file.close();
        }
    }
}

