/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.backup.sequenceLog;

import java.io.File;
import java.io.FileInputStream;
import kd.bos.olapServer.backup.sequenceLog.ISeqLogReader;
import kd.bos.olapServer.backup.sequenceLog.SeqLogEntry;
import kd.bos.olapServer.backup.sequenceLog.SeqLogFileReader;
import kd.bos.olapServer.backup.sequenceLog.SeqLogSetting;
import kd.bos.olapServer.common.Paths;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u00060\tj\u0002`\nH\u0016J\b\u0010\u0015\u001a\u00020\u0003H\u0016R\u0018\u0010\b\u001a\u00060\tj\u0002`\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\r\u001a\u00060\u0003j\u0002`\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\u00060\tj\u0002`\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\f\u00a8\u0006\u0016"}, d2={"Lkd/bos/olapServer/backup/sequenceLog/SeqLogFileEntry;", "Lkd/bos/olapServer/backup/sequenceLog/SeqLogEntry;", "filename", "", "Lkd/bos/olapServer/common/string;", "setting", "Lkd/bos/olapServer/backup/sequenceLog/SeqLogSetting;", "(Ljava/lang/String;Lkd/bos/olapServer/backup/sequenceLog/SeqLogSetting;)V", "end", "", "Lkd/bos/olapServer/common/long;", "getEnd", "()J", "path", "getPath", "()Ljava/lang/String;", "start", "getStart", "read", "Lkd/bos/olapServer/backup/sequenceLog/ISeqLogReader;", "version", "toString", "bos-olap-core"})
public final class SeqLogFileEntry
extends SeqLogEntry {
    @NotNull
    private final String filename;
    private final long start;
    private final long end;

    public SeqLogFileEntry(@NotNull String filename, @NotNull SeqLogSetting setting) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Intrinsics.checkNotNullParameter((Object)setting, (String)"setting");
        super(setting);
        this.filename = filename;
        Pair<Long, Long> versions = SeqLogSetting.Companion.getStartAndEnd(this.filename, setting.getPrefix().length());
        this.start = ((Number)versions.getFirst()).longValue();
        this.end = ((Number)versions.getFirst()).longValue() < ((Number)versions.getSecond()).longValue() ? ((Number)versions.getSecond()).longValue() : SeqLogSetting.Companion.getLastId(new File(this.getPath()), ((Number)versions.getSecond()).longValue());
    }

    @Override
    public long getStart() {
        return this.start;
    }

    @Override
    public long getEnd() {
        return this.end;
    }

    @NotNull
    public final String getPath() {
        String[] stringArray = new String[]{this.filename};
        return ((Object)Paths.INSTANCE.get(this.getSetting().getRootPath(), stringArray)).toString();
    }

    @Override
    @NotNull
    public ISeqLogReader read(long version) {
        boolean bl = version <= this.getEnd();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Should not read " + this.getPath() + '.';
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        SeqLogFileReader seqLogFileReader = new SeqLogFileReader(new FileInputStream(this.getPath()));
        bl2 = false;
        bl3 = false;
        SeqLogFileReader $this$read_u24lambda_u2d1 = seqLogFileReader;
        boolean bl5 = false;
        if (version > this.getStart()) {
            $this$read_u24lambda_u2d1.skip(version);
        }
        return seqLogFileReader;
    }

    @NotNull
    public String toString() {
        return "" + '[' + this.getStart() + ',' + this.getEnd() + ']' + this.filename;
    }
}

