/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.backup.sequenceLog;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import kd.bos.olapServer.backup.sequenceLog.ISeqLogReader;
import kd.bos.olapServer.backup.sequenceLog.SeqLogSetting;
import kd.bos.olapServer.tools.Res;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\n\u001a\u00020\u000bH\u0016J\t\u0010\f\u001a\u00020\rH\u0096\u0002J\r\u0010\u000e\u001a\u00060\u0006j\u0002`\u0007H\u0096\u0002J\u000e\u0010\u000f\u001a\n\u0018\u00010\u0006j\u0004\u0018\u0001`\u0007J\u0012\u0010\u0010\u001a\u00020\u000b2\n\u0010\u0011\u001a\u00060\u0012j\u0002`\u0013R\u0016\u0010\u0005\u001a\n\u0018\u00010\u0006j\u0004\u0018\u0001`\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lkd/bos/olapServer/backup/sequenceLog/SeqLogFileReader;", "Lkd/bos/olapServer/backup/sequenceLog/ISeqLogReader;", "input", "Ljava/io/InputStream;", "(Ljava/io/InputStream;)V", "_line", "", "Lkd/bos/olapServer/common/string;", "_reader", "Ljava/io/BufferedReader;", "close", "", "hasNext", "", "next", "readLine", "skip", "version", "", "Lkd/bos/olapServer/common/long;", "bos-olap-core"})
public final class SeqLogFileReader
implements ISeqLogReader {
    @NotNull
    private final BufferedReader _reader;
    @Nullable
    private String _line;

    public SeqLogFileReader(@NotNull InputStream input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this._reader = new BufferedReader(new InputStreamReader(input, Charsets.UTF_8));
        this._line = this._reader.readLine();
    }

    @Override
    public boolean hasNext() {
        return this._line != null;
    }

    @Override
    @NotNull
    public String next() {
        String string;
        String result = this._line;
        if (result != null) {
            this._line = this._reader.readLine();
        }
        if ((string = result) == null) {
            String string2 = Res.INSTANCE.getCommonException_9();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"Res.CommonException_9");
            throw Res.INSTANCE.getRuntimeException(string2, new Object[0]);
        }
        return string;
    }

    public final void skip(long version) {
        long logId;
        String line = this._line;
        while (line != null && ((logId = SeqLogSetting.Companion.tryParseLogId$bos_olap_core(line)) == Long.MIN_VALUE || logId < version)) {
            line = this._reader.readLine();
        }
        this._line = line;
    }

    @Nullable
    public final String readLine() {
        String result = this._line;
        if (result != null) {
            this._line = this._reader.readLine();
        }
        return result;
    }

    @Override
    public void close() {
        this._reader.close();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }
}

