/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.backup.sequenceLog;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import kd.bos.olapServer.backup.sequenceLog.BigStreamCache;
import kd.bos.olapServer.common.NotSupportedException;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u001c\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0006\u0010\f\u001a\u00020\u000bJ\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\r\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0012H\u0002J\u0014\u0010\r\u001a\u00020\u000b2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0002R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lkd/bos/olapServer/backup/sequenceLog/SeqLogFileWriter;", "Ljava/io/Closeable;", "file", "Ljava/io/File;", "(Ljava/io/File;)V", "channel", "Ljava/nio/channels/FileChannel;", "kotlin.jvm.PlatformType", "output", "Ljava/io/FileOutputStream;", "close", "", "flush", "write", "value", "Ljava/nio/ByteBuffer;", "cmdData", "", "", "items", "", "bos-olap-core"})
public final class SeqLogFileWriter
implements Closeable {
    @NotNull
    private final FileOutputStream output;
    private final FileChannel channel;

    public SeqLogFileWriter(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.output = new FileOutputStream(file, true);
        this.channel = this.output.getChannel();
    }

    public final void write(@NotNull Object cmdData) {
        Intrinsics.checkNotNullParameter((Object)cmdData, (String)"cmdData");
        Object object = cmdData;
        if (object instanceof ByteBuffer) {
            this.write((ByteBuffer)cmdData);
        } else if (object instanceof Iterable) {
            this.write((Iterable)cmdData);
        } else if (object instanceof File) {
            this.write((File)cmdData);
        } else if (object instanceof byte[]) {
            this.write((byte[])cmdData);
        } else {
            throw new NotSupportedException();
        }
    }

    private final void write(Iterable<?> items2) {
        for (Object item : items2) {
            if (item == null) continue;
            this.write(item);
        }
    }

    private final void write(byte[] value2) {
        this.output.write(value2);
    }

    private final void write(ByteBuffer value2) {
        this.channel.write(value2);
        BigStreamCache.Companion.release(value2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void write(File file) {
        long length = file.length();
        Object object = file;
        boolean bl = false;
        object = new FileInputStream((File)object);
        bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            FileInputStream otherStream = (FileInputStream)object;
            boolean bl3 = false;
            long l = this.channel.transferFrom(otherStream.getChannel(), this.channel.position(), length);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        file.delete();
    }

    public final void flush() {
        this.output.flush();
    }

    @Override
    public void close() {
        this.channel.close();
        this.output.close();
    }
}

