/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.backup.sequenceLog;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import kd.bos.olapServer.backup.sequenceLog.ISeqLogReader;
import kd.bos.olapServer.backup.sequenceLog.SeqLogEntry;
import kd.bos.olapServer.backup.sequenceLog.SeqLogFileEntry;
import kd.bos.olapServer.backup.sequenceLog.SeqLogFileReader;
import kd.bos.olapServer.backup.sequenceLog.SeqLogFileWriter;
import kd.bos.olapServer.backup.sequenceLog.SeqLogSetting;
import kd.bos.olapServer.common.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002BC\b\u0016\u0012\n\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005\u0012\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u0012\n\u0010\t\u001a\u00060\u0007j\u0002`\b\u0012\n\u0010\n\u001a\u00060\u0004j\u0002`\u0005\u0012\n\u0010\u000b\u001a\u00060\u0004j\u0002`\u0005\u00a2\u0006\u0002\u0010\fBM\u0012\n\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005\u0012\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u0012\n\u0010\t\u001a\u00060\u0007j\u0002`\b\u0012\n\u0010\n\u001a\u00060\u0004j\u0002`\u0005\u0012\n\u0010\u000b\u001a\u00060\u0004j\u0002`\u0005\u0012\n\u0010\r\u001a\u00060\u0004j\u0002`\u0005\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0006\u0010\u001a\u001a\u00020\u0019J\u0014\u0010\u001b\u001a\u00020\u001c2\n\u0010\u001d\u001a\u00060\u0007j\u0002`\bH\u0016J\u0006\u0010\u001e\u001a\u00020\u001fJ\u001a\u0010 \u001a\u00020\u00192\n\u0010!\u001a\u00060\u0007j\u0002`\b2\u0006\u0010\"\u001a\u00020#R\u0012\u0010\t\u001a\u00060\u0007j\u0002`\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00060\u0007j\u0002`\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0013\u001a\u00060\u0007j\u0002`\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0012\u0010\n\u001a\u00060\u0004j\u0002`\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00060\u0004j\u0002`\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0016\u001a\u00060\u0007j\u0002`\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015\u00a8\u0006$"}, d2={"Lkd/bos/olapServer/backup/sequenceLog/SeqLogFileWriterManager;", "Lkd/bos/olapServer/backup/sequenceLog/SeqLogEntry;", "Ljava/io/Closeable;", "logDirectory", "", "Lkd/bos/olapServer/common/string;", "_start", "", "Lkd/bos/olapServer/common/long;", "_end", "filePrefix", "fileSuffix", "(Ljava/lang/String;JJLjava/lang/String;Ljava/lang/String;)V", "filePath", "(Ljava/lang/String;JJLjava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "_file", "Ljava/io/File;", "_writer", "Lkd/bos/olapServer/backup/sequenceLog/SeqLogFileWriter;", "end", "getEnd", "()J", "start", "getStart", "close", "", "flush", "read", "Lkd/bos/olapServer/backup/sequenceLog/ISeqLogReader;", "version", "splitFile", "Lkd/bos/olapServer/backup/sequenceLog/SeqLogFileEntry;", "write", "id", "command", "", "bos-olap-core"})
public final class SeqLogFileWriterManager
extends SeqLogEntry
implements Closeable {
    @NotNull
    private final String logDirectory;
    private long _start;
    private long _end;
    @NotNull
    private final String filePrefix;
    @NotNull
    private final String fileSuffix;
    @NotNull
    private File _file;
    @NotNull
    private SeqLogFileWriter _writer;

    public SeqLogFileWriterManager(@NotNull String logDirectory, long _start, long _end, @NotNull String filePrefix, @NotNull String fileSuffix, @NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)logDirectory, (String)"logDirectory");
        Intrinsics.checkNotNullParameter((Object)filePrefix, (String)"filePrefix");
        Intrinsics.checkNotNullParameter((Object)fileSuffix, (String)"fileSuffix");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        super(new SeqLogSetting(logDirectory, filePrefix));
        this.logDirectory = logDirectory;
        this._start = _start;
        this._end = _end;
        this.filePrefix = filePrefix;
        this.fileSuffix = fileSuffix;
        this._file = new File(filePath);
        this._writer = new SeqLogFileWriter(this._file);
    }

    public SeqLogFileWriterManager(@NotNull String logDirectory, long _start, long _end, @NotNull String filePrefix, @NotNull String fileSuffix) {
        Intrinsics.checkNotNullParameter((Object)logDirectory, (String)"logDirectory");
        Intrinsics.checkNotNullParameter((Object)filePrefix, (String)"filePrefix");
        Intrinsics.checkNotNullParameter((Object)fileSuffix, (String)"fileSuffix");
        String[] stringArray = new String[]{SeqLogSetting.Companion.getFileName(filePrefix, _start, _end, fileSuffix)};
        this(logDirectory, _start, _end, filePrefix, fileSuffix, ((Object)Paths.INSTANCE.get(logDirectory, stringArray)).toString());
    }

    @Override
    public long getStart() {
        return this._start;
    }

    @Override
    public long getEnd() {
        return this._end;
    }

    public final void write(long id, @NotNull Object command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        if (id <= 0L) {
            throw new IllegalArgumentException("id(" + id + ") must >= 0");
        }
        this._writer.write(command);
        long l = this._end;
        boolean bl = false;
        this._end = Math.max(l, id);
    }

    @Override
    @NotNull
    public ISeqLogReader read(long version) {
        this.flush();
        boolean bl = version <= this._end;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Should not read " + this._file + '.';
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        SeqLogFileReader seqLogFileReader = new SeqLogFileReader(new FileInputStream(this._file));
        bl2 = false;
        bl3 = false;
        SeqLogFileReader $this$read_u24lambda_u2d1 = seqLogFileReader;
        boolean bl5 = false;
        if (version > this._start) {
            $this$read_u24lambda_u2d1.skip(version);
        }
        return seqLogFileReader;
    }

    @NotNull
    public final SeqLogFileEntry splitFile() {
        this.flush();
        this._writer.close();
        String[] stringArray = new String[]{SeqLogSetting.Companion.getFileName(this.filePrefix, this._start, this._end, this.fileSuffix)};
        File result = Paths.INSTANCE.get(this.logDirectory, stringArray).toFile();
        boolean bl = this._file.renameTo(result);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = this._file + " rename to " + result + " failed!";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this._start = this._end + 1L;
        String[] stringArray2 = new String[]{SeqLogSetting.Companion.getFileName(this.filePrefix, this._start, this._end, this.fileSuffix)};
        Object object = Paths.INSTANCE.get(this.logDirectory, stringArray2).toFile();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Paths.get(logDirectory, SeqLogSetting.getFileName(filePrefix, _start, _end, fileSuffix)).toFile()");
        this._file = object;
        this._writer = new SeqLogFileWriter(this._file);
        object = result.getName();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"result.name");
        return new SeqLogFileEntry((String)object, new SeqLogSetting(this.logDirectory, this.filePrefix));
    }

    public final void flush() {
        this._writer.flush();
    }

    @Override
    public void close() {
        this._writer.close();
    }
}

