/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.backup.sequenceLog;

import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kd.bos.olapServer.backup.sequenceLog.FaultToleranceCustomer;
import kd.bos.olapServer.backup.sequenceLog.ISeqLogReader;
import kd.bos.olapServer.backup.sequenceLog.LogMessage;
import kd.bos.olapServer.backup.sequenceLog.SeqLog7zEntry;
import kd.bos.olapServer.backup.sequenceLog.SeqLogDirectoryEntry;
import kd.bos.olapServer.backup.sequenceLog.SeqLogEntry;
import kd.bos.olapServer.backup.sequenceLog.SeqLogFileEntry;
import kd.bos.olapServer.backup.sequenceLog.SeqLogFileWriterManager;
import kd.bos.olapServer.backup.sequenceLog.SeqLogSetting;
import kd.bos.olapServer.common.CommonTypesKt;
import kd.bos.olapServer.computingEngine.thread.DefaultThreadFactory;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 ;2\u00020\u0001:\u0002;<B_\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\n\u0010\u0005\u001a\u00060\u0003j\u0002`\u0004\u0012\n\u0010\u0006\u001a\u00060\u0003j\u0002`\u0004\u0012\n\u0010\u0007\u001a\u00060\u0003j\u0002`\u0004\u0012\n\u0010\b\u001a\u00060\tj\u0002`\n\u0012\n\u0010\u000b\u001a\u00060\fj\u0002`\r\u0012\u0006\u0010\u000e\u001a\u00020\f\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\b\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020*H\u0002J\u0006\u0010,\u001a\u00020*J'\u0010-\u001a\u00020\u001b2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020&0/2\n\u0010\u0006\u001a\u00060\u0003j\u0002`\u0004H\u0002\u00a2\u0006\u0002\u00100J\u0012\u00101\u001a\u0002022\n\u00103\u001a\u00060\tj\u0002`\nJ\u001a\u00104\u001a\u00020*2\n\u00105\u001a\u00060\tj\u0002`\n2\u0006\u00106\u001a\u00020\u0014J/\u00107\u001a\u00020*2\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u00170/2\n\u00109\u001a\u00060\u0003j\u0002`\u00042\u0006\u0010#\u001a\u00020$H\u0002\u00a2\u0006\u0002\u0010:R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00060\tj\u0002`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\u00020 X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0012\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00060\fj\u0002`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010%\u001a\u00020\u001d*\u00020&8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\u00a8\u0006="}, d2={"Lkd/bos/olapServer/backup/sequenceLog/SeqLogWriter;", "Ljava/io/Closeable;", "rootPath", "", "Lkd/bos/olapServer/common/string;", "filePrefix", "fileSuffix", "zipSuffix", "fileMaxNumber", "", "Lkd/bos/olapServer/common/long;", "zipFilesCount", "", "Lkd/bos/olapServer/common/int;", "faultToleranceSize", "threadPool", "Ljava/util/concurrent/ExecutorService;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;JIILjava/util/concurrent/ExecutorService;)V", "_cacheWriter", "Lkd/bos/olapServer/backup/sequenceLog/FaultToleranceCustomer;", "", "_candidateFileList", "", "Lkd/bos/olapServer/backup/sequenceLog/SeqLogFileEntry;", "_lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "_logWriter", "Lkd/bos/olapServer/backup/sequenceLog/SeqLogFileWriterManager;", "_stopZip", "", "_zipLock", "reader", "Lkd/bos/olapServer/backup/sequenceLog/SeqLogDirectoryEntry;", "getReader$bos_olap_core", "()Lkd/bos/olapServer/backup/sequenceLog/SeqLogDirectoryEntry;", "setting", "Lkd/bos/olapServer/backup/sequenceLog/SeqLogSetting;", "needSplit", "Lkd/bos/olapServer/backup/sequenceLog/SeqLogEntry;", "getNeedSplit", "(Lkd/bos/olapServer/backup/sequenceLog/SeqLogEntry;)Z", "close", "", "dealZipThing", "flush", "getOrCreateWriter", "entries", "", "([Lkd/bos/olapServer/backup/sequenceLog/SeqLogEntry;Ljava/lang/String;)Lkd/bos/olapServer/backup/sequenceLog/SeqLogFileWriterManager;", "read", "Lkd/bos/olapServer/backup/sequenceLog/ISeqLogReader;", "version", "write", "id", "commandData", "zipFile", "source", "target", "([Lkd/bos/olapServer/backup/sequenceLog/SeqLogFileEntry;Ljava/lang/String;Lkd/bos/olapServer/backup/sequenceLog/SeqLogSetting;)V", "Companion", "SeqLogReader", "bos-olap-core"})
public final class SeqLogWriter
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String rootPath;
    @NotNull
    private final String filePrefix;
    @NotNull
    private final String zipSuffix;
    private final long fileMaxNumber;
    private final int zipFilesCount;
    @NotNull
    private final ExecutorService threadPool;
    @NotNull
    private final SeqLogSetting setting;
    @NotNull
    private final SeqLogDirectoryEntry reader;
    @NotNull
    private final List<SeqLogFileEntry> _candidateFileList;
    @NotNull
    private final SeqLogFileWriterManager _logWriter;
    @NotNull
    private final FaultToleranceCustomer<Object> _cacheWriter;
    private volatile boolean _stopZip;
    @NotNull
    private final ReentrantReadWriteLock _zipLock;
    @NotNull
    private final ReentrantReadWriteLock _lock;
    @NotNull
    private static final ThreadPoolExecutor defaultZipThreadPool;

    public SeqLogWriter(@NotNull String rootPath, @NotNull String filePrefix, @NotNull String fileSuffix, @NotNull String zipSuffix, long fileMaxNumber, int zipFilesCount, int faultToleranceSize, @NotNull ExecutorService threadPool) {
        Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
        Intrinsics.checkNotNullParameter((Object)filePrefix, (String)"filePrefix");
        Intrinsics.checkNotNullParameter((Object)fileSuffix, (String)"fileSuffix");
        Intrinsics.checkNotNullParameter((Object)zipSuffix, (String)"zipSuffix");
        Intrinsics.checkNotNullParameter((Object)threadPool, (String)"threadPool");
        this.rootPath = rootPath;
        this.filePrefix = filePrefix;
        this.zipSuffix = zipSuffix;
        this.fileMaxNumber = fileMaxNumber;
        this.zipFilesCount = zipFilesCount;
        this.threadPool = threadPool;
        this.setting = new SeqLogSetting(this.rootPath, this.filePrefix);
        this.reader = new SeqLogDirectoryEntry(this.setting, fileSuffix, this.zipSuffix);
        boolean bl = false;
        this._candidateFileList = new ArrayList();
        this._zipLock = new ReentrantReadWriteLock();
        this._lock = new ReentrantReadWriteLock();
        SeqLogEntry[] entries = this.reader.getEntries();
        this._logWriter = this.getOrCreateWriter(entries, fileSuffix);
        int n = 0;
        int n2 = entries.length - 1;
        if (n < n2) {
            do {
                int i;
                if (!(entries[i = n++] instanceof SeqLogFileEntry)) continue;
                this._candidateFileList.add((SeqLogFileEntry)entries[i]);
                if (this._candidateFileList.size() < this.zipFilesCount) continue;
                Collection $this$toTypedArray$iv = this._candidateFileList;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                SeqLogFileEntry[] seqLogFileEntryArray = thisCollection$iv.toArray(new SeqLogFileEntry[0]);
                if (seqLogFileEntryArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                this.zipFile(seqLogFileEntryArray, SeqLogSetting.Companion.getFileName(this.filePrefix, this._candidateFileList.get(0).getStart(), ((SeqLogFileEntry)CollectionsKt.last(this._candidateFileList)).getEnd(), this.zipSuffix), this.setting);
                this._candidateFileList.clear();
            } while (n < n2);
        }
        this._cacheWriter = new FaultToleranceCustomer(faultToleranceSize, this._logWriter.getEnd() + 1L, (Function2)new Function2<Long, Object, Unit>(){

            public final void invoke(long id, @NotNull Object cmdData) {
                Intrinsics.checkNotNullParameter((Object)cmdData, (String)"cmdData");
                if (this.getNeedSplit(_logWriter)) {
                    this.dealZipThing();
                }
                _logWriter.write(id, cmdData);
            }
        });
    }

    public /* synthetic */ SeqLogWriter(String string, String string2, String string3, String string4, long l, int n, int n2, ExecutorService executorService, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 0x80) != 0) {
            executorService = defaultZipThreadPool;
        }
        this(string, string2, string3, string4, l, n, n2, executorService);
    }

    @NotNull
    public final SeqLogDirectoryEntry getReader$bos_olap_core() {
        return this.reader;
    }

    private final boolean getNeedSplit(SeqLogEntry $this$needSplit) {
        return $this$needSplit.getEnd() % this.fileMaxNumber == this.fileMaxNumber - 1L;
    }

    private final SeqLogFileWriterManager getOrCreateWriter(SeqLogEntry[] entries, String fileSuffix) {
        SeqLogFileWriterManager curWriter = null;
        SeqLogEntry lastEntry = null;
        SeqLogEntry[] seqLogEntryArray = entries;
        boolean bl = false;
        Object object = seqLogEntryArray;
        boolean bl2 = false;
        if (!(((SeqLogEntry[])object).length == 0) && (lastEntry = (SeqLogEntry)ArraysKt.last((Object[])entries)) instanceof SeqLogFileEntry && (lastEntry.getEnd() - lastEntry.getStart()) % this.fileMaxNumber < this.fileMaxNumber - 1L) {
            curWriter = new SeqLogFileWriterManager(this.rootPath, lastEntry.getStart(), lastEntry.getEnd(), this.filePrefix, fileSuffix, ((SeqLogFileEntry)lastEntry).getPath());
            entries[ArraysKt.getLastIndex((Object[])entries)] = curWriter;
            this.reader.resetEntries(entries);
        }
        if (curWriter == null) {
            long l;
            object = lastEntry;
            long end = object == null ? 0L : (l = ((SeqLogEntry)object).getEnd());
            curWriter = new SeqLogFileWriterManager(this.rootPath, end + 1L, end, this.filePrefix, fileSuffix);
            SeqLogEntry[] newEntries = (SeqLogEntry[])ArraysKt.plus((Object[])entries, (Object)curWriter);
            this.reader.resetEntries(newEntries);
        }
        return curWriter;
    }

    @NotNull
    public final ISeqLogReader read(long version) {
        ReentrantReadWriteLock.ReadLock readLock = this._lock.readLock();
        readLock.lock();
        try {
            ISeqLogReader iSeqLogReader = this.reader.read(version);
            Intrinsics.checkNotNullExpressionValue((Object)readLock, (String)"readLock");
            return new SeqLogReader(iSeqLogReader, readLock);
        }
        catch (Exception ex) {
            readLock.unlock();
            throw ex;
        }
    }

    public final void write(long id, @NotNull Object commandData) {
        Intrinsics.checkNotNullParameter((Object)commandData, (String)"commandData");
        this._cacheWriter.deal(id, commandData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void dealZipThing() {
        int n;
        int n2;
        if (this._logWriter.getEnd() < this._logWriter.getStart()) {
            return;
        }
        SeqLogFileEntry addElem = this._logWriter.splitFile();
        this._candidateFileList.add(addElem);
        ReentrantReadWriteLock reentrantReadWriteLock = this._lock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        boolean bl3 = false;
        int n4 = 0;
        n4 = 0;
        int n5 = n3;
        while (n4 < n5) {
            n2 = n4++;
            n = 0;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl4 = false;
            Object[] oldEntries = this.getReader$bos_olap_core().getEntries();
            SeqLogEntry[] newEntries = (SeqLogEntry[])ArraysKt.plus((Object[])oldEntries, (Object)this._logWriter);
            newEntries[newEntries.length - 2] = addElem;
            this.getReader$bos_olap_core().resetEntries(newEntries);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            n5 = 0;
            n2 = 0;
            n2 = 0;
            n = n3;
            while (n2 < n) {
                int n6 = n2++;
                boolean bl5 = false;
                readLock.lock();
            }
            writeLock.unlock();
        }
        if (this._candidateFileList.size() >= this.zipFilesCount) {
            Collection $this$toTypedArray$iv = this._candidateFileList;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            SeqLogFileEntry[] seqLogFileEntryArray = thisCollection$iv.toArray(new SeqLogFileEntry[0]);
            if (seqLogFileEntryArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            this.zipFile(seqLogFileEntryArray, SeqLogSetting.Companion.getFileName(this.filePrefix, this._candidateFileList.get(0).getStart(), ((SeqLogFileEntry)CollectionsKt.last(this._candidateFileList)).getEnd(), this.zipSuffix), this.setting);
            this._candidateFileList.clear();
        }
    }

    private final void zipFile(SeqLogFileEntry[] source2, String target, SeqLogSetting setting) {
        if (!this._stopZip) {
            this.threadPool.submit(() -> SeqLogWriter.zipFile$lambda-4(this, source2, target, setting));
        }
    }

    public final void flush() {
        this._cacheWriter.flush();
        this._logWriter.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this._cacheWriter.flush();
        this._logWriter.flush();
        if (this.getNeedSplit(this._logWriter)) {
            this.dealZipThing();
        }
        this._logWriter.close();
        this._stopZip = true;
        try {
            this._zipLock.writeLock().tryLock(120L, TimeUnit.SECONDS);
        }
        finally {
            this._zipLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void zipFile$lambda-4(SeqLogWriter this$0, SeqLogFileEntry[] $source, String $target, SeqLogSetting $setting) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$source, (String)"$source");
        Intrinsics.checkNotNullParameter((Object)$target, (String)"$target");
        Intrinsics.checkNotNullParameter((Object)$setting, (String)"$setting");
        if (this$0._stopZip) {
            return;
        }
        this$0._zipLock.readLock().lock();
        try {
            int n;
            int n2;
            if (this$0._stopZip) {
                return;
            }
            SeqLog7zEntry addEntry = SeqLog7zEntry.Companion.create7zFile($source, $target, $setting);
            ReentrantReadWriteLock reentrantReadWriteLock = this$0._lock;
            boolean bl = false;
            boolean bl2 = false;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            boolean bl3 = false;
            int n4 = 0;
            n4 = 0;
            int n5 = n3;
            while (n4 < n5) {
                n2 = n4++;
                n = 0;
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                boolean bl4 = false;
                Object[] oldEntries = this$0.getReader$bos_olap_core().getEntries();
                boolean bl5 = false;
                List newEntries = new ArrayList();
                CollectionsKt.addAll((Collection)newEntries, (Object[])oldEntries);
                CollectionsKt.removeAll((Collection)newEntries, (Object[])$source);
                newEntries.add(addEntry);
                List $this$sortBy$iv = newEntries;
                boolean $i$f$sortBy = false;
                if ($this$sortBy$iv.size() > 1) {
                    boolean bl6 = false;
                    CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator<T>(){

                        public final int compare(T a, T b) {
                            boolean bl = false;
                            SeqLogEntry it = (SeqLogEntry)a;
                            boolean bl2 = false;
                            Comparable comparable = Long.valueOf(it.getStart());
                            it = (SeqLogEntry)b;
                            Comparable comparable2 = comparable;
                            bl2 = false;
                            Long l = it.getStart();
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
                        }
                    });
                }
                Collection $this$toTypedArray$iv = newEntries;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                SeqLogEntry[] seqLogEntryArray = thisCollection$iv.toArray(new SeqLogEntry[0]);
                if (seqLogEntryArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                this$0.getReader$bos_olap_core().resetEntries(seqLogEntryArray);
                for (SeqLogFileEntry elem : $source) {
                    boolean bl7 = new File(elem.getPath()).delete();
                    boolean bl8 = false;
                    boolean bl9 = false;
                    if (bl7) continue;
                    boolean bl10 = false;
                    String string = "delete " + elem.getPath() + " failed";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                n5 = 0;
                n2 = 0;
                n2 = 0;
                n = n3;
                while (n2 < n) {
                    int n6 = n2++;
                    boolean bl11 = false;
                    readLock.lock();
                }
                writeLock.unlock();
            }
        }
        catch (Exception e) {
            StringBuilder stringBuilder = new StringBuilder().append("do ");
            Object object = $source;
            boolean bl = false;
            String string = Arrays.toString(object);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.util.Arrays.toString(this)");
            object = stringBuilder.append(string).append(" zip to ").append($target).append(" failed. ").append((Object)e.getMessage()).toString();
            bl = false;
            System.out.println(object);
            e.printStackTrace();
        }
        finally {
            this$0._zipLock.readLock().unlock();
        }
    }

    static {
        LinkedBlockingQueue queue = new LinkedBlockingQueue();
        DefaultThreadFactory factory = new DefaultThreadFactory("SeqLogZipThread-");
        int n = 4;
        int n2 = CommonTypesKt.getAvailableProcessors() / 8;
        boolean bl = false;
        int coreSize = Math.max(n, n2);
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(coreSize, coreSize, 1000L, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)queue, factory);
        n2 = 0;
        bl = false;
        ThreadPoolExecutor $this$_init__u24lambda_u2d5 = threadPoolExecutor;
        boolean bl2 = false;
        $this$_init__u24lambda_u2d5.allowCoreThreadTimeOut(true);
        defaultZipThreadPool = threadPoolExecutor;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\t\u0010\b\u001a\u00020\tH\u0096\u0003J\r\u0010\n\u001a\u00060\u000bj\u0002`\fH\u0096\u0003R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lkd/bos/olapServer/backup/sequenceLog/SeqLogWriter$SeqLogReader;", "Lkd/bos/olapServer/backup/sequenceLog/ISeqLogReader;", "realReader", "lock", "Ljava/util/concurrent/locks/Lock;", "(Lkd/bos/olapServer/backup/sequenceLog/ISeqLogReader;Ljava/util/concurrent/locks/Lock;)V", "close", "", "hasNext", "", "next", "", "Lkd/bos/olapServer/common/string;", "bos-olap-core"})
    private static final class SeqLogReader
    implements ISeqLogReader {
        @NotNull
        private final ISeqLogReader realReader;
        @NotNull
        private final Lock lock;

        public SeqLogReader(@NotNull ISeqLogReader realReader, @NotNull Lock lock) {
            Intrinsics.checkNotNullParameter((Object)realReader, (String)"realReader");
            Intrinsics.checkNotNullParameter((Object)lock, (String)"lock");
            this.realReader = realReader;
            this.lock = lock;
        }

        @Override
        public boolean hasNext() {
            return this.realReader.hasNext();
        }

        @Override
        @NotNull
        public String next() {
            return (String)this.realReader.next();
        }

        @Override
        public void close() {
            this.realReader.close();
            this.lock.unlock();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\n\u0010\b\u001a\u00060\tj\u0002`\n2\n\u0010\u000b\u001a\u00060\fj\u0002`\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lkd/bos/olapServer/backup/sequenceLog/SeqLogWriter$Companion;", "", "()V", "defaultZipThreadPool", "Ljava/util/concurrent/ThreadPoolExecutor;", "writeString", "", "Lkd/bos/olapServer/backup/sequenceLog/SeqLogWriter;", "id", "", "Lkd/bos/olapServer/common/long;", "commandStr", "", "Lkd/bos/olapServer/common/string;", "bos-olap-core"})
    public static final class Companion {
        private Companion() {
        }

        public final void writeString(@NotNull SeqLogWriter $this$writeString, long id, @NotNull String commandStr) {
            Intrinsics.checkNotNullParameter((Object)$this$writeString, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)commandStr, (String)"commandStr");
            $this$writeString.write(id, LogMessage.Companion.commandToByteBuffer$bos_olap_core(null, id, commandStr));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

