/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.collections;

import java.io.Closeable;
import kd.bos.olapServer.collections.IImmutableArrayInt;
import kd.bos.olapServer.collections.IImmutableListHashMapEntry;
import kd.bos.olapServer.common.IEqualityComparer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\b \u0018\u0000*\n\b\u0000\u0010\u0001 \u0000*\u00020\u00022\u00020\u0003B#\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0018\u001a\u00020\u0019H\u0016J%\u0010\u001a\u001a\u00060\u001bj\u0002`\u001c2\n\u0010\u001d\u001a\u00060\u0014j\u0002`\u00152\u0006\u0010\u001e\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u001fJ\u0017\u0010 \u001a\u00060\u0014j\u0002`\u00152\u0006\u0010\u001e\u001a\u00028\u0000\u00a2\u0006\u0002\u0010!J%\u0010 \u001a\u00060\u0014j\u0002`\u00152\u0006\u0010\u001e\u001a\u00028\u00002\n\u0010\"\u001a\u00060\u0014j\u0002`#H\u0004\u00a2\u0006\u0002\u0010$J\u0011\u0010%\u001a\u00060&j\u0002`'H\u0000\u00a2\u0006\u0002\b(J\u0014\u0010)\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020\u00140*H\u0002J\b\u0010,\u001a\u00020&H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0015\u0010\u0013\u001a\u00060\u0014j\u0002`\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lkd/bos/olapServer/collections/AbstractImmutableMap;", "TKey", "", "Ljava/io/Closeable;", "buckets", "Lkd/bos/olapServer/collections/IImmutableArrayInt;", "entries", "Lkd/bos/olapServer/collections/IImmutableListHashMapEntry;", "comparer", "Lkd/bos/olapServer/common/IEqualityComparer;", "(Lkd/bos/olapServer/collections/IImmutableArrayInt;Lkd/bos/olapServer/collections/IImmutableListHashMapEntry;Lkd/bos/olapServer/common/IEqualityComparer;)V", "getComparer", "()Lkd/bos/olapServer/common/IEqualityComparer;", "conflictCount", "", "getConflictCount", "()J", "setConflictCount", "(J)V", "count", "", "Lkd/bos/olapServer/common/idx;", "getCount", "()I", "close", "", "equalsKey", "", "Lkd/bos/olapServer/common/bool;", "index", "key", "(ILjava/lang/Object;)Z", "getKeyIndex", "(Ljava/lang/Object;)I", "hashcode", "Lkd/bos/olapServer/common/int;", "(Ljava/lang/Object;I)I", "getLinkCountersString", "", "Lkd/bos/olapServer/common/string;", "getLinkCountersString$bos_olap_core", "getStatisticsInfo", "Lkotlin/Pair;", "", "toString", "bos-olap-core"})
public abstract class AbstractImmutableMap<TKey>
implements Closeable {
    @NotNull
    private final IImmutableArrayInt buckets;
    @NotNull
    private final IImmutableListHashMapEntry entries;
    @NotNull
    private final IEqualityComparer<TKey> comparer;
    private long conflictCount;

    public AbstractImmutableMap(@NotNull IImmutableArrayInt buckets, @NotNull IImmutableListHashMapEntry entries, @NotNull IEqualityComparer<? super TKey> comparer) {
        Intrinsics.checkNotNullParameter((Object)buckets, (String)"buckets");
        Intrinsics.checkNotNullParameter((Object)entries, (String)"entries");
        Intrinsics.checkNotNullParameter(comparer, (String)"comparer");
        this.buckets = buckets;
        this.entries = entries;
        this.comparer = comparer;
    }

    @NotNull
    protected final IEqualityComparer<TKey> getComparer() {
        return this.comparer;
    }

    public final long getConflictCount() {
        return this.conflictCount;
    }

    public final void setConflictCount(long l) {
        this.conflictCount = l;
    }

    public final int getKeyIndex(@NotNull TKey key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return this.getKeyIndex(key, this.comparer.getHashCode(key) & Integer.MAX_VALUE);
    }

    protected final int getKeyIndex(@NotNull TKey key, int hashcode) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        int bucketsLength = this.buckets.getLength();
        if (bucketsLength == 0) {
            return -1;
        }
        if (hashcode < 0) {
            throw new RuntimeException();
        }
        int targetBucket = hashcode % bucketsLength;
        int i = this.buckets.get(targetBucket);
        while (i >= 0) {
            if (this.entries.getEntryHashcode(i) == hashcode && this.equalsKey(i, key)) {
                return i;
            }
            i = this.entries.getEntryNext(i);
        }
        return -1;
    }

    public final int getCount() {
        return this.entries.getCount();
    }

    protected abstract boolean equalsKey(int var1, @NotNull TKey var2);

    @Override
    public void close() {
        Closeable closeable;
        Object object = this.buckets;
        Closeable closeable2 = closeable = object instanceof Closeable ? (Closeable)object : null;
        if (closeable != null) {
            closeable.close();
        }
        object = this.entries;
        Closeable closeable3 = closeable = object instanceof Closeable ? (Closeable)object : null;
        if (closeable != null) {
            closeable.close();
        }
    }

    @NotNull
    public String toString() {
        return Intrinsics.stringPlus((String)"count = ", (Object)this.getCount());
    }

    @NotNull
    public final String getLinkCountersString$bos_olap_core() {
        int n;
        Pair<int[], Integer> pair = this.getStatisticsInfo();
        int[] linkCounters = (int[])pair.component1();
        int veryBigLinkCounters = ((Number)pair.component2()).intValue();
        int last = linkCounters.length - 1;
        while (linkCounters[last] == 0 && (last = (n = last) + -1) >= 0) {
        }
        if (last < 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int n2 = 0;
        if (n2 <= last) {
            int i;
            do {
                i = n2++;
                StringBuilder stringBuilder = sb;
                String string = i + " \t " + linkCounters[i];
                boolean bl = false;
                StringBuilder stringBuilder2 = stringBuilder.append(string);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder2);
            } while (i != last);
        }
        if (veryBigLinkCounters != 0) {
            StringBuilder stringBuilder = sb;
            String string = Intrinsics.stringPlus((String)"[Very Big] \t ", (Object)veryBigLinkCounters);
            boolean bl = false;
            StringBuilder stringBuilder3 = stringBuilder.append(string);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder3);
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    private final Pair<int[], Integer> getStatisticsInfo() {
        int[] linkCounters = new int[20];
        int veryBigLinkCounters = 0;
        int n = 0;
        int n2 = this.getCount();
        if (n < n2) {
            do {
                int n3;
                int i;
                int next = i = n++;
                if (this.entries.getEntryHashcode(i) < 0) continue;
                int linkCount = -1;
                do {
                    next = this.entries.getEntryNext(next);
                    n3 = linkCount;
                    linkCount = n3 + 1;
                } while (next >= 0);
                if (linkCount < linkCounters.length) {
                    int[] nArray = linkCounters;
                    int n4 = linkCount;
                    nArray[n4] = nArray[n4] + 1;
                    continue;
                }
                n3 = veryBigLinkCounters;
                veryBigLinkCounters = n3 + 1;
            } while (n < n2);
        }
        return new Pair((Object)linkCounters, (Object)veryBigLinkCounters);
    }
}

