/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.collections;

import kd.bos.olapServer.collections.AbstractImmutableMap;
import kd.bos.olapServer.collections.HashHelpers;
import kd.bos.olapServer.collections.HashMapEntry;
import kd.bos.olapServer.collections.IAddEntryFunction;
import kd.bos.olapServer.collections.IDataContainer;
import kd.bos.olapServer.collections.IGetOrAddStrategy;
import kd.bos.olapServer.collections.IMutableArrayInt;
import kd.bos.olapServer.collections.IMutableListHashMapEntry;
import kd.bos.olapServer.common.DefaultEqualityComparer;
import kd.bos.olapServer.common.IEqualityComparer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b \u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\b\u0012\u0004\u0012\u0002H\u00010\u00052\u00020\u0006B\u001d\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00010\n\u00a2\u0006\u0002\u0010\u000bB)\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00010\n\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r\u00a2\u0006\u0002\u0010\u000eJ'\u0010\u0011\u001a\u00060\u0010j\u0002`\u00122\u0006\u0010\u0013\u001a\u00028\u00002\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015H\u0004\u00a2\u0006\u0002\u0010\u0016J3\u0010\u0011\u001a\u00060\u0010j\u0002`\u00122\u0006\u0010\u0013\u001a\u00028\u00002\n\u0010\u0017\u001a\u00060\u0010j\u0002`\u00182\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015H\u0004\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0010H\u0002J'\u0010\u001d\u001a\u00060\u0010j\u0002`\u00122\u0006\u0010\u0013\u001a\u00028\u00002\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015H\u0004\u00a2\u0006\u0002\u0010\u0016J1\u0010\u001d\u001a\u00060\u0010j\u0002`\u00122\u0006\u0010\u0013\u001a\u00028\u00002\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u00152\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0004\u00a2\u0006\u0002\u0010 J=\u0010\u001d\u001a\u00060\u0010j\u0002`\u00122\u0006\u0010\u0013\u001a\u00028\u00002\n\u0010\u0017\u001a\u00060\u0010j\u0002`\u00182\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u00152\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0004\u00a2\u0006\u0002\u0010!J\b\u0010\"\u001a\u00020\u001bH\u0002J\b\u0010#\u001a\u00020\u001bH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lkd/bos/olapServer/collections/AbstractMutableMap;", "TKey", "", "TEntry", "Lkd/bos/olapServer/collections/HashMapEntry;", "Lkd/bos/olapServer/collections/AbstractImmutableMap;", "Lkd/bos/olapServer/collections/IDataContainer;", "buckets", "Lkd/bos/olapServer/collections/IMutableArrayInt;", "entries", "Lkd/bos/olapServer/collections/IMutableListHashMapEntry;", "(Lkd/bos/olapServer/collections/IMutableArrayInt;Lkd/bos/olapServer/collections/IMutableListHashMapEntry;)V", "comparer", "Lkd/bos/olapServer/common/IEqualityComparer;", "(Lkd/bos/olapServer/collections/IMutableArrayInt;Lkd/bos/olapServer/collections/IMutableListHashMapEntry;Lkd/bos/olapServer/common/IEqualityComparer;)V", "bucketsResizeCount", "", "add", "Lkd/bos/olapServer/common/idx;", "key", "addEntry", "Lkd/bos/olapServer/collections/IAddEntryFunction;", "(Ljava/lang/Object;Lkd/bos/olapServer/collections/IAddEntryFunction;)I", "hashcode", "Lkd/bos/olapServer/common/int;", "(Ljava/lang/Object;ILkd/bos/olapServer/collections/IAddEntryFunction;)I", "force", "", "getNeedResizeLength", "getOrAdd", "strategy", "Lkd/bos/olapServer/collections/IGetOrAddStrategy;", "(Ljava/lang/Object;Lkd/bos/olapServer/collections/IAddEntryFunction;Lkd/bos/olapServer/collections/IGetOrAddStrategy;)I", "(Ljava/lang/Object;ILkd/bos/olapServer/collections/IAddEntryFunction;Lkd/bos/olapServer/collections/IGetOrAddStrategy;)I", "initialize", "resize", "bos-olap-core"})
public abstract class AbstractMutableMap<TKey, TEntry extends HashMapEntry>
extends AbstractImmutableMap<TKey>
implements IDataContainer {
    @NotNull
    private final IMutableArrayInt buckets;
    @NotNull
    private final IMutableListHashMapEntry<TEntry> entries;
    private int bucketsResizeCount;

    public AbstractMutableMap(@NotNull IMutableArrayInt buckets, @NotNull IMutableListHashMapEntry<TEntry> entries, @NotNull IEqualityComparer<? super TKey> comparer) {
        Intrinsics.checkNotNullParameter((Object)buckets, (String)"buckets");
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        Intrinsics.checkNotNullParameter(comparer, (String)"comparer");
        super(buckets, entries, comparer);
        this.buckets = buckets;
        this.entries = entries;
        this.bucketsResizeCount = this.getNeedResizeLength();
    }

    public AbstractMutableMap(@NotNull IMutableArrayInt buckets, @NotNull IMutableListHashMapEntry<TEntry> entries) {
        Intrinsics.checkNotNullParameter((Object)buckets, (String)"buckets");
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        this(buckets, entries, DefaultEqualityComparer.Companion.getDefault());
    }

    private final int getNeedResizeLength() {
        int bucketsLength = this.buckets.getLength();
        return bucketsLength < 0x3FFFFFFF ? (int)((long)bucketsLength * 3L / 4L) : bucketsLength;
    }

    private final void initialize() {
        int newSize = HashHelpers.INSTANCE.GetPrime(0);
        this.buckets.resize(newSize);
        this.buckets.fill(-1);
        this.bucketsResizeCount = this.getNeedResizeLength();
    }

    protected final int getOrAdd(@NotNull TKey key, @NotNull IAddEntryFunction<? super TKey> addEntry) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(addEntry, (String)"addEntry");
        return this.getOrAdd(key, this.getComparer().getHashCode(key) & Integer.MAX_VALUE, addEntry, null);
    }

    protected final int getOrAdd(@NotNull TKey key, @NotNull IAddEntryFunction<? super TKey> addEntry, @Nullable IGetOrAddStrategy strategy) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(addEntry, (String)"addEntry");
        return this.getOrAdd(key, this.getComparer().getHashCode(key) & Integer.MAX_VALUE, addEntry, strategy);
    }

    protected final int getOrAdd(@NotNull TKey key, int hashcode, @NotNull IAddEntryFunction<? super TKey> addEntry, @Nullable IGetOrAddStrategy strategy) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(addEntry, (String)"addEntry");
        int bucketsLength = this.buckets.getLength();
        if (bucketsLength == 0) {
            this.initialize();
        }
        boolean bl = hashcode >= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "hashcode:" + hashcode + " \u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int targetBucket = hashcode % this.buckets.getLength();
        int i = this.buckets.get(targetBucket);
        while (i >= 0) {
            AbstractMutableMap abstractMutableMap = this;
            long l = abstractMutableMap.getConflictCount();
            abstractMutableMap.setConflictCount(l + 1L);
            if (this.entries.getEntryHashcode(i) == hashcode && this.equalsKey(i, key)) {
                return i;
            }
            i = this.entries.getEntryNext(i);
        }
        if (strategy != null && !strategy.canAdd()) {
            return Integer.MIN_VALUE;
        }
        int index2 = this.getCount();
        if (index2 >= this.bucketsResizeCount) {
            this.resize();
            targetBucket = hashcode % this.buckets.getLength();
        }
        boolean bl5 = index2 == addEntry.invoke(key, hashcode, this.buckets.get(targetBucket));
        boolean bl6 = false;
        boolean bl7 = false;
        bl7 = false;
        boolean bl8 = false;
        if (!bl5) {
            boolean bl9 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.buckets.set(targetBucket, index2);
        return -(index2 + 1);
    }

    protected final int add(@NotNull TKey key, @NotNull IAddEntryFunction<? super TKey> addEntry) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(addEntry, (String)"addEntry");
        return this.add(key, this.getComparer().getHashCode(key) & Integer.MAX_VALUE, addEntry);
    }

    protected final int add(@NotNull TKey key, int hashcode, @NotNull IAddEntryFunction<? super TKey> addEntry) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(addEntry, (String)"addEntry");
        int bucketsLength = this.buckets.getLength();
        if (bucketsLength == 0) {
            this.initialize();
        }
        boolean bl = hashcode >= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "hashcode:" + hashcode + " \u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int targetBucket = hashcode % this.buckets.getLength();
        int index2 = this.getCount();
        if (index2 >= this.bucketsResizeCount) {
            this.resize();
            targetBucket = hashcode % this.buckets.getLength();
        }
        bl3 = index2 == addEntry.invoke(key, hashcode, this.buckets.get(targetBucket));
        boolean bl5 = false;
        boolean bl6 = false;
        bl6 = false;
        boolean bl7 = false;
        if (!bl3) {
            boolean bl8 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.buckets.set(targetBucket, index2);
        return index2;
    }

    private final void resize() {
        int currentCount = this.buckets.getLength();
        int newSize = HashHelpers.INSTANCE.ExpandPrime(currentCount);
        this.buckets.resize(newSize);
        this.buckets.fill(-1);
        int bucket = 0;
        int n = 0;
        int n2 = this.getCount();
        if (n < n2) {
            do {
                int i;
                int hashcode;
                if ((hashcode = this.entries.getEntryHashcode(i = n++)) < 0) continue;
                bucket = hashcode % newSize;
                this.entries.setEntryNext(i, this.buckets.get(bucket));
                this.buckets.set(bucket, i);
            } while (n < n2);
        }
        this.bucketsResizeCount = this.getNeedResizeLength();
    }

    @Override
    public void force() {
        IDataContainer iDataContainer;
        Object object = this.buckets;
        IDataContainer iDataContainer2 = iDataContainer = object instanceof IDataContainer ? (IDataContainer)object : null;
        if (iDataContainer != null) {
            iDataContainer.force();
        }
        object = this.entries;
        IDataContainer iDataContainer3 = iDataContainer = object instanceof IDataContainer ? (IDataContainer)object : null;
        if (iDataContainer != null) {
            iDataContainer.force();
        }
    }
}

