/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.collections;

import java.util.Arrays;
import kd.bos.olapServer.collections.ICloneable;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0013\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 ,2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001,B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u001b\b\u0012\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\u0010\b\u001a\u00060\u0004j\u0002`\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0000J\u000e\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0000J\b\u0010\u001a\u001a\u00020\u0017H\u0002J\u0006\u0010\u001b\u001a\u00020\u0017J\u000e\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u0004J\b\u0010\u001d\u001a\u00020\u0000H\u0016J\u0012\u0010\u001e\u001a\u00060\u000fj\u0002`\u00102\u0006\u0010\u0018\u001a\u00020\u0000J\u0010\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u0004H\u0002J\u0010\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u0004H\u0002J\u0019\u0010#\u001a\u00060\u000fj\u0002`\u00102\n\u0010\u001c\u001a\u00060\u0004j\u0002`\tH\u0086\u0002J\u0010\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u0004H\u0002J\u0016\u0010&\u001a\u00060\u0004j\u0002`\t2\n\u0010%\u001a\u00060\u0004j\u0002`\tJ\u000e\u0010'\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0000J\b\u0010(\u001a\u00020\u0017H\u0002J\u000e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u0004J\u0019\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u000fH\u0086\u0002J\b\u0010*\u001a\u00020+H\u0016R\u0015\u0010\u000b\u001a\u00060\u0004j\u0002`\t8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0015\u0010\u000e\u001a\u00060\u000fj\u0002`\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\rR\u0011\u0010\u0014\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lkd/bos/olapServer/collections/BitSetEx;", "Lkd/bos/olapServer/collections/ICloneable;", "()V", "bitSize", "", "(I)V", "words", "", "wordsInUse", "Lkd/bos/olapServer/common/int;", "([JI)V", "cardinality", "getCardinality", "()I", "isEmpty", "", "Lkd/bos/olapServer/common/bool;", "()Z", "length", "getLength", "size", "getSize", "and", "", "set", "andNot", "checkInvariants", "clear", "bitIndex", "clone", "containsAll", "ensureCapacity", "wordsRequired", "expandTo", "wordIndex", "get", "nextClearBit", "fromIndex", "nextSetBit", "or", "recalculateWordsInUse", "value", "toString", "", "Companion", "bos-olap-core"})
public final class BitSetEx
implements ICloneable<BitSetEx> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private long[] words;
    private int wordsInUse;
    private static final int ADDRESS_BITS_PER_WORD = 6;
    private static final int BITS_PER_WORD = 64;
    private static final long WORD_MASK = -1L;

    public final boolean isEmpty() {
        return this.wordsInUse == 0;
    }

    public BitSetEx() {
        this.words = BitSetEx.Companion.initWords(64);
    }

    public BitSetEx(int bitSize) {
        if (bitSize < 0) {
            throw new NegativeArraySizeException(Intrinsics.stringPlus((String)"bitSize < 0: ", (Object)bitSize));
        }
        this.words = BitSetEx.Companion.initWords(bitSize);
    }

    private BitSetEx(long[] words, int wordsInUse) {
        this.words = words;
        this.wordsInUse = wordsInUse;
    }

    private final void checkInvariants() {
        boolean bl = this.wordsInUse == 0 || this.words[this.wordsInUse - 1] != 0L;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        bl = this.wordsInUse >= 0 && this.wordsInUse <= this.words.length;
        bl2 = false;
        bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl5 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        bl = this.wordsInUse == this.words.length || this.words[this.wordsInUse] == 0L;
        bl2 = false;
        bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl6 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }

    private final void recalculateWordsInUse() {
        int i = this.wordsInUse - 1;
        while (i >= 0 && this.words[i] == 0L) {
            int n = i;
            i = n + -1;
        }
        this.wordsInUse = i + 1;
    }

    private final void ensureCapacity(int wordsRequired) {
        if (this.words.length < wordsRequired) {
            int request = Math.max(2 * this.words.length, wordsRequired);
            long[] lArray = this.words;
            boolean bl = false;
            long[] lArray2 = Arrays.copyOf(lArray, request);
            Intrinsics.checkNotNullExpressionValue((Object)lArray2, (String)"java.util.Arrays.copyOf(this, newSize)");
            this.words = lArray2;
        }
    }

    private final void expandTo(int wordIndex) {
        int wordsRequired = wordIndex + 1;
        if (this.wordsInUse < wordsRequired) {
            this.ensureCapacity(wordsRequired);
            this.wordsInUse = wordsRequired;
        }
    }

    public final void set(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException(Intrinsics.stringPlus((String)"bitIndex < 0: ", (Object)bitIndex));
        }
        int wordIndex = BitSetEx.Companion.wordIndex(bitIndex);
        this.expandTo(wordIndex);
        this.words[wordIndex] = this.words[wordIndex] | 1L << bitIndex;
        this.checkInvariants();
    }

    public final void set(int bitIndex, boolean value2) {
        if (value2) {
            this.set(bitIndex);
        } else {
            this.clear(bitIndex);
        }
    }

    public final void clear(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException(Intrinsics.stringPlus((String)"bitIndex < 0: ", (Object)bitIndex));
        }
        int wordIndex = BitSetEx.Companion.wordIndex(bitIndex);
        if (wordIndex >= this.wordsInUse) {
            return;
        }
        this.words[wordIndex] = this.words[wordIndex] & (1L << bitIndex ^ 0xFFFFFFFFFFFFFFFFL);
        this.recalculateWordsInUse();
        this.checkInvariants();
    }

    public final void clear() {
        while (this.wordsInUse > 0) {
            BitSetEx bitSetEx = this;
            bitSetEx.wordsInUse += -1;
            this.words[bitSetEx.wordsInUse] = 0L;
        }
    }

    public final boolean get(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException(Intrinsics.stringPlus((String)"bitIndex < 0: ", (Object)bitIndex));
        }
        this.checkInvariants();
        int wordIndex = BitSetEx.Companion.wordIndex(bitIndex);
        return wordIndex < this.wordsInUse && (this.words[wordIndex] & 1L << bitIndex) != 0L;
    }

    public final int nextSetBit(int fromIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException(Intrinsics.stringPlus((String)"fromIndex < 0: ", (Object)fromIndex));
        }
        this.checkInvariants();
        int u = BitSetEx.Companion.wordIndex(fromIndex);
        if (u >= this.wordsInUse) {
            return -1;
        }
        long word = this.words[u] & -1L << fromIndex;
        while (word == 0L) {
            if (++u == this.wordsInUse) {
                return -1;
            }
            word = this.words[u];
        }
        return u * 64 + Long.numberOfTrailingZeros(word);
    }

    private final int nextClearBit(int fromIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException(Intrinsics.stringPlus((String)"fromIndex < 0: ", (Object)fromIndex));
        }
        this.checkInvariants();
        int u = BitSetEx.Companion.wordIndex(fromIndex);
        if (u >= this.wordsInUse) {
            return fromIndex;
        }
        long word = (this.words[u] ^ 0xFFFFFFFFFFFFFFFFL) & -1L << fromIndex;
        while (word == 0L) {
            if (++u == this.wordsInUse) {
                return this.wordsInUse * 64;
            }
            word = this.words[u] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return u * 64 + Long.numberOfTrailingZeros(word);
    }

    public final int getLength() {
        return this.wordsInUse == 0 ? 0 : 64 * (this.wordsInUse - 1) + (64 - Long.numberOfLeadingZeros(this.words[this.wordsInUse - 1]));
    }

    public final boolean containsAll(@NotNull BitSetEx set) {
        Intrinsics.checkNotNullParameter((Object)set, (String)"set");
        if (this.wordsInUse < set.wordsInUse) {
            return false;
        }
        int n = set.wordsInUse - 1;
        if (0 <= n) {
            do {
                long b;
                int i;
                long a;
                if (((a = this.words[i = n--]) & (b = set.words[i])) == b) continue;
                return false;
            } while (0 <= n);
        }
        return true;
    }

    public final int getCardinality() {
        int sum = 0;
        int n = 0;
        int n2 = this.wordsInUse;
        if (n < n2) {
            do {
                int i = n++;
                sum += Long.bitCount(this.words[i]);
            } while (n < n2);
        }
        return sum;
    }

    public final void and(@NotNull BitSetEx set) {
        Intrinsics.checkNotNullParameter((Object)set, (String)"set");
        if (this == set) {
            return;
        }
        while (this.wordsInUse > set.wordsInUse) {
            BitSetEx bitSetEx = this;
            bitSetEx.wordsInUse += -1;
            this.words[bitSetEx.wordsInUse] = 0L;
        }
        int n = 0;
        int n2 = this.wordsInUse;
        if (n < n2) {
            do {
                int i = n++;
                this.words[i] = this.words[i] & set.words[i];
            } while (n < n2);
        }
        this.recalculateWordsInUse();
        this.checkInvariants();
    }

    public final void andNot(@NotNull BitSetEx set) {
        Intrinsics.checkNotNullParameter((Object)set, (String)"set");
        int n = Math.min(this.wordsInUse, set.wordsInUse) - 1;
        if (0 <= n) {
            do {
                int i = n--;
                this.words[i] = this.words[i] & (set.words[i] ^ 0xFFFFFFFFFFFFFFFFL);
            } while (0 <= n);
        }
        this.recalculateWordsInUse();
        this.checkInvariants();
    }

    public final void or(@NotNull BitSetEx set) {
        int n;
        Intrinsics.checkNotNullParameter((Object)set, (String)"set");
        if (this == set) {
            return;
        }
        int wordsInCommon = Math.min(this.wordsInUse, set.wordsInUse);
        if (this.wordsInUse < set.wordsInUse) {
            this.ensureCapacity(set.wordsInUse);
            this.wordsInUse = set.wordsInUse;
        }
        if ((n = 0) < wordsInCommon) {
            do {
                int i = n++;
                this.words[i] = this.words[i] | set.words[i];
            } while (n < wordsInCommon);
        }
        if (wordsInCommon < set.wordsInUse) {
            System.arraycopy(set.words, wordsInCommon, this.words, wordsInCommon, this.wordsInUse - wordsInCommon);
        }
        this.checkInvariants();
    }

    public final int getSize() {
        return this.words.length * 64;
    }

    @Override
    @NotNull
    public BitSetEx clone() {
        long[] lArray = this.words;
        boolean bl = false;
        long[] lArray2 = Arrays.copyOf(lArray, lArray.length);
        Intrinsics.checkNotNullExpressionValue((Object)lArray2, (String)"java.util.Arrays.copyOf(this, size)");
        return new BitSetEx(lArray2, this.wordsInUse);
    }

    @NotNull
    public String toString() {
        this.checkInvariants();
        int numBits = this.wordsInUse > 128 ? this.getCardinality() : this.wordsInUse * 64;
        StringBuilder b = new StringBuilder(6 * numBits + 2);
        b.append('{');
        int i = this.nextSetBit(0);
        if (i != -1) {
            b.append(i);
            while (++i >= 0 && (i = this.nextSetBit(i)) >= 0) {
                int endOfRun = this.nextClearBit(i);
                do {
                    b.append(", ").append(i);
                } while (++i != endOfRun);
            }
        }
        b.append('}');
        String string = b.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"b.toString()");
        return string;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004H\u0002J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lkd/bos/olapServer/collections/BitSetEx$Companion;", "", "()V", "ADDRESS_BITS_PER_WORD", "", "BITS_PER_WORD", "WORD_MASK", "", "initWords", "", "bitSize", "wordIndex", "bitIndex", "bos-olap-core"})
    public static final class Companion {
        private Companion() {
        }

        private final long[] initWords(int bitSize) {
            return new long[this.wordIndex(bitSize - 1) + 1];
        }

        private final int wordIndex(int bitIndex) {
            return bitIndex >> 6;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

