/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.common;

import java.util.concurrent.CancellationException;
import kd.bos.olapServer.common.CommonTypesKt;
import kd.bos.olapServer.common.ICancellable;
import kd.bos.olapServer.common.IContinueToken;
import kd.bos.olapServer.common.OlapContext;
import kd.bos.olapServer.tools.Res;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0005\u0018\u0019\u001a\u001b\u001cB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u0006\u0010\u0005\u001a\u00020\u0006JM\u0010\u0007\u001a\u0002H\b\"\u0004\b\u0000\u0010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\b0\n2\u001a\b\u0002\u0010\u000b\u001a\u0014\u0012\b\u0012\u00060\rj\u0002`\u000e\u0012\u0004\u0012\u0002H\b\u0018\u00010\f2\u0010\b\u0002\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\n\u00a2\u0006\u0002\u0010\u0011J\f\u0010\u0012\u001a\u00020\u0010*\u00020\u0004H\u0002J\n\u0010\u0013\u001a\u00020\u0006*\u00020\u0004J\u0018\u0010\u0014\u001a\u00020\u0006*\u00020\u00042\f\b\u0002\u0010\u0015\u001a\u00060\u0016j\u0002`\u0017\u00a8\u0006\u001d"}, d2={"Lkd/bos/olapServer/common/CancellableToken;", "", "()V", "createCancellable", "Lkd/bos/olapServer/common/ICancellable;", "getContinueToken", "Lkd/bos/olapServer/common/IContinueToken;", "withCancellable", "R", "body", "Lkotlin/Function0;", "catchBody", "Lkotlin/Function1;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "finallyBody", "", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "throwException", "toContinueToken", "withTimeout", "timeout", "", "Lkd/bos/olapServer/common/long;", "Cancellable", "ContinueTokenProxy", "EmptyContinueToken", "LazyToken", "TimeoutToken", "bos-olap-core"})
public final class CancellableToken {
    @NotNull
    public static final CancellableToken INSTANCE = new CancellableToken();

    private CancellableToken() {
    }

    @NotNull
    public final IContinueToken getContinueToken() {
        IContinueToken current = OlapContext.Companion.tryGetContext(IContinueToken.class);
        ICancellable currentCancelToken = OlapContext.Companion.tryGetContext(ICancellable.class);
        return current == null ? (currentCancelToken == null ? (IContinueToken)EmptyContinueToken.INSTANCE : this.toContinueToken(currentCancelToken)) : (currentCancelToken == null ? current : (IContinueToken)new LazyToken(current, currentCancelToken));
    }

    @NotNull
    public final ICancellable createCancellable() {
        return new Cancellable();
    }

    @NotNull
    public final IContinueToken withTimeout(@NotNull ICancellable $this$withTimeout, long timeout) {
        Intrinsics.checkNotNullParameter((Object)$this$withTimeout, (String)"<this>");
        return new TimeoutToken(timeout, $this$withTimeout);
    }

    public static /* synthetic */ IContinueToken withTimeout$default(CancellableToken cancellableToken, ICancellable iCancellable, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = CommonTypesKt.getComputingTimeOut();
        }
        return cancellableToken.withTimeout(iCancellable, l);
    }

    @NotNull
    public final IContinueToken toContinueToken(@NotNull ICancellable $this$toContinueToken) {
        Intrinsics.checkNotNullParameter((Object)$this$toContinueToken, (String)"<this>");
        return new ContinueTokenProxy($this$toContinueToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <R> R withCancellable(@NotNull Function0<? extends R> body, @Nullable Function1<? super Exception, ? extends R> catchBody, @Nullable Function0<Unit> finallyBody) {
        Object object;
        Intrinsics.checkNotNullParameter(body, (String)"body");
        ICancellable ct = OlapContext.Companion.tryGetContext(ICancellable.class);
        ICancellable cancelToken = null;
        ICancellable myCt = null;
        if (ct == null) {
            cancelToken = myCt = this.createCancellable();
            OlapContext.Companion.push(myCt);
        } else {
            myCt = null;
            cancelToken = ct;
        }
        try {
            Object result = body.invoke();
            Function0<Unit> ex = cancelToken.getException();
            if (ex != null) {
                throw ex;
            }
            object = result;
        }
        catch (Exception ex) {
            cancelToken.cancel(ex);
            Function1<? super Exception, ? extends R> function1 = catchBody;
            if (function1 != null) {
                function1.invoke((Object)ex);
            }
            throw ex;
        }
        finally {
            Function0<Unit> function0;
            if (myCt != null) {
                OlapContext.Companion.pop(myCt);
            }
            if ((function0 = finallyBody) != null) {
                function0.invoke();
            }
        }
        return (R)object;
    }

    public static /* synthetic */ Object withCancellable$default(CancellableToken cancellableToken, Function0 function0, Function1 function1, Function0 function02, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        if ((n & 4) != 0) {
            function02 = null;
        }
        return cancellableToken.withCancellable(function0, function1, (Function0<Unit>)function02);
    }

    private final void throwException(ICancellable $this$throwException) {
        Exception ex = $this$throwException.getException();
        int checkCount = 0;
        while (ex == null) {
            ex = $this$throwException.getException();
            int n = checkCount;
            if ((checkCount = n + 1) != Integer.MAX_VALUE) continue;
            String string = Res.INSTANCE.getCancelCommadException_1();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Res.CancelCommadException_1");
            ex = new CancellationException(Res.INSTANCE.format(string, new Object[0]));
        }
        throw ex;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u00060\u0004j\u0002`\u0005H\u0016R\u0016\u0010\u0003\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\u00060\nj\u0002`\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\f\u00a8\u0006\u0010"}, d2={"Lkd/bos/olapServer/common/CancellableToken$Cancellable;", "Lkd/bos/olapServer/common/ICancellable;", "()V", "_ex", "Ljava/lang/Exception;", "Lkotlin/Exception;", "exception", "getException", "()Ljava/lang/Exception;", "isCancel", "", "Lkd/bos/olapServer/common/bool;", "()Z", "cancel", "", "ex", "bos-olap-core"})
    private static final class Cancellable
    implements ICancellable {
        @Nullable
        private Exception _ex;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel(@NotNull Exception ex) {
            Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
            boolean bl = false;
            boolean bl2 = false;
            synchronized (this) {
                boolean bl3 = false;
                if (this._ex == null) {
                    this._ex = ex;
                }
                Unit unit = Unit.INSTANCE;
            }
        }

        @Override
        @Nullable
        public Exception getException() {
            return this._ex;
        }

        @Override
        public boolean isCancel() {
            return this._ex != null;
        }

        @Override
        public void cancel() {
            ICancellable.DefaultImpls.cancel(this);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\f\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lkd/bos/olapServer/common/CancellableToken$ContinueTokenProxy;", "Lkd/bos/olapServer/common/IContinueToken;", "parent", "Lkd/bos/olapServer/common/ICancellable;", "(Lkd/bos/olapServer/common/ICancellable;)V", "canContinue", "", "Lkd/bos/olapServer/common/bool;", "bos-olap-core"})
    private static final class ContinueTokenProxy
    implements IContinueToken {
        @NotNull
        private final ICancellable parent;

        public ContinueTokenProxy(@NotNull ICancellable parent) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            this.parent = parent;
        }

        @Override
        public boolean canContinue() {
            if (this.parent.isCancel()) {
                INSTANCE.throwException(this.parent);
            }
            return true;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\f\u0010\t\u001a\u00060\nj\u0002`\u000bH\u0016R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lkd/bos/olapServer/common/CancellableToken$TimeoutToken;", "Lkd/bos/olapServer/common/IContinueToken;", "timeOut", "", "Lkd/bos/olapServer/common/long;", "cancellable", "Lkd/bos/olapServer/common/ICancellable;", "(JLkd/bos/olapServer/common/ICancellable;)V", "_timeOutStamp", "canContinue", "", "Lkd/bos/olapServer/common/bool;", "bos-olap-core"})
    private static final class TimeoutToken
    implements IContinueToken {
        private final long timeOut;
        @NotNull
        private final ICancellable cancellable;
        private long _timeOutStamp;

        public TimeoutToken(long timeOut, @NotNull ICancellable cancellable) {
            Intrinsics.checkNotNullParameter((Object)cancellable, (String)"cancellable");
            this.timeOut = timeOut;
            this.cancellable = cancellable;
            this._timeOutStamp = this.timeOut > 0L ? System.nanoTime() + this.timeOut * (long)1000000000 : -1L;
        }

        @Override
        public boolean canContinue() {
            if (this._timeOutStamp > 0L && System.nanoTime() > this._timeOutStamp) {
                this._timeOutStamp = -2L;
                Object[] objectArray = Res.INSTANCE.getComputingContextException_1();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.ComputingContextException_1");
                Object[] objectArray2 = objectArray;
                objectArray = new Object[]{this.timeOut, ""};
                CancellationException ex = new CancellationException(Res.INSTANCE.format((String)objectArray2, objectArray));
                this.cancellable.cancel(ex);
                throw ex;
            }
            return true;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\f\u0010\b\u001a\u00060\tj\u0002`\nH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lkd/bos/olapServer/common/CancellableToken$LazyToken;", "Lkd/bos/olapServer/common/IContinueToken;", "parent", "cancellable", "Lkd/bos/olapServer/common/ICancellable;", "(Lkd/bos/olapServer/common/IContinueToken;Lkd/bos/olapServer/common/ICancellable;)V", "_checkCount", "", "canContinue", "", "Lkd/bos/olapServer/common/bool;", "bos-olap-core"})
    private static final class LazyToken
    implements IContinueToken {
        @NotNull
        private final IContinueToken parent;
        @NotNull
        private final ICancellable cancellable;
        private int _checkCount;

        public LazyToken(@NotNull IContinueToken parent, @NotNull ICancellable cancellable) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            Intrinsics.checkNotNullParameter((Object)cancellable, (String)"cancellable");
            this.parent = parent;
            this.cancellable = cancellable;
        }

        @Override
        public boolean canContinue() {
            boolean bl;
            if (this.cancellable.isCancel()) {
                INSTANCE.throwException(this.cancellable);
            }
            LazyToken lazyToken = this;
            int n = lazyToken._checkCount;
            lazyToken._checkCount = n + 1;
            if (n > 100000) {
                this._checkCount = 0;
                bl = this.parent.canContinue();
            } else {
                bl = true;
            }
            return bl;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lkd/bos/olapServer/common/CancellableToken$EmptyContinueToken;", "Lkd/bos/olapServer/common/IContinueToken;", "()V", "canContinue", "", "Lkd/bos/olapServer/common/bool;", "bos-olap-core"})
    private static final class EmptyContinueToken
    implements IContinueToken {
        @NotNull
        public static final EmptyContinueToken INSTANCE = new EmptyContinueToken();

        private EmptyContinueToken() {
        }

        @Override
        public boolean canContinue() {
            return true;
        }
    }
}

