/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.computingEngine;

import kd.bos.olapServer.collections.IImmutableListBoolean;
import kd.bos.olapServer.collections.IIterator;
import kd.bos.olapServer.common.CommonTypesKt;
import kd.bos.olapServer.common.NotSupportedException;
import kd.bos.olapServer.computingEngine.AggShieldRuleMasker;
import kd.bos.olapServer.computingEngine.batchTasks.SimpleRowKey;
import kd.bos.olapServer.computingEngine.multiDimensionAgg.AggFactor;
import kd.bos.olapServer.computingEngine.multiDimensionAgg.AggOperators;
import kd.bos.olapServer.computingEngine.multiDimensionAgg.Axis;
import kd.bos.olapServer.computingEngine.multiDimensionAgg.MultiDimensionAggComputingUnit;
import kd.bos.olapServer.computingEngine.multiDimensionAgg.MultiDimensionAggUnit;
import kd.bos.olapServer.metadata.Dimension;
import kd.bos.olapServer.metadata.Member;
import kd.bos.olapServer.metadata.MemberCollection;
import kd.bos.olapServer.metadata.MemberStorageTypes;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b \u0018\u0000 \u00102\u00020\u0001:\n\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u000e\u001a\u00020\u000fH\u0004R\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lkd/bos/olapServer/computingEngine/AbstractMultiDimensionAggMapper;", "", "unit", "Lkd/bos/olapServer/computingEngine/multiDimensionAgg/MultiDimensionAggComputingUnit;", "ruleMasker", "Lkd/bos/olapServer/computingEngine/AggShieldRuleMasker;", "isDynamicCalc", "", "Lkd/bos/olapServer/common/bool;", "(Lkd/bos/olapServer/computingEngine/multiDimensionAgg/MultiDimensionAggComputingUnit;Lkd/bos/olapServer/computingEngine/AggShieldRuleMasker;Z)V", "_mapTables", "", "Lkd/bos/olapServer/computingEngine/AbstractMultiDimensionAggMapper$MapTable;", "[Lkd/bos/olapServer/computingEngine/AbstractMultiDimensionAggMapper$MapTable;", "createMapRowIteratorBuilderCore", "Lkd/bos/olapServer/computingEngine/AbstractMultiDimensionAggMapper$IMapRowIteratorBuilder;", "Companion", "EmptyMapRowIterator", "IMapRowIterator", "IMapRowIteratorBuilder", "MapRow", "MapRowIterator", "MapRowIteratorBuilder", "MapTable", "OneMapRowIterator", "Step", "bos-olap-core"})
public abstract class AbstractMultiDimensionAggMapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AggShieldRuleMasker ruleMasker;
    @NotNull
    private final MapTable[] _mapTables;
    @NotNull
    private static final MapRow emptyMapRow = new MapRow(-1, AggOperators.PLUS, false);
    @NotNull
    private static final MapRow[] emptyMapRowArray = new MapRow[0];

    public AbstractMultiDimensionAggMapper(@NotNull MultiDimensionAggComputingUnit unit, @NotNull AggShieldRuleMasker ruleMasker, boolean isDynamicCalc) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        Intrinsics.checkNotNullParameter((Object)ruleMasker, (String)"ruleMasker");
        this.ruleMasker = ruleMasker;
        int n = 0;
        int n2 = unit.getAxes().size();
        MapTable[] mapTableArray = new MapTable[n2];
        AbstractMultiDimensionAggMapper abstractMultiDimensionAggMapper = this;
        while (n < n2) {
            int n3 = n++;
            mapTableArray[n3] = new MapTable(unit.getAxes().get(n3), isDynamicCalc);
        }
        abstractMultiDimensionAggMapper._mapTables = mapTableArray;
    }

    @NotNull
    protected final IMapRowIteratorBuilder createMapRowIteratorBuilderCore() {
        return new MapRowIteratorBuilder(this.ruleMasker.clone());
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lkd/bos/olapServer/computingEngine/AbstractMultiDimensionAggMapper$MapRowIteratorBuilder;", "Lkd/bos/olapServer/computingEngine/AbstractMultiDimensionAggMapper$IMapRowIteratorBuilder;", "ruleMasker", "Lkd/bos/olapServer/computingEngine/AggShieldRuleMasker;", "(Lkd/bos/olapServer/computingEngine/AbstractMultiDimensionAggMapper;Lkd/bos/olapServer/computingEngine/AggShieldRuleMasker;)V", "_oneSeqItr", "Lkd/bos/olapServer/computingEngine/AbstractMultiDimensionAggMapper$OneMapRowIterator;", "_seqItr", "Lkd/bos/olapServer/computingEngine/AbstractMultiDimensionAggMapper$MapRowIterator;", "createIterator", "Lkd/bos/olapServer/computingEngine/AbstractMultiDimensionAggMapper$IMapRowIterator;", "rowKey", "Lkd/bos/olapServer/computingEngine/batchTasks/SimpleRowKey;", "bos-olap-core"})
    private final class MapRowIteratorBuilder
    implements IMapRowIteratorBuilder {
        @NotNull
        private final AggShieldRuleMasker ruleMasker;
        @NotNull
        private final MapRowIterator _seqItr;
        @NotNull
        private final OneMapRowIterator _oneSeqItr;

        public MapRowIteratorBuilder(AggShieldRuleMasker ruleMasker) {
            Intrinsics.checkNotNullParameter((Object)AbstractMultiDimensionAggMapper.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)ruleMasker, (String)"ruleMasker");
            this.ruleMasker = ruleMasker;
            int n = 0;
            int n2 = AbstractMultiDimensionAggMapper.this._mapTables.length;
            Step[] stepArray = new Step[n2];
            MapRowIteratorBuilder mapRowIteratorBuilder = this;
            while (n < n2) {
                int n3 = n++;
                stepArray[n3] = new Step(AbstractMultiDimensionAggMapper.this._mapTables[n3].getDimensionPosition());
            }
            Step[] stepArray2 = stepArray;
            mapRowIteratorBuilder._seqItr = new MapRowIterator(stepArray2);
            this._oneSeqItr = new OneMapRowIterator();
        }

        @Override
        @NotNull
        public IMapRowIterator createIterator(@NotNull SimpleRowKey rowKey) {
            boolean isStored;
            Intrinsics.checkNotNullParameter((Object)rowKey, (String)"rowKey");
            int[] targetKeyArray = rowKey.getArray();
            IImmutableListBoolean aggRule = this.ruleMasker.getAggMask(rowKey);
            int n = 0;
            int n2 = AbstractMultiDimensionAggMapper.this._mapTables.length;
            if (n < n2) {
                do {
                    int i = n++;
                    MapTable table = AbstractMultiDimensionAggMapper.this._mapTables[i];
                    int dimensionPosition = table.getDimensionPosition();
                    int memberPosition = targetKeyArray[dimensionPosition];
                    MapRow[] mapRowArray = table.getMapToTarget()[memberPosition];
                    if (mapRowArray == null) {
                        throw new RuntimeException(rowKey + " at " + dimensionPosition + " value is " + memberPosition + " .");
                    }
                    MapRow[] maps = mapRowArray;
                    Step step = this._seqItr.getSteps()[i];
                    step.reset(maps, targetKeyArray);
                    if (aggRule.get(dimensionPosition) || !step.shieldAgg()) continue;
                    return EmptyMapRowIterator.INSTANCE;
                } while (n < n2);
            }
            this._seqItr.reset(targetKeyArray, !(isStored = this._seqItr.isStored()));
            return this._seqItr.getOnlyOneRow() ? (this._seqItr.next() ? this._oneSeqItr.reset(this._seqItr.getOperator(), isStored) : (IMapRowIterator)EmptyMapRowIterator.INSTANCE) : (IMapRowIterator)this._seqItr;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b`\u0018\u00002\u00020\u0001R\u0016\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lkd/bos/olapServer/computingEngine/AbstractMultiDimensionAggMapper$IMapRowIterator;", "Lkd/bos/olapServer/collections/IIterator;", "isStored", "", "Lkd/bos/olapServer/common/bool;", "()Z", "operator", "Lkd/bos/olapServer/computingEngine/multiDimensionAgg/AggOperators;", "getOperator", "()Lkd/bos/olapServer/computingEngine/multiDimensionAgg/AggOperators;", "bos-olap-core"})
    public static interface IMapRowIterator
    extends IIterator {
        @NotNull
        public AggOperators getOperator();

        public boolean isStored();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b`\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lkd/bos/olapServer/computingEngine/AbstractMultiDimensionAggMapper$IMapRowIteratorBuilder;", "", "createIterator", "Lkd/bos/olapServer/computingEngine/AbstractMultiDimensionAggMapper$IMapRowIterator;", "rowKey", "Lkd/bos/olapServer/computingEngine/batchTasks/SimpleRowKey;", "bos-olap-core"})
    public static interface IMapRowIteratorBuilder {
        @NotNull
        public IMapRowIterator createIterator(@NotNull SimpleRowKey var1);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\f\u0010\u0015\u001a\u00060\u0007j\u0002`\bH\u0016J\u001a\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00142\n\u0010\u0019\u001a\u00060\u0007j\u0002`\bR\u0018\u0010\u0006\u001a\u00060\u0007j\u0002`\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\tR\u0015\u0010\n\u001a\u00060\u0007j\u0002`\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0019\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lkd/bos/olapServer/computingEngine/AbstractMultiDimensionAggMapper$MapRowIterator;", "Lkd/bos/olapServer/computingEngine/AbstractMultiDimensionAggMapper$IMapRowIterator;", "steps", "", "Lkd/bos/olapServer/computingEngine/AbstractMultiDimensionAggMapper$Step;", "([Lkd/bos/olapServer/computingEngine/AbstractMultiDimensionAggMapper$Step;)V", "isStored", "", "Lkd/bos/olapServer/common/bool;", "()Z", "onlyOneRow", "getOnlyOneRow", "operator", "Lkd/bos/olapServer/computingEngine/multiDimensionAgg/AggOperators;", "getOperator", "()Lkd/bos/olapServer/computingEngine/multiDimensionAgg/AggOperators;", "getSteps", "()[Lkd/bos/olapServer/computingEngine/AbstractMultiDimensionAggMapper$Step;", "[Lkd/bos/olapServer/computingEngine/AbstractMultiDimensionAggMapper$Step;", "target", "", "next", "reset", "", "targetKeyArray", "resetLastStep", "bos-olap-core"})
    private static final class MapRowIterator
    implements IMapRowIterator {
        @NotNull
        private final Step[] steps;
        @NotNull
        private int[] target;

        public MapRowIterator(@NotNull Step[] steps) {
            Intrinsics.checkNotNullParameter((Object)steps, (String)"steps");
            this.steps = steps;
            this.target = new int[0];
        }

        @NotNull
        public final Step[] getSteps() {
            return this.steps;
        }

        @Override
        public boolean next() {
            int stepIndex = this.steps.length - 1;
            while (stepIndex >= 0) {
                if (this.steps[stepIndex].addNext(this.target)) {
                    int n = stepIndex;
                    stepIndex = n + -1;
                    continue;
                }
                return true;
            }
            return false;
        }

        @Override
        @NotNull
        public AggOperators getOperator() {
            AggOperators result = AggOperators.PLUS;
            Step[] stepArray = this.steps;
            int n = 0;
            int n2 = stepArray.length;
            while (n < n2) {
                Step step = stepArray[n];
                ++n;
                result = result.xor(step.getCurrentOperator());
            }
            return result;
        }

        public final boolean getOnlyOneRow() {
            for (Step step : this.steps) {
                if (step.getOnlyOneRow()) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isStored() {
            for (Step step : this.steps) {
                if (step.isStored()) continue;
                return false;
            }
            return true;
        }

        public final void reset(@NotNull int[] targetKeyArray, boolean resetLastStep) {
            Intrinsics.checkNotNullParameter((Object)targetKeyArray, (String)"targetKeyArray");
            this.target = targetKeyArray;
            if (resetLastStep) {
                this.steps[this.steps.length - 1].resetLastStep();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u000e\u001a\u00060\u0004j\u0002`\tH\u0016J\u001a\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00072\n\u0010\b\u001a\u00060\u0004j\u0002`\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\u00060\u0004j\u0002`\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\nR\u0014\u0010\u000b\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0011"}, d2={"Lkd/bos/olapServer/computingEngine/AbstractMultiDimensionAggMapper$OneMapRowIterator;", "Lkd/bos/olapServer/computingEngine/AbstractMultiDimensionAggMapper$IMapRowIterator;", "()V", "_hasValue", "", "_isStored", "_operator", "Lkd/bos/olapServer/computingEngine/multiDimensionAgg/AggOperators;", "isStored", "Lkd/bos/olapServer/common/bool;", "()Z", "operator", "getOperator", "()Lkd/bos/olapServer/computingEngine/multiDimensionAgg/AggOperators;", "next", "reset", "opt", "bos-olap-core"})
    private static final class OneMapRowIterator
    implements IMapRowIterator {
        @NotNull
        private AggOperators _operator = AggOperators.PLUS;
        private boolean _isStored;
        private boolean _hasValue;

        @Override
        @NotNull
        public AggOperators getOperator() {
            return this._operator;
        }

        @Override
        public boolean isStored() {
            return this._isStored;
        }

        @Override
        public boolean next() {
            if (this._hasValue) {
                this._hasValue = false;
                return true;
            }
            return false;
        }

        @NotNull
        public final IMapRowIterator reset(@NotNull AggOperators opt, boolean isStored) {
            Intrinsics.checkNotNullParameter((Object)((Object)opt), (String)"opt");
            this._hasValue = true;
            this._operator = opt;
            this._isStored = isStored;
            return this;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c4\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u000b\u001a\u00060\u0004j\u0002`\u0005H\u0016R\u0018\u0010\u0003\u001a\u00060\u0004j\u0002`\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Lkd/bos/olapServer/computingEngine/AbstractMultiDimensionAggMapper$EmptyMapRowIterator;", "Lkd/bos/olapServer/computingEngine/AbstractMultiDimensionAggMapper$IMapRowIterator;", "()V", "isStored", "", "Lkd/bos/olapServer/common/bool;", "()Z", "operator", "Lkd/bos/olapServer/computingEngine/multiDimensionAgg/AggOperators;", "getOperator", "()Lkd/bos/olapServer/computingEngine/multiDimensionAgg/AggOperators;", "next", "bos-olap-core"})
    protected static final class EmptyMapRowIterator
    implements IMapRowIterator {
        @NotNull
        public static final EmptyMapRowIterator INSTANCE = new EmptyMapRowIterator();

        private EmptyMapRowIterator() {
        }

        @Override
        @NotNull
        public AggOperators getOperator() {
            throw new NotSupportedException();
        }

        @Override
        public boolean isStored() {
            throw new NotSupportedException();
        }

        @Override
        public boolean next() {
            return false;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0015\u001a\u00020\u0016H\u0016J3\u0010\u0017\u001a\u00020\u0018*\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00100\u00102\n\u0010\u0019\u001a\u00060\u000bj\u0002`\f2\u0006\u0010\u001a\u001a\u00020\u0011H\u0002\u00a2\u0006\u0002\u0010\u001bJ\u0010\u0010\u001c\u001a\u00060\u0016j\u0002`\u001d*\u00020\u001eH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\n\u001a\u00060\u000bj\u0002`\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR!\u0010\u000f\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00100\u0010\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001f"}, d2={"Lkd/bos/olapServer/computingEngine/AbstractMultiDimensionAggMapper$MapTable;", "", "axis", "Lkd/bos/olapServer/computingEngine/multiDimensionAgg/Axis;", "isDynamicCalc", "", "Lkd/bos/olapServer/common/bool;", "(Lkd/bos/olapServer/computingEngine/multiDimensionAgg/Axis;Z)V", "dimension", "Lkd/bos/olapServer/metadata/Dimension;", "dimensionPosition", "", "Lkd/bos/olapServer/common/int;", "getDimensionPosition", "()I", "mapToTarget", "", "Lkd/bos/olapServer/computingEngine/AbstractMultiDimensionAggMapper$MapRow;", "getMapToTarget", "()[[Lkd/bos/olapServer/computingEngine/AbstractMultiDimensionAggMapper$MapRow;", "[[Lkd/bos/olapServer/computingEngine/AbstractMultiDimensionAggMapper$MapRow;", "toString", "", "add", "", "memberPosition", "row", "([[Lkd/bos/olapServer/computingEngine/AbstractMultiDimensionAggMapper$MapRow;ILkd/bos/olapServer/computingEngine/AbstractMultiDimensionAggMapper$MapRow;)V", "getMemberName", "Lkd/bos/olapServer/common/string;", "Lkd/bos/olapServer/metadata/Member;", "bos-olap-core"})
    private static final class MapTable {
        private final int dimensionPosition;
        @NotNull
        private final MapRow[][] mapToTarget;
        @NotNull
        private final Dimension dimension;

        public MapTable(@NotNull Axis axis, boolean isDynamicCalc) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)axis, (String)"axis");
            this.dimensionPosition = axis.getDimension().getPosition();
            this.mapToTarget = new MapRow[axis.getDimension().getMembers().getCount()][];
            this.dimension = axis.getDimension();
            for (Member fixedMember : axis.getFixedMembers()) {
                boolean bl2 = !CommonTypesKt.getDynamicCalcEnabled() || fixedMember.getStorageType() == MemberStorageTypes.Stored;
                boolean bl3 = false;
                boolean bl4 = false;
                bl4 = false;
                bl = false;
                if (!bl2) {
                    boolean bl5 = false;
                    String string = "Failed requirement.";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                int memberPosition = fixedMember.getPosition$bos_olap_core();
                this.add(this.mapToTarget, memberPosition, new MapRow(memberPosition, AggOperators.PLUS, true));
            }
            for (MultiDimensionAggUnit unit : axis.getUnits()) {
                int targetPosition = unit.getTarget().getPosition$bos_olap_core();
                for (AggFactor elem : unit.getFactors()) {
                    bl = !CommonTypesKt.getDynamicCalcEnabled() || elem.getFactor().getStorageType() == MemberStorageTypes.Stored;
                    boolean bl6 = false;
                    boolean bl7 = false;
                    bl7 = false;
                    boolean bl8 = false;
                    if (!bl) {
                        boolean bl9 = false;
                        String string = "Failed requirement.";
                        throw (Throwable)new IllegalArgumentException(string.toString());
                    }
                    this.add(this.mapToTarget, elem.getFactor().getPosition$bos_olap_core(), new MapRow(targetPosition, elem.getOperator(), false));
                }
                if (!isDynamicCalc) continue;
                this.add(this.mapToTarget, targetPosition, new MapRow(targetPosition, AggOperators.PLUS, true));
            }
        }

        public final int getDimensionPosition() {
            return this.dimensionPosition;
        }

        @NotNull
        public final MapRow[][] getMapToTarget() {
            return this.mapToTarget;
        }

        private final void add(MapRow[][] $this$add, int memberPosition, MapRow row) {
            Object[] list = $this$add[memberPosition];
            if (list == null) {
                MapRow[] mapRowArray = new MapRow[]{row};
                $this$add[memberPosition] = mapRowArray;
            } else {
                $this$add[memberPosition] = (MapRow[])ArraysKt.plus((Object[])list, (Object)row);
            }
        }

        @NotNull
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.dimension.getName() + '[' + this.dimension.getPosition() + "]:");
            MemberCollection members2 = this.dimension.getMembers();
            int n = 0;
            int n2 = ((Object[])this.mapToTarget).length;
            if (n < n2) {
                do {
                    int i;
                    Object[] mapRows;
                    if ((mapRows = this.mapToTarget[i = n++]) == null) continue;
                    sb.append(' ' + this.getMemberName((Member)members2.get(i)) + ":{");
                    sb.append(ArraysKt.joinToString$default((Object[])mapRows, null, null, null, (int)0, null, (Function1)((Function1)new Function1<MapRow, CharSequence>(this, members2){
                        final /* synthetic */ MapTable this$0;
                        final /* synthetic */ MemberCollection $members;
                        {
                            this.this$0 = $receiver;
                            this.$members = $members;
                            super(1);
                        }

                        @NotNull
                        public final CharSequence invoke(@NotNull MapRow it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            return (it.isStored() ? "*" : "") + MapTable.access$getMemberName(this.this$0, (Member)this.$members.get(it.getMemberPosition())) + (it.getOperator() == AggOperators.PLUS ? "" : String.valueOf(it.getOperator().getCode()));
                        }
                    }), (int)31, null));
                    sb.append("}");
                } while (n < n2);
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
            return string;
        }

        private final String getMemberName(Member $this$getMemberName) {
            return $this$getMemberName.getName() + '[' + $this$getMemberName.getPosition$bos_olap_core() + ']';
        }

        public static final /* synthetic */ String access$getMemberName(MapTable $this, Member $receiver) {
            return $this.getMemberName($receiver);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B%\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\u0010\u0007\u001a\u00060\bj\u0002`\t\u00a2\u0006\u0002\u0010\nR\u0015\u0010\u0007\u001a\u00060\bj\u0002`\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u000bR\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lkd/bos/olapServer/computingEngine/AbstractMultiDimensionAggMapper$MapRow;", "", "memberPosition", "", "Lkd/bos/olapServer/common/int;", "operator", "Lkd/bos/olapServer/computingEngine/multiDimensionAgg/AggOperators;", "isStored", "", "Lkd/bos/olapServer/common/bool;", "(ILkd/bos/olapServer/computingEngine/multiDimensionAgg/AggOperators;Z)V", "()Z", "getMemberPosition", "()I", "getOperator", "()Lkd/bos/olapServer/computingEngine/multiDimensionAgg/AggOperators;", "bos-olap-core"})
    private static final class MapRow {
        private final int memberPosition;
        @NotNull
        private final AggOperators operator;
        private final boolean isStored;

        public MapRow(int memberPosition, @NotNull AggOperators operator, boolean isStored) {
            Intrinsics.checkNotNullParameter((Object)((Object)operator), (String)"operator");
            this.memberPosition = memberPosition;
            this.operator = operator;
            this.isStored = isStored;
        }

        public final int getMemberPosition() {
            return this.memberPosition;
        }

        @NotNull
        public final AggOperators getOperator() {
            return this.operator;
        }

        public final boolean isStored() {
            return this.isStored;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\u0019\u001a\u00060\u0010j\u0002`\u00112\u0006\u0010\u001a\u001a\u00020\u001bJ!\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\b0\u00172\u0006\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\u0002\u0010\u001fJ\u0006\u0010 \u001a\u00020\u001dJ\n\u0010!\u001a\u00060\u0010j\u0002`\u0011R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0015\u0010\u000f\u001a\u00060\u0010j\u0002`\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u000e\u0010\u0015\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u0017X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0018\u00a8\u0006\""}, d2={"Lkd/bos/olapServer/computingEngine/AbstractMultiDimensionAggMapper$Step;", "", "dimensionPosition", "", "Lkd/bos/olapServer/common/int;", "(I)V", "currentIndex", "currentMapRow", "Lkd/bos/olapServer/computingEngine/AbstractMultiDimensionAggMapper$MapRow;", "currentOperator", "Lkd/bos/olapServer/computingEngine/multiDimensionAgg/AggOperators;", "getCurrentOperator", "()Lkd/bos/olapServer/computingEngine/multiDimensionAgg/AggOperators;", "getDimensionPosition", "()I", "isStored", "", "Lkd/bos/olapServer/common/bool;", "()Z", "onlyOneRow", "getOnlyOneRow", "size", "values", "", "[Lkd/bos/olapServer/computingEngine/AbstractMultiDimensionAggMapper$MapRow;", "addNext", "target", "", "reset", "", "newValues", "([Lkd/bos/olapServer/computingEngine/AbstractMultiDimensionAggMapper$MapRow;[I)V", "resetLastStep", "shieldAgg", "bos-olap-core"})
    private static final class Step {
        private final int dimensionPosition;
        @NotNull
        private MapRow[] values;
        private int currentIndex;
        @NotNull
        private MapRow currentMapRow;
        private int size;

        public Step(int dimensionPosition) {
            this.dimensionPosition = dimensionPosition;
            this.values = emptyMapRowArray;
            this.currentIndex = -1;
            this.currentMapRow = emptyMapRow;
        }

        public final int getDimensionPosition() {
            return this.dimensionPosition;
        }

        @NotNull
        public final AggOperators getCurrentOperator() {
            return this.currentMapRow.getOperator();
        }

        public final boolean isStored() {
            return this.currentMapRow.isStored();
        }

        public final boolean getOnlyOneRow() {
            return this.values.length == 1;
        }

        public final void reset(@NotNull MapRow[] newValues, @NotNull int[] target) {
            MapRow rowMap;
            Intrinsics.checkNotNullParameter((Object)newValues, (String)"newValues");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            this.currentMapRow = rowMap = newValues[0];
            target[this.dimensionPosition] = rowMap.getMemberPosition();
            this.currentIndex = 0;
            this.values = newValues;
            this.size = newValues.length;
        }

        public final void resetLastStep() {
            this.currentIndex = -1;
        }

        public final boolean shieldAgg() {
            this.size = this.values[0].isStored() ? 1 : 0;
            return this.size == 0;
        }

        public final boolean addNext(@NotNull int[] target) {
            boolean bl;
            MapRow rowMap;
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            Step step = this;
            ++step.currentIndex;
            int index2 = step.currentIndex;
            if (index2 >= this.size) {
                index2 = 0;
                rowMap = this.values[index2];
                target[this.dimensionPosition] = rowMap.getMemberPosition();
                this.currentMapRow = rowMap;
                this.currentIndex = 0;
                bl = true;
            } else {
                rowMap = this.values[index2];
                target[this.dimensionPosition] = rowMap.getMemberPosition();
                this.currentMapRow = rowMap;
                bl = false;
            }
            return bl;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lkd/bos/olapServer/computingEngine/AbstractMultiDimensionAggMapper$Companion;", "", "()V", "emptyMapRow", "Lkd/bos/olapServer/computingEngine/AbstractMultiDimensionAggMapper$MapRow;", "emptyMapRowArray", "", "[Lkd/bos/olapServer/computingEngine/AbstractMultiDimensionAggMapper$MapRow;", "bos-olap-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

