/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.computingEngine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kd.bos.olapServer.collections.INumberSetFilter;
import kd.bos.olapServer.collections.MutableBitSet;
import kd.bos.olapServer.collections.NumberSetFilter;
import kd.bos.olapServer.common.CommonTypesKt;
import kd.bos.olapServer.common.NotSupportedException;
import kd.bos.olapServer.computingEngine.AggShieldRuleMasker;
import kd.bos.olapServer.computingEngine.DimensionFilterCollection;
import kd.bos.olapServer.computingEngine.IComputingUnit;
import kd.bos.olapServer.computingEngine.OverrideData;
import kd.bos.olapServer.computingEngine.StoredFilter;
import kd.bos.olapServer.computingEngine.multiDimensionAgg.AggFactor;
import kd.bos.olapServer.computingEngine.multiDimensionAgg.Axis;
import kd.bos.olapServer.computingEngine.multiDimensionAgg.MultiDimensionAggComputingUnit;
import kd.bos.olapServer.computingEngine.multiDimensionAgg.MultiDimensionAggUnit;
import kd.bos.olapServer.metadata.Cube;
import kd.bos.olapServer.metadata.Dimension;
import kd.bos.olapServer.metadata.DimensionCollection;
import kd.bos.olapServer.metadata.Member;
import kd.bos.olapServer.query.models.ContainerFilter;
import kd.bos.olapServer.query.models.DimensionFilter;
import kd.bos.olapServer.query.models.Filter;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u00014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0012\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J\u0010\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u001fH\u0002J\u0018\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$2\b\u0010!\u001a\u0004\u0018\u00010\u001fJ\u0016\u0010%\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020&2\u0006\u0010\u001e\u001a\u00020\u001dJ\u001c\u0010'\u001a\u00020\u001b2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020&0)2\u0006\u0010\u001e\u001a\u00020\u001dJ\u0018\u0010*\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$2\b\u0010!\u001a\u0004\u0018\u00010\u001fJ\u0016\u0010+\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/J\u0010\u00100\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020&H\u0002J\u001c\u00100\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$2\n\u00101\u001a\u000602j\u0002`3H\u0002R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u00065"}, d2={"Lkd/bos/olapServer/computingEngine/AggShieldRuleFilterBuilder;", "", "cube", "Lkd/bos/olapServer/metadata/Cube;", "(Lkd/bos/olapServer/metadata/Cube;)V", "_data", "", "Lkd/bos/olapServer/computingEngine/AggShieldRuleFilterBuilder$ScanData;", "[Lkd/bos/olapServer/computingEngine/AggShieldRuleFilterBuilder$ScanData;", "_hasSomeAggShieldRuleDimensions", "", "_masker", "Lkd/bos/olapServer/computingEngine/AggShieldRuleMasker;", "_storedFilter", "Lkd/bos/olapServer/computingEngine/StoredFilter;", "aggShieldRuleMasker", "getAggShieldRuleMasker", "()Lkd/bos/olapServer/computingEngine/AggShieldRuleMasker;", "dimensions", "Lkd/bos/olapServer/metadata/DimensionCollection;", "hasSomeAggShieldRuleDimensions", "getHasSomeAggShieldRuleDimensions", "()[I", "storedFilter", "getStoredFilter", "()Lkd/bos/olapServer/computingEngine/StoredFilter;", "scanFilter", "", "filters", "Lkd/bos/olapServer/computingEngine/DimensionFilterCollection;", "filter", "Lkd/bos/olapServer/query/models/Filter;", "scanFilterCore", "filer", "scanForDynamicCalc", "unit", "Lkd/bos/olapServer/computingEngine/multiDimensionAgg/MultiDimensionAggComputingUnit;", "scanForFullComputing", "Lkd/bos/olapServer/computingEngine/IComputingUnit;", "scanForLambda", "units", "", "scanForMultiDimensionAgg", "scanForSave", "dimension", "Lkd/bos/olapServer/metadata/Dimension;", "fixMember", "Lkd/bos/olapServer/metadata/Member;", "scanUnit", "isDynamicCalc", "", "Lkd/bos/olapServer/common/bool;", "ScanData", "bos-olap-core"})
public final class AggShieldRuleFilterBuilder {
    @NotNull
    private final DimensionCollection dimensions;
    @NotNull
    private final ScanData[] _data;
    @Nullable
    private StoredFilter _storedFilter;
    @Nullable
    private int[] _hasSomeAggShieldRuleDimensions;
    @Nullable
    private AggShieldRuleMasker _masker;

    public AggShieldRuleFilterBuilder(@NotNull Cube cube) {
        Intrinsics.checkNotNullParameter((Object)cube, (String)"cube");
        this.dimensions = cube.getDimensions();
        int n = 0;
        int n2 = this.dimensions.getCount();
        ScanData[] scanDataArray = new ScanData[n2];
        AggShieldRuleFilterBuilder aggShieldRuleFilterBuilder = this;
        while (n < n2) {
            int n3 = n++;
            scanDataArray[n3] = new ScanData((Dimension)this.dimensions.get(n3));
        }
        aggShieldRuleFilterBuilder._data = scanDataArray;
    }

    /*
     * WARNING - void declaration
     */
    private final void scanUnit(MultiDimensionAggComputingUnit unit, boolean isDynamicCalc) {
        Iterable $this$forEach$iv = unit.getAxes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            Collection<Member> collection;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Axis axis = (Axis)element$iv;
            boolean bl = false;
            ScanData dimData = this._data[axis.getDimension().getPosition()];
            Iterable iterable = axis.getUnits();
            boolean bl2 = isDynamicCalc;
            ScanData scanData = dimData;
            boolean $i$f$map = false;
            void var14_15 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                MultiDimensionAggUnit multiDimensionAggUnit = (MultiDimensionAggUnit)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl3 = false;
                Member member = it.getTarget();
                collection.add(member);
            }
            collection = (List)destination$iv$iv;
            scanData.scanAggMembers(bl2, (Iterable<? extends Member>)collection);
            dimData.scanStoredMembers((Iterable<? extends Member>)axis.getFixedMembers());
            if (!isDynamicCalc) continue;
            $this$map$iv = axis.getUnits();
            scanData = dimData;
            boolean $i$f$flatMap = false;
            $this$mapTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$mapTo$iv$iv2;
                MultiDimensionAggUnit muUnit = (MultiDimensionAggUnit)element$iv$iv;
                boolean bl4 = false;
                Iterable $this$map$iv2 = muUnit.getFactors();
                boolean $i$f$map2 = false;
                Iterable iterable2 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    AggFactor aggFactor = (AggFactor)item$iv$iv;
                    Collection collection2 = destination$iv$iv2;
                    boolean bl5 = false;
                    Member member = it.getFactor();
                    collection2.add(member);
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List list = (List)destination$iv$iv;
            scanData.scanStoredMembers(list);
        }
    }

    private final void scanUnit(IComputingUnit unit) {
        int n = 0;
        OverrideData target = unit.getTarget();
        int n2 = target.getCount();
        if (n < n2) {
            do {
                int i;
                int member;
                if ((member = target.get(i = n++)) < 0) continue;
                ScanData dimData = this._data[i];
                dimData.scanMember((Member)dimData.getDimension().getMembers().get(member));
            } while (n < n2);
        }
    }

    private final void scanFilter(Filter filter) {
        if (filter != null) {
            this.scanFilterCore(filter);
        }
    }

    private final void scanFilterCore(Filter filer) {
        Filter filter = filer;
        if (filter instanceof ContainerFilter) {
            if (filer.getHasChildren()) {
                Iterator<Filter> iterator = filer.getChildren();
                boolean bl = false;
                Iterator<Filter> iterator2 = iterator;
                while (iterator2.hasNext()) {
                    Filter child = iterator2.next();
                    this.scanFilterCore(child);
                }
            }
        } else if (filter instanceof DimensionFilter) {
            ScanData dimData = this._data[((DimensionFilter)filer).getDimension().getPosition()];
            for (Member member : ((DimensionFilter)filer).getMembers()) {
                dimData.scanMember(member);
            }
        } else {
            throw new NotSupportedException(filer + " is not supported ");
        }
    }

    @NotNull
    public final StoredFilter getStoredFilter() {
        StoredFilter result = this._storedFilter;
        if (result == null) {
            boolean bl = false;
            List isAggFilters = new ArrayList();
            MutableBitSet init2 = MutableBitSet.Companion.create$default(MutableBitSet.Companion, this.dimensions.getCount(), false, 2, null);
            ScanData[] scanDataArray = this._data;
            int n = 0;
            int n2 = scanDataArray.length;
            while (n < n2) {
                ScanData dimData = scanDataArray[n];
                ++n;
                int dimPosition = dimData.getDimension().getPosition();
                Pair<Boolean, INumberSetFilter> pair = dimData.tryCreateIsAggMemberFilter();
                boolean initValue = (Boolean)pair.component1();
                INumberSetFilter aggMemberFilter = (INumberSetFilter)pair.component2();
                if (initValue) {
                    init2.setTrue(dimPosition);
                }
                if (aggMemberFilter == null) continue;
                isAggFilters.add(new StoredFilter.IsAggMemberFilterPair(dimPosition, aggMemberFilter));
            }
            Collection $this$toTypedArray$iv = isAggFilters;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            StoredFilter.IsAggMemberFilterPair[] isAggMemberFilterPairArray = thisCollection$iv.toArray(new StoredFilter.IsAggMemberFilterPair[0]);
            if (isAggMemberFilterPairArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            this._storedFilter = result = new StoredFilter(this.dimensions, init2, isAggMemberFilterPairArray, this.getHasSomeAggShieldRuleDimensions());
        }
        return result;
    }

    private final void scanFilter(DimensionFilterCollection filters) {
        Collection collection = filters;
        boolean bl = false;
        if (!collection.isEmpty()) {
            for (DimensionFilter item : filters) {
                ScanData dimData = this._data[item.getDimension().getPosition()];
                for (Member member : item.getMembers()) {
                    dimData.scanMember(member);
                }
            }
        }
    }

    private final int[] getHasSomeAggShieldRuleDimensions() {
        int[] result = this._hasSomeAggShieldRuleDimensions;
        if (result == null) {
            boolean bl = false;
            List list = new ArrayList();
            for (ScanData dimData : this._data) {
                if (!dimData.getHasAggShieldRule()) continue;
                list.add(dimData.getDimension().getPosition());
            }
            int n = 0;
            int n2 = list.size();
            int[] nArray = new int[n2];
            while (n < n2) {
                int n3 = n++;
                nArray[n3] = ((Number)list.get(n3)).intValue();
            }
            this._hasSomeAggShieldRuleDimensions = result = nArray;
        }
        return result;
    }

    @NotNull
    public final AggShieldRuleMasker getAggShieldRuleMasker() {
        AggShieldRuleMasker result = this._masker;
        if (result == null) {
            this._masker = result = new AggShieldRuleMasker(this.dimensions, this.getHasSomeAggShieldRuleDimensions());
        }
        return result;
    }

    public final void scanForDynamicCalc(@NotNull MultiDimensionAggComputingUnit unit, @Nullable Filter filer) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        this.scanUnit(unit, true);
        this.scanFilter(filer);
    }

    public final void scanForMultiDimensionAgg(@NotNull MultiDimensionAggComputingUnit unit, @Nullable Filter filer) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        this.scanUnit(unit, false);
        this.scanFilter(filer);
    }

    public final void scanForFullComputing(@NotNull IComputingUnit unit, @NotNull DimensionFilterCollection filter) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        this.scanUnit(unit);
        this.scanFilter(filter);
    }

    public final void scanForLambda(@NotNull Iterable<? extends IComputingUnit> units, @NotNull DimensionFilterCollection filter) {
        Intrinsics.checkNotNullParameter(units, (String)"units");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        Iterable<? extends IComputingUnit> $this$forEach$iv = units;
        boolean $i$f$forEach = false;
        Iterator<? extends IComputingUnit> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            IComputingUnit element$iv;
            IComputingUnit it = element$iv = iterator.next();
            boolean bl = false;
            this.scanUnit(it);
        }
        this.scanFilter(filter);
    }

    public final void scanForSave(@NotNull Dimension dimension, @NotNull Member fixMember) {
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
        Intrinsics.checkNotNullParameter((Object)fixMember, (String)"fixMember");
        ScanData dimData = this._data[dimension.getPosition()];
        dimData.scanMember(fixMember);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J \u0010\u0018\u001a\u00020\u00152\n\u0010\u0019\u001a\u00060\bj\u0002`\u00112\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00170\u001bJ\u0010\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0016\u0010\u001c\u001a\u00020\u00152\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00170\u001bH\u0002J\u000e\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0014\u0010\u001f\u001a\u00020\u00152\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00170\u001bJ\u0018\u0010 \u001a\u0014\u0012\b\u0012\u00060\bj\u0002`\u0011\u0012\u0006\u0012\u0004\u0018\u00010\"0!R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0015\u0010\u0010\u001a\u00060\bj\u0002`\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006#"}, d2={"Lkd/bos/olapServer/computingEngine/AggShieldRuleFilterBuilder$ScanData;", "", "dimension", "Lkd/bos/olapServer/metadata/Dimension;", "(Lkd/bos/olapServer/metadata/Dimension;)V", "_aggMembers", "Lkd/bos/olapServer/collections/NumberSetFilter;", "_hasAggShieldRule", "", "_hasScanned", "_hasStoredMember", "aggMembers", "getAggMembers", "()Lkd/bos/olapServer/collections/NumberSetFilter;", "getDimension", "()Lkd/bos/olapServer/metadata/Dimension;", "hasAggShieldRule", "Lkd/bos/olapServer/common/bool;", "getHasAggShieldRule", "()Z", "scanAggMember", "", "member", "Lkd/bos/olapServer/metadata/Member;", "scanAggMembers", "isDynamicCalc", "members", "", "scanAggShieldRule", "scanMember", "scanStoredMember", "scanStoredMembers", "tryCreateIsAggMemberFilter", "Lkotlin/Pair;", "Lkd/bos/olapServer/collections/INumberSetFilter;", "bos-olap-core"})
    private static final class ScanData {
        @NotNull
        private final Dimension dimension;
        private boolean _hasScanned;
        @Nullable
        private NumberSetFilter _aggMembers;
        private boolean _hasStoredMember;
        private boolean _hasAggShieldRule;

        public ScanData(@NotNull Dimension dimension) {
            Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
            this.dimension = dimension;
        }

        @NotNull
        public final Dimension getDimension() {
            return this.dimension;
        }

        private final NumberSetFilter getAggMembers() {
            NumberSetFilter aggMembers = this._aggMembers;
            if (aggMembers == null) {
                this._aggMembers = aggMembers = new NumberSetFilter(1024);
            }
            return aggMembers;
        }

        public final void scanAggMembers(boolean isDynamicCalc, @NotNull Iterable<? extends Member> members2) {
            Intrinsics.checkNotNullParameter(members2, (String)"members");
            if (!isDynamicCalc) {
                this._hasScanned = true;
            }
            NumberSetFilter aggMembers = this.getAggMembers();
            Iterable<? extends Member> $this$forEach$iv = members2;
            boolean $i$f$forEach = false;
            Iterator<? extends Member> iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Member element$iv;
                Member it = element$iv = iterator.next();
                boolean bl = false;
                aggMembers.add(it.getPosition$bos_olap_core());
            }
            this.scanAggShieldRule(members2);
        }

        private final void scanAggShieldRule(Iterable<? extends Member> members2) {
            if (CommonTypesKt.getDynamicCalcEnabled() && !this._hasAggShieldRule && this.dimension.getHasAnyAggShieldRule()) {
                for (Member member : members2) {
                    if (member.getAggShieldRuleMasker() == null) continue;
                    this._hasAggShieldRule = true;
                    break;
                }
            }
        }

        private final void scanAggShieldRule(Member member) {
            if (CommonTypesKt.getDynamicCalcEnabled() && !this._hasAggShieldRule && member.getAggShieldRuleMasker() != null) {
                this._hasAggShieldRule = true;
            }
        }

        public final void scanStoredMembers(@NotNull Iterable<? extends Member> members2) {
            Iterator<? extends Member> itr;
            Intrinsics.checkNotNullParameter(members2, (String)"members");
            if (!this._hasStoredMember && (itr = members2.iterator()).hasNext()) {
                this._hasStoredMember = true;
            }
            this.scanAggShieldRule(members2);
        }

        public final void scanMember(@NotNull Member member) {
            Intrinsics.checkNotNullParameter((Object)member, (String)"member");
            NumberSetFilter aggMembers = this._aggMembers;
            if (aggMembers != null && aggMembers.get(member.getPosition$bos_olap_core())) {
                return;
            }
            this._hasScanned = true;
            if (CommonTypesKt.getDynamicCalcEnabled() && !member.getStorageType().isStored()) {
                this.scanAggMember(member);
            } else {
                this.scanStoredMember(member);
            }
        }

        private final void scanAggMember(Member member) {
            this.getAggMembers().add(member.getPosition$bos_olap_core());
            this.scanAggShieldRule(member);
        }

        private final void scanStoredMember(Member member) {
            this._hasStoredMember = true;
            this.scanAggShieldRule(member);
        }

        @NotNull
        public final Pair<Boolean, INumberSetFilter> tryCreateIsAggMemberFilter() {
            NumberSetFilter aggMembers;
            return this._hasScanned ? ((aggMembers = this._aggMembers) == null || aggMembers.isEmpty() ? new Pair((Object)false, null) : (this._hasStoredMember ? new Pair((Object)false, (Object)aggMembers.getWhiteListFilter()) : new Pair((Object)true, null))) : (CommonTypesKt.getDynamicCalcEnabled() && this.dimension.getHasSomeCalculatedMember() ? new Pair((Object)false, (Object)this.dimension.isCalculatedMemberFilter()) : new Pair((Object)false, null));
        }

        public final boolean getHasAggShieldRule() {
            return !CommonTypesKt.getDynamicCalcEnabled() ? false : (this._hasScanned ? this._hasAggShieldRule : this.dimension.getHasAnyAggShieldRule());
        }
    }
}

