/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.computingEngine;

import kd.bos.olapServer.collections.IImmutableListBoolean;
import kd.bos.olapServer.collections.ImmutableBitSet;
import kd.bos.olapServer.collections.MutableBitSet;
import kd.bos.olapServer.dataEntities.IDimensionKeys;
import kd.bos.olapServer.metadata.Dimension;
import kd.bos.olapServer.metadata.DimensionCollection;
import kd.bos.olapServer.metadata.IAggShieldRuleMasker;
import kd.bos.olapServer.metadata.Member;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\f\u001a\u00020\u0000J\u000e\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fR\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lkd/bos/olapServer/computingEngine/AggShieldRuleMasker;", "", "dims", "Lkd/bos/olapServer/metadata/DimensionCollection;", "ruleScanner", "", "(Lkd/bos/olapServer/metadata/DimensionCollection;[I)V", "alwaysTrueResult", "Lkd/bos/olapServer/collections/IImmutableListBoolean;", "initCache", "Lkd/bos/olapServer/collections/MutableBitSet;", "resultCache", "clone", "getAggMask", "key", "Lkd/bos/olapServer/dataEntities/IDimensionKeys;", "bos-olap-core"})
public final class AggShieldRuleMasker {
    @NotNull
    private final DimensionCollection dims;
    @NotNull
    private final int[] ruleScanner;
    @NotNull
    private final MutableBitSet initCache;
    @NotNull
    private final MutableBitSet resultCache;
    @Nullable
    private final IImmutableListBoolean alwaysTrueResult;

    public AggShieldRuleMasker(@NotNull DimensionCollection dims, @NotNull int[] ruleScanner) {
        Intrinsics.checkNotNullParameter((Object)dims, (String)"dims");
        Intrinsics.checkNotNullParameter((Object)ruleScanner, (String)"ruleScanner");
        this.dims = dims;
        this.ruleScanner = ruleScanner;
        this.initCache = MutableBitSet.Companion.create(this.dims.getCount(), true);
        this.resultCache = MutableBitSet.Companion.create(this.dims.getCount(), true);
        int[] nArray = this.ruleScanner;
        boolean bl = false;
        this.alwaysTrueResult = nArray.length == 0 ? ImmutableBitSet.Companion.createAlwaysTrue(this.dims.getCount()) : null;
    }

    @NotNull
    public final AggShieldRuleMasker clone() {
        return new AggShieldRuleMasker(this.dims, this.ruleScanner);
    }

    @NotNull
    public final IImmutableListBoolean getAggMask(@NotNull IDimensionKeys key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        IImmutableListBoolean alwaysTrue = this.alwaysTrueResult;
        if (alwaysTrue != null) {
            return alwaysTrue;
        }
        MutableBitSet result = this.resultCache;
        result.copyFrom(this.initCache);
        for (int dimPosition : this.ruleScanner) {
            IAggShieldRuleMasker masker;
            int memberPosition;
            Dimension dimension = (Dimension)this.dims.get(dimPosition);
            if (!dimension.isDefinedRule(memberPosition = key.get(dimPosition)) || (masker = ((Member)dimension.getMembers().get(memberPosition)).getAggShieldRuleMasker()) == null) continue;
            result.and(masker.getAggShieldRuleMask(key));
        }
        return result;
    }
}

