/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.computingEngine;

import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import kd.bos.olapServer.collections.IReferenceIterator;
import kd.bos.olapServer.computingEngine.OverrideData;
import kd.bos.olapServer.dataEntities.IDimensionKeys;
import kd.bos.olapServer.dataSources.ComputingCommandInfo;
import kd.bos.olapServer.dataSources.DimensionFilterItem;
import kd.bos.olapServer.metadata.Cube;
import kd.bos.olapServer.metadata.Dimension;
import kd.bos.olapServer.metadata.Member;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0012B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J'\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\b\u00a2\u0006\u0002\u0010\u0011R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006\u0013"}, d2={"Lkd/bos/olapServer/computingEngine/FindComputingFactor;", "", "cube", "Lkd/bos/olapServer/metadata/Cube;", "scope", "Lkd/bos/olapServer/dataSources/ComputingCommandInfo;", "(Lkd/bos/olapServer/metadata/Cube;Lkd/bos/olapServer/dataSources/ComputingCommandInfo;)V", "scopeArray", "", "Ljava/util/BitSet;", "[Ljava/util/BitSet;", "findFactors", "Lkd/bos/olapServer/collections/IReferenceIterator;", "Lkd/bos/olapServer/computingEngine/OverrideData;", "baseRowKey", "Lkd/bos/olapServer/dataEntities/IDimensionKeys;", "factors", "(Lkd/bos/olapServer/dataEntities/IDimensionKeys;[Lkd/bos/olapServer/computingEngine/OverrideData;)Lkd/bos/olapServer/collections/IReferenceIterator;", "FactorIterator", "bos-olap-core"})
public final class FindComputingFactor {
    @NotNull
    private final BitSet[] scopeArray;

    public FindComputingFactor(@NotNull Cube cube, @NotNull ComputingCommandInfo scope) {
        boolean bl;
        Iterator<String> iterator;
        Intrinsics.checkNotNullParameter((Object)cube, (String)"cube");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        int n = 0;
        int n2 = CollectionsKt.count((Iterable)cube.getDimensions());
        BitSet[] bitSetArray = new BitSet[n2];
        FindComputingFactor findComputingFactor = this;
        while (n < n2) {
            int n3 = n++;
            bitSetArray[n3] = new BitSet();
        }
        findComputingFactor.scopeArray = bitSetArray;
        n2 = 0;
        HashMap dimIndex = new HashMap();
        n2 = 0;
        int n4 = this.scopeArray.length;
        if (n2 < n4) {
            do {
                int i = n2++;
                iterator = dimIndex;
                String string = ((Dimension)cube.getDimensions().get(i)).getName();
                Integer n5 = i;
                bl = false;
                iterator.put(string, n5);
            } while (n2 < n4);
        }
        int i = 0;
        for (DimensionFilterItem elem : scope.getFilter()) {
            iterator = dimIndex.getOrDefault(elem.getName(), -1);
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"dimIndex.getOrDefault(elem.Name, -1)");
            i = ((Number)((Object)iterator)).intValue();
            boolean bl2 = i != -1;
            boolean bl3 = false;
            boolean bl4 = false;
            bl4 = false;
            bl = false;
            if (!bl2) {
                boolean bl5 = false;
                String string = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            for (String members2 : elem.getValues()) {
                this.scopeArray[i].set(((Member)((Dimension)cube.getDimensions().get(i)).getMembers().get(members2)).getPosition$bos_olap_core(), true);
            }
        }
    }

    @NotNull
    public final IReferenceIterator<OverrideData> findFactors(@NotNull IDimensionKeys baseRowKey, @NotNull OverrideData[] factors2) {
        Intrinsics.checkNotNullParameter((Object)baseRowKey, (String)"baseRowKey");
        Intrinsics.checkNotNullParameter((Object)factors2, (String)"factors");
        return new FactorIterator(baseRowKey, factors2);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010\u000f\u001a\u00060\u0010j\u0002`\u00112\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0002H\u0002J\f\u0010\u0013\u001a\u00060\u0010j\u0002`\u0011H\u0016R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lkd/bos/olapServer/computingEngine/FindComputingFactor$FactorIterator;", "Lkd/bos/olapServer/collections/IReferenceIterator;", "Lkd/bos/olapServer/computingEngine/OverrideData;", "baseRowKey", "Lkd/bos/olapServer/dataEntities/IDimensionKeys;", "factors", "", "(Lkd/bos/olapServer/computingEngine/FindComputingFactor;Lkd/bos/olapServer/dataEntities/IDimensionKeys;[Lkd/bos/olapServer/computingEngine/OverrideData;)V", "_current", "current", "getCurrent", "()Lkd/bos/olapServer/computingEngine/OverrideData;", "[Lkd/bos/olapServer/computingEngine/OverrideData;", "index", "", "compareKeys", "", "Lkd/bos/olapServer/common/bool;", "overrideKey", "next", "bos-olap-core"})
    private final class FactorIterator
    implements IReferenceIterator<OverrideData> {
        @NotNull
        private final IDimensionKeys baseRowKey;
        @NotNull
        private final OverrideData[] factors;
        private int index;
        @Nullable
        private OverrideData _current;

        public FactorIterator(@NotNull IDimensionKeys baseRowKey, OverrideData[] factors2) {
            Intrinsics.checkNotNullParameter((Object)FindComputingFactor.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)baseRowKey, (String)"baseRowKey");
            Intrinsics.checkNotNullParameter((Object)factors2, (String)"factors");
            this.baseRowKey = baseRowKey;
            this.factors = factors2;
            this.index = -1;
        }

        @Override
        @NotNull
        public OverrideData getCurrent() {
            OverrideData overrideData = this._current;
            Intrinsics.checkNotNull((Object)overrideData);
            return overrideData;
        }

        @Override
        public boolean next() {
            block1: {
                do {
                    FactorIterator factorIterator = this;
                    ++factorIterator.index;
                    if (factorIterator.index >= this.factors.length) break block1;
                } while (!this.compareKeys(this.baseRowKey, this.factors[this.index]));
                this._current = this.factors[this.index];
                return true;
            }
            return false;
        }

        private final boolean compareKeys(IDimensionKeys baseRowKey, OverrideData overrideKey) {
            if (baseRowKey.getCount() != overrideKey.getCount()) {
                return false;
            }
            int n = 0;
            int n2 = baseRowKey.getCount();
            if (n < n2) {
                do {
                    BitSet bitSet;
                    int i;
                    if (!(overrideKey.get(i = n++) == -1 ? !(bitSet = FindComputingFactor.this.scopeArray[i]).isEmpty() && !bitSet.get(baseRowKey.get(i)) : baseRowKey.get(i) != overrideKey.get(i))) continue;
                    return false;
                } while (n < n2);
            }
            return true;
        }
    }
}

