/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.computingEngine;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.olapServer.collections.IIterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001:\u0006#$%&'(B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0000J\u0016\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003J\u0016\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0014JH\u0010\u0018\u001a\u00020\u00002\n\u0010\u0019\u001a\u00060\u0014j\u0002`\u001a2\n\u0010\u001b\u001a\u00060\u0014j\u0002`\u001a2\n\u0010\u001c\u001a\u00060\u0014j\u0002`\u001a2\u001c\u0010\u001d\u001a\u0018\u0012\b\u0012\u00060\u0014j\u0002`\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u001f0\u001eJ\u001e\u0010 \u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\u0014R\u0018\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006)"}, d2={"Lkd/bos/olapServer/computingEngine/IntArraySequenceBuilder;", "", "resultArray", "", "([I)V", "_stepItems", "", "Lkd/bos/olapServer/computingEngine/IntArraySequenceBuilder$MemberStep;", "[Lkd/bos/olapServer/computingEngine/IntArraySequenceBuilder$MemberStep;", "getResultArray", "()[I", "sequenceCount", "Ljava/math/BigInteger;", "getSequenceCount", "()Ljava/math/BigInteger;", "build", "Lkd/bos/olapServer/collections/IIterator;", "reverse", "setArrayValue", "index", "", "values", "setFixedValue", "value", "setMapValue", "fromIndex", "Lkd/bos/olapServer/common/int;", "targetIndex", "mapCount", "mapFunc", "Lkotlin/Function2;", "", "setRangeValue", "start", "end", "ArrayStep", "BackwardRangeStep", "ForwardRangeStep", "IntArraySequence", "MapStep", "MemberStep", "bos-olap-core"})
public final class IntArraySequenceBuilder {
    @NotNull
    private final int[] resultArray;
    @NotNull
    private final MemberStep[] _stepItems;

    public IntArraySequenceBuilder(@NotNull int[] resultArray) {
        Intrinsics.checkNotNullParameter((Object)resultArray, (String)"resultArray");
        this.resultArray = resultArray;
        this._stepItems = new MemberStep[this.resultArray.length];
    }

    @NotNull
    public final int[] getResultArray() {
        return this.resultArray;
    }

    @NotNull
    public final IntArraySequenceBuilder setFixedValue(int index2, int value2) {
        this._stepItems[index2] = null;
        this.resultArray[index2] = value2;
        return this;
    }

    @NotNull
    public final IntArraySequenceBuilder setRangeValue(int index2, int start, int end) {
        if (end == start) {
            this.setFixedValue(index2, start);
        } else {
            this._stepItems[index2] = start > end ? (MemberStep)new BackwardRangeStep(this.resultArray, index2, start, end) : (MemberStep)new ForwardRangeStep(this.resultArray, index2, start, end);
        }
        return this;
    }

    @NotNull
    public final IntArraySequenceBuilder setArrayValue(int index2, @NotNull int[] values) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        if (values.length == 1) {
            this.setFixedValue(index2, values[0]);
        } else {
            int[] nArray = values;
            boolean bl = false;
            int[] nArray2 = nArray;
            boolean bl2 = false;
            boolean bl3 = !(nArray2.length == 0);
            bl = false;
            boolean bl4 = false;
            bl4 = false;
            bl2 = false;
            if (!bl3) {
                boolean bl5 = false;
                String string = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            this._stepItems[index2] = new ArrayStep(this.resultArray, index2, values);
        }
        return this;
    }

    @NotNull
    public final IntArraySequenceBuilder setMapValue(int fromIndex, int targetIndex, int mapCount, @NotNull Function2<? super Integer, ? super int[], Unit> mapFunc) {
        Intrinsics.checkNotNullParameter(mapFunc, (String)"mapFunc");
        this._stepItems[fromIndex] = new MapStep(this.resultArray, this._stepItems[fromIndex], fromIndex, targetIndex, mapCount, mapFunc);
        return this;
    }

    @NotNull
    public final IntArraySequenceBuilder reverse() {
        ArraysKt.reverse((Object[])this._stepItems);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IIterator build() {
        void $this$filterTo$iv$iv;
        int[] nArray = this.resultArray;
        boolean bl = false;
        int[] nArray2 = nArray;
        boolean bl2 = false;
        boolean bl3 = !(nArray2.length == 0);
        bl = false;
        boolean bl4 = false;
        bl4 = false;
        bl2 = false;
        if (!bl3) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        MemberStep[] $this$filter$iv = this._stepItems;
        boolean $i$f$filter = false;
        MemberStep[] memberStepArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        void var7_14 = $this$filterTo$iv$iv;
        int n = ((void)var7_14).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = var7_14[i];
            boolean bl6 = false;
            if (!(it != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Object[] objectArray = thisCollection$iv.toArray(new MemberStep[0]);
        if (objectArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        MemberStep[] stepItems = (MemberStep[])ArraysKt.requireNoNulls((Object[])objectArray);
        return new IntArraySequence(stepItems);
    }

    @NotNull
    public final BigInteger getSequenceCount() {
        BigInteger sum = null;
        sum = BigInteger.ONE;
        MemberStep[] $this$forEach$iv = this._stepItems;
        boolean $i$f$forEach = false;
        MemberStep[] memberStepArray = $this$forEach$iv;
        int n = memberStepArray.length;
        for (int i = 0; i < n; ++i) {
            BigInteger bigInteger;
            MemberStep element$iv;
            MemberStep it = element$iv = memberStepArray[i];
            boolean bl = false;
            if (it == null) continue;
            BigInteger bigInteger2 = sum;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"sum");
            int n2 = it.getCapacity();
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)BigInteger.valueOf(n2), (String)"BigInteger.valueOf(this.toLong())");
            bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger2.multiply(bigInteger), (String)"this.multiply(other)");
        }
        BigInteger bigInteger = sum;
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"sum");
        return bigInteger;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\f"}, d2={"Lkd/bos/olapServer/computingEngine/IntArraySequenceBuilder$IntArraySequence;", "Lkd/bos/olapServer/collections/IIterator;", "stepItems", "", "Lkd/bos/olapServer/computingEngine/IntArraySequenceBuilder$MemberStep;", "([Lkd/bos/olapServer/computingEngine/IntArraySequenceBuilder$MemberStep;)V", "_states", "", "rangeSize", "[Lkd/bos/olapServer/computingEngine/IntArraySequenceBuilder$MemberStep;", "next", "", "bos-olap-core"})
    private static final class IntArraySequence
    implements IIterator {
        @NotNull
        private final MemberStep[] stepItems;
        private int _states;
        private final int rangeSize;

        public IntArraySequence(@NotNull MemberStep[] stepItems) {
            Intrinsics.checkNotNullParameter((Object)stepItems, (String)"stepItems");
            this.stepItems = stepItems;
            this.rangeSize = this.stepItems.length - 1;
        }

        @Override
        public boolean next() {
            boolean bl;
            int n = this._states;
            switch (n) {
                case 0: {
                    this._states = this.rangeSize < 0 ? -1 : 1;
                    bl = true;
                    break;
                }
                case 1: {
                    if (!this.stepItems[this.rangeSize].next()) {
                        return true;
                    }
                    int n2 = this.rangeSize - 1;
                    if (0 <= n2) {
                        do {
                            int stepIndex;
                            if (this.stepItems[stepIndex = n2--].next()) continue;
                            return true;
                        } while (0 <= n2);
                    }
                    this._states = -1;
                    bl = false;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            return bl;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\"\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH&J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0004R\u0016\u0010\u0007\u001a\u00060\u0005j\u0002`\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lkd/bos/olapServer/computingEngine/IntArraySequenceBuilder$MemberStep;", "", "resultArray", "", "resultIndex", "", "([II)V", "capacity", "Lkd/bos/olapServer/common/int;", "getCapacity", "()I", "next", "", "setResult", "", "value", "bos-olap-core"})
    private static abstract class MemberStep {
        @NotNull
        private final int[] resultArray;
        private final int resultIndex;

        public MemberStep(@NotNull int[] resultArray, int resultIndex) {
            Intrinsics.checkNotNullParameter((Object)resultArray, (String)"resultArray");
            this.resultArray = resultArray;
            this.resultIndex = resultIndex;
        }

        protected final void setResult(int value2) {
            this.resultArray[this.resultIndex] = value2;
        }

        public abstract int getCapacity();

        public abstract boolean next();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\u00060\u0005j\u0002`\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lkd/bos/olapServer/computingEngine/IntArraySequenceBuilder$ForwardRangeStep;", "Lkd/bos/olapServer/computingEngine/IntArraySequenceBuilder$MemberStep;", "resultArray", "", "resultIndex", "", "start", "end", "([IIII)V", "_currentValue", "calcEnd", "capacity", "Lkd/bos/olapServer/common/int;", "getCapacity", "()I", "next", "", "bos-olap-core"})
    private static final class ForwardRangeStep
    extends MemberStep {
        private final int start;
        private final int end;
        private int _currentValue;
        private final int calcEnd;

        public ForwardRangeStep(@NotNull int[] resultArray, int resultIndex, int start, int end) {
            Intrinsics.checkNotNullParameter((Object)resultArray, (String)"resultArray");
            super(resultArray, resultIndex);
            this.start = start;
            this.end = end;
            if (this.start > this.end) {
                throw new IllegalArgumentException();
            }
            this.setResult(this.start);
            this._currentValue = this.start;
            this.calcEnd = this.end >= 0 ? this.end - 1 : this.end + 1;
        }

        @Override
        public int getCapacity() {
            return this.end - this.start + 1;
        }

        @Override
        public boolean next() {
            boolean bl;
            if (this._currentValue > this.calcEnd) {
                this._currentValue = this.start;
                this.setResult(this.start);
                bl = true;
            } else {
                ForwardRangeStep forwardRangeStep = this;
                ++forwardRangeStep._currentValue;
                this.setResult(forwardRangeStep._currentValue);
                bl = false;
            }
            return bl;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\u00060\u0005j\u0002`\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lkd/bos/olapServer/computingEngine/IntArraySequenceBuilder$BackwardRangeStep;", "Lkd/bos/olapServer/computingEngine/IntArraySequenceBuilder$MemberStep;", "resultArray", "", "resultIndex", "", "start", "end", "([IIII)V", "_currentValue", "calcEnd", "capacity", "Lkd/bos/olapServer/common/int;", "getCapacity", "()I", "next", "", "bos-olap-core"})
    private static final class BackwardRangeStep
    extends MemberStep {
        private final int start;
        private final int end;
        private int _currentValue;
        private final int calcEnd;

        public BackwardRangeStep(@NotNull int[] resultArray, int resultIndex, int start, int end) {
            Intrinsics.checkNotNullParameter((Object)resultArray, (String)"resultArray");
            super(resultArray, resultIndex);
            this.start = start;
            this.end = end;
            if (this.start < this.end) {
                throw new IllegalArgumentException();
            }
            this.setResult(this.start);
            this._currentValue = this.start;
            this.calcEnd = this.end >= 0 ? this.end - 1 : this.end + 1;
        }

        @Override
        public int getCapacity() {
            return this.start - this.end + 1;
        }

        @Override
        public boolean next() {
            boolean bl;
            if (this._currentValue < this.calcEnd) {
                this._currentValue = this.start;
                this.setResult(this._currentValue);
                bl = true;
            } else {
                BackwardRangeStep backwardRangeStep = this;
                backwardRangeStep._currentValue += -1;
                this.setResult(backwardRangeStep._currentValue);
                bl = false;
            }
            return bl;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\u00060\u0005j\u0002`\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lkd/bos/olapServer/computingEngine/IntArraySequenceBuilder$ArrayStep;", "Lkd/bos/olapServer/computingEngine/IntArraySequenceBuilder$MemberStep;", "resultArray", "", "resultIndex", "", "values", "([II[I)V", "_currentIndex", "calcEnd", "capacity", "Lkd/bos/olapServer/common/int;", "getCapacity", "()I", "next", "", "bos-olap-core"})
    private static final class ArrayStep
    extends MemberStep {
        @NotNull
        private final int[] values;
        private int _currentIndex;
        private final int calcEnd;

        public ArrayStep(@NotNull int[] resultArray, int resultIndex, @NotNull int[] values) {
            Intrinsics.checkNotNullParameter((Object)resultArray, (String)"resultArray");
            Intrinsics.checkNotNullParameter((Object)values, (String)"values");
            super(resultArray, resultIndex);
            this.values = values;
            int[] nArray = this.values;
            boolean bl = false;
            if (nArray.length == 0) {
                throw new IllegalArgumentException();
            }
            this.setResult(this.values[0]);
            this.calcEnd = this.values.length - 1;
        }

        @Override
        public int getCapacity() {
            return this.values.length;
        }

        @Override
        public boolean next() {
            boolean bl;
            if (this._currentIndex >= this.calcEnd) {
                this._currentIndex = 0;
                this.setResult(this.values[0]);
                bl = true;
            } else {
                ArrayStep arrayStep = this;
                ++arrayStep._currentIndex;
                this.setResult(this.values[arrayStep._currentIndex]);
                bl = false;
            }
            return bl;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001BY\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u0012\n\u0010\b\u001a\u00060\u0006j\u0002`\u0007\u0012\n\u0010\t\u001a\u00060\u0006j\u0002`\u0007\u0012\u001c\u0010\n\u001a\u0018\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000f\u001a\u00060\u0006j\u0002`\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0012\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00060\u0006j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\n\u001a\u0018\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lkd/bos/olapServer/computingEngine/IntArraySequenceBuilder$MapStep;", "Lkd/bos/olapServer/computingEngine/IntArraySequenceBuilder$MemberStep;", "resultArray", "", "_sourceStepItem", "fromIndex", "", "Lkd/bos/olapServer/common/int;", "targetIndex", "mapCount", "mapFunc", "Lkotlin/Function2;", "", "([ILkd/bos/olapServer/computingEngine/IntArraySequenceBuilder$MemberStep;IIILkotlin/jvm/functions/Function2;)V", "_currentMapIndex", "capacity", "getCapacity", "()I", "mapEnd", "values", "next", "", "bos-olap-core"})
    private static final class MapStep
    extends MemberStep {
        @NotNull
        private final int[] resultArray;
        @Nullable
        private final MemberStep _sourceStepItem;
        private final int fromIndex;
        private final int mapCount;
        @NotNull
        private final Function2<Integer, int[], Unit> mapFunc;
        @NotNull
        private final int[] values;
        private int _currentMapIndex;
        private final int mapEnd;

        public MapStep(@NotNull int[] resultArray, @Nullable MemberStep _sourceStepItem, int fromIndex, int targetIndex, int mapCount, @NotNull Function2<? super Integer, ? super int[], Unit> mapFunc) {
            Intrinsics.checkNotNullParameter((Object)resultArray, (String)"resultArray");
            Intrinsics.checkNotNullParameter(mapFunc, (String)"mapFunc");
            super(resultArray, targetIndex);
            this.resultArray = resultArray;
            this._sourceStepItem = _sourceStepItem;
            this.fromIndex = fromIndex;
            this.mapCount = mapCount;
            this.mapFunc = mapFunc;
            this.values = new int[this.mapCount];
            this.mapFunc.invoke((Object)this.resultArray[this.fromIndex], (Object)this.values);
            this.setResult(this.values[0]);
            this.mapEnd = this.mapCount - 1;
        }

        @Override
        public int getCapacity() {
            MemberStep sourceStepItem = this._sourceStepItem;
            return sourceStepItem == null ? this.mapCount : sourceStepItem.getCapacity() * this.mapCount;
        }

        @Override
        public boolean next() {
            boolean bl;
            if (this._currentMapIndex < this.mapEnd) {
                MapStep mapStep = this;
                ++mapStep._currentMapIndex;
                this.setResult(this.values[mapStep._currentMapIndex]);
                bl = false;
            } else {
                MemberStep memberStep = this._sourceStepItem;
                if (memberStep == null ? false : !memberStep.next()) {
                    this._currentMapIndex = 0;
                    this.mapFunc.invoke((Object)this.resultArray[this.fromIndex], (Object)this.values);
                    this.setResult(this.values[0]);
                    bl = false;
                } else {
                    this._currentMapIndex = 0;
                    this.mapFunc.invoke((Object)this.resultArray[this.fromIndex], (Object)this.values);
                    this.setResult(this.values[0]);
                    bl = true;
                }
            }
            return bl;
        }
    }
}

