/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.computingEngine;

import java.util.Arrays;
import kd.bos.olapServer.common.NotSupportedException;
import kd.bos.olapServer.computingEngine.OverrideData;
import kd.bos.olapServer.computingEngine.OverrideDimensionGroup;
import kd.bos.olapServer.computingEngine.OverrideSingleData;
import kd.bos.olapServer.metadata.DimensionCollection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0007\u001a\u00060\bj\u0002`\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0013\u0010\u0017\u001a\u00020\u00112\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0096\u0002J\u0019\u0010\u001a\u001a\u00060\bj\u0002`\t2\n\u0010\u001b\u001a\u00060\bj\u0002`\tH\u0096\u0002J\b\u0010\u001c\u001a\u00020\bH\u0016R\u0018\u0010\u000b\u001a\u00060\bj\u0002`\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\u00060\u0011j\u0002`\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\u00060\bj\u0002`\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\r\u00a8\u0006\u001e"}, d2={"Lkd/bos/olapServer/computingEngine/OverrideMultiData;", "Lkd/bos/olapServer/computingEngine/OverrideData;", "dimensions", "Lkd/bos/olapServer/metadata/DimensionCollection;", "overrideArray", "", "(Lkd/bos/olapServer/metadata/DimensionCollection;[I)V", "overrideCount", "", "Lkd/bos/olapServer/common/int;", "(Lkd/bos/olapServer/metadata/DimensionCollection;[II)V", "Count", "getCount", "()I", "getDimensions", "()Lkd/bos/olapServer/metadata/DimensionCollection;", "isEmptyScope", "", "Lkd/bos/olapServer/common/bool;", "()Z", "getOverrideCount", "createOverrideDimensionGroup", "Lkd/bos/olapServer/computingEngine/OverrideDimensionGroup;", "equals", "other", "", "get", "dimensionIndex", "hashCode", "Companion", "bos-olap-core"})
public final class OverrideMultiData
extends OverrideData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DimensionCollection dimensions;
    @NotNull
    private final int[] overrideArray;
    private final int overrideCount;

    public OverrideMultiData(@NotNull DimensionCollection dimensions2, @NotNull int[] overrideArray, int overrideCount) {
        Intrinsics.checkNotNullParameter((Object)dimensions2, (String)"dimensions");
        Intrinsics.checkNotNullParameter((Object)overrideArray, (String)"overrideArray");
        this.dimensions = dimensions2;
        this.overrideArray = overrideArray;
        this.overrideCount = overrideCount;
    }

    @Override
    @NotNull
    public DimensionCollection getDimensions() {
        return this.dimensions;
    }

    @Override
    public int getOverrideCount() {
        return this.overrideCount;
    }

    public OverrideMultiData(@NotNull DimensionCollection dimensions2, @NotNull int[] overrideArray) {
        Intrinsics.checkNotNullParameter((Object)dimensions2, (String)"dimensions");
        Intrinsics.checkNotNullParameter((Object)overrideArray, (String)"overrideArray");
        this(dimensions2, overrideArray, OverrideMultiData.Companion.getOverrideCount(overrideArray));
    }

    @Override
    public int getCount() {
        return this.overrideArray.length;
    }

    @Override
    public int get(int dimensionIndex) {
        return this.overrideArray[dimensionIndex];
    }

    @Override
    @NotNull
    public OverrideDimensionGroup createOverrideDimensionGroup() {
        int[] overrideDimIndexes = new int[this.getOverrideCount()];
        int i = 0;
        int n = 0;
        int n2 = this.overrideArray.length + -1;
        if (n <= n2) {
            do {
                int j;
                if (this.overrideArray[j = n++] < 0) continue;
                int n3 = i;
                i = n3 + 1;
                overrideDimIndexes[n3] = j;
            } while (n <= n2);
        }
        return new OverrideDimensionGroup(overrideDimIndexes);
    }

    @Override
    public boolean isEmptyScope() {
        return ArraysKt.contains((int[])this.overrideArray, (int)-2);
    }

    public boolean equals(@Nullable Object other) {
        boolean bl;
        if (other == null) {
            return false;
        }
        Object object = other;
        if (object instanceof OverrideMultiData) {
            bl = Arrays.equals(this.overrideArray, ((OverrideMultiData)other).overrideArray);
        } else if (object instanceof OverrideSingleData) {
            if (this.getOverrideCount() == 1) {
                Pair pair = OverrideMultiData.Companion.getSingleDimensionIndex(this.overrideArray);
                int overrideDimensionIndex = ((Number)pair.component1()).intValue();
                int newValue = ((Number)pair.component2()).intValue();
                bl = newValue == ((OverrideSingleData)other).get(overrideDimensionIndex);
            } else {
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public int hashCode() {
        int result = 1;
        if (this.getOverrideCount() == 1) {
            Pair pair = OverrideMultiData.Companion.getSingleDimensionIndex(this.overrideArray);
            int overrideDimensionIndex = ((Number)pair.component1()).intValue();
            int newValue = ((Number)pair.component2()).intValue();
            result = 31 * result + this.overrideArray.length;
            result = 31 * result + overrideDimensionIndex;
            result = 31 * result + newValue;
        } else {
            int n = 0;
            int n2 = this.overrideArray.length;
            if (n < n2) {
                do {
                    int index2 = n++;
                    result = result * 31 + index2;
                    result = result * 31 + this.overrideArray[index2];
                } while (n < n2);
            }
        }
        return result;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00060\u0004j\u0002`\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J$\u0010\b\u001a\u0016\u0012\b\u0012\u00060\u0004j\u0002`\u0005\u0012\b\u0012\u00060\u0004j\u0002`\u00050\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\n"}, d2={"Lkd/bos/olapServer/computingEngine/OverrideMultiData$Companion;", "", "()V", "getOverrideCount", "", "Lkd/bos/olapServer/common/int;", "overrideArray", "", "getSingleDimensionIndex", "Lkotlin/Pair;", "bos-olap-core"})
    public static final class Companion {
        private Companion() {
        }

        private final int getOverrideCount(int[] overrideArray) {
            int overrideCount = 0;
            for (int i : overrideArray) {
                if (i == -1) continue;
                int n = overrideCount;
                overrideCount = n + 1;
            }
            return overrideCount;
        }

        private final Pair<Integer, Integer> getSingleDimensionIndex(int[] overrideArray) {
            int n = 0;
            int n2 = overrideArray.length;
            if (n < n2) {
                do {
                    int i;
                    int value2;
                    if ((value2 = overrideArray[i = n++]) < 0) continue;
                    return new Pair((Object)i, (Object)value2);
                } while (n < n2);
            }
            throw new NotSupportedException();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

