/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.computingEngine;

import kd.bos.olapServer.collections.INumberSetFilter;
import kd.bos.olapServer.collections.MutableBitSet;
import kd.bos.olapServer.computingEngine.AlwaysFalseDimensionKeysFilter;
import kd.bos.olapServer.computingEngine.AlwaysTrueDimensionKeysFilter;
import kd.bos.olapServer.computingEngine.IDimensionKeysFilter;
import kd.bos.olapServer.computingEngine.NotStoredFilter;
import kd.bos.olapServer.dataEntities.IDimensionKeys;
import kd.bos.olapServer.metadata.Dimension;
import kd.bos.olapServer.metadata.DimensionCollection;
import kd.bos.olapServer.metadata.IAggShieldRuleMasker;
import kd.bos.olapServer.metadata.Member;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0016B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u000e\u001a\u00020\u0001J\u0014\u0010\u000f\u001a\u00060\u0010j\u0002`\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u000e\u0010\r\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lkd/bos/olapServer/computingEngine/StoredFilter;", "Lkd/bos/olapServer/computingEngine/IDimensionKeysFilter;", "dims", "Lkd/bos/olapServer/metadata/DimensionCollection;", "init", "Lkd/bos/olapServer/collections/MutableBitSet;", "isAggMemberFilters", "", "Lkd/bos/olapServer/computingEngine/StoredFilter$IsAggMemberFilterPair;", "hasSomeAggShieldRuleDimensions", "", "(Lkd/bos/olapServer/metadata/DimensionCollection;Lkd/bos/olapServer/collections/MutableBitSet;[Lkd/bos/olapServer/computingEngine/StoredFilter$IsAggMemberFilterPair;[I)V", "[Lkd/bos/olapServer/computingEngine/StoredFilter$IsAggMemberFilterPair;", "resultCache", "clone", "match", "", "Lkd/bos/olapServer/common/bool;", "key", "Lkd/bos/olapServer/dataEntities/IDimensionKeys;", "reverse", "Lkd/bos/olapServer/computingEngine/NotStoredFilter;", "IsAggMemberFilterPair", "bos-olap-core"})
public final class StoredFilter
implements IDimensionKeysFilter {
    @NotNull
    private final DimensionCollection dims;
    @NotNull
    private final MutableBitSet init;
    @NotNull
    private final IsAggMemberFilterPair[] isAggMemberFilters;
    @NotNull
    private final int[] hasSomeAggShieldRuleDimensions;
    @NotNull
    private final MutableBitSet resultCache;

    public StoredFilter(@NotNull DimensionCollection dims, @NotNull MutableBitSet init2, @NotNull IsAggMemberFilterPair[] isAggMemberFilters, @NotNull int[] hasSomeAggShieldRuleDimensions) {
        Intrinsics.checkNotNullParameter((Object)dims, (String)"dims");
        Intrinsics.checkNotNullParameter((Object)init2, (String)"init");
        Intrinsics.checkNotNullParameter((Object)isAggMemberFilters, (String)"isAggMemberFilters");
        Intrinsics.checkNotNullParameter((Object)hasSomeAggShieldRuleDimensions, (String)"hasSomeAggShieldRuleDimensions");
        this.dims = dims;
        this.init = init2;
        this.isAggMemberFilters = isAggMemberFilters;
        this.hasSomeAggShieldRuleDimensions = hasSomeAggShieldRuleDimensions;
        this.resultCache = MutableBitSet.Companion.create$default(MutableBitSet.Companion, this.init.getSize(), false, 2, null);
    }

    @NotNull
    public final IDimensionKeysFilter clone() {
        Object[] objectArray = this.isAggMemberFilters;
        boolean bl = false;
        if (objectArray.length == 0) {
            if (this.init.isEmpty()) {
                return AlwaysTrueDimensionKeysFilter.INSTANCE;
            }
            objectArray = this.hasSomeAggShieldRuleDimensions;
            bl = false;
            if (objectArray.length == 0) {
                return AlwaysFalseDimensionKeysFilter.INSTANCE;
            }
        }
        return new StoredFilter(this.dims, this.init, this.isAggMemberFilters, this.hasSomeAggShieldRuleDimensions);
    }

    @Override
    public boolean match(@NotNull IDimensionKeys key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        MutableBitSet result = this.resultCache;
        result.copyFrom(this.init);
        for (IsAggMemberFilterPair isAggMemberFilterPair : this.isAggMemberFilters) {
            int dimPosition = isAggMemberFilterPair.component1();
            INumberSetFilter isAggNodeFilter = isAggMemberFilterPair.component2();
            if (!isAggNodeFilter.match(key.get(dimPosition))) continue;
            result.setTrue(dimPosition);
        }
        if (result.isEmpty()) {
            return true;
        }
        for (int dimPosition : this.hasSomeAggShieldRuleDimensions) {
            IAggShieldRuleMasker masker;
            int memberPosition;
            Dimension dimension = (Dimension)this.dims.get(dimPosition);
            if (!dimension.isDefinedRule(memberPosition = key.get(dimPosition)) || (masker = ((Member)dimension.getMembers().get(memberPosition)).getAggShieldRuleMasker()) == null) continue;
            result.and(masker.getStoredShieldRuleMask(key));
        }
        return result.isEmpty();
    }

    @NotNull
    public final NotStoredFilter reverse() {
        return new NotStoredFilter(this);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u0019\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\r\u0010\u000b\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0006H\u00c6\u0003J!\u0010\r\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u00060\u0003j\u0002`\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\n\u00a8\u0006\u0014"}, d2={"Lkd/bos/olapServer/computingEngine/StoredFilter$IsAggMemberFilterPair;", "", "dimensionPosition", "", "Lkd/bos/olapServer/common/int;", "isAggMemberFilter", "Lkd/bos/olapServer/collections/INumberSetFilter;", "(ILkd/bos/olapServer/collections/INumberSetFilter;)V", "getDimensionPosition", "()I", "()Lkd/bos/olapServer/collections/INumberSetFilter;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "bos-olap-core"})
    public static final class IsAggMemberFilterPair {
        private final int dimensionPosition;
        @NotNull
        private final INumberSetFilter isAggMemberFilter;

        public IsAggMemberFilterPair(int dimensionPosition, @NotNull INumberSetFilter isAggMemberFilter) {
            Intrinsics.checkNotNullParameter((Object)isAggMemberFilter, (String)"isAggMemberFilter");
            this.dimensionPosition = dimensionPosition;
            this.isAggMemberFilter = isAggMemberFilter;
        }

        public final int getDimensionPosition() {
            return this.dimensionPosition;
        }

        @NotNull
        public final INumberSetFilter isAggMemberFilter() {
            return this.isAggMemberFilter;
        }

        public final int component1() {
            return this.dimensionPosition;
        }

        @NotNull
        public final INumberSetFilter component2() {
            return this.isAggMemberFilter;
        }

        @NotNull
        public final IsAggMemberFilterPair copy(int dimensionPosition, @NotNull INumberSetFilter isAggMemberFilter) {
            Intrinsics.checkNotNullParameter((Object)isAggMemberFilter, (String)"isAggMemberFilter");
            return new IsAggMemberFilterPair(dimensionPosition, isAggMemberFilter);
        }

        public static /* synthetic */ IsAggMemberFilterPair copy$default(IsAggMemberFilterPair isAggMemberFilterPair, int n, INumberSetFilter iNumberSetFilter, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = isAggMemberFilterPair.dimensionPosition;
            }
            if ((n2 & 2) != 0) {
                iNumberSetFilter = isAggMemberFilterPair.isAggMemberFilter;
            }
            return isAggMemberFilterPair.copy(n, iNumberSetFilter);
        }

        @NotNull
        public String toString() {
            return "IsAggMemberFilterPair(dimensionPosition=" + this.dimensionPosition + ", isAggMemberFilter=" + this.isAggMemberFilter + ')';
        }

        public int hashCode() {
            int result = Integer.hashCode(this.dimensionPosition);
            result = result * 31 + this.isAggMemberFilter.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof IsAggMemberFilterPair)) {
                return false;
            }
            IsAggMemberFilterPair isAggMemberFilterPair = (IsAggMemberFilterPair)other;
            if (this.dimensionPosition != isAggMemberFilterPair.dimensionPosition) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.isAggMemberFilter, (Object)isAggMemberFilterPair.isAggMemberFilter);
        }
    }
}

