/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.computingEngine.batchTasks;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b \u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0003\u0014\u0015\u0016B\u0013\u0012\f\b\u0002\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005\u00a2\u0006\u0002\u0010\u0006J!\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\r2\n\u0010\u000e\u001a\u00060\u0004j\u0002`\u0005H&\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\f0\u0011R\b\u0012\u0004\u0012\u00028\u00000\u0000J\u0010\u0010\u0012\u001a\f0\u0013R\b\u0012\u0004\u0012\u00028\u00000\u0000R\u001c\u0010\u0007\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lkd/bos/olapServer/computingEngine/batchTasks/BatchQueue;", "E", "", "batchSize", "", "Lkd/bos/olapServer/common/int;", "(I)V", "_queue", "Ljava/util/concurrent/ArrayBlockingQueue;", "Lkd/bos/olapServer/computingEngine/batchTasks/BatchQueue$BatchArray;", "_writerCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "createArray", "", "size", "(I)[Ljava/lang/Object;", "createReader", "Lkd/bos/olapServer/computingEngine/batchTasks/BatchQueue$QueueReader;", "createWriter", "Lkd/bos/olapServer/computingEngine/batchTasks/BatchQueue$QueueWriter;", "BatchArray", "QueueReader", "QueueWriter", "bos-olap-core"})
public abstract class BatchQueue<E> {
    private final int batchSize;
    @NotNull
    private final ArrayBlockingQueue<BatchArray<E>> _queue;
    @NotNull
    private final AtomicInteger _writerCount;

    public BatchQueue(int batchSize) {
        this.batchSize = batchSize;
        this._queue = new ArrayBlockingQueue(1024, false);
        this._writerCount = new AtomicInteger();
    }

    public /* synthetic */ BatchQueue(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 1024;
        }
        this(n);
    }

    @NotNull
    public final QueueWriter createWriter() {
        this._writerCount.incrementAndGet();
        return new QueueWriter();
    }

    @NotNull
    public final QueueReader createReader() {
        return new QueueReader();
    }

    @NotNull
    public abstract E[] createArray(int var1);

    public BatchQueue() {
        this(0, 1, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\n\u001a\u00020\u000bJ\u0013\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u000f\u001a\u00020\u000bH\u0002J\u0015\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0004H\u0002\u00a2\u0006\u0002\u0010\u0011R\u001a\u0010\u0003\u001a\f\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00060\u0007j\u0002`\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lkd/bos/olapServer/computingEngine/batchTasks/BatchQueue$QueueWriter;", "", "(Lkd/bos/olapServer/computingEngine/batchTasks/BatchQueue;)V", "_array", "", "[Ljava/lang/Object;", "_currentBatchSize", "", "_size", "Lkd/bos/olapServer/common/int;", "end", "", "put", "item", "(Ljava/lang/Object;)V", "putToQueue", "reCreate", "()[Ljava/lang/Object;", "bos-olap-core"})
    public final class QueueWriter {
        @Nullable
        private E[] _array;
        private int _size;
        private int _currentBatchSize;

        public QueueWriter() {
            Intrinsics.checkNotNullParameter((Object)BatchQueue.this, (String)"this$0");
            this._currentBatchSize = 2;
        }

        public final void put(E item) {
            Object object = this._array;
            E[] array = object == null ? this.reCreate() : object;
            object = this;
            int n = object._size;
            object._size = n + 1;
            array[n] = item;
            if (this._size == array.length) {
                this.putToQueue();
            }
        }

        private final E[] reCreate() {
            E[] array;
            int bs = this._currentBatchSize;
            if (bs < BatchQueue.this.batchSize) {
                if ((bs *= 2) > BatchQueue.this.batchSize) {
                    bs = BatchQueue.this.batchSize;
                }
                this._currentBatchSize = bs;
            }
            E[] EArray = array = BatchQueue.this.createArray(bs);
            boolean bl = false;
            E[] EArray2 = EArray;
            boolean bl2 = false;
            boolean bl3 = !(EArray2.length == 0);
            bl = false;
            boolean bl4 = false;
            bl4 = false;
            bl2 = false;
            if (!bl3) {
                boolean bl5 = false;
                String string = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            this._size = 0;
            this._array = array;
            return array;
        }

        public final void end() {
            int writerCountNow;
            if (this._size > 0) {
                this.putToQueue();
            }
            if ((writerCountNow = BatchQueue.this._writerCount.decrementAndGet()) == 0) {
                this._size = 0;
                E[] EArray = this._array;
                E[] array = EArray == null ? BatchQueue.this.createArray(0) : EArray;
                BatchArray ba = new BatchArray(array, this._size);
                BatchQueue.this._queue.put(ba);
            }
        }

        private final void putToQueue() {
            E[] array = this._array;
            if (array != null) {
                BatchArray ba = new BatchArray(array, this._size);
                BatchQueue.this._queue.put(ba);
                this._array = null;
                this._size = 0;
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\n\u001a\f\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u00010\u0004H\u0002\u00a2\u0006\u0002\u0010\u000bJ\r\u0010\f\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\rR\u001a\u0010\u0003\u001a\f\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0012\u0010\u0006\u001a\u00060\u0007j\u0002`\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00060\u0007j\u0002`\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lkd/bos/olapServer/computingEngine/batchTasks/BatchQueue$QueueReader;", "", "(Lkd/bos/olapServer/computingEngine/batchTasks/BatchQueue;)V", "_array", "", "[Ljava/lang/Object;", "_index", "", "Lkd/bos/olapServer/common/int;", "_size", "getArray", "()[Ljava/lang/Object;", "tryTake", "()Ljava/lang/Object;", "bos-olap-core"})
    public final class QueueReader {
        @Nullable
        private E[] _array;
        private int _size;
        private int _index;

        public QueueReader() {
            Intrinsics.checkNotNullParameter((Object)BatchQueue.this, (String)"this$0");
        }

        @Nullable
        public final E tryTake() {
            E[] EArray;
            Object object;
            E[] EArray2 = this._array;
            if (EArray2 == null) {
                object = this.getArray();
                if (object == null) {
                    return null;
                }
                EArray = object;
            } else {
                EArray = EArray2;
            }
            E[] array = EArray;
            object = this;
            int n = object._index;
            object._index = n + 1;
            Object result = array[n];
            if (this._size == this._index) {
                this._array = null;
            }
            return result;
        }

        private final E[] getArray() {
            BatchArray ba = (BatchArray)BatchQueue.this._queue.take();
            E[] array = ba.getItems();
            this._array = array;
            this._size = ba.getSize();
            this._index = 0;
            if (this._size == 0) {
                BatchQueue.this._queue.put(ba);
                return null;
            }
            return array;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B\u001f\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u00a2\u0006\u0002\u0010\bR\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0015\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lkd/bos/olapServer/computingEngine/batchTasks/BatchQueue$BatchArray;", "E", "", "items", "", "size", "", "Lkd/bos/olapServer/common/int;", "([Ljava/lang/Object;I)V", "getItems", "()[Ljava/lang/Object;", "[Ljava/lang/Object;", "getSize", "()I", "bos-olap-core"})
    public static final class BatchArray<E> {
        @NotNull
        private final E[] items;
        private final int size;

        public BatchArray(@NotNull E[] items2, int size) {
            Intrinsics.checkNotNullParameter(items2, (String)"items");
            this.items = items2;
            this.size = size;
        }

        @NotNull
        public final E[] getItems() {
            return this.items;
        }

        public final int getSize() {
            return this.size;
        }
    }
}

