/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.computingEngine.batchTasks;

import kd.bos.olapServer.collections.IIterator;
import kd.bos.olapServer.computingEngine.batchTasks.AbstractBatchLockedResourceIterator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u0001*\b\b\u0001\u0010\u0002*\u0002H\u0001*\b\b\u0002\u0010\u0003*\u00020\u00042\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0005Bx\b\u0016\u0012\u0006\u0010\u0006\u001a\u00028\u0002\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\b\u0012Y\u0010\t\u001aU\u0012\u0013\u0012\u00118\u0002\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u0006\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00028\u00010\b\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0017\u0012\u00150\u000ej\u0002`\u000f\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u0010\u0012\b\u0012\u00060\u000ej\u0002`\u000f0\n\u00a2\u0006\u0002\u0010\u0011B@\b\u0016\u0012\u0006\u0010\u0006\u001a\u00028\u0002\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\b\u0012!\u0010\u0012\u001a\u001d\u0012\u0013\u0012\u00118\u0002\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u0006\u0012\u0004\u0012\u00028\u00010\u0013\u00a2\u0006\u0002\u0010\u0014J+\u0010\u0016\u001a\u00060\u000ej\u0002`\u000f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00010\b2\n\u0010\u0010\u001a\u00060\u000ej\u0002`\u000fH\u0014\u00a2\u0006\u0002\u0010\u0017Rc\u0010\t\u001aW\u0012\u0013\u0012\u00118\u0002\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u0006\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00028\u00010\b\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0017\u0012\u00150\u000ej\u0002`\u000f\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u0010\u0012\b\u0012\u00060\u000ej\u0002`\u000f\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u0012\u001a\u001f\u0012\u0013\u0012\u00118\u0002\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u0006\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00028\u0002X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015\u00a8\u0006\u0018"}, d2={"Lkd/bos/olapServer/computingEngine/batchTasks/BatchResourceIterator;", "TOut", "T", "TSource", "Lkd/bos/olapServer/collections/IIterator;", "Lkd/bos/olapServer/computingEngine/batchTasks/AbstractBatchLockedResourceIterator;", "source", "cacheArray", "", "loadFunc", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "array", "", "Lkd/bos/olapServer/common/int;", "size", "(Lkd/bos/olapServer/collections/IIterator;[Ljava/lang/Object;Lkotlin/jvm/functions/Function3;)V", "map", "Lkotlin/Function1;", "(Lkd/bos/olapServer/collections/IIterator;[Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)V", "Lkd/bos/olapServer/collections/IIterator;", "load", "([Ljava/lang/Object;I)I", "bos-olap-core"})
public final class BatchResourceIterator<TOut, T extends TOut, TSource extends IIterator>
extends AbstractBatchLockedResourceIterator<TOut, T> {
    @NotNull
    private final TSource source;
    @Nullable
    private final Function1<TSource, T> map;
    @Nullable
    private final Function3<TSource, T[], Integer, Integer> loadFunc;

    public BatchResourceIterator(@NotNull TSource source2, @NotNull T[] cacheArray, @NotNull Function3<? super TSource, ? super T[], ? super Integer, Integer> loadFunc) {
        Intrinsics.checkNotNullParameter(source2, (String)"source");
        Intrinsics.checkNotNullParameter(cacheArray, (String)"cacheArray");
        Intrinsics.checkNotNullParameter(loadFunc, (String)"loadFunc");
        super(cacheArray);
        this.source = source2;
        this.loadFunc = loadFunc;
        this.map = null;
    }

    public BatchResourceIterator(@NotNull TSource source2, @NotNull T[] cacheArray, @NotNull Function1<? super TSource, ? extends T> map) {
        Intrinsics.checkNotNullParameter(source2, (String)"source");
        Intrinsics.checkNotNullParameter(cacheArray, (String)"cacheArray");
        Intrinsics.checkNotNullParameter(map, (String)"map");
        super(cacheArray);
        this.source = source2;
        this.loadFunc = null;
        this.map = map;
    }

    @Override
    protected int load(@NotNull T[] array, int size) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        Function3<TSource, T[], Integer, Integer> loadf = this.loadFunc;
        if (loadf != null) {
            return ((Number)loadf.invoke(this.source, array, (Object)size)).intValue();
        }
        Function1<TSource, T> mapf = this.map;
        if (mapf != null) {
            int realSize = 0;
            while (realSize < size && this.source.next()) {
                int n = realSize;
                realSize = n + 1;
                array[n] = mapf.invoke(this.source);
            }
            return realSize;
        }
        throw new RuntimeException();
    }
}

