/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.computingEngine.batchTasks;

import java.io.Closeable;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kd.bos.olapServer.computingEngine.batchTasks.ComputingContext;
import kd.bos.olapServer.computingEngine.thread.ComputingResourceContainer;
import kd.bos.olapServer.computingEngine.thread.OlapThreadPoolExecutor;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b \u0018\u0000 /2\u00020\u0001:\u0002/0B\u0005\u00a2\u0006\u0002\u0010\u0002J\f\u0010!\u001a\u00060\u0004j\u0002`\u0005H\u0002J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020#H\u0014J\u0016\u0010%\u001a\u00020#2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)J\u0018\u0010*\u001a\u00020#2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H$J\b\u0010+\u001a\u00020#H\u0002J\b\u0010,\u001a\u00020#H\u0016J\u0014\u0010-\u001a\u00020#2\n\u0010.\u001a\u00060\u0013j\u0002`\u0014H\u0002R\u0012\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\t\u001a\u00060\u0004j\u0002`\u00058F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0015\u0010\f\u001a\u00060\u0004j\u0002`\u00058F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000bR\u0018\u0010\r\u001a\u00060\u000ej\u0002`\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0018\u0010\u0012\u001a\u00060\u0013j\u0002`\u00148TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0012\u0010\u001c\u001a\u00060\u001dj\u0002`\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001f\u001a\u00060\u0013j\u0002`\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0016\u00a8\u00061"}, d2={"Lkd/bos/olapServer/computingEngine/batchTasks/ComputingTask;", "Ljava/io/Closeable;", "()V", "_isClosed", "", "Lkd/bos/olapServer/common/bool;", "_states", "Ljava/util/concurrent/atomic/AtomicReference;", "Lkd/bos/olapServer/computingEngine/batchTasks/ComputingTask$ComputingTaskStates;", "hasSomeJobs", "getHasSomeJobs", "()Z", "isClosed", "lockTime", "", "Lkd/bos/olapServer/common/long;", "getLockTime", "()J", "name", "", "Lkd/bos/olapServer/common/string;", "getName", "()Ljava/lang/String;", "nextTask", "getNextTask", "()Lkd/bos/olapServer/computingEngine/batchTasks/ComputingTask;", "setNextTask", "(Lkd/bos/olapServer/computingEngine/batchTasks/ComputingTask;)V", "taskId", "", "Lkd/bos/olapServer/common/int;", "workerName", "getWorkerName", "canCreate", "close", "", "closeCore", "executeJob", "res", "Lkd/bos/olapServer/computingEngine/thread/ComputingResourceContainer;", "ctx", "Lkd/bos/olapServer/computingEngine/batchTasks/ComputingContext;", "executeJobCore", "iHaveFinished", "onStarting", "printDebugInfo", "info", "Companion", "ComputingTaskStates", "bos-olap-core"})
public abstract class ComputingTask
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AtomicReference<ComputingTaskStates> _states = new AtomicReference<ComputingTaskStates>(ComputingTaskStates.Ready);
    private final int taskId;
    private boolean _isClosed;
    @Nullable
    private volatile ComputingTask nextTask;
    @NotNull
    private static final OlapThreadPoolExecutor executor = new OlapThreadPoolExecutor("computingThread-");
    @NotNull
    private static final AtomicInteger TASK_ID = new AtomicInteger();

    public ComputingTask() {
        this.taskId = 0;
    }

    public final boolean getHasSomeJobs() {
        return this._states.get() == ComputingTaskStates.Ready;
    }

    public void onStarting() {
    }

    private final boolean canCreate() {
        return this._states.get() == ComputingTaskStates.Ready;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void executeJob(@NotNull ComputingResourceContainer res, @NotNull ComputingContext ctx) {
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if (this.canCreate()) {
            try {
                boolean $i$f$statistics = false;
                this.executeJobCore(res, ctx);
            }
            finally {
                this.iHaveFinished();
            }
        }
    }

    protected abstract void executeJobCore(@NotNull ComputingResourceContainer var1, @NotNull ComputingContext var2);

    @NotNull
    protected String getName() {
        String string = ((Class)new PropertyReference0Impl(this){

            @Nullable
            public Object get() {
                return this.receiver.getClass();
            }
        }.get()).getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this::javaClass.get().simpleName");
        return string;
    }

    private final String getWorkerName() {
        return String.valueOf(Thread.currentThread().getId());
    }

    private final void printDebugInfo(String info) {
        String string = Instant.now() + ' ' + this.getWorkerName() + " Task:[" + this.taskId + "],  " + info;
        boolean bl = false;
        System.out.println((Object)string);
    }

    private final void iHaveFinished() {
        boolean $i$f$statistics = false;
        this._states.compareAndSet(ComputingTaskStates.Ready, ComputingTaskStates.DataSourceEnd);
    }

    protected void closeCore() {
    }

    @Override
    public void close() {
        if (!this._isClosed) {
            boolean $i$f$statistics = false;
            this._states.set(ComputingTaskStates.Finished);
            this.closeCore();
            this._isClosed = true;
            $i$f$statistics = false;
        }
    }

    public final boolean isClosed() {
        return this._isClosed;
    }

    @Nullable
    public final ComputingTask getNextTask() {
        return this.nextTask;
    }

    public final void setNextTask(@Nullable ComputingTask computingTask) {
        this.nextTask = computingTask;
    }

    public long getLockTime() {
        return 0L;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lkd/bos/olapServer/computingEngine/batchTasks/ComputingTask$Companion;", "", "()V", "TASK_ID", "Ljava/util/concurrent/atomic/AtomicInteger;", "executor", "Lkd/bos/olapServer/computingEngine/thread/OlapThreadPoolExecutor;", "getExecutor", "()Lkd/bos/olapServer/computingEngine/thread/OlapThreadPoolExecutor;", "bos-olap-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final OlapThreadPoolExecutor getExecutor() {
            return executor;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lkd/bos/olapServer/computingEngine/batchTasks/ComputingTask$ComputingTaskStates;", "", "(Ljava/lang/String;I)V", "Ready", "DataSourceEnd", "Finished", "bos-olap-core"})
    private static final class ComputingTaskStates
    extends Enum<ComputingTaskStates> {
        public static final /* enum */ ComputingTaskStates Ready = new ComputingTaskStates();
        public static final /* enum */ ComputingTaskStates DataSourceEnd = new ComputingTaskStates();
        public static final /* enum */ ComputingTaskStates Finished = new ComputingTaskStates();
        private static final /* synthetic */ ComputingTaskStates[] $VALUES;

        public static ComputingTaskStates[] values() {
            return (ComputingTaskStates[])$VALUES.clone();
        }

        public static ComputingTaskStates valueOf(String value2) {
            return Enum.valueOf(ComputingTaskStates.class, value2);
        }

        static {
            $VALUES = computingTaskStatesArray = new ComputingTaskStates[]{ComputingTaskStates.Ready, ComputingTaskStates.DataSourceEnd, ComputingTaskStates.Finished};
        }
    }
}

