/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.computingEngine.batchTasks;

import kd.bos.olapServer.computingEngine.batchTasks.ComputingContext;
import kd.bos.olapServer.computingEngine.batchTasks.ComputingTask;
import kd.bos.olapServer.computingEngine.thread.ComputingResourceContainer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0014J\u0018\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\b\u0010\u0012\u001a\u00020\fH\u0016R\u0018\u0010\u0005\u001a\u00060\u0006j\u0002`\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006\u0013"}, d2={"Lkd/bos/olapServer/computingEngine/batchTasks/GroupComputingTask;", "Lkd/bos/olapServer/computingEngine/batchTasks/ComputingTask;", "tasks", "", "([Lkd/bos/olapServer/computingEngine/batchTasks/ComputingTask;)V", "lockTime", "", "Lkd/bos/olapServer/common/long;", "getLockTime", "()J", "[Lkd/bos/olapServer/computingEngine/batchTasks/ComputingTask;", "closeCore", "", "executeJobCore", "res", "Lkd/bos/olapServer/computingEngine/thread/ComputingResourceContainer;", "ctx", "Lkd/bos/olapServer/computingEngine/batchTasks/ComputingContext;", "onStarting", "bos-olap-core"})
public final class GroupComputingTask
extends ComputingTask {
    @NotNull
    private final ComputingTask[] tasks;

    public GroupComputingTask(@NotNull ComputingTask[] tasks) {
        Intrinsics.checkNotNullParameter((Object)tasks, (String)"tasks");
        this.tasks = tasks;
    }

    @Override
    public void onStarting() {
        for (ComputingTask task : this.tasks) {
            task.onStarting();
        }
    }

    @Override
    protected void executeJobCore(@NotNull ComputingResourceContainer res, @NotNull ComputingContext ctx) {
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        for (ComputingTask task : this.tasks) {
            task.executeJob(res, ctx);
        }
    }

    @Override
    protected void closeCore() {
        for (ComputingTask task : this.tasks) {
            task.close();
        }
    }

    @Override
    public long getLockTime() {
        long result = 0L;
        ComputingTask[] computingTaskArray = this.tasks;
        int n = 0;
        int n2 = computingTaskArray.length;
        while (n < n2) {
            ComputingTask task = computingTaskArray[n];
            ++n;
            result += task.getLockTime();
        }
        return result;
    }
}

