/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.computingEngine.batchTasks;

import kd.bos.olapServer.common.CancellableToken;
import kd.bos.olapServer.common.CommonTypesKt;
import kd.bos.olapServer.common.IContinueToken;
import kd.bos.olapServer.computingEngine.IComputingScope;
import kd.bos.olapServer.computingEngine.IComputingUnit;
import kd.bos.olapServer.computingEngine.UnitDependencyMapperContainer;
import kd.bos.olapServer.computingEngine.batchTasks.ComputingContext;
import kd.bos.olapServer.computingEngine.batchTasks.ComputingScope;
import kd.bos.olapServer.computingEngine.batchTasks.ComputingTask;
import kd.bos.olapServer.computingEngine.thread.ComputingResourceContainer;
import kd.bos.olapServer.computingEngine.thread.ComputingWorkspace;
import kd.bos.olapServer.dataEntities.IDimensionKeys;
import kd.bos.olapServer.storages.tempStorages.MutableLinkedListFactorRow;
import kd.bos.olapServer.tools.Res;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lkd/bos/olapServer/computingEngine/batchTasks/StandardComputingTask;", "Lkd/bos/olapServer/computingEngine/batchTasks/ComputingTask;", "computingWorkspace", "Lkd/bos/olapServer/computingEngine/thread/ComputingWorkspace;", "(Lkd/bos/olapServer/computingEngine/thread/ComputingWorkspace;)V", "execute", "", "unit", "Lkd/bos/olapServer/computingEngine/IComputingUnit;", "scope", "Lkd/bos/olapServer/computingEngine/IComputingScope;", "executeJobCore", "", "res", "Lkd/bos/olapServer/computingEngine/thread/ComputingResourceContainer;", "ctx", "Lkd/bos/olapServer/computingEngine/batchTasks/ComputingContext;", "onStarting", "bos-olap-core"})
public final class StandardComputingTask
extends ComputingTask {
    @NotNull
    private final ComputingWorkspace computingWorkspace;

    public StandardComputingTask(@NotNull ComputingWorkspace computingWorkspace) {
        Intrinsics.checkNotNullParameter((Object)computingWorkspace, (String)"computingWorkspace");
        this.computingWorkspace = computingWorkspace;
    }

    @Override
    public void onStarting() {
        super.onStarting();
        this.computingWorkspace.getSharedResourceContainer().getTargetList().flush();
    }

    @Override
    protected void executeJobCore(@NotNull ComputingResourceContainer res, @NotNull ComputingContext ctx) {
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        MutableLinkedListFactorRow targetList = this.computingWorkspace.getSharedResourceContainer().pollSubTargetList();
        IContinueToken continueToken = CancellableToken.INSTANCE.getContinueToken();
        while (targetList != null) {
            ComputingScope scope = res.getScope();
            MutableLinkedListFactorRow.CalcUnitRowIterator source2 = targetList.iterator();
            UnitDependencyMapperContainer units = this.computingWorkspace.getDependencyContainer();
            while (source2.next() && continueToken.canContinue()) {
                IDimensionKeys targetKey = source2.getTargetKey();
                IComputingUnit unit = units.get(source2.getCalcUnitId());
                scope.switch(unit, targetKey, source2.getFactorArray());
                Object mainMeasureValue = this.execute(unit, scope);
                targetList.updateTargetValue(source2.getIndex(), mainMeasureValue);
            }
            ctx.getFactorCount().addAndGet(targetList.getFactorCount());
            targetList = this.computingWorkspace.getSharedResourceContainer().pollSubTargetList();
        }
    }

    private final Object execute(IComputingUnit unit, IComputingScope scope) {
        Object value2 = null;
        try {
            value2 = unit.execute(scope);
        }
        catch (ArithmeticException ex) {
            String message2 = ex.getMessage();
            if (message2 == null) {
                Object[] objectArray = Res.INSTANCE.getComputingTaskException_3();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.ComputingTaskException_3");
                Object[] objectArray2 = objectArray;
                objectArray = new Object[]{unit};
                throw Res.INSTANCE.getRuntimeException((String)objectArray2, ex, objectArray);
            }
            if (Intrinsics.areEqual((Object)message2, (Object)"BigInteger divide by zero") || Intrinsics.areEqual((Object)message2, (Object)"Division by zero")) {
                Object[] objectArray = Res.INSTANCE.getComputingTaskException_2();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.ComputingTaskException_2");
                Object[] objectArray3 = objectArray;
                objectArray = new Object[]{unit};
                throw Res.INSTANCE.getRuntimeException((String)objectArray3, ex, objectArray);
            }
            Object[] objectArray = Res.INSTANCE.getComputingTaskException_1();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.ComputingTaskException_1");
            Object[] objectArray4 = objectArray;
            objectArray = new Object[]{unit, ex.getMessage()};
            throw Res.INSTANCE.getRuntimeException((String)objectArray4, ex, objectArray);
        }
        catch (Exception ex) {
            Object[] objectArray = Res.INSTANCE.getComputingTaskException_1();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.ComputingTaskException_1");
            Object[] objectArray5 = objectArray;
            objectArray = new Object[]{unit, ex.getMessage()};
            throw Res.INSTANCE.getRuntimeException((String)objectArray5, ex, objectArray);
        }
        return value2 == CommonTypesKt.getUndefined() ? null : value2;
    }
}

