/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.computingEngine.dynamicCalc;

import kd.bos.olapServer.common.NotSupportedException;
import kd.bos.olapServer.computingEngine.AbstractMultiDimensionAggMapper;
import kd.bos.olapServer.computingEngine.AggShieldRuleMasker;
import kd.bos.olapServer.computingEngine.AlwaysTrueDimensionKeysFilter;
import kd.bos.olapServer.computingEngine.IDimensionKeysFilter;
import kd.bos.olapServer.computingEngine.IDimensionKeysFilterKt;
import kd.bos.olapServer.computingEngine.StoredFilter;
import kd.bos.olapServer.computingEngine.batchTasks.SimpleRowKey;
import kd.bos.olapServer.computingEngine.multiDimensionAgg.AggOperators;
import kd.bos.olapServer.computingEngine.multiDimensionAgg.MultiDimensionAggComputingUnit;
import kd.bos.olapServer.metadata.Cube;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0012B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\n\u0010\f\u001a\u00060\rj\u0002`\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00060\rj\u0002`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lkd/bos/olapServer/computingEngine/dynamicCalc/DynamicCalcAggMapper;", "Lkd/bos/olapServer/computingEngine/AbstractMultiDimensionAggMapper;", "unit", "Lkd/bos/olapServer/computingEngine/multiDimensionAgg/MultiDimensionAggComputingUnit;", "cube", "Lkd/bos/olapServer/metadata/Cube;", "storedFilter", "Lkd/bos/olapServer/computingEngine/StoredFilter;", "filter", "Lkd/bos/olapServer/computingEngine/IDimensionKeysFilter;", "ruleMasker", "Lkd/bos/olapServer/computingEngine/AggShieldRuleMasker;", "isSimpleFilter", "", "Lkd/bos/olapServer/common/bool;", "(Lkd/bos/olapServer/computingEngine/multiDimensionAgg/MultiDimensionAggComputingUnit;Lkd/bos/olapServer/metadata/Cube;Lkd/bos/olapServer/computingEngine/StoredFilter;Lkd/bos/olapServer/computingEngine/IDimensionKeysFilter;Lkd/bos/olapServer/computingEngine/AggShieldRuleMasker;Z)V", "createMapRowIteratorBuilder", "Lkd/bos/olapServer/computingEngine/AbstractMultiDimensionAggMapper$IMapRowIteratorBuilder;", "MapRowIteratorBuilder", "bos-olap-core"})
public final class DynamicCalcAggMapper
extends AbstractMultiDimensionAggMapper {
    @NotNull
    private final Cube cube;
    @NotNull
    private final StoredFilter storedFilter;
    @NotNull
    private final IDimensionKeysFilter filter;
    private final boolean isSimpleFilter;

    public DynamicCalcAggMapper(@NotNull MultiDimensionAggComputingUnit unit, @NotNull Cube cube, @NotNull StoredFilter storedFilter, @NotNull IDimensionKeysFilter filter, @NotNull AggShieldRuleMasker ruleMasker, boolean isSimpleFilter) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        Intrinsics.checkNotNullParameter((Object)cube, (String)"cube");
        Intrinsics.checkNotNullParameter((Object)storedFilter, (String)"storedFilter");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        Intrinsics.checkNotNullParameter((Object)ruleMasker, (String)"ruleMasker");
        super(unit, ruleMasker, true);
        this.cube = cube;
        this.storedFilter = storedFilter;
        this.filter = filter;
        this.isSimpleFilter = isSimpleFilter;
    }

    @NotNull
    public final AbstractMultiDimensionAggMapper.IMapRowIteratorBuilder createMapRowIteratorBuilder() {
        return new MapRowIteratorBuilder(this.cube, this.storedFilter.clone(), this.filter, this.createMapRowIteratorBuilderCore(), this.isSimpleFilter);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B1\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0001\u0012\n\u0010\t\u001a\u00060\nj\u0002`\u000b\u00a2\u0006\u0002\u0010\fJ\f\u0010\u001b\u001a\u00060\nj\u0002`\u000bH\u0002J\f\u0010\u001c\u001a\u00060\nj\u0002`\u000bH\u0002J\u0010\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u000fH\u0016J\f\u0010\u001f\u001a\u00060\nj\u0002`\u000bH\u0016R\u000e\u0010\r\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u00060\u0011j\u0002`\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00060\nj\u0002`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0013\u001a\u00060\nj\u0002`\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lkd/bos/olapServer/computingEngine/dynamicCalc/DynamicCalcAggMapper$MapRowIteratorBuilder;", "Lkd/bos/olapServer/computingEngine/AbstractMultiDimensionAggMapper$IMapRowIteratorBuilder;", "Lkd/bos/olapServer/computingEngine/AbstractMultiDimensionAggMapper$IMapRowIterator;", "cube", "Lkd/bos/olapServer/metadata/Cube;", "storedFilter", "Lkd/bos/olapServer/computingEngine/IDimensionKeysFilter;", "filter", "coreBuilder", "isSampleFilter", "", "Lkd/bos/olapServer/common/bool;", "(Lkd/bos/olapServer/metadata/Cube;Lkd/bos/olapServer/computingEngine/IDimensionKeysFilter;Lkd/bos/olapServer/computingEngine/IDimensionKeysFilter;Lkd/bos/olapServer/computingEngine/AbstractMultiDimensionAggMapper$IMapRowIteratorBuilder;Z)V", "_currentItr", "_currentRowKey", "Lkd/bos/olapServer/computingEngine/batchTasks/SimpleRowKey;", "_state", "", "Lkd/bos/olapServer/common/int;", "isStored", "()Z", "mergeFilter", "operator", "Lkd/bos/olapServer/computingEngine/multiDimensionAgg/AggOperators;", "getOperator", "()Lkd/bos/olapServer/computingEngine/multiDimensionAgg/AggOperators;", "validFilter", "buildSequenceAndNext", "coreNext", "createIterator", "rowKey", "next", "bos-olap-core"})
    private static final class MapRowIteratorBuilder
    implements AbstractMultiDimensionAggMapper.IMapRowIteratorBuilder,
    AbstractMultiDimensionAggMapper.IMapRowIterator {
        @NotNull
        private final IDimensionKeysFilter storedFilter;
        @NotNull
        private final AbstractMultiDimensionAggMapper.IMapRowIteratorBuilder coreBuilder;
        private final boolean isSampleFilter;
        @NotNull
        private final IDimensionKeysFilter validFilter;
        @NotNull
        private final IDimensionKeysFilter mergeFilter;
        @NotNull
        private AbstractMultiDimensionAggMapper.IMapRowIterator _currentItr;
        private int _state;
        @NotNull
        private SimpleRowKey _currentRowKey;

        public MapRowIteratorBuilder(@NotNull Cube cube, @NotNull IDimensionKeysFilter storedFilter, @NotNull IDimensionKeysFilter filter, @NotNull AbstractMultiDimensionAggMapper.IMapRowIteratorBuilder coreBuilder, boolean isSampleFilter) {
            Intrinsics.checkNotNullParameter((Object)cube, (String)"cube");
            Intrinsics.checkNotNullParameter((Object)storedFilter, (String)"storedFilter");
            Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
            Intrinsics.checkNotNullParameter((Object)coreBuilder, (String)"coreBuilder");
            this.storedFilter = storedFilter;
            this.coreBuilder = coreBuilder;
            this.isSampleFilter = isSampleFilter;
            this.validFilter = cube.getValidDataRules().getValidFilter();
            this.mergeFilter = IDimensionKeysFilterKt.and(filter, this.validFilter);
            this._currentItr = AbstractMultiDimensionAggMapper.EmptyMapRowIterator.INSTANCE;
            this._state = 3;
            this._currentRowKey = new SimpleRowKey(cube, null, 2, null);
        }

        @Override
        @NotNull
        public AbstractMultiDimensionAggMapper.IMapRowIterator createIterator(@NotNull SimpleRowKey rowKey) {
            Intrinsics.checkNotNullParameter((Object)rowKey, (String)"rowKey");
            this._currentRowKey = rowKey;
            this._state = 3;
            return this;
        }

        @Override
        public boolean next() {
            boolean bl;
            int n = this._state;
            switch (n) {
                case 0: {
                    bl = false;
                    break;
                }
                case 1: {
                    bl = this.coreNext();
                    break;
                }
                case 2: {
                    bl = this.buildSequenceAndNext();
                    break;
                }
                case 3: {
                    if (!this.storedFilter.match(this._currentRowKey)) {
                        this._state = 0;
                        return false;
                    }
                    if (this.mergeFilter.match(this._currentRowKey)) {
                        this._state = 2;
                        return true;
                    }
                    bl = this.buildSequenceAndNext();
                    break;
                }
                default: {
                    throw new NotSupportedException();
                }
            }
            return bl;
        }

        @Override
        @NotNull
        public AggOperators getOperator() {
            return this._currentItr.getOperator();
        }

        @Override
        public boolean isStored() {
            return this._state == 2;
        }

        private final boolean buildSequenceAndNext() {
            this._currentItr = this.coreBuilder.createIterator(this._currentRowKey);
            this._state = 1;
            return this.coreNext();
        }

        private final boolean coreNext() {
            while (this._currentItr.next()) {
                boolean simpleFilter = this.isSampleFilter & this.validFilter == AlwaysTrueDimensionKeysFilter.INSTANCE;
                if (!simpleFilter && !this.mergeFilter.match(this._currentRowKey)) continue;
                return true;
            }
            this._state = 0;
            return false;
        }
    }
}

