/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.computingEngine.dynamicCalc;

import java.util.BitSet;
import java.util.Iterator;
import kd.bos.olapServer.computingEngine.multiDimensionAgg.AggFactor;
import kd.bos.olapServer.metadata.Cube;
import kd.bos.olapServer.metadata.Dimension;
import kd.bos.olapServer.metadata.Member;
import kd.bos.olapServer.metadata.MemberCollection;
import kd.bos.olapServer.metadata.MemberStorageTypes;
import kd.bos.olapServer.query.match.AbstractMatchBitmap;
import kd.bos.olapServer.query.models.AndFilter;
import kd.bos.olapServer.query.models.ContainerFilter;
import kd.bos.olapServer.query.models.DimensionFilter;
import kd.bos.olapServer.query.models.Filter;
import kd.bos.olapServer.query.models.OrFilter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\u0010\t\u001a\u00060\nj\u0002`\u000b\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0000H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0002J\u0012\u0010!\u001a\u00020\u00102\n\u0010\"\u001a\u00060\u0005j\u0002`\u0006J\u0010\u0010#\u001a\u00020\u00162\u0006\u0010$\u001a\u00020\u001fH\u0002J \u0010%\u001a\u00020\u00102\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010%\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0000H\u0002R\u000e\u0010\r\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006*"}, d2={"Lkd/bos/olapServer/computingEngine/dynamicCalc/FilterNode;", "", "cube", "Lkd/bos/olapServer/metadata/Cube;", "dimensionCount", "", "Lkd/bos/olapServer/common/int;", "sourceFilter", "Lkd/bos/olapServer/query/models/Filter;", "includeDynamicMemberWhenNullFilter", "", "Lkd/bos/olapServer/common/bool;", "(Lkd/bos/olapServer/metadata/Cube;ILkd/bos/olapServer/query/models/Filter;Z)V", "_expandedFilter", "_memberItems", "", "Lkd/bos/olapServer/query/match/AbstractMatchBitmap;", "[Lkd/bos/olapServer/query/match/AbstractMatchBitmap;", "expandedFilter", "getExpandedFilter", "()Lkd/bos/olapServer/query/models/Filter;", "and", "", "newContainer", "Lkd/bos/olapServer/query/models/ContainerFilter;", "other", "createStoredFullBitset", "Ljava/util/BitSet;", "members", "Lkd/bos/olapServer/metadata/MemberCollection;", "expandedDimFilter", "Lkd/bos/olapServer/query/models/DimensionFilter;", "sourceDimFilter", "getBitmap", "dimPosition", "initMemberItems", "filter", "or", "x", "Lkd/bos/olapServer/query/match/AbstractMatchBitmap$StoredFullBitmap;", "y", "Lkd/bos/olapServer/query/match/AbstractMatchBitmap$MatchBitmap;", "bos-olap-core"})
public final class FilterNode {
    @NotNull
    private final Cube cube;
    @NotNull
    private AbstractMatchBitmap[] _memberItems;
    @NotNull
    private final Filter _expandedFilter;

    public FilterNode(@NotNull Cube cube, int dimensionCount, @NotNull Filter sourceFilter, boolean includeDynamicMemberWhenNullFilter) {
        Intrinsics.checkNotNullParameter((Object)cube, (String)"cube");
        Intrinsics.checkNotNullParameter((Object)sourceFilter, (String)"sourceFilter");
        this.cube = cube;
        AbstractMatchBitmap initBitmap = includeDynamicMemberWhenNullFilter ? (AbstractMatchBitmap)AbstractMatchBitmap.FullBitmap.INSTANCE : (AbstractMatchBitmap)AbstractMatchBitmap.StoredFullBitmap.INSTANCE;
        Filter filter = sourceFilter;
        if (filter instanceof OrFilter) {
            ContainerFilter newContainer = new OrFilter();
            if (sourceFilter.getHasChildren()) {
                int n = 0;
                int n2 = dimensionCount;
                AbstractMatchBitmap[] abstractMatchBitmapArray = new AbstractMatchBitmap[n2];
                FilterNode filterNode = this;
                while (n < n2) {
                    int n3 = n++;
                    abstractMatchBitmapArray[n3] = AbstractMatchBitmap.EmptyBitmap.INSTANCE;
                }
                filterNode._memberItems = abstractMatchBitmapArray;
                Iterator<Filter> iterator = sourceFilter.getChildren();
                boolean bl = false;
                Iterator<Filter> iterator2 = iterator;
                while (iterator2.hasNext()) {
                    Filter child = iterator2.next();
                    this.or(newContainer, new FilterNode(this.cube, dimensionCount, child, includeDynamicMemberWhenNullFilter));
                }
            } else {
                int n = 0;
                int child = dimensionCount;
                AbstractMatchBitmap[] abstractMatchBitmapArray = new AbstractMatchBitmap[child];
                FilterNode filterNode = this;
                while (n < child) {
                    int n4 = n++;
                    abstractMatchBitmapArray[n4] = initBitmap;
                }
                filterNode._memberItems = abstractMatchBitmapArray;
            }
            this._expandedFilter = newContainer;
        } else if (filter instanceof AndFilter) {
            int n;
            int newContainer = 0;
            int n5 = dimensionCount;
            Object child = new AbstractMatchBitmap[n5];
            FilterNode filterNode = this;
            while (newContainer < n5) {
                n = newContainer++;
                child[n] = initBitmap;
            }
            filterNode._memberItems = child;
            ContainerFilter newContainer2 = new AndFilter();
            if (sourceFilter.getHasChildren()) {
                child = sourceFilter.getChildren();
                n = 0;
                Object object = child;
                while (object.hasNext()) {
                    child = (Filter)object.next();
                    this.and(newContainer2, new FilterNode(this.cube, dimensionCount, (Filter)child, includeDynamicMemberWhenNullFilter));
                }
            }
            this._expandedFilter = newContainer2;
        } else if (filter instanceof DimensionFilter) {
            int n = 0;
            int n6 = dimensionCount;
            AbstractMatchBitmap[] abstractMatchBitmapArray = new AbstractMatchBitmap[n6];
            FilterNode filterNode = this;
            while (n < n6) {
                int n7 = n++;
                abstractMatchBitmapArray[n7] = initBitmap;
            }
            filterNode._memberItems = abstractMatchBitmapArray;
            this._expandedFilter = this.expandedDimFilter((DimensionFilter)sourceFilter);
            this.initMemberItems((DimensionFilter)sourceFilter);
        } else {
            throw new RuntimeException(Intrinsics.stringPlus((String)"Not Support Filter: ", (Object)sourceFilter));
        }
    }

    @NotNull
    public final Filter getExpandedFilter() {
        return this._expandedFilter;
    }

    @NotNull
    public final AbstractMatchBitmap getBitmap(int dimPosition) {
        return this._memberItems[dimPosition];
    }

    private final void initMemberItems(DimensionFilter filter) {
        BitSet bitSet = new BitSet(filter.getMembers().size());
        for (Member member : filter.getMembers()) {
            bitSet.set(member.getPosition$bos_olap_core());
        }
        this._memberItems[filter.getDimension().getPosition()] = AbstractMatchBitmap.Companion.create(bitSet);
    }

    private final DimensionFilter expandedDimFilter(DimensionFilter sourceDimFilter) {
        Dimension dimension = sourceDimFilter.getDimension();
        DimensionFilter expandedDimensionFilter = new DimensionFilter(dimension);
        for (Member member : sourceDimFilter.getMembers()) {
            if (member.getStorageType() == MemberStorageTypes.DynamicCalc) {
                for (AggFactor factor : member.getExpandedExpression().getFactors()) {
                    expandedDimensionFilter.getMembers().add(factor.getFactor());
                }
                expandedDimensionFilter.getMembers().add(member);
                continue;
            }
            expandedDimensionFilter.getMembers().add(member);
        }
        return expandedDimensionFilter;
    }

    /*
     * WARNING - void declaration
     */
    private final void and(ContainerFilter newContainer, FilterNode other) {
        AbstractMatchBitmap[] otherItems = other._memberItems;
        AbstractMatchBitmap[] $this$forEachIndexed$iv = this._memberItems;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (AbstractMatchBitmap item$iv : $this$forEachIndexed$iv) {
            void bitmap;
            int n = index$iv++;
            AbstractMatchBitmap abstractMatchBitmap = item$iv;
            int i = n;
            boolean bl = false;
            this._memberItems[i] = bitmap.and(otherItems[i]);
        }
        newContainer.add(other._expandedFilter);
    }

    /*
     * WARNING - void declaration
     */
    private final void or(ContainerFilter newContainer, FilterNode other) {
        AbstractMatchBitmap[] otherItems = other._memberItems;
        AbstractMatchBitmap[] $this$forEachIndexed$iv = this._memberItems;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (AbstractMatchBitmap item$iv : $this$forEachIndexed$iv) {
            void bitmap;
            int n = index$iv++;
            AbstractMatchBitmap abstractMatchBitmap = item$iv;
            int i = n;
            boolean bl = false;
            AbstractMatchBitmap otherBitmap = otherItems[i];
            this._memberItems[i] = bitmap instanceof AbstractMatchBitmap.StoredFullBitmap && otherBitmap instanceof AbstractMatchBitmap.MatchBitmap ? this.or((AbstractMatchBitmap.StoredFullBitmap)bitmap, (AbstractMatchBitmap.MatchBitmap)otherBitmap, ((Dimension)this.cube.getDimensions().get(i)).getMembers()) : (bitmap instanceof AbstractMatchBitmap.MatchBitmap && otherBitmap instanceof AbstractMatchBitmap.StoredFullBitmap ? this.or((AbstractMatchBitmap.StoredFullBitmap)otherBitmap, (AbstractMatchBitmap.MatchBitmap)bitmap, ((Dimension)this.cube.getDimensions().get(i)).getMembers()) : bitmap.or(otherItems[i]));
        }
        newContainer.add(other._expandedFilter);
    }

    private final AbstractMatchBitmap or(AbstractMatchBitmap.StoredFullBitmap x, AbstractMatchBitmap.MatchBitmap y, MemberCollection members2) {
        int index2 = y.nextSetBit(0);
        while (index2 >= 0) {
            Member member = (Member)members2.get(index2);
            if (member.getStorageType().isDynamicCalc()) {
                BitSet storedFullBitSet = this.createStoredFullBitset(members2);
                return AbstractMatchBitmap.Companion.create(storedFullBitSet).or(y);
            }
            index2 = y.nextSetBit(index2 + 1);
        }
        return x;
    }

    private final BitSet createStoredFullBitset(MemberCollection members2) {
        BitSet bitSet = new BitSet();
        for (Member mem : members2) {
            if (!mem.getStorageType().isStored()) continue;
            bitSet.set(mem.getPosition$bos_olap_core());
        }
        return bitSet;
    }
}

