/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.computingEngine.multiDimensionAgg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.olapServer.computingEngine.multiDimensionAgg.MultiDimensionAggUnit;
import kd.bos.olapServer.metadata.Dimension;
import kd.bos.olapServer.metadata.Member;
import kd.bos.olapServer.query.models.BitSetFilterMemberCollection;
import kd.bos.olapServer.query.models.RoaringBitmapFilterMemberCollection;
import kd.bos.olapServer.tools.Res;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\nJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0007J\u0006\u0010\u0019\u001a\u00020\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001c"}, d2={"Lkd/bos/olapServer/computingEngine/multiDimensionAgg/Axis;", "", "dimension", "Lkd/bos/olapServer/metadata/Dimension;", "(Lkd/bos/olapServer/metadata/Dimension;)V", "_fixedMembers", "", "Lkd/bos/olapServer/metadata/Member;", "_units", "", "Lkd/bos/olapServer/computingEngine/multiDimensionAgg/MultiDimensionAggUnit;", "getDimension", "()Lkd/bos/olapServer/metadata/Dimension;", "fixedMembers", "", "getFixedMembers", "()Ljava/util/Collection;", "units", "", "getUnits", "()Ljava/util/List;", "add", "", "unit", "fixedMember", "check", "toString", "", "bos-olap-core"})
public final class Axis {
    @NotNull
    private final Dimension dimension;
    @NotNull
    private final List<MultiDimensionAggUnit> _units;
    @NotNull
    private final Collection<Member> _fixedMembers;

    public Axis(@NotNull Dimension dimension) {
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
        this.dimension = dimension;
        boolean bl = false;
        this._units = new ArrayList();
        this._fixedMembers = this.dimension.getMembers().getCount() < 4096 ? (Collection)new BitSetFilterMemberCollection(this.dimension.getMembers()) : (Collection)new RoaringBitmapFilterMemberCollection(this.dimension.getMembers());
    }

    @NotNull
    public final Dimension getDimension() {
        return this.dimension;
    }

    @NotNull
    public final List<MultiDimensionAggUnit> getUnits() {
        return this._units;
    }

    public final void add(@NotNull MultiDimensionAggUnit unit) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        this._units.add(unit);
    }

    @NotNull
    public final Collection<Member> getFixedMembers() {
        return this._fixedMembers;
    }

    public final void add(@NotNull Member fixedMember) {
        Intrinsics.checkNotNullParameter((Object)fixedMember, (String)"fixedMember");
        this._fixedMembers.add(fixedMember);
    }

    public final void check() {
        if (this._units.isEmpty()) {
            String string = Res.INSTANCE.getAxisException_1();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Res.AxisException_1");
            throw Res.INSTANCE.getNotSupportedException(string, new Object[0]);
        }
        for (MultiDimensionAggUnit unit : this._units) {
            unit.check();
        }
    }

    @NotNull
    public String toString() {
        return "" + this.dimension + ':' + this.getUnits();
    }
}

