/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.computingEngine.thread;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import kd.bos.olapServer.collections.IAddOrUpdateStrategy;
import kd.bos.olapServer.collections.IMutableDictionary;
import kd.bos.olapServer.common.CancellableToken;
import kd.bos.olapServer.common.CommonTypesKt;
import kd.bos.olapServer.common.ICancellable;
import kd.bos.olapServer.common.IContinueToken;
import kd.bos.olapServer.common.IEqualityComparer;
import kd.bos.olapServer.common.OlapContext;
import kd.bos.olapServer.common.ParallelTaskManager;
import kd.bos.olapServer.computingEngine.ComputeMode;
import kd.bos.olapServer.computingEngine.ComputingLevel;
import kd.bos.olapServer.computingEngine.ComputingResult;
import kd.bos.olapServer.computingEngine.DimensionFilterCollection;
import kd.bos.olapServer.computingEngine.IComputingResultIterator;
import kd.bos.olapServer.computingEngine.IComputingUnit;
import kd.bos.olapServer.computingEngine.MapEntryIterator;
import kd.bos.olapServer.computingEngine.SingleMeasureValues;
import kd.bos.olapServer.computingEngine.TargetKeyEqualityComparer;
import kd.bos.olapServer.computingEngine.UnitDependencyMapperContainer;
import kd.bos.olapServer.computingEngine.batchTasks.CollectComplexFactorTask;
import kd.bos.olapServer.computingEngine.batchTasks.CollectSimpleFactorTask;
import kd.bos.olapServer.computingEngine.batchTasks.ComputingContext;
import kd.bos.olapServer.computingEngine.batchTasks.ComputingTask;
import kd.bos.olapServer.computingEngine.batchTasks.ExistTargetComputingTask;
import kd.bos.olapServer.computingEngine.batchTasks.FullComputingTask;
import kd.bos.olapServer.computingEngine.batchTasks.GroupComputingTask;
import kd.bos.olapServer.computingEngine.batchTasks.StandardComputingTask;
import kd.bos.olapServer.computingEngine.multiDimensionAgg.AggAddOrUpdateStrategy;
import kd.bos.olapServer.computingEngine.multiDimensionAgg.AggMultiDimensionComputingTask;
import kd.bos.olapServer.computingEngine.multiDimensionAgg.AggMultiDimensionComputingTaskV2;
import kd.bos.olapServer.computingEngine.multiDimensionAgg.ExistTargetMultiDimensionComputingTask;
import kd.bos.olapServer.computingEngine.multiDimensionAgg.ExistTargetMultiDimensionComputingTaskV2;
import kd.bos.olapServer.computingEngine.multiDimensionAgg.MergeTask;
import kd.bos.olapServer.computingEngine.multiDimensionAgg.MultiDimensionAggComputingUnit;
import kd.bos.olapServer.computingEngine.thread.ComputingResourceContainer;
import kd.bos.olapServer.computingEngine.thread.ComputingWorkerStarter;
import kd.bos.olapServer.computingEngine.thread.SharedComputingResourceContainer;
import kd.bos.olapServer.dataEntities.IDimensionKeys;
import kd.bos.olapServer.dataEntities.IMeasureValues;
import kd.bos.olapServer.memoryMappedFiles.byteBufferProviders.ByteBufferResourcePool;
import kd.bos.olapServer.metadata.Cube;
import kd.bos.olapServer.metadata.Dimension;
import kd.bos.olapServer.metadata.Measure;
import kd.bos.olapServer.performanceStatistics.CommandContext;
import kd.bos.olapServer.performanceStatistics.CommandExecuteState;
import kd.bos.olapServer.storages.CubeWorkspace;
import kd.bos.olapServer.storages.IInputRowWriter;
import kd.bos.olapServer.storages.tempStorages.MutableLinkedListFactorRow;
import kd.bos.olapServer.storages.tempStorages.MutableListAggResult;
import kd.olap.fel.common.OperateUtils;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00c4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0010&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001TB/\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020\u0013H\u0002J\u0016\u0010G\u001a\u00020E2\f\u0010H\u001a\b\u0012\u0004\u0012\u00020\u001302H\u0002J\b\u0010I\u001a\u00020EH\u0016J\u0006\u0010J\u001a\u00020EJ\u0006\u0010K\u001a\u00020EJ\b\u0010L\u001a\u00020EH\u0002J \u0010M\u001a\u00020E2\u0006\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020SH\u0002R\u0012\u0010\r\u001a\u00060\u000ej\u0002`\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0014\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010'\u001a\u00020(8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0011\u0010-\u001a\u00020.\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0014\u00101\u001a\b\u0012\u0004\u0012\u00020302X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u0014\u00106\u001a\b\u0012\u0004\u0012\u00020807X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u00109\u001a\u00060\u000ej\u0002`\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010;R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010=R\u0011\u0010>\u001a\u00020?\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010AR\u000e\u0010B\u001a\u00020CX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006U"}, d2={"Lkd/bos/olapServer/computingEngine/thread/ComputingWorkspace;", "Ljava/io/Closeable;", "mainDimension", "Lkd/bos/olapServer/metadata/Dimension;", "mainMeasure", "Lkd/bos/olapServer/metadata/Measure;", "cubeWorkspace", "Lkd/bos/olapServer/storages/CubeWorkspace;", "computingLevel", "Lkd/bos/olapServer/computingEngine/ComputingLevel;", "resourcePool", "Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/ByteBufferResourcePool;", "(Lkd/bos/olapServer/metadata/Dimension;Lkd/bos/olapServer/metadata/Measure;Lkd/bos/olapServer/storages/CubeWorkspace;Lkd/bos/olapServer/computingEngine/ComputingLevel;Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/ByteBufferResourcePool;)V", "_exitQueryLockTime", "", "Lkd/bos/olapServer/common/long;", "_isClosed", "", "_lastTask", "Lkd/bos/olapServer/computingEngine/batchTasks/ComputingTask;", "_multiAggResult", "", "", "Lkd/bos/olapServer/dataEntities/IDimensionKeys;", "Lkd/bos/olapServer/computingEngine/ComputingResult;", "_privateResources", "", "Lkd/bos/olapServer/computingEngine/thread/ComputingResourceContainer;", "[Lkd/bos/olapServer/computingEngine/thread/ComputingResourceContainer;", "_resultCount", "_startTask", "commandContext", "Lkd/bos/olapServer/performanceStatistics/CommandContext;", "getComputingLevel", "()Lkd/bos/olapServer/computingEngine/ComputingLevel;", "continueToken", "Lkd/bos/olapServer/common/IContinueToken;", "ctx", "Lkd/bos/olapServer/computingEngine/batchTasks/ComputingContext;", "cube", "Lkd/bos/olapServer/metadata/Cube;", "getCube", "()Lkd/bos/olapServer/metadata/Cube;", "getCubeWorkspace", "()Lkd/bos/olapServer/storages/CubeWorkspace;", "dependencyContainer", "Lkd/bos/olapServer/computingEngine/UnitDependencyMapperContainer;", "getDependencyContainer", "()Lkd/bos/olapServer/computingEngine/UnitDependencyMapperContainer;", "fullUnits", "", "Lkd/bos/olapServer/computingEngine/IComputingUnit;", "getMainMeasure", "()Lkd/bos/olapServer/metadata/Measure;", "multiAggUnits", "", "Lkd/bos/olapServer/computingEngine/multiDimensionAgg/MultiDimensionAggComputingUnit;", "queryLockTime", "getQueryLockTime", "()J", "getResourcePool", "()Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/ByteBufferResourcePool;", "sharedResourceContainer", "Lkd/bos/olapServer/computingEngine/thread/SharedComputingResourceContainer;", "getSharedResourceContainer", "()Lkd/bos/olapServer/computingEngine/thread/SharedComputingResourceContainer;", "workerCount", "", "addTask", "", "task", "addTaskGroup", "tasks", "close", "compute", "copyTempCubeDataToMainCube", "initTasks", "write", "writer", "Lkd/bos/olapServer/storages/IInputRowWriter;", "items", "Lkd/bos/olapServer/computingEngine/IComputingResultIterator;", "measureValues", "Lkd/bos/olapServer/computingEngine/SingleMeasureValues;", "IgnoreDefaultValueStrategy", "bos-olap-core"})
public final class ComputingWorkspace
implements Closeable {
    @NotNull
    private final Measure mainMeasure;
    @NotNull
    private final CubeWorkspace cubeWorkspace;
    @NotNull
    private final ComputingLevel computingLevel;
    @NotNull
    private final ByteBufferResourcePool resourcePool;
    @NotNull
    private final ComputingContext ctx;
    @NotNull
    private final SharedComputingResourceContainer sharedResourceContainer;
    @NotNull
    private final ComputingResourceContainer[] _privateResources;
    @NotNull
    private final UnitDependencyMapperContainer dependencyContainer;
    @NotNull
    private final List<IComputingUnit> fullUnits;
    @NotNull
    private final List<MultiDimensionAggComputingUnit> multiAggUnits;
    private final int workerCount;
    @Nullable
    private Iterable<? extends Map.Entry<? extends IDimensionKeys, ComputingResult>> _multiAggResult;
    @Nullable
    private ComputingTask _lastTask;
    @Nullable
    private ComputingTask _startTask;
    @Nullable
    private final CommandContext commandContext;
    @NotNull
    private final IContinueToken continueToken;
    private long _exitQueryLockTime;
    private long _resultCount;
    private boolean _isClosed;

    public ComputingWorkspace(@Nullable Dimension mainDimension, @NotNull Measure mainMeasure, @NotNull CubeWorkspace cubeWorkspace, @NotNull ComputingLevel computingLevel, @NotNull ByteBufferResourcePool resourcePool) {
        Intrinsics.checkNotNullParameter((Object)mainMeasure, (String)"mainMeasure");
        Intrinsics.checkNotNullParameter((Object)cubeWorkspace, (String)"cubeWorkspace");
        Intrinsics.checkNotNullParameter((Object)computingLevel, (String)"computingLevel");
        Intrinsics.checkNotNullParameter((Object)resourcePool, (String)"resourcePool");
        this.mainMeasure = mainMeasure;
        this.cubeWorkspace = cubeWorkspace;
        this.computingLevel = computingLevel;
        this.resourcePool = resourcePool;
        this.ctx = new ComputingContext(this.cubeWorkspace, mainDimension, this.mainMeasure);
        this.sharedResourceContainer = new SharedComputingResourceContainer(this.ctx, this.resourcePool);
        this.dependencyContainer = this.computingLevel.createDependencyMapperContainer();
        int n = 0;
        this.fullUnits = new ArrayList();
        this.multiAggUnits = this.computingLevel.getMultiAggUnits();
        this.workerCount = CommonTypesKt.getDefaultWorkerCount();
        this.commandContext = OlapContext.Companion.tryGetContext(CommandContext.class);
        this.continueToken = CancellableToken.INSTANCE.getContinueToken();
        n = 0;
        int n2 = this.computingLevel.getCount();
        if (n < n2) {
            do {
                int i;
                IComputingUnit unit;
                if ((unit = this.computingLevel.get(i = n++)).getComputeMode() != ComputeMode.Full) continue;
                this.fullUnits.add(unit);
            } while (n < n2);
        }
        this.ctx.setTargetKeyComparer(TargetKeyEqualityComparer.Companion.buildFromFilter(this.getCube().getDimensions(), this.computingLevel.getFilter()));
        n = 0;
        n2 = this.workerCount;
        ComputingResourceContainer[] computingResourceContainerArray = new ComputingResourceContainer[n2];
        ComputingWorkspace computingWorkspace = this;
        while (n < n2) {
            ComputingResourceContainer res;
            int n3 = n++;
            computingResourceContainerArray[n3] = res = (ComputingResourceContainer)this.sharedResourceContainer.createComputingResource();
        }
        computingWorkspace._privateResources = computingResourceContainerArray;
        this.initTasks();
        if (this.dependencyContainer.getCount() > 0) {
            this.sharedResourceContainer.getTargetList();
        }
        Collection collection = this.multiAggUnits;
        n2 = 0;
        if (!collection.isEmpty()) {
            this.sharedResourceContainer.getAggResultList();
        }
    }

    @NotNull
    public final Measure getMainMeasure() {
        return this.mainMeasure;
    }

    @NotNull
    public final CubeWorkspace getCubeWorkspace() {
        return this.cubeWorkspace;
    }

    @NotNull
    public final ComputingLevel getComputingLevel() {
        return this.computingLevel;
    }

    @NotNull
    public final ByteBufferResourcePool getResourcePool() {
        return this.resourcePool;
    }

    @NotNull
    public final Cube getCube() {
        return this.cubeWorkspace.getMetadata();
    }

    @NotNull
    public final SharedComputingResourceContainer getSharedResourceContainer() {
        return this.sharedResourceContainer;
    }

    @NotNull
    public final UnitDependencyMapperContainer getDependencyContainer() {
        return this.dependencyContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void compute() {
        int n;
        CommandContext commandContext = this.commandContext;
        if (commandContext != null) {
            commandContext.setTimeState(CommandExecuteState.Companion.getWaitingQueryLock());
        }
        ComputingWorkerStarter workerStarter = new ComputingWorkerStarter(this.ctx, this._privateResources);
        OlapContext.Companion this_$iv = OlapContext.Companion;
        boolean $i$f$withContext = false;
        try {
            this_$iv.push(workerStarter);
            boolean bl = false;
            for (ComputingTask currentGroupTask = this._startTask; currentGroupTask != null; currentGroupTask = currentGroupTask.getNextTask()) {
                ComputingTask groupTask = currentGroupTask;
                Closeable closeable = groupTask;
                n = 0;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    ComputingTask it = (ComputingTask)closeable;
                    boolean bl3 = false;
                    groupTask.onStarting();
                    workerStarter.reset(groupTask);
                    try {
                        ComputingResourceContainer res = this._privateResources[0];
                        groupTask.executeJob(res, this.ctx);
                    }
                    catch (Exception ex) {
                        boolean bl4 = false;
                        boolean bl5 = false;
                        synchronized (workerStarter) {
                            boolean bl6 = false;
                            ICancellable iCancellable = OlapContext.Companion.tryGetContext(ICancellable.class);
                            if (iCancellable != null) {
                                iCancellable.cancel(ex);
                            }
                            if (workerStarter.getCex() == null) {
                                workerStarter.setCex(ex);
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                    }
                    workerStarter.waitWorkersAndClose();
                    it = Unit.INSTANCE;
                    continue;
                }
                catch (Throwable it) {
                    throwable = it;
                    throw it;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
        }
        finally {
            this_$iv.pop(workerStarter);
        }
        $i$f$withContext = false;
        List mergeJobs = new ArrayList();
        MergeTask mergeTask = new MergeTask(new AggAddOrUpdateStrategy());
        Object $this$forEach$iv = this._privateResources;
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv;
        int n2 = ((ComputingResourceContainer[])object).length;
        for (n = 0; n < n2; ++n) {
            ComputingResourceContainer element$iv;
            ComputingResourceContainer res = element$iv = object[n];
            boolean bl = false;
            IMutableDictionary<IDimensionKeys, ComputingResult> tempCube = res.getTempCube();
            if (tempCube == null) continue;
            Future<Unit> future = ComputingTask.Companion.getExecutor().submit(() -> ComputingWorkspace.compute$lambda-4$lambda-3(mergeTask, res));
            Intrinsics.checkNotNullExpressionValue(future, (String)"ComputingTask.executor.submit<Unit> {\n                    mergeTask.submit(res.tempCube)\n                }");
            mergeJobs.add(future);
        }
        $this$forEach$iv = mergeJobs;
        $i$f$forEach = false;
        object = $this$forEach$iv.iterator();
        while (object.hasNext()) {
            Object element$iv = object.next();
            Future it = (Future)element$iv;
            boolean bl = false;
            it.get();
        }
        this._multiAggResult = mergeTask.getResult();
        CommandContext commandContext2 = this.commandContext;
        if (commandContext2 != null) {
            commandContext2.setState(CommandExecuteState.Companion.getEnterQueryLock(), this.getQueryLockTime());
        }
        commandContext2 = this.commandContext;
        if (commandContext2 != null) {
            commandContext2.setState(CommandExecuteState.Companion.getSelectCount(), this.ctx.getFactorCount().get());
        }
        this._exitQueryLockTime = System.nanoTime();
        commandContext2 = this.commandContext;
        if (commandContext2 != null) {
            commandContext2.setTimeState(CommandExecuteState.Companion.getExitQueryLock(), this._exitQueryLockTime);
        }
    }

    private final void addTask(ComputingTask task) {
        if (task.isClosed()) {
            return;
        }
        ComputingTask lastTask = this._lastTask;
        if (lastTask == null) {
            this._startTask = task;
            this._lastTask = task;
        } else {
            lastTask.setNextTask(task);
            this._lastTask = task;
        }
    }

    private final void addTaskGroup(List<ComputingTask> tasks) {
        Collection collection = tasks;
        boolean bl = false;
        if (!collection.isEmpty()) {
            tasks.removeIf(ComputingWorkspace::addTaskGroup$lambda-6);
            collection = tasks;
            bl = false;
            if (!collection.isEmpty()) {
                Collection $this$toTypedArray$iv = tasks;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                ComputingTask[] computingTaskArray = thisCollection$iv.toArray(new ComputingTask[0]);
                if (computingTaskArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                this.addTask(new GroupComputingTask(computingTaskArray));
            }
        }
    }

    private final void initTasks() {
        int unitIndex22;
        IComputingUnit unit = null;
        ComputingTask task = null;
        DimensionFilterCollection filter = this.computingLevel.getFilter();
        int n = 0;
        List fullTasks = new ArrayList();
        n = 0;
        int n2 = this.fullUnits.size();
        if (n < n2) {
            do {
                unitIndex22 = n++;
                unit = this.fullUnits.get(unitIndex22);
                fullTasks.add(new FullComputingTask(this, unit, this.dependencyContainer.indexOf(unit)));
            } while (n < n2);
        }
        this.addTaskGroup(fullTasks);
        n2 = 0;
        List existTasks = new ArrayList();
        if (this.dependencyContainer.getSimpleUnits().getCount() > 0) {
            existTasks.add(new ExistTargetComputingTask(this, this.dependencyContainer.getSimpleUnits()));
        }
        if (this.dependencyContainer.getComplexUnits().getCount() > 0) {
            existTasks.add(new ExistTargetComputingTask(this, this.dependencyContainer.getComplexUnits()));
        }
        this.addTaskGroup(existTasks);
        unitIndex22 = 0;
        List collectTasks = new ArrayList();
        if (this.dependencyContainer.getSimpleUnits().getCount() > 0) {
            collectTasks.add(new CollectSimpleFactorTask(this, this.dependencyContainer.getSimpleUnits()));
        }
        if (this.dependencyContainer.getComplexUnits().getCount() > 0) {
            collectTasks.add(new CollectComplexFactorTask(this, this.dependencyContainer.getComplexUnits()));
        }
        this.addTaskGroup(collectTasks);
        if (this.dependencyContainer.getCount() > 0) {
            task = new StandardComputingTask(this);
            this.addTask(task);
        }
        Collection unitIndex22 = this.multiAggUnits;
        boolean bl = false;
        if (!unitIndex22.isEmpty()) {
            Integer smallTargetSize = this.computingLevel.isMultiAggUnitsSmallTargetMode(this.getCube());
            if (smallTargetSize != null) {
                TargetKeyEqualityComparer targetKeyEqualityComparer;
                IEqualityComparer<IDimensionKeys> iEqualityComparer = this.ctx.getTargetKeyComparer();
                TargetKeyEqualityComparer targetKeyEqualityComparer2 = targetKeyEqualityComparer = iEqualityComparer instanceof TargetKeyEqualityComparer ? (TargetKeyEqualityComparer)iEqualityComparer : null;
                if (targetKeyEqualityComparer != null) {
                    targetKeyEqualityComparer.setConverter(this.computingLevel.getLongConverter(this.getCube()));
                }
                boolean bl2 = false;
                List multiAggTasks = new ArrayList();
                for (MultiDimensionAggComputingUnit mUnit : this.multiAggUnits) {
                    task = new ExistTargetMultiDimensionComputingTask(this.cubeWorkspace, filter, mUnit, this.mainMeasure);
                    multiAggTasks.add(task);
                }
                this.addTaskGroup(multiAggTasks);
                multiAggTasks.clear();
                for (MultiDimensionAggComputingUnit mUnit : this.multiAggUnits) {
                    task = new AggMultiDimensionComputingTask(this.cubeWorkspace, filter, mUnit, this.mainMeasure);
                    multiAggTasks.add(task);
                }
                this.addTaskGroup(multiAggTasks);
            } else {
                boolean bl3 = false;
                List multiAggTasks = new ArrayList();
                for (MultiDimensionAggComputingUnit mUnit : this.multiAggUnits) {
                    task = new ExistTargetMultiDimensionComputingTaskV2(this, this.cubeWorkspace, filter, mUnit);
                    multiAggTasks.add(task);
                }
                this.addTaskGroup(multiAggTasks);
                multiAggTasks.clear();
                for (MultiDimensionAggComputingUnit mUnit : this.multiAggUnits) {
                    task = new AggMultiDimensionComputingTaskV2(this, this.cubeWorkspace, filter, mUnit, this.mainMeasure);
                    multiAggTasks.add(task);
                }
                this.addTaskGroup(multiAggTasks);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void copyTempCubeDataToMainCube() {
        boolean $i$f$statistics = false;
        SingleMeasureValues measureValues = new SingleMeasureValues(this.getCube().getMeasures().getCount(), this.mainMeasure.getPosition$bos_olap_core(), null, 4, null);
        IgnoreDefaultValueStrategy strategy = new IgnoreDefaultValueStrategy(measureValues);
        Object object = this.cubeWorkspace.createWriter(strategy);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            Unit unit;
            Object res;
            IInputRowWriter writer = (IInputRowWriter)object;
            boolean bl3 = false;
            try {
                Unit unit2;
                Iterable<? extends Map.Entry<? extends IDimensionKeys, ComputingResult>> aggResult = this._multiAggResult;
                if (aggResult != null) {
                    MapEntryIterator aggResultItr = new MapEntryIterator(aggResult.iterator());
                    this.write(writer, aggResultItr, measureValues);
                }
                this.getSharedResourceContainer().flushAggResultList();
                MutableListAggResult aggResultList = this.getSharedResourceContainer().pollSubAggTargetList();
                while (aggResultList != null) {
                    this.write(writer, aggResultList.iterator(), measureValues);
                    aggResultList = this.getSharedResourceContainer().pollSubAggTargetList();
                }
                this.getSharedResourceContainer().resetPollIndex();
                res = this.getSharedResourceContainer().pollSubTargetList();
                while (res != null) {
                    this.write(writer, ((MutableLinkedListFactorRow)res).iterator(), measureValues);
                    res = this.getSharedResourceContainer().pollSubTargetList();
                }
                CommandContext commandContext = this.commandContext;
                if (commandContext != null) {
                    commandContext.setTimeState(CommandExecuteState.Companion.getEnterWriteLock(), this._exitQueryLockTime + writer.getWriteLockTime());
                }
                commandContext = this.commandContext;
                if (commandContext == null) {
                    unit2 = null;
                } else {
                    commandContext.setState(CommandExecuteState.Companion.getResultCount(), this._resultCount);
                    unit2 = Unit.INSTANCE;
                }
                unit = unit2;
            }
            finally {
                boolean $i$f$statistics2 = false;
                ParallelTaskManager ptm = ParallelTaskManager.Companion.begin();
                res = ptm;
                boolean bl4 = false;
                boolean bl5 = false;
                Throwable throwable2 = null;
                try {
                    ParallelTaskManager it = (ParallelTaskManager)res;
                    boolean bl6 = false;
                    writer.force();
                    Unit unit3 = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)res, (Throwable)throwable2);
                }
                res = this.commandContext;
                if (res != null) {
                    ((CommandContext)res).updateTransactionVersion(writer.getTransactionId());
                }
                boolean $i$f$statistics3 = false;
            }
            Unit unit4 = unit;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        object = this.commandContext;
        if (object != null) {
            ((CommandContext)object).setTimeState(CommandExecuteState.Companion.getExitWriteLock());
        }
    }

    private final void write(IInputRowWriter writer, IComputingResultIterator items2, SingleMeasureValues measureValues) {
        while (items2.next() && this.continueToken.canContinue()) {
            long l;
            ComputingWorkspace computingWorkspace;
            long rowIndex = items2.getMainCubeRowIndex();
            Object measureValue = items2.getTargetValue();
            measureValues.setMainMeasureValue(measureValue);
            if (rowIndex < 0L) {
                if (rowIndex == -1L) {
                    computingWorkspace = this;
                    l = computingWorkspace._resultCount;
                    computingWorkspace._resultCount = l + 1L;
                    writer.add(items2.getTargetKey(), measureValues);
                    continue;
                }
                computingWorkspace = this;
                l = computingWorkspace._resultCount;
                computingWorkspace._resultCount = l + 1L;
                writer.addOrUpdate(items2.getTargetKey(), measureValues);
                continue;
            }
            computingWorkspace = this;
            l = computingWorkspace._resultCount;
            computingWorkspace._resultCount = l + 1L;
            writer.update(rowIndex, measureValues);
        }
    }

    private final long getQueryLockTime() {
        long result = 0L;
        for (ComputingTask task = this._startTask; task != null; task = task.getNextTask()) {
            result += task.getLockTime();
        }
        return result;
    }

    @Override
    public void close() {
        if (!this._isClosed) {
            this._isClosed = true;
            this.sharedResourceContainer.close();
        }
    }

    private static final Unit compute$lambda-4$lambda-3(MergeTask $mergeTask, ComputingResourceContainer $res) {
        Intrinsics.checkNotNullParameter((Object)$mergeTask, (String)"$mergeTask");
        Intrinsics.checkNotNullParameter((Object)$res, (String)"$res");
        $mergeTask.submit($res.getTempCube());
        return Unit.INSTANCE;
    }

    private static final boolean addTaskGroup$lambda-6(ComputingTask it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isClosed();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\f\u0010\u000e\u001a\u00060\nj\u0002`\u000bH\u0016J\u0018\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0002H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R\u0018\u0010\t\u001a\u00060\nj\u0002`\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0012"}, d2={"Lkd/bos/olapServer/computingEngine/thread/ComputingWorkspace$IgnoreDefaultValueStrategy;", "Lkd/bos/olapServer/collections/IAddOrUpdateStrategy;", "Lkd/bos/olapServer/dataEntities/IMeasureValues;", "measureValue", "Lkd/bos/olapServer/computingEngine/SingleMeasureValues;", "(Lkd/bos/olapServer/computingEngine/SingleMeasureValues;)V", "getMeasureValue", "()Lkd/bos/olapServer/computingEngine/SingleMeasureValues;", "setMeasureValue", "supportModifiedValue", "", "Lkd/bos/olapServer/common/bool;", "getSupportModifiedValue", "()Z", "canAdd", "modifiedValue", "current", "newValue", "bos-olap-core"})
    private static final class IgnoreDefaultValueStrategy
    implements IAddOrUpdateStrategy<IMeasureValues> {
        @NotNull
        private SingleMeasureValues measureValue;

        public IgnoreDefaultValueStrategy(@NotNull SingleMeasureValues measureValue) {
            Intrinsics.checkNotNullParameter((Object)measureValue, (String)"measureValue");
            this.measureValue = measureValue;
        }

        @NotNull
        public final SingleMeasureValues getMeasureValue() {
            return this.measureValue;
        }

        public final void setMeasureValue(@NotNull SingleMeasureValues singleMeasureValues) {
            Intrinsics.checkNotNullParameter((Object)singleMeasureValues, (String)"<set-?>");
            this.measureValue = singleMeasureValues;
        }

        @Override
        public boolean canAdd() {
            return !OperateUtils.isDefaultValue((Object)this.measureValue.getMainMeasureValue());
        }

        @Override
        public boolean getSupportModifiedValue() {
            return true;
        }

        @Override
        @NotNull
        public IMeasureValues modifiedValue(@NotNull IMeasureValues current, @NotNull IMeasureValues newValue) {
            Intrinsics.checkNotNullParameter((Object)current, (String)"current");
            Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
            Object oldMeasure = current.get(this.measureValue.getMainMeasureIndex());
            if (OperateUtils.valueEquals((Object)this.measureValue.getMainMeasureValue(), (Object)oldMeasure)) {
                this.measureValue.setMainMeasureValue(CommonTypesKt.getUndefined());
            }
            return newValue;
        }
    }
}

