/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.computingEngine.thread;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lkd/bos/olapServer/computingEngine/thread/DefaultThreadFactory;", "Ljava/util/concurrent/ThreadFactory;", "threadNamePrefix", "", "Lkd/bos/olapServer/common/string;", "(Ljava/lang/String;)V", "group", "Ljava/lang/ThreadGroup;", "threadNumber", "Ljava/util/concurrent/atomic/AtomicInteger;", "newThread", "Ljava/lang/Thread;", "r", "Ljava/lang/Runnable;", "bos-olap-core"})
public final class DefaultThreadFactory
implements ThreadFactory {
    @NotNull
    private final String threadNamePrefix;
    @NotNull
    private final ThreadGroup group;
    @NotNull
    private final AtomicInteger threadNumber;

    public DefaultThreadFactory(@NotNull String threadNamePrefix) {
        ThreadGroup threadGroup;
        Intrinsics.checkNotNullParameter((Object)threadNamePrefix, (String)"threadNamePrefix");
        this.threadNamePrefix = threadNamePrefix;
        this.threadNumber = new AtomicInteger(1);
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            ThreadGroup threadGroup2 = s.getThreadGroup();
            Intrinsics.checkNotNullExpressionValue((Object)threadGroup2, (String)"s.threadGroup");
            threadGroup = threadGroup2;
        } else {
            ThreadGroup threadGroup3 = Thread.currentThread().getThreadGroup();
            Intrinsics.checkNotNullExpressionValue((Object)threadGroup3, (String)"currentThread().threadGroup");
            threadGroup = threadGroup3;
        }
        this.group = threadGroup;
    }

    @Override
    @NotNull
    public Thread newThread(@NotNull Runnable r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Thread t2 = new Thread(this.group, r, Intrinsics.stringPlus((String)this.threadNamePrefix, (Object)this.threadNumber.getAndIncrement()), 0L);
        if (t2.isDaemon()) {
            t2.setDaemon(false);
        }
        if (t2.getPriority() != 5) {
            t2.setPriority(5);
        }
        return t2;
    }
}

