/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.computingEngine.thread;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kd.bos.olapServer.common.CommonTypesKt;
import kd.bos.olapServer.computingEngine.thread.DefaultThreadFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u000bB\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\"\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\b0\u0007\"\u0004\b\u0000\u0010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\b0\nH\u0014\u00a8\u0006\f"}, d2={"Lkd/bos/olapServer/computingEngine/thread/OlapThreadPoolExecutor;", "Ljava/util/concurrent/ThreadPoolExecutor;", "threadNamePrefix", "", "Lkd/bos/olapServer/common/string;", "(Ljava/lang/String;)V", "newTaskFor", "Ljava/util/concurrent/RunnableFuture;", "V", "callable", "Ljava/util/concurrent/Callable;", "OlapFutureTask", "bos-olap-core"})
public final class OlapThreadPoolExecutor
extends ThreadPoolExecutor {
    public OlapThreadPoolExecutor(@NotNull String threadNamePrefix) {
        Intrinsics.checkNotNullParameter((Object)threadNamePrefix, (String)"threadNamePrefix");
        super(CommonTypesKt.getAvailableProcessors(), CommonTypesKt.getAvailableProcessors(), 5L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)new LinkedBlockingQueue(), new DefaultThreadFactory(threadNamePrefix));
        this.allowCoreThreadTimeOut(true);
    }

    @NotNull
    protected <V> RunnableFuture<V> newTaskFor(@NotNull Callable<V> callable) {
        Intrinsics.checkNotNullParameter(callable, (String)"callable");
        return new OlapFutureTask<V>(callable);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0015\u0010\b\u001a\u00060\u0007j\u0002`\t8F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\n\u00a8\u0006\r"}, d2={"Lkd/bos/olapServer/computingEngine/thread/OlapThreadPoolExecutor$OlapFutureTask;", "V", "Ljava/util/concurrent/FutureTask;", "callable", "Ljava/util/concurrent/Callable;", "(Ljava/util/concurrent/Callable;)V", "_isStarting", "", "isStarting", "Lkd/bos/olapServer/common/bool;", "()Z", "run", "", "bos-olap-core"})
    public static final class OlapFutureTask<V>
    extends FutureTask<V> {
        private volatile boolean _isStarting;

        public OlapFutureTask(@NotNull Callable<V> callable) {
            Intrinsics.checkNotNullParameter(callable, (String)"callable");
            super(callable);
        }

        public final boolean isStarting() {
            return this._isStarting;
        }

        @Override
        public void run() {
            this._isStarting = true;
            super.run();
        }
    }
}

