/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.dataEntities;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import kd.bos.olapServer.common.CommonTypesKt;
import kd.bos.olapServer.dataEntities.IDimensionKeys;
import kd.bos.olapServer.dataEntities.IInputRow;
import kd.bos.olapServer.dataEntities.IMeasureValues;
import kd.bos.olapServer.metadata.Cube;
import kd.bos.olapServer.metadata.Dimension;
import kd.bos.olapServer.metadata.Measure;
import kd.bos.olapServer.metadata.Member;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0002+,B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0011\u001a\u00060\u0012j\u0002`\u00132\n\u0010\u0014\u001a\u00060\u0015j\u0002`\u0016H\u0016J\u0018\u0010\u0017\u001a\u00060\u0012j\u0002`\u00132\n\u0010\u0018\u001a\u00060\u0015j\u0002`\u0016H\u0016J\u0018\u0010\u0019\u001a\u00060\u0012j\u0002`\u00132\n\u0010\u0014\u001a\u00060\u0015j\u0002`\u0016H\u0016J\u0006\u0010\u001a\u001a\u00020\u001bJ \u0010\u001c\u001a\u00020\u001b2\n\u0010\u0014\u001a\u00060\u0015j\u0002`\u00162\n\u0010\u001d\u001a\u00060\u0015j\u0002`\u0016H\u0016J \u0010\u001c\u001a\u00020\u001b2\n\u0010\u001e\u001a\u00060\u0012j\u0002`\u00132\n\u0010\u001f\u001a\u00060\u0012j\u0002`\u0013H\u0016J\u0016\u0010\u001c\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\u001c\u0010$\u001a\u00020\u001b2\n\u0010\u0018\u001a\u00060\u0015j\u0002`\u00162\b\u0010%\u001a\u0004\u0018\u00010&J\u001e\u0010$\u001a\u00020\u001b2\n\u0010'\u001a\u00060\u0012j\u0002`\u00132\b\u0010%\u001a\u0004\u0018\u00010&H\u0016J\u0018\u0010$\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020)2\b\u0010%\u001a\u0004\u0018\u00010&J\b\u0010*\u001a\u00020\u0012H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lkd/bos/olapServer/dataEntities/InputRow;", "Lkd/bos/olapServer/dataEntities/IInputRow;", "cube", "Lkd/bos/olapServer/metadata/Cube;", "(Lkd/bos/olapServer/metadata/Cube;)V", "Keys", "Lkd/bos/olapServer/dataEntities/IDimensionKeys;", "getKeys", "()Lkd/bos/olapServer/dataEntities/IDimensionKeys;", "Values", "Lkd/bos/olapServer/dataEntities/IMeasureValues;", "getValues", "()Lkd/bos/olapServer/dataEntities/IMeasureValues;", "keysObj", "Lkd/bos/olapServer/dataEntities/InputRow$DimensionKeys;", "valuesObj", "Lkd/bos/olapServer/dataEntities/InputRow$MeasureValues;", "getDimensionName", "", "Lkd/bos/olapServer/common/string;", "dimensionIndex", "", "Lkd/bos/olapServer/common/int;", "getMeasureName", "measureIndex", "getMemberName", "reset", "", "setDimensionValue", "memberIndex", "dimensionName", "memberName", "dimension", "Lkd/bos/olapServer/metadata/Dimension;", "member", "Lkd/bos/olapServer/metadata/Member;", "setMeasureValue", "value", "", "measureName", "measure", "Lkd/bos/olapServer/metadata/Measure;", "toString", "DimensionKeys", "MeasureValues", "bos-olap-core"})
public final class InputRow
implements IInputRow {
    @NotNull
    private final Cube cube;
    @NotNull
    private final DimensionKeys keysObj;
    @NotNull
    private final MeasureValues valuesObj;

    public InputRow(@NotNull Cube cube) {
        int n;
        Intrinsics.checkNotNullParameter((Object)cube, (String)"cube");
        this.cube = cube;
        int n2 = 0;
        int n3 = this.cube.getDimensions().getCount();
        Object[] objectArray = new int[n3];
        InputRow inputRow = this;
        while (n2 < n3) {
            n = n2++;
            objectArray[n] = -1;
        }
        Cube cube2 = this.cube;
        int[] nArray = objectArray;
        inputRow.keysObj = new DimensionKeys(nArray, cube2);
        n2 = 0;
        n3 = this.cube.getMeasures().getCount();
        objectArray = new Object[n3];
        inputRow = this;
        while (n2 < n3) {
            n = n2++;
            objectArray[n] = (int)CommonTypesKt.getUndefined();
        }
        Object[] objectArray2 = objectArray;
        inputRow.valuesObj = new MeasureValues(objectArray2);
    }

    @Override
    public void setDimensionValue(@NotNull String dimensionName, @NotNull String memberName) {
        Intrinsics.checkNotNullParameter((Object)dimensionName, (String)"dimensionName");
        Intrinsics.checkNotNullParameter((Object)memberName, (String)"memberName");
        Dimension dim = (Dimension)this.cube.getDimensions().get(dimensionName);
        Member member = (Member)dim.getMembers().get(memberName);
        this.setDimensionValue(dim, member);
    }

    public final void setDimensionValue(@NotNull Dimension dimension, @NotNull Member member) {
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
        Intrinsics.checkNotNullParameter((Object)member, (String)"member");
        this.keysObj.getKeys()[dimension.getPosition()] = member.getPosition$bos_olap_core();
    }

    @Override
    public void setDimensionValue(int dimensionIndex, int memberIndex) {
        this.keysObj.getKeys()[dimensionIndex] = memberIndex;
    }

    @Override
    public void setMeasureValue(@NotNull String measureName, @Nullable Object value2) {
        Intrinsics.checkNotNullParameter((Object)measureName, (String)"measureName");
        Measure measure = (Measure)this.cube.getMeasures().get(measureName);
        this.setMeasureValue(measure, value2);
    }

    public final void setMeasureValue(@NotNull Measure measure, @Nullable Object value2) {
        Intrinsics.checkNotNullParameter((Object)measure, (String)"measure");
        this.valuesObj.getValues$bos_olap_core()[measure.getPosition$bos_olap_core()] = value2;
    }

    public final void setMeasureValue(int measureIndex, @Nullable Object value2) {
        this.valuesObj.getValues$bos_olap_core()[measureIndex] = value2;
    }

    public final void reset() {
        this.keysObj.reset();
        this.valuesObj.reset();
    }

    @Override
    @NotNull
    public IDimensionKeys getKeys() {
        return this.keysObj;
    }

    @Override
    @NotNull
    public IMeasureValues getValues() {
        return this.valuesObj;
    }

    @Override
    @NotNull
    public String getDimensionName(int dimensionIndex) {
        return ((Dimension)this.cube.getDimensions().get(dimensionIndex)).getName();
    }

    @Override
    @NotNull
    public String getMemberName(int dimensionIndex) {
        return ((Member)((Dimension)this.cube.getDimensions().get(dimensionIndex)).getMembers().get(this.keysObj.getKeys()[dimensionIndex])).getName();
    }

    @Override
    @NotNull
    public String getMeasureName(int measureIndex) {
        return ((Dimension)this.cube.getDimensions().get(measureIndex)).getName();
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.keysObj.addTo(sb);
        for (Measure measure : this.cube.getMeasures()) {
            String string;
            Object object;
            sb.append(", " + measure.getName() + '=' + ((object = this.valuesObj.get(measure.getPosition$bos_olap_core())) == null ? "null" : ((string = object.toString()) == null ? "null" : string)));
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u000e\u001a\u00060\u000fj\u0002`\u00102\n\u0010\u0011\u001a\u00060\u000fj\u0002`\u0010J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0096\u0002J\u0019\u0010\u0016\u001a\u00060\bj\u0002`\t2\n\u0010\u0017\u001a\u00060\bj\u0002`\tH\u0096\u0002J\b\u0010\u0018\u001a\u00020\bH\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u0018\u0010\u0007\u001a\u00060\bj\u0002`\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001d"}, d2={"Lkd/bos/olapServer/dataEntities/InputRow$DimensionKeys;", "Lkd/bos/olapServer/dataEntities/IDimensionKeys;", "keys", "", "cube", "Lkd/bos/olapServer/metadata/Cube;", "([ILkd/bos/olapServer/metadata/Cube;)V", "Count", "", "Lkd/bos/olapServer/common/int;", "getCount", "()I", "getKeys", "()[I", "addTo", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "sb", "equals", "", "other", "", "get", "dimensionIndex", "hashCode", "reset", "", "toString", "", "bos-olap-core"})
    private static final class DimensionKeys
    implements IDimensionKeys {
        @NotNull
        private final int[] keys;
        @NotNull
        private final Cube cube;

        public DimensionKeys(@NotNull int[] keys, @NotNull Cube cube) {
            Intrinsics.checkNotNullParameter((Object)keys, (String)"keys");
            Intrinsics.checkNotNullParameter((Object)cube, (String)"cube");
            this.keys = keys;
            this.cube = cube;
        }

        @NotNull
        public final int[] getKeys() {
            return this.keys;
        }

        @Override
        public int getCount() {
            return this.keys.length;
        }

        @Override
        public int get(int dimensionIndex) {
            return this.keys[dimensionIndex];
        }

        public final void reset() {
            ArraysKt.fill$default((int[])this.keys, (int)-1, (int)0, (int)0, (int)6, null);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(@Nullable Object other) {
            boolean bl;
            if (!(other instanceof IDimensionKeys)) return false;
            if (((IDimensionKeys)other).getCount() != this.keys.length) return false;
            Iterable $this$none$iv = (Iterable)RangesKt.until((int)0, (int)this.keys.length);
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                return true;
            }
            Iterator iterator = $this$none$iv.iterator();
            do {
                int element$iv;
                if (!iterator.hasNext()) return true;
                int it = element$iv = ((IntIterator)iterator).nextInt();
                boolean bl2 = false;
                if (((IDimensionKeys)other).get(it) != this.getKeys()[it]) {
                    return false;
                }
                bl = false;
            } while (!bl);
            return false;
        }

        public int hashCode() {
            return this.cube.getKeyHashcode(this.keys);
        }

        @NotNull
        public String toString() {
            String string = this.addTo(new StringBuilder()).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"addTo(StringBuilder()).toString()");
            return string;
        }

        @NotNull
        public final StringBuilder addTo(@NotNull StringBuilder sb) {
            Intrinsics.checkNotNullParameter((Object)sb, (String)"sb");
            for (Dimension dim : this.cube.getDimensions()) {
                int memberPosition = this.keys[dim.getPosition()];
                String value2 = (0 <= memberPosition ? memberPosition < dim.getMembers().getCount() : false) ? ((Member)dim.getMembers().get(memberPosition)).getName() : "<Error>";
                sb.append((dim.getPosition() > 0 ? ", " : "") + dim.getName() + '=' + value2);
            }
            return sb;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0017\u0010\u000e\u001a\u0004\u0018\u00010\u00042\n\u0010\u000f\u001a\u00060\u0007j\u0002`\bH\u0096\u0002J\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0018\u0010\u0006\u001a\u00060\u0007j\u0002`\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lkd/bos/olapServer/dataEntities/InputRow$MeasureValues;", "Lkd/bos/olapServer/dataEntities/IMeasureValues;", "values", "", "", "([Ljava/lang/Object;)V", "Count", "", "Lkd/bos/olapServer/common/int;", "getCount", "()I", "getValues$bos_olap_core", "()[Ljava/lang/Object;", "[Ljava/lang/Object;", "get", "measureIndex", "reset", "", "toString", "", "bos-olap-core"})
    public static final class MeasureValues
    implements IMeasureValues {
        @NotNull
        private final Object[] values;

        public MeasureValues(@NotNull Object[] values) {
            Intrinsics.checkNotNullParameter((Object)values, (String)"values");
            this.values = values;
        }

        @NotNull
        public final Object[] getValues$bos_olap_core() {
            return this.values;
        }

        @Override
        public int getCount() {
            return this.values.length;
        }

        @Override
        @Nullable
        public Object get(int measureIndex) {
            return this.values[measureIndex];
        }

        public final void reset() {
            ArraysKt.fill$default((Object[])this.values, (Object)CommonTypesKt.getUndefined(), (int)0, (int)0, (int)6, null);
        }

        @NotNull
        public String toString() {
            Object[] objectArray = this.values;
            boolean bl = false;
            String string = Arrays.toString(objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.util.Arrays.toString(this)");
            return string;
        }
    }
}

