/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.dataSources;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.Reader;
import java.math.BigDecimal;
import kd.bos.olapServer.common.NotSupportedException;
import kd.bos.olapServer.dataSources.IntStringPair;
import kd.bos.olapServer.metadata.OlapDataTypes;
import kd.bos.olapServer.tools.JsonHelper;
import kd.bos.olapServer.tools.Res;
import kd.olap.fel.common.OperateUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.decimal4j.immutable.Decimal6f;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\f\b\u0000\u0018\u0000 \u001a2\u00020\u0001:\b\u001a\u001b\u001c\u001d\u001e\u001f !B)\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\b\u0002\u0010\u0007\u001a\u00060\bj\u0002`\t\u00a2\u0006\u0002\u0010\nJ\n\u0010\u0013\u001a\u0004\u0018\u00010\fH\u0002J\n\u0010\u0014\u001a\u00060\u0015j\u0002`\u0016J\u001f\u0010\u0017\u001a\u00060\u0015j\u0002`\u00162\u000e\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0003\u00a2\u0006\u0002\u0010\u0019R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lkd/bos/olapServer/dataSources/ArrayJsonReader;", "", "arrayTypes", "", "Lkd/bos/olapServer/metadata/OlapDataTypes;", "reader", "Ljava/io/Reader;", "clientVersion", "", "Lkd/bos/olapServer/common/int;", "([Lkd/bos/olapServer/metadata/OlapDataTypes;Ljava/io/Reader;I)V", "_currentToken", "Lcom/fasterxml/jackson/core/JsonToken;", "[Lkd/bos/olapServer/metadata/OlapDataTypes;", "converters", "Lkd/bos/olapServer/dataSources/ArrayJsonReader$TypeConverter;", "[Lkd/bos/olapServer/dataSources/ArrayJsonReader$TypeConverter;", "parser", "Lcom/fasterxml/jackson/core/JsonParser;", "moveToFirstElement", "next", "", "Lkd/bos/olapServer/common/bool;", "read", "values", "([Ljava/lang/Object;)Z", "Companion", "DecimalConverter", "Int32Converter", "NumberStringParser", "ObjectConverter", "StringConverterV1", "StringConverterV3", "TypeConverter", "bos-olap-core"})
public final class ArrayJsonReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OlapDataTypes[] arrayTypes;
    @NotNull
    private final JsonParser parser;
    @NotNull
    private final TypeConverter[] converters;
    @Nullable
    private JsonToken _currentToken;
    @NotNull
    private static final BigDecimal MaxDecimal = new BigDecimal(Long.MAX_VALUE);
    @NotNull
    private static final BigDecimal MinDecimal = new BigDecimal(Long.MIN_VALUE);
    private static final int MaxScale = 15;

    public ArrayJsonReader(@NotNull OlapDataTypes[] arrayTypes, @NotNull Reader reader, int clientVersion) {
        Intrinsics.checkNotNullParameter((Object)arrayTypes, (String)"arrayTypes");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        this.arrayTypes = arrayTypes;
        JsonParser jsonParser = JsonHelper.INSTANCE.getDefaultFactory().createParser(reader);
        Intrinsics.checkNotNullExpressionValue((Object)jsonParser, (String)"JsonHelper.defaultFactory.createParser(reader)");
        this.parser = jsonParser;
        int n = this.arrayTypes.length;
        TypeConverter[] typeConverterArray = new TypeConverter[n];
        ArrayJsonReader arrayJsonReader = this;
        for (int i = 0; i < n; ++i) {
            TypeConverter typeConverter;
            int n2 = i;
            int n3 = clientVersion;
            switch (n3) {
                case 1: {
                    typeConverter = TypeConverter.Companion.getConverterV1(this.arrayTypes[n2]);
                    break;
                }
                case 3: {
                    typeConverter = TypeConverter.Companion.getConverter(this.arrayTypes[n2]);
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            typeConverterArray[n2] = typeConverter;
        }
        arrayJsonReader.converters = typeConverterArray;
    }

    public /* synthetic */ ArrayJsonReader(OlapDataTypes[] olapDataTypesArray, Reader reader, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 3;
        }
        this(olapDataTypesArray, reader, n);
    }

    public final boolean next() {
        JsonToken token;
        this._currentToken = token = this.moveToFirstElement();
        return token != null;
    }

    public final boolean read(@NotNull Object[] values) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        boolean bl = values.length == this.arrayTypes.length;
        int n = 0;
        int n2 = 0;
        n2 = 0;
        boolean bl2 = false;
        if (!bl) {
            boolean bl3 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        JsonToken token = this._currentToken;
        if (token != null) {
            n = 0;
            n2 = this.arrayTypes.length + -1;
            if (n <= n2) {
                do {
                    int i = n++;
                    if (token == null || !token.isScalarValue()) {
                        Object[] objectArray = Res.INSTANCE.getArrayJsonReaderException_1();
                        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.ArrayJsonReaderException_1");
                        Object[] objectArray2 = objectArray;
                        objectArray = new Object[]{this.arrayTypes.length, i};
                        throw Res.INSTANCE.getRuntimeException((String)objectArray2, objectArray);
                    }
                    TypeConverter converter = this.converters[i];
                    if (token.id() == converter.getTokenId() || converter.isSupportToken(token)) {
                        try {
                            values[i] = converter.convert(this.parser);
                        }
                        catch (Exception ex) {
                            Object[] objectArray = Res.INSTANCE.getArrayJsonReaderException_2();
                            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.ArrayJsonReaderException_2");
                            Object[] objectArray3 = objectArray;
                            objectArray = new Object[]{i, converter.getTypeName(), ex.getMessage()};
                            throw Res.INSTANCE.getRuntimeException((String)objectArray3, ex, objectArray);
                        }
                    } else if (token == JsonToken.VALUE_NULL) {
                        values[i] = null;
                    } else {
                        Object[] objectArray = Res.INSTANCE.getArrayJsonReaderException_3();
                        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.ArrayJsonReaderException_3");
                        Object[] objectArray4 = objectArray;
                        objectArray = new Object[]{i, converter.getTypeName()};
                        throw Res.INSTANCE.getRuntimeException((String)objectArray4, objectArray);
                    }
                    token = this.parser.nextToken();
                } while (n <= n2);
            }
            if (token == null || token != JsonToken.END_ARRAY) {
                Object[] objectArray = Res.INSTANCE.getArrayJsonReaderException_4();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.ArrayJsonReaderException_4");
                Object[] objectArray5 = objectArray;
                objectArray = new Object[]{this.arrayTypes.length};
                throw Res.INSTANCE.getRuntimeException((String)objectArray5, objectArray);
            }
            return true;
        }
        return false;
    }

    private final JsonToken moveToFirstElement() {
        boolean state = false;
        JsonToken token = this.parser.nextToken();
        while (token != null) {
            if (token != JsonToken.START_ARRAY || state) {
                if (token.isScalarValue() && state) {
                    return token;
                }
                String string = Res.INSTANCE.getArrayJsonReaderException_5();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Res.ArrayJsonReaderException_5");
                throw Res.INSTANCE.getRuntimeException(string, new Object[0]);
            }
            state = true;
            token = this.parser.nextToken();
        }
        if (state) {
            String string = Res.INSTANCE.getArrayJsonReaderException_5();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Res.ArrayJsonReaderException_5");
            throw Res.INSTANCE.getRuntimeException(string, new Object[0]);
        }
        return null;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u000b\u001a\u00020\f*\u00020\u0004H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\r"}, d2={"Lkd/bos/olapServer/dataSources/ArrayJsonReader$Companion;", "", "()V", "MaxDecimal", "Ljava/math/BigDecimal;", "getMaxDecimal", "()Ljava/math/BigDecimal;", "MaxScale", "", "MinDecimal", "getMinDecimal", "checkInScope", "", "bos-olap-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BigDecimal getMaxDecimal() {
            return MaxDecimal;
        }

        @NotNull
        public final BigDecimal getMinDecimal() {
            return MinDecimal;
        }

        private final void checkInScope(BigDecimal $this$checkInScope) {
            if (!OperateUtils.isInScope((BigDecimal)$this$checkInScope)) {
                Object[] objectArray = Res.INSTANCE.getArrayJsonReaderException_8();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.ArrayJsonReaderException_8");
                Object[] objectArray2 = objectArray;
                objectArray = new Object[]{this.getMinDecimal(), this.getMaxDecimal(), $this$checkInScope};
                throw Res.INSTANCE.getNotSupportedException((String)objectArray2, objectArray);
            }
            if ($this$checkInScope.scale() > 15) {
                Object[] objectArray = Res.INSTANCE.getArrayJsonReaderException_9();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.ArrayJsonReaderException_9");
                Object[] objectArray3 = objectArray;
                objectArray = new Object[]{15, $this$checkInScope};
                throw Res.INSTANCE.getNotSupportedException((String)objectArray3, objectArray);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u00a8\u0006\b"}, d2={"Lkd/bos/olapServer/dataSources/ArrayJsonReader$NumberStringParser;", "", "()V", "parse", "Lkd/bos/olapServer/dataSources/IntStringPair;", "str", "", "Lkd/bos/olapServer/common/string;", "bos-olap-core"})
    private static final class NumberStringParser {
        @NotNull
        public static final NumberStringParser INSTANCE = new NumberStringParser();

        private NumberStringParser() {
        }

        @NotNull
        public final IntStringPair parse(@NotNull String str) {
            IntStringPair intStringPair;
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            CharSequence charSequence = (CharSequence)str;
            boolean bl = false;
            boolean bl2 = charSequence.length() > 0;
            bl = false;
            boolean bl3 = false;
            bl3 = false;
            int n = 0;
            if (!bl2) {
                boolean bl4 = false;
                String string = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            int colonIndex = -1;
            int number = 0;
            Object[] objectArray = str;
            n = 0;
            int n2 = objectArray.length();
            while (n < n2) {
                int i = n;
                char c = objectArray.charAt(n);
                ++n;
                boolean bl5 = '0' <= c ? c <= '9' : false;
                if (bl5) {
                    number = number * 10 + (c - 48);
                    continue;
                }
                if (c == ':') {
                    colonIndex = i;
                    break;
                }
                Object[] objectArray2 = Res.INSTANCE.getArrayJsonReaderException_6();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"Res.ArrayJsonReaderException_6");
                Object[] objectArray3 = objectArray2;
                objectArray2 = new Object[]{str};
                throw Res.INSTANCE.getRuntimeException((String)objectArray3, objectArray2);
            }
            if (colonIndex < 0) {
                objectArray = Res.INSTANCE.getArrayJsonReaderException_7();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.ArrayJsonReaderException_7");
                Object[] objectArray4 = objectArray;
                objectArray = new Object[]{str};
                throw Res.INSTANCE.getRuntimeException((String)objectArray4, objectArray);
            }
            boolean bl6 = number >= 0;
            n = 0;
            n2 = 0;
            n2 = 0;
            boolean bl7 = false;
            if (!bl6) {
                boolean bl8 = false;
                String string = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            if (colonIndex == str.length() - 1) {
                intStringPair = new IntStringPair(number, "");
            } else {
                Object[] objectArray5 = str;
                n = colonIndex + 1;
                n2 = 0;
                String string = objectArray5.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).substring(startIndex)");
                intStringPair = new IntStringPair(number, string);
            }
            return intStringPair;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\"\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000e\u001a\u00020\u000fH&J\u0014\u0010\u0010\u001a\u00060\u0011j\u0002`\u00122\u0006\u0010\u0013\u001a\u00020\u0014H&R\u0016\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u00060\tj\u0002`\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lkd/bos/olapServer/dataSources/ArrayJsonReader$TypeConverter;", "", "()V", "TokenId", "", "Lkd/bos/olapServer/common/int;", "getTokenId", "()I", "TypeName", "", "Lkd/bos/olapServer/common/string;", "getTypeName", "()Ljava/lang/String;", "convert", "parser", "Lcom/fasterxml/jackson/core/JsonParser;", "isSupportToken", "", "Lkd/bos/olapServer/common/bool;", "token", "Lcom/fasterxml/jackson/core/JsonToken;", "Companion", "bos-olap-core"})
    private static abstract class TypeConverter {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final DecimalConverter Decimal = new DecimalConverter();
        @NotNull
        private static final Int32Converter Int32 = new Int32Converter();
        @NotNull
        private static final ObjectConverter Object = new ObjectConverter();
        @NotNull
        private static final StringConverterV1 StringV1 = new StringConverterV1();
        @NotNull
        private static final StringConverterV3 StringV3 = new StringConverterV3();

        @NotNull
        public abstract String getTypeName();

        public abstract int getTokenId();

        public abstract boolean isSupportToken(@NotNull JsonToken var1);

        @Nullable
        public abstract Object convert(@NotNull JsonParser var1);

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011H\u0000\u00a2\u0006\u0002\b\u0012J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lkd/bos/olapServer/dataSources/ArrayJsonReader$TypeConverter$Companion;", "", "()V", "Decimal", "Lkd/bos/olapServer/dataSources/ArrayJsonReader$DecimalConverter;", "Int32", "Lkd/bos/olapServer/dataSources/ArrayJsonReader$Int32Converter;", "Object", "Lkd/bos/olapServer/dataSources/ArrayJsonReader$ObjectConverter;", "StringV1", "Lkd/bos/olapServer/dataSources/ArrayJsonReader$StringConverterV1;", "StringV3", "Lkd/bos/olapServer/dataSources/ArrayJsonReader$StringConverterV3;", "convertToBigDecimal", "Ljava/math/BigDecimal;", "str", "", "Lkd/bos/olapServer/common/string;", "convertToBigDecimal$bos_olap_core", "getConverter", "Lkd/bos/olapServer/dataSources/ArrayJsonReader$TypeConverter;", "type", "Lkd/bos/olapServer/metadata/OlapDataTypes;", "getConverterV1", "bos-olap-core"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final TypeConverter getConverter(@NotNull OlapDataTypes type) {
                TypeConverter typeConverter;
                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                OlapDataTypes olapDataTypes = type;
                int n = WhenMappings.$EnumSwitchMapping$0[olapDataTypes.ordinal()];
                switch (n) {
                    case 1: {
                        typeConverter = Object;
                        break;
                    }
                    case 2: {
                        typeConverter = Decimal;
                        break;
                    }
                    case 3: {
                        typeConverter = Int32;
                        break;
                    }
                    case 4: {
                        typeConverter = StringV3;
                        break;
                    }
                    default: {
                        throw new NotSupportedException();
                    }
                }
                return typeConverter;
            }

            @NotNull
            public final TypeConverter getConverterV1(@NotNull OlapDataTypes type) {
                TypeConverter typeConverter;
                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                OlapDataTypes olapDataTypes = type;
                int n = WhenMappings.$EnumSwitchMapping$0[olapDataTypes.ordinal()];
                switch (n) {
                    case 1: {
                        typeConverter = Object;
                        break;
                    }
                    case 2: {
                        typeConverter = Decimal;
                        break;
                    }
                    case 3: {
                        typeConverter = Int32;
                        break;
                    }
                    case 4: {
                        typeConverter = StringV1;
                        break;
                    }
                    default: {
                        throw new NotSupportedException();
                    }
                }
                return typeConverter;
            }

            @NotNull
            public final BigDecimal convertToBigDecimal$bos_olap_core(@NotNull String str) {
                Intrinsics.checkNotNullParameter((Object)str, (String)"str");
                BigDecimal value2 = new BigDecimal(str);
                ArrayJsonReader.Companion.checkInScope(value2);
                return value2;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            @Metadata(mv={1, 5, 1}, k=3, xi=48)
            public final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[OlapDataTypes.values().length];
                    nArray[OlapDataTypes.object.ordinal()] = 1;
                    nArray[OlapDataTypes.decimal.ordinal()] = 2;
                    nArray[OlapDataTypes.int32.ordinal()] = 3;
                    nArray[OlapDataTypes.string.ordinal()] = 4;
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0014\u0010\u0011\u001a\u00060\u0012j\u0002`\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0018\u0010\u0003\u001a\u00060\u0004j\u0002`\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\u00060\tj\u0002`\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lkd/bos/olapServer/dataSources/ArrayJsonReader$DecimalConverter;", "Lkd/bos/olapServer/dataSources/ArrayJsonReader$TypeConverter;", "()V", "TokenId", "", "Lkd/bos/olapServer/common/int;", "getTokenId", "()I", "TypeName", "", "Lkd/bos/olapServer/common/string;", "getTypeName", "()Ljava/lang/String;", "convert", "", "parser", "Lcom/fasterxml/jackson/core/JsonParser;", "isSupportToken", "", "Lkd/bos/olapServer/common/bool;", "token", "Lcom/fasterxml/jackson/core/JsonToken;", "bos-olap-core"})
    private static final class DecimalConverter
    extends TypeConverter {
        @Override
        @NotNull
        public String getTypeName() {
            return "decimal";
        }

        @Override
        public int getTokenId() {
            return JsonToken.VALUE_NUMBER_FLOAT.id();
        }

        @Override
        public boolean isSupportToken(@NotNull JsonToken token) {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            return token == JsonToken.VALUE_NUMBER_INT || token == JsonToken.VALUE_STRING;
        }

        @Override
        @Nullable
        public Object convert(@NotNull JsonParser parser) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            return Decimal6f.valueOf((String)parser.getValueAsString(null));
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0014\u0010\u0011\u001a\u00060\u0012j\u0002`\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0018\u0010\u0003\u001a\u00060\u0004j\u0002`\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\u00060\tj\u0002`\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lkd/bos/olapServer/dataSources/ArrayJsonReader$Int32Converter;", "Lkd/bos/olapServer/dataSources/ArrayJsonReader$TypeConverter;", "()V", "TokenId", "", "Lkd/bos/olapServer/common/int;", "getTokenId", "()I", "TypeName", "", "Lkd/bos/olapServer/common/string;", "getTypeName", "()Ljava/lang/String;", "convert", "", "parser", "Lcom/fasterxml/jackson/core/JsonParser;", "isSupportToken", "", "Lkd/bos/olapServer/common/bool;", "token", "Lcom/fasterxml/jackson/core/JsonToken;", "bos-olap-core"})
    private static final class Int32Converter
    extends TypeConverter {
        @Override
        @NotNull
        public String getTypeName() {
            return "int32";
        }

        @Override
        public int getTokenId() {
            return JsonToken.VALUE_NUMBER_INT.id();
        }

        @Override
        public boolean isSupportToken(@NotNull JsonToken token) {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            return token == JsonToken.VALUE_NUMBER_INT;
        }

        @Override
        @NotNull
        public Object convert(@NotNull JsonParser parser) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            return parser.getIntValue();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0014\u0010\u0011\u001a\u00060\u0012j\u0002`\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0018\u0010\u0003\u001a\u00060\u0004j\u0002`\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\u00060\tj\u0002`\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lkd/bos/olapServer/dataSources/ArrayJsonReader$StringConverterV1;", "Lkd/bos/olapServer/dataSources/ArrayJsonReader$TypeConverter;", "()V", "TokenId", "", "Lkd/bos/olapServer/common/int;", "getTokenId", "()I", "TypeName", "", "Lkd/bos/olapServer/common/string;", "getTypeName", "()Ljava/lang/String;", "convert", "", "parser", "Lcom/fasterxml/jackson/core/JsonParser;", "isSupportToken", "", "Lkd/bos/olapServer/common/bool;", "token", "Lcom/fasterxml/jackson/core/JsonToken;", "bos-olap-core"})
    private static final class StringConverterV1
    extends TypeConverter {
        @Override
        @NotNull
        public String getTypeName() {
            return "string";
        }

        @Override
        public int getTokenId() {
            return JsonToken.VALUE_STRING.id();
        }

        @Override
        public boolean isSupportToken(@NotNull JsonToken token) {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            return token == JsonToken.VALUE_STRING;
        }

        @Override
        @Nullable
        public Object convert(@NotNull JsonParser parser) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            return parser.getValueAsString();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0014\u0010\u0011\u001a\u00060\u0012j\u0002`\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0018\u0010\u0003\u001a\u00060\u0004j\u0002`\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\u00060\tj\u0002`\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lkd/bos/olapServer/dataSources/ArrayJsonReader$StringConverterV3;", "Lkd/bos/olapServer/dataSources/ArrayJsonReader$TypeConverter;", "()V", "TokenId", "", "Lkd/bos/olapServer/common/int;", "getTokenId", "()I", "TypeName", "", "Lkd/bos/olapServer/common/string;", "getTypeName", "()Ljava/lang/String;", "convert", "", "parser", "Lcom/fasterxml/jackson/core/JsonParser;", "isSupportToken", "", "Lkd/bos/olapServer/common/bool;", "token", "Lcom/fasterxml/jackson/core/JsonToken;", "bos-olap-core"})
    private static final class StringConverterV3
    extends TypeConverter {
        @Override
        @NotNull
        public String getTypeName() {
            return "string";
        }

        @Override
        public int getTokenId() {
            return JsonToken.VALUE_STRING.id();
        }

        @Override
        public boolean isSupportToken(@NotNull JsonToken token) {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            return token == JsonToken.VALUE_NUMBER_INT || token == JsonToken.VALUE_STRING;
        }

        @Override
        @NotNull
        public Object convert(@NotNull JsonParser parser) {
            Object object;
            JsonToken token;
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            JsonToken jsonToken = token = parser.getCurrentToken();
            int n = jsonToken == null ? -1 : WhenMappings.$EnumSwitchMapping$0[jsonToken.ordinal()];
            switch (n) {
                case 1: {
                    object = parser.getIntValue();
                    break;
                }
                case 2: {
                    String str = parser.getValueAsString();
                    Intrinsics.checkNotNullExpressionValue((Object)str, (String)"str");
                    object = NumberStringParser.INSTANCE.parse(str);
                    break;
                }
                default: {
                    Object[] objectArray = Res.INSTANCE.getUnsupportedDataTypeException();
                    Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.UnsupportedDataTypeException");
                    Object[] objectArray2 = objectArray;
                    objectArray = new Object[]{token.asString()};
                    throw Res.INSTANCE.getRuntimeException((String)objectArray2, objectArray);
                }
            }
            return object;
        }

        @Metadata(mv={1, 5, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[JsonToken.values().length];
                nArray[JsonToken.VALUE_NUMBER_INT.ordinal()] = 1;
                nArray[JsonToken.VALUE_STRING.ordinal()] = 2;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0014\u0010\u0011\u001a\u00060\u0012j\u0002`\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0018\u0010\u0003\u001a\u00060\u0004j\u0002`\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\u00060\tj\u0002`\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lkd/bos/olapServer/dataSources/ArrayJsonReader$ObjectConverter;", "Lkd/bos/olapServer/dataSources/ArrayJsonReader$TypeConverter;", "()V", "TokenId", "", "Lkd/bos/olapServer/common/int;", "getTokenId", "()I", "TypeName", "", "Lkd/bos/olapServer/common/string;", "getTypeName", "()Ljava/lang/String;", "convert", "", "parser", "Lcom/fasterxml/jackson/core/JsonParser;", "isSupportToken", "", "Lkd/bos/olapServer/common/bool;", "token", "Lcom/fasterxml/jackson/core/JsonToken;", "bos-olap-core"})
    private static final class ObjectConverter
    extends TypeConverter {
        @Override
        @NotNull
        public String getTypeName() {
            return "object";
        }

        @Override
        public int getTokenId() {
            return JsonToken.VALUE_NUMBER_FLOAT.id();
        }

        @Override
        public boolean isSupportToken(@NotNull JsonToken token) {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            return token == JsonToken.VALUE_NUMBER_INT || token == JsonToken.VALUE_STRING || token == JsonToken.VALUE_TRUE || token == JsonToken.VALUE_FALSE;
        }

        @Override
        @Nullable
        public Object convert(@NotNull JsonParser parser) {
            Object object;
            JsonToken token;
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            JsonToken jsonToken = token = parser.getCurrentToken();
            int n = jsonToken == null ? -1 : WhenMappings.$EnumSwitchMapping$0[jsonToken.ordinal()];
            switch (n) {
                case 1: {
                    BigDecimal bigDecimal;
                    String str = parser.getValueAsString(null);
                    try {
                        int scale;
                        Intrinsics.checkNotNullExpressionValue((Object)str, (String)"str");
                        int dotIndex = StringsKt.indexOf$default((CharSequence)str, (String)".", (int)1, (boolean)false, (int)4, null);
                        int eIndex = StringsKt.indexOf((CharSequence)str, (String)"E", (int)dotIndex, (boolean)true);
                        bigDecimal = eIndex >= 0 ? TypeConverter.Companion.convertToBigDecimal$bos_olap_core(str) : ((scale = str.length() - dotIndex - 1) <= 6 ? Decimal6f.valueOf((String)str) : TypeConverter.Companion.convertToBigDecimal$bos_olap_core(str));
                    }
                    catch (NumberFormatException _) {
                        Intrinsics.checkNotNullExpressionValue((Object)str, (String)"str");
                        bigDecimal = TypeConverter.Companion.convertToBigDecimal$bos_olap_core(str);
                    }
                    object = bigDecimal;
                    break;
                }
                case 2: {
                    long value2 = parser.getLongValue();
                    return (Integer.MIN_VALUE <= value2 ? value2 <= Integer.MAX_VALUE : false) ? (Number)((int)value2) : (Number)value2;
                }
                case 3: {
                    object = parser.getValueAsString();
                    break;
                }
                case 4: 
                case 5: {
                    object = parser.getBooleanValue();
                    break;
                }
                default: {
                    throw new NotSupportedException();
                }
            }
            return object;
        }

        @Metadata(mv={1, 5, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[JsonToken.values().length];
                nArray[JsonToken.VALUE_NUMBER_FLOAT.ordinal()] = 1;
                nArray[JsonToken.VALUE_NUMBER_INT.ordinal()] = 2;
                nArray[JsonToken.VALUE_STRING.ordinal()] = 3;
                nArray[JsonToken.VALUE_TRUE.ordinal()] = 4;
                nArray[JsonToken.VALUE_FALSE.ordinal()] = 5;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

