/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.memoryMappedFiles;

import java.io.Closeable;
import java.nio.file.ClosedFileSystemException;
import kd.bos.olapServer.common.NotSupportedException;
import kd.bos.olapServer.memoryMappedFiles.FileHeadField;
import kd.bos.olapServer.memoryMappedFiles.byteBufferProviders.Bits;
import kd.bos.olapServer.memoryMappedFiles.byteBufferProviders.ByteBufferResource;
import kd.bos.olapServer.memoryMappedFiles.byteBufferProviders.IByteBuffer;
import kd.bos.olapServer.memoryMappedFiles.byteBufferProviders.IByteBufferResource;
import kd.bos.olapServer.tools.Res;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0005\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b \u0018\u0000 B2\u00020\u0001:\u0002ABB)\b\u0016\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\b\u0002\u0010\u0007\u001a\u00060\bj\u0002`\t\u00a2\u0006\u0002\u0010\nB\u0015\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\rJ\u0018\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u00062\u0006\u00103\u001a\u00020\u000fH\u0014J\b\u00104\u001a\u000201H\u0016J\b\u00105\u001a\u000201H\u0016J\"\u00106\u001a\u000607j\u0002`82\n\u00109\u001a\u000607j\u0002`82\n\u0010:\u001a\u00060\u0013j\u0002`\u0014J\u0018\u0010;\u001a\u0002012\u0006\u00102\u001a\u00020\u00062\u0006\u00103\u001a\u00020\u000fH\u0014J\u0014\u0010<\u001a\u00020\u000f2\n\u0010=\u001a\u00060\u0013j\u0002`\u0014H\u0002J\u0012\u0010>\u001a\u00020\u000f2\n\u0010=\u001a\u000607j\u0002`?J\u0012\u0010>\u001a\u00020\u000f2\n\u0010=\u001a\u00060\u0013j\u0002`\u0014J\b\u0010@\u001a\u00020\u0003H\u0016R\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0015\u0010\u0012\u001a\u00060\u0013j\u0002`\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00138TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016R\u0014\u0010\u0019\u001a\u00020\u000f8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0011R\u0015\u0010\u001b\u001a\u00060\u0003j\u0002`\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0018\u0010\u001e\u001a\u00060\u001fj\u0002` 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0015\u0010#\u001a\u00060\bj\u0002`\t8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R,\u0010'\u001a\u00060\u0013j\u0002`\u00142\n\u0010&\u001a\u00060\u0013j\u0002`\u00148F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b(\u0010\u0016\"\u0004\b)\u0010*R\u000e\u0010+\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010,\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010-\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010/\u001a\u00060\u0013j\u0002`\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lkd/bos/olapServer/memoryMappedFiles/AbstractMetadata;", "Ljava/io/Closeable;", "fileName", "", "Lkd/bos/olapServer/common/string;", "headItems", "Lkd/bos/olapServer/memoryMappedFiles/AbstractMetadata$AbstractHeadFieldCollection;", "isReadonly", "", "Lkd/bos/olapServer/common/bool;", "(Ljava/lang/String;Lkd/bos/olapServer/memoryMappedFiles/AbstractMetadata$AbstractHeadFieldCollection;Z)V", "byteResource", "Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/IByteBufferResource;", "(Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/IByteBufferResource;Lkd/bos/olapServer/memoryMappedFiles/AbstractMetadata$AbstractHeadFieldCollection;)V", "ContentBuffer", "Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/IByteBuffer;", "getContentBuffer", "()Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/IByteBuffer;", "ContentSize", "", "Lkd/bos/olapServer/common/long;", "getContentSize", "()J", "FileDataPosition", "getFileDataPosition", "FileHeadBuffer", "getFileHeadBuffer", "FileType", "getFileType", "()Ljava/lang/String;", "FileTypeVersion", "", "Lkd/bos/olapServer/common/byte;", "getFileTypeVersion", "()B", "IsReadonly", "getIsReadonly", "()Z", "value", "Version", "getVersion", "setVersion", "(J)V", "_byteResource", "_contentBuffer", "_headBuffer", "_headItems", "lastTranId", "checkFile", "", "items", "fileHeadBuffer", "close", "force", "getMinSize", "", "Lkd/bos/olapServer/common/idx;", "rowCount", "entryBytes", "initFile", "mapContentBuffer", "minSize", "resize", "Lkd/bos/olapServer/common/int;", "toString", "AbstractHeadFieldCollection", "Companion", "bos-olap-core"})
public abstract class AbstractMetadata
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AbstractHeadFieldCollection _headItems;
    @NotNull
    private final IByteBufferResource _byteResource;
    @Nullable
    private IByteBuffer _headBuffer;
    @Nullable
    private IByteBuffer _contentBuffer;
    private long lastTranId;

    public AbstractMetadata(@NotNull IByteBufferResource byteResource, @NotNull AbstractHeadFieldCollection headItems) {
        Intrinsics.checkNotNullParameter((Object)byteResource, (String)"byteResource");
        Intrinsics.checkNotNullParameter((Object)headItems, (String)"headItems");
        this._headItems = headItems;
        this._byteResource = byteResource;
        long headSize = headItems.getLastField().getEnd();
        this._headBuffer = this._byteResource.open(headSize, headItems.getFileType(), (Function1<? super IByteBuffer, Unit>)((Function1)new Function1<IByteBuffer, Unit>(){

            public final void invoke(@NotNull IByteBuffer buffer) {
                Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
                this.initFile(_headItems, buffer);
            }
        }), (Function1<? super IByteBuffer, Unit>)((Function1)new Function1<IByteBuffer, Unit>(){

            public final void invoke(@NotNull IByteBuffer buffer) {
                Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
                this.checkFile(_headItems, buffer);
            }
        }));
    }

    public AbstractMetadata(@NotNull String fileName, @NotNull AbstractHeadFieldCollection headItems, boolean isReadonly) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)headItems, (String)"headItems");
        this(new ByteBufferResource(fileName, isReadonly), headItems);
    }

    public /* synthetic */ AbstractMetadata(String string, AbstractHeadFieldCollection abstractHeadFieldCollection, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(string, abstractHeadFieldCollection, bl);
    }

    protected void checkFile(@NotNull AbstractHeadFieldCollection items2, @NotNull IByteBuffer fileHeadBuffer) {
        Intrinsics.checkNotNullParameter((Object)items2, (String)"items");
        Intrinsics.checkNotNullParameter((Object)fileHeadBuffer, (String)"fileHeadBuffer");
        long index2 = items2.getFileTypeField().getOffset();
        String string = this.getFileType();
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            char c = string.charAt(n);
            ++n;
            char c2 = fileHeadBuffer.getChar(index2);
            if (c2 != c) {
                Object[] objectArray = Res.INSTANCE.getAbstractMetadataException_1();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.AbstractMetadataException_1");
                Object[] objectArray2 = objectArray;
                objectArray = new Object[]{this.getFileType()};
                throw Res.INSTANCE.getRuntimeException((String)objectArray2, objectArray);
            }
            index2 += (long)2;
        }
        index2 = items2.getFileTypeVersionField().getOffset();
        byte fv = fileHeadBuffer.getByte(index2);
        if (fv != this.getFileTypeVersion()) {
            Object[] objectArray = Res.INSTANCE.getAbstractMetadataException_2();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.AbstractMetadataException_2");
            Object[] objectArray3 = objectArray;
            objectArray = new Object[]{fv, this.getFileTypeVersion()};
            throw Res.INSTANCE.getRuntimeException((String)objectArray3, objectArray);
        }
    }

    protected void initFile(@NotNull AbstractHeadFieldCollection items2, @NotNull IByteBuffer fileHeadBuffer) {
        Intrinsics.checkNotNullParameter((Object)items2, (String)"items");
        Intrinsics.checkNotNullParameter((Object)fileHeadBuffer, (String)"fileHeadBuffer");
        long index2 = items2.getFileTypeField().getOffset();
        String string = this.getFileType();
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            char c = string.charAt(n);
            ++n;
            fileHeadBuffer.putChar(index2, c);
            index2 += (long)2;
        }
        index2 = items2.getFileTypeVersionField().getOffset();
        fileHeadBuffer.putByte(index2, this.getFileTypeVersion());
        index2 = items2.getVersionField().getOffset();
        fileHeadBuffer.putLong(index2, 0L);
    }

    public final boolean getIsReadonly() {
        return this._byteResource.getIsReadonly();
    }

    @NotNull
    public final String getFileType() {
        return this._headItems.getFileType();
    }

    public byte getFileTypeVersion() {
        return 1;
    }

    public final long getVersion() {
        return this.getFileHeadBuffer().getLong(this._headItems.getVersionField().getOffset());
    }

    public final void setVersion(long value2) {
        this.getFileHeadBuffer().putLong(this._headItems.getVersionField().getOffset(), value2);
    }

    public final long getContentSize() {
        return this._byteResource.getLength() == 0L ? 0L : this._byteResource.getLength() - this.getFileDataPosition();
    }

    protected long getFileDataPosition() {
        return this._headItems.getLastField().getEnd();
    }

    @NotNull
    protected final IByteBuffer getFileHeadBuffer() {
        IByteBuffer iByteBuffer = this._headBuffer;
        if (iByteBuffer == null) {
            throw new ClosedFileSystemException();
        }
        return iByteBuffer;
    }

    private final IByteBuffer mapContentBuffer(long minSize) {
        IByteBuffer oldBuffer = this._contentBuffer;
        if (oldBuffer != null && oldBuffer.getCapacity() >= minSize) {
            return oldBuffer;
        }
        long position = this.getFileDataPosition();
        IByteBuffer newBuffer = this._byteResource.mapContentBuffer(position, minSize);
        if (oldBuffer != null) {
            this._byteResource.releaseBuffer(null, oldBuffer);
        }
        this._contentBuffer = newBuffer;
        return newBuffer;
    }

    @NotNull
    public final IByteBuffer getContentBuffer() {
        return this.mapContentBuffer(this.getContentSize());
    }

    @NotNull
    public final IByteBuffer resize(int minSize) {
        return this.resize((long)minSize);
    }

    @NotNull
    public final IByteBuffer resize(long minSize) {
        return this.mapContentBuffer(minSize);
    }

    public final int getMinSize(int rowCount, long entryBytes) {
        if (rowCount < 0) {
            Object[] objectArray = Res.INSTANCE.getAbstractMetadataException_3();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.AbstractMetadataException_3");
            Object[] objectArray2 = objectArray;
            objectArray = new Object[]{rowCount};
            throw Res.INSTANCE.getIndexOutOfBoundsException((String)objectArray2, objectArray);
        }
        boolean bl = entryBytes > 0L;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        long startPos = this.getFileDataPosition();
        long minByteSize = (long)rowCount * entryBytes;
        minByteSize = (minByteSize += startPos) < 4096L ? 4096L : (minByteSize < 131072L ? 131072L : (minByteSize < 0x100000L ? 0x100000L : (minByteSize < 0x400000L ? 0x400000L : (minByteSize < 0x4000000L ? Bits.INSTANCE.roundTo4096(minByteSize * 2L) : Bits.INSTANCE.roundTo4096(minByteSize + (long)0x4000000)))));
        long newRowCount = (minByteSize - startPos) / entryBytes;
        return newRowCount > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)newRowCount;
    }

    public void force() {
        if (this._byteResource.getIsReadonly()) {
            throw new NotSupportedException();
        }
    }

    @Override
    public void close() {
        this._byteResource.releaseBuffer(this._headBuffer, this._contentBuffer);
        this._headBuffer = null;
        this._contentBuffer = null;
    }

    @NotNull
    public String toString() {
        return this.getClass() + " : " + this._byteResource;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\b\u0010\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0010\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lkd/bos/olapServer/memoryMappedFiles/AbstractMetadata$AbstractHeadFieldCollection;", "", "FileType", "", "Lkd/bos/olapServer/common/string;", "(Ljava/lang/String;)V", "getFileType", "()Ljava/lang/String;", "LastField", "Lkd/bos/olapServer/memoryMappedFiles/FileHeadField;", "getLastField", "()Lkd/bos/olapServer/memoryMappedFiles/FileHeadField;", "fileTypeField", "getFileTypeField", "fileTypeVersionField", "getFileTypeVersionField", "versionField", "getVersionField", "bos-olap-core"})
    public static class AbstractHeadFieldCollection {
        @NotNull
        private final String FileType;
        @NotNull
        private final FileHeadField fileTypeField;
        @NotNull
        private final FileHeadField fileTypeVersionField;
        @NotNull
        private final FileHeadField versionField;

        public AbstractHeadFieldCollection(@NotNull String FileType) {
            Intrinsics.checkNotNullParameter((Object)FileType, (String)"FileType");
            this.FileType = FileType;
            this.fileTypeField = new FileHeadField(0L, this.FileType.length() * 2, null);
            this.fileTypeVersionField = this.fileTypeField.add(1);
            this.versionField = this.fileTypeVersionField.add(8);
        }

        @NotNull
        public final String getFileType() {
            return this.FileType;
        }

        @NotNull
        public final FileHeadField getFileTypeField() {
            return this.fileTypeField;
        }

        @NotNull
        public final FileHeadField getFileTypeVersionField() {
            return this.fileTypeVersionField;
        }

        @NotNull
        public final FileHeadField getVersionField() {
            return this.versionField;
        }

        @NotNull
        public FileHeadField getLastField() {
            return this.versionField;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00060\u0004j\u0002`\u00052\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b2\n\u0010\t\u001a\u00060\u0007j\u0002`\b\u00a8\u0006\n"}, d2={"Lkd/bos/olapServer/memoryMappedFiles/AbstractMetadata$Companion;", "", "()V", "getCapacityFromByteBuffer", "", "Lkd/bos/olapServer/common/int;", "bufferCapacity", "", "Lkd/bos/olapServer/common/long;", "entryBytes", "bos-olap-core"})
    public static final class Companion {
        private Companion() {
        }

        public final int getCapacityFromByteBuffer(long bufferCapacity, long entryBytes) {
            long newCapacity = bufferCapacity / entryBytes;
            return newCapacity >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)newCapacity;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

