/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.memoryMappedFiles;

import java.io.Closeable;
import kd.bos.olapServer.collections.ICloneable;
import kd.bos.olapServer.collections.IImmutableListInt;
import kd.bos.olapServer.dataEntities.DynamicSizeRange;
import kd.bos.olapServer.dataEntities.DynamicSizeRangeCollection;
import kd.bos.olapServer.memoryMappedFiles.DynamicIntMetadata;
import kd.bos.olapServer.memoryMappedFiles.byteBufferProviders.IByteBuffer;
import kd.bos.olapServer.tools.Res;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u00002\u00020\u00012\u00020\u00022\b\u0012\u0004\u0012\u00020\u00000\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\"\u001a\u00020#2\n\u0010$\u001a\u00060\bj\u0002`\u00182\n\u0010%\u001a\u00060\bj\u0002`\u00182\u0006\u0010&\u001a\u00020'H\u0016J,\u0010(\u001a\u00020#2\u0006\u0010)\u001a\u00020\r2\n\u0010*\u001a\u00060+j\u0002`,2\u0006\u0010-\u001a\u00020\b2\u0006\u0010&\u001a\u00020'H\u0002J,\u0010.\u001a\u00020#2\u0006\u0010)\u001a\u00020\r2\n\u0010*\u001a\u00060+j\u0002`,2\u0006\u0010-\u001a\u00020\b2\u0006\u0010&\u001a\u00020'H\u0002J,\u0010/\u001a\u00020#2\u0006\u0010)\u001a\u00020\r2\n\u0010*\u001a\u00060+j\u0002`,2\u0006\u0010-\u001a\u00020\b2\u0006\u0010&\u001a\u00020'H\u0002J,\u00100\u001a\u00020#2\u0006\u0010)\u001a\u00020\r2\n\u0010*\u001a\u00060+j\u0002`,2\u0006\u0010-\u001a\u00020\b2\u0006\u0010&\u001a\u00020'H\u0002J(\u00101\u001a\u00020#2\n\u0010$\u001a\u00060\bj\u0002`\u00182\n\u0010%\u001a\u00060\bj\u0002`\u00182\u0006\u0010&\u001a\u00020'H\u0002J\b\u00102\u001a\u00020\u0000H\u0016J\b\u00103\u001a\u00020#H\u0016J\u0019\u00104\u001a\u00060\bj\u0002`\u00182\n\u00105\u001a\u00060\bj\u0002`\tH\u0096\u0002J\u001c\u00106\u001a\u00020\b2\u0006\u00107\u001a\u0002082\n\u00105\u001a\u00060\bj\u0002`\tH\u0002J\u001c\u00109\u001a\u00020\b2\u0006\u00107\u001a\u0002082\n\u00105\u001a\u00060\bj\u0002`\tH\u0002R\u0018\u0010\u0007\u001a\u00060\bj\u0002`\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u000fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001e\u0010\u0017\u001a\u00060\bj\u0002`\u0018X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u000b\"\u0004\b\u001a\u0010\u001bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006:"}, d2={"Lkd/bos/olapServer/memoryMappedFiles/ImmutableListDynamicInt;", "Lkd/bos/olapServer/collections/IImmutableListInt;", "Ljava/io/Closeable;", "Lkd/bos/olapServer/collections/ICloneable;", "metadata", "Lkd/bos/olapServer/memoryMappedFiles/DynamicIntMetadata;", "(Lkd/bos/olapServer/memoryMappedFiles/DynamicIntMetadata;)V", "Count", "", "Lkd/bos/olapServer/common/idx;", "getCount", "()I", "_batchGetCache", "", "_buffer", "Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/IByteBuffer;", "get_buffer", "()Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/IByteBuffer;", "set_buffer", "(Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/IByteBuffer;)V", "_bytes", "get_bytes", "()[B", "_count", "Lkd/bos/olapServer/common/int;", "get_count", "set_count", "(I)V", "getMetadata", "()Lkd/bos/olapServer/memoryMappedFiles/DynamicIntMetadata;", "ranges", "Lkd/bos/olapServer/dataEntities/DynamicSizeRangeCollection;", "getRanges", "()Lkd/bos/olapServer/dataEntities/DynamicSizeRangeCollection;", "batchGet", "", "start", "end", "result", "", "batchGet1Byte", "bytes", "position", "", "Lkd/bos/olapServer/common/long;", "size", "batchGet2Byte", "batchGet3Byte", "batchGet4Byte", "batchGetOther", "clone", "close", "get", "index", "get3Byte", "range", "Lkd/bos/olapServer/dataEntities/DynamicSizeRange;", "get4Byte", "bos-olap-core"})
public class ImmutableListDynamicInt
implements IImmutableListInt,
Closeable,
ICloneable<ImmutableListDynamicInt> {
    @NotNull
    private final DynamicIntMetadata metadata;
    @NotNull
    private IByteBuffer _buffer;
    @NotNull
    private final DynamicSizeRangeCollection ranges;
    private int _count;
    @NotNull
    private final byte[] _bytes;
    @NotNull
    private final byte[] _batchGetCache;

    public ImmutableListDynamicInt(@NotNull DynamicIntMetadata metadata) {
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        this.metadata = metadata;
        this.ranges = new DynamicSizeRangeCollection();
        this._count = this.metadata.getCount();
        this._bytes = new byte[4];
        if (this._count > 0) {
            this.ranges.build(this.metadata.getTwoByteStart(), this.metadata.getThreeByteStart(), this.metadata.getFourByteStart());
        }
        this._buffer = this.metadata.getContentBuffer();
        this._batchGetCache = new byte[256];
    }

    @NotNull
    protected final DynamicIntMetadata getMetadata() {
        return this.metadata;
    }

    @NotNull
    protected final IByteBuffer get_buffer() {
        return this._buffer;
    }

    protected final void set_buffer(@NotNull IByteBuffer iByteBuffer) {
        Intrinsics.checkNotNullParameter((Object)iByteBuffer, (String)"<set-?>");
        this._buffer = iByteBuffer;
    }

    @NotNull
    protected final DynamicSizeRangeCollection getRanges() {
        return this.ranges;
    }

    protected final int get_count() {
        return this._count;
    }

    protected final void set_count(int n) {
        this._count = n;
    }

    @NotNull
    protected final byte[] get_bytes() {
        return this._bytes;
    }

    @Override
    public int get(int index2) {
        int n;
        boolean bl = 0 <= index2 ? index2 < this._count : false;
        int n2 = 0;
        boolean bl2 = false;
        bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Object range = this.ranges.getRange(index2);
        n2 = ((DynamicSizeRange)range).getElementByteSize();
        switch (n2) {
            case 1: {
                byte by = this._buffer.getByte(((DynamicSizeRange)range).getElementPosition(index2));
                n = by & 0xFF;
                break;
            }
            case 2: {
                short s = this._buffer.getShort(((DynamicSizeRange)range).getElementPosition(index2));
                n = (s & 0xFF) << 8 | s >> 8 & 0xFF;
                break;
            }
            case 3: {
                n = this.get3Byte((DynamicSizeRange)range, index2);
                break;
            }
            case 4: {
                n = this.get4Byte((DynamicSizeRange)range, index2);
                break;
            }
            default: {
                String string = Res.INSTANCE.getCommonException_4();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Res.CommonException_4");
                throw Res.INSTANCE.getRuntimeException(string, new Object[0]);
            }
        }
        return n;
    }

    private final int get4Byte(DynamicSizeRange range, int index2) {
        byte[] bytes = this._bytes;
        this._buffer.getByteArray(range.getElementPosition(index2), bytes, 0, range.getElementByteSize());
        return (bytes[3] & 0xFF) << 24 | (bytes[2] & 0xFF) << 16 | (bytes[1] & 0xFF) << 8 | bytes[0] & 0xFF;
    }

    private final int get3Byte(DynamicSizeRange range, int index2) {
        byte[] bytes = this._bytes;
        this._buffer.getByteArray(range.getElementPosition(index2), bytes, 0, range.getElementByteSize());
        return (bytes[2] & 0xFF) << 16 | (bytes[1] & 0xFF) << 8 | bytes[0] & 0xFF;
    }

    @Override
    public void batchGet(int start, int end, @NotNull int[] result) {
        block8: {
            block7: {
                Object rangeEnd;
                Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                boolean bl = (0 <= start ? start <= end : false) && end < this._count;
                boolean bl2 = false;
                boolean bl3 = false;
                bl3 = false;
                boolean bl4 = false;
                if (!bl) {
                    boolean bl5 = false;
                    String string = "Failed requirement.";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                Object rangeStart = this.ranges.getRange(start);
                if (rangeStart != (rangeEnd = this.ranges.getRange(end))) break block7;
                long position = ((DynamicSizeRange)rangeStart).getElementPosition(start);
                int size = end - start + 1;
                int n = ((DynamicSizeRange)rangeStart).getElementByteSize();
                switch (n) {
                    case 1: {
                        this.batchGet1Byte(this._batchGetCache, position, size, result);
                        break block8;
                    }
                    case 2: {
                        this.batchGet2Byte(this._batchGetCache, position, size, result);
                        break block8;
                    }
                    case 3: {
                        this.batchGet3Byte(this._batchGetCache, position, size, result);
                        break block8;
                    }
                    case 4: {
                        this.batchGet4Byte(this._batchGetCache, position, size, result);
                        break block8;
                    }
                    default: {
                        String string = Res.INSTANCE.getCommonException_4();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Res.CommonException_4");
                        throw Res.INSTANCE.getRuntimeException(string, new Object[0]);
                    }
                }
            }
            this.batchGetOther(start, end, result);
        }
    }

    private final void batchGet1Byte(byte[] bytes, long position, int size, int[] result) {
        this._buffer.getByteArray(position, bytes, 0, size);
        int n = 0;
        if (n < size) {
            do {
                int i = n++;
                result[i] = bytes[i] & 0xFF;
            } while (n < size);
        }
    }

    private final void batchGet2Byte(byte[] bytes, long position, int size, int[] result) {
        this._buffer.getByteArray(position, bytes, 0, size * 2);
        int byteIndex = 0;
        int n = 0;
        if (n < size) {
            do {
                int i = n++;
                result[i] = (bytes[byteIndex + 1] & 0xFF) << 8 | bytes[byteIndex] & 0xFF;
                byteIndex += 2;
            } while (n < size);
        }
    }

    private final void batchGet3Byte(byte[] bytes, long position, int size, int[] result) {
        this._buffer.getByteArray(position, bytes, 0, size * 3);
        int byteIndex = 0;
        int n = 0;
        if (n < size) {
            do {
                int i = n++;
                result[i] = (bytes[byteIndex + 2] & 0xFF) << 16 | (bytes[byteIndex + 1] & 0xFF) << 8 | bytes[byteIndex] & 0xFF;
                byteIndex += 3;
            } while (n < size);
        }
    }

    private final void batchGet4Byte(byte[] bytes, long position, int size, int[] result) {
        this._buffer.getByteArray(position, bytes, 0, size * 4);
        int byteIndex = 0;
        int n = 0;
        if (n < size) {
            do {
                int i = n++;
                result[i] = (bytes[byteIndex + 3] & 0xFF) << 24 | (bytes[byteIndex + 2] & 0xFF) << 16 | (bytes[byteIndex + 1] & 0xFF) << 8 | bytes[byteIndex] & 0xFF;
                byteIndex += 4;
            } while (n < size);
        }
    }

    private final void batchGetOther(int start, int end, int[] result) {
        int index2 = 0;
        int n = start;
        if (n <= end) {
            int i;
            do {
                i = n++;
                int n2 = index2;
                index2 = n2 + 1;
                result[n2] = this.get(i);
            } while (i != end);
        }
    }

    @Override
    public int getCount() {
        return this._count;
    }

    @Override
    public void close() {
        this.metadata.close();
    }

    @Override
    @NotNull
    public ImmutableListDynamicInt clone() {
        return new ImmutableListDynamicInt(this.metadata);
    }
}

